// DO NOT EDIT THIS FILE!
//
// This module part of a subset of web-sys that is used by wgpu's webgpu backend.
//
// These bindings are vendored into wgpu for the sole purpose of letting
// us pin the WebGPU backend to a specific version of the bindings, not
// to enable local changes. There are no provisions to preserve changes
// you make here the next time we re-vendor the bindings.
//
// The `web-sys` crate does not treat breaking changes to the WebGPU API
// as semver breaking changes, as WebGPU is "unstable". This means Cargo
// will not let us mix versions of `web-sys`, pinning WebGPU bindings to
// a specific version, while letting other bindings like WebGL get
// updated. Vendoring WebGPU was the workaround we chose.
//
// Vendoring also allows us to avoid building `web-sys` with
// `--cfg=web_sys_unstable_apis`, needed to get the WebGPU bindings.
//
// If you want to improve the generated code, please submit a PR to the https://github.com/wasm-bindgen/wasm-bindgen repository.
//
// This file was generated by the `cargo xtask vendor-web-sys --version f7e0467c4b4d88303eb79fba485320cfb4dfdd58` command.
#![allow(unused_imports)]
#![allow(clippy::all)]
use wasm_bindgen::prelude::*;

#[wasm_bindgen]
#[doc = "The `GpuFeatureName` enum."]
#[doc = ""]
#[doc = "*This API requires the following crate features to be activated: `GpuFeatureName`*"]
#[doc = ""]
#[doc = "*This API is unstable and requires `--cfg=web_sys_unstable_apis` to be activated, as"]
#[doc = "[described in the `wasm-bindgen` guide](https://wasm-bindgen.github.io/wasm-bindgen/web-sys/unstable-apis.html)*"]
#[derive(Debug, Clone, Copy, PartialEq, Eq)]
pub enum GpuFeatureName {
    DepthClipControl = "depth-clip-control",
    Depth32floatStencil8 = "depth32float-stencil8",
    TextureCompressionBc = "texture-compression-bc",
    TextureCompressionBcSliced3d = "texture-compression-bc-sliced-3d",
    TextureCompressionEtc2 = "texture-compression-etc2",
    TextureCompressionAstc = "texture-compression-astc",
    TextureCompressionAstcSliced3d = "texture-compression-astc-sliced-3d",
    TimestampQuery = "timestamp-query",
    IndirectFirstInstance = "indirect-first-instance",
    ShaderF16 = "shader-f16",
    Rg11b10ufloatRenderable = "rg11b10ufloat-renderable",
    Bgra8unormStorage = "bgra8unorm-storage",
    Float32Filterable = "float32-filterable",
    Float32Blendable = "float32-blendable",
    ClipDistances = "clip-distances",
    DualSourceBlending = "dual-source-blending",
}
