// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// When writing a match expression against `ObjectStorageClass`, it is important to ensure
/// your code is forward-compatible. That is, if a match arm handles a case for a
/// feature that is supported by the service but has not been represented as an enum
/// variant in a current version of SDK, your code should continue to work when you
/// upgrade SDK to a future version in which the enum does include a variant for that
/// feature.
///
/// Here is an example of how you can make a match expression forward-compatible:
///
/// ```text
/// # let objectstorageclass = unimplemented!();
/// match objectstorageclass {
///     ObjectStorageClass::DeepArchive => { /* ... */ },
///     ObjectStorageClass::ExpressOnezone => { /* ... */ },
///     ObjectStorageClass::Glacier => { /* ... */ },
///     ObjectStorageClass::GlacierIr => { /* ... */ },
///     ObjectStorageClass::IntelligentTiering => { /* ... */ },
///     ObjectStorageClass::OnezoneIa => { /* ... */ },
///     ObjectStorageClass::Outposts => { /* ... */ },
///     ObjectStorageClass::ReducedRedundancy => { /* ... */ },
///     ObjectStorageClass::Snow => { /* ... */ },
///     ObjectStorageClass::Standard => { /* ... */ },
///     ObjectStorageClass::StandardIa => { /* ... */ },
///     other @ _ if other.as_str() == "NewFeature" => { /* handles a case for `NewFeature` */ },
///     _ => { /* ... */ },
/// }
/// ```
/// The above code demonstrates that when `objectstorageclass` represents
/// `NewFeature`, the execution path will lead to the second last match arm,
/// even though the enum does not contain a variant `ObjectStorageClass::NewFeature`
/// in the current version of SDK. The reason is that the variable `other`,
/// created by the `@` operator, is bound to
/// `ObjectStorageClass::Unknown(UnknownVariantValue("NewFeature".to_owned()))`
/// and calling `as_str` on it yields `"NewFeature"`.
/// This match expression is forward-compatible when executed with a newer
/// version of SDK where the variant `ObjectStorageClass::NewFeature` is defined.
/// Specifically, when `objectstorageclass` represents `NewFeature`,
/// the execution path will hit the second last match arm as before by virtue of
/// calling `as_str` on `ObjectStorageClass::NewFeature` also yielding `"NewFeature"`.
///
/// Explicitly matching on the `Unknown` variant should
/// be avoided for two reasons:
/// - The inner data `UnknownVariantValue` is opaque, and no further information can be extracted.
/// - It might inadvertently shadow other intended match arms.
///
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(
    ::std::clone::Clone, ::std::cmp::Eq, ::std::cmp::Ord, ::std::cmp::PartialEq, ::std::cmp::PartialOrd, ::std::fmt::Debug, ::std::hash::Hash,
)]
pub enum ObjectStorageClass {
    #[allow(missing_docs)] // documentation missing in model
    DeepArchive,
    #[allow(missing_docs)] // documentation missing in model
    ExpressOnezone,
    #[allow(missing_docs)] // documentation missing in model
    Glacier,
    #[allow(missing_docs)] // documentation missing in model
    GlacierIr,
    #[allow(missing_docs)] // documentation missing in model
    IntelligentTiering,
    #[allow(missing_docs)] // documentation missing in model
    OnezoneIa,
    #[allow(missing_docs)] // documentation missing in model
    Outposts,
    #[allow(missing_docs)] // documentation missing in model
    ReducedRedundancy,
    #[allow(missing_docs)] // documentation missing in model
    Snow,
    #[allow(missing_docs)] // documentation missing in model
    Standard,
    #[allow(missing_docs)] // documentation missing in model
    StandardIa,
    /// `Unknown` contains new variants that have been added since this code was generated.
    #[deprecated(note = "Don't directly match on `Unknown`. See the docs on this enum for the correct way to handle unknown variants.")]
    Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue),
}
impl ::std::convert::From<&str> for ObjectStorageClass {
    fn from(s: &str) -> Self {
        match s {
            "DEEP_ARCHIVE" => ObjectStorageClass::DeepArchive,
            "EXPRESS_ONEZONE" => ObjectStorageClass::ExpressOnezone,
            "GLACIER" => ObjectStorageClass::Glacier,
            "GLACIER_IR" => ObjectStorageClass::GlacierIr,
            "INTELLIGENT_TIERING" => ObjectStorageClass::IntelligentTiering,
            "ONEZONE_IA" => ObjectStorageClass::OnezoneIa,
            "OUTPOSTS" => ObjectStorageClass::Outposts,
            "REDUCED_REDUNDANCY" => ObjectStorageClass::ReducedRedundancy,
            "SNOW" => ObjectStorageClass::Snow,
            "STANDARD" => ObjectStorageClass::Standard,
            "STANDARD_IA" => ObjectStorageClass::StandardIa,
            other => ObjectStorageClass::Unknown(crate::primitives::sealed_enum_unknown::UnknownVariantValue(other.to_owned())),
        }
    }
}
impl ::std::str::FromStr for ObjectStorageClass {
    type Err = ::std::convert::Infallible;

    fn from_str(s: &str) -> ::std::result::Result<Self, <Self as ::std::str::FromStr>::Err> {
        ::std::result::Result::Ok(ObjectStorageClass::from(s))
    }
}
impl ObjectStorageClass {
    /// Returns the `&str` value of the enum member.
    pub fn as_str(&self) -> &str {
        match self {
            ObjectStorageClass::DeepArchive => "DEEP_ARCHIVE",
            ObjectStorageClass::ExpressOnezone => "EXPRESS_ONEZONE",
            ObjectStorageClass::Glacier => "GLACIER",
            ObjectStorageClass::GlacierIr => "GLACIER_IR",
            ObjectStorageClass::IntelligentTiering => "INTELLIGENT_TIERING",
            ObjectStorageClass::OnezoneIa => "ONEZONE_IA",
            ObjectStorageClass::Outposts => "OUTPOSTS",
            ObjectStorageClass::ReducedRedundancy => "REDUCED_REDUNDANCY",
            ObjectStorageClass::Snow => "SNOW",
            ObjectStorageClass::Standard => "STANDARD",
            ObjectStorageClass::StandardIa => "STANDARD_IA",
            ObjectStorageClass::Unknown(value) => value.as_str(),
        }
    }
    /// Returns all the `&str` representations of the enum members.
    pub const fn values() -> &'static [&'static str] {
        &[
            "DEEP_ARCHIVE",
            "EXPRESS_ONEZONE",
            "GLACIER",
            "GLACIER_IR",
            "INTELLIGENT_TIERING",
            "ONEZONE_IA",
            "OUTPOSTS",
            "REDUCED_REDUNDANCY",
            "SNOW",
            "STANDARD",
            "STANDARD_IA",
        ]
    }
}
impl ::std::convert::AsRef<str> for ObjectStorageClass {
    fn as_ref(&self) -> &str {
        self.as_str()
    }
}
impl ObjectStorageClass {
    /// Parses the enum value while disallowing unknown variants.
    ///
    /// Unknown variants will result in an error.
    pub fn try_parse(value: &str) -> ::std::result::Result<Self, crate::error::UnknownVariantError> {
        match Self::from(value) {
            #[allow(deprecated)]
            Self::Unknown(_) => ::std::result::Result::Err(crate::error::UnknownVariantError::new(value)),
            known => Ok(known),
        }
    }
}
impl ::std::fmt::Display for ObjectStorageClass {
    fn fmt(&self, f: &mut ::std::fmt::Formatter) -> ::std::fmt::Result {
        match self {
            ObjectStorageClass::DeepArchive => write!(f, "DEEP_ARCHIVE"),
            ObjectStorageClass::ExpressOnezone => write!(f, "EXPRESS_ONEZONE"),
            ObjectStorageClass::Glacier => write!(f, "GLACIER"),
            ObjectStorageClass::GlacierIr => write!(f, "GLACIER_IR"),
            ObjectStorageClass::IntelligentTiering => write!(f, "INTELLIGENT_TIERING"),
            ObjectStorageClass::OnezoneIa => write!(f, "ONEZONE_IA"),
            ObjectStorageClass::Outposts => write!(f, "OUTPOSTS"),
            ObjectStorageClass::ReducedRedundancy => write!(f, "REDUCED_REDUNDANCY"),
            ObjectStorageClass::Snow => write!(f, "SNOW"),
            ObjectStorageClass::Standard => write!(f, "STANDARD"),
            ObjectStorageClass::StandardIa => write!(f, "STANDARD_IA"),
            ObjectStorageClass::Unknown(value) => write!(f, "{}", value),
        }
    }
}
