from typing import Dict

from .. import Provider as LoremProvider


class Provider(LoremProvider):
    """Implement lorem provider for ``it_IT`` locale.

    Word list is based on the source(s) below, and some words have been removed
    to make the word list appropriate for public testing.

    Sources:

    - https://github.com/napolux/paroleitaliane
    """

    word_list: tuple = (
        "a",
        "abbandonare",
        "abbastanza",
        "abitare",
        "abito",
        "accadere",
        "accanto",
        "accendere",
        "accettare",
        "accogliere",
        "accompagnare",
        "accordo",
        "accorgersi",
        "acqua",
        "addirittura",
        "addosso",
        "adesso",
        "affare",
        "affatto",
        "affermare",
        "affrontare",
        "aggiungere",
        "ah",
        "aiutare",
        "aiuto",
        "albergo",
        "albero",
        "alcuno",
        "allontanare",
        "allora",
        "almeno",
        "alto",
        "altro",
        "alzare",
        "amare",
        "ambiente",
        "americano",
        "amico",
        "ammazzare",
        "ammettere",
        "amore",
        "ampio",
        "anche",
        "ancora",
        "andare",
        "angolo",
        "anima",
        "animale",
        "animo",
        "anno",
        "annunciare",
        "antico",
        "anzi",
        "apparire",
        "appartenere",
        "appena",
        "appoggiare",
        "appunto",
        "aprire",
        "argomento",
        "aria",
        "arma",
        "armare",
        "arrestare",
        "arrivare",
        "arte",
        "articolo",
        "ascoltare",
        "aspettare",
        "aspetto",
        "assai",
        "assicurare",
        "assistere",
        "assoluto",
        "assumere",
        "attaccare",
        "atteggiamento",
        "attendere",
        "attento",
        "attenzione",
        "attesa",
        "attimo",
        "attività",
        "atto",
        "attore",
        "attorno",
        "attraversare",
        "attuale",
        "aumentare",
        "automobile",
        "autore",
        "autorità",
        "avanti",
        "avanzare",
        "avere",
        "avvenire",
        "avvertire",
        "avvicinare",
        "avvocato",
        "azione",
        "azzurro",
        "baciare",
        "badare",
        "bagno",
        "bambina",
        "bambino",
        "base",
        "basso",
        "bastare",
        "battaglia",
        "battere",
        "bellezza",
        "bello",
        "bene",
        "bere",
        "bestia",
        "bianco",
        "biondo",
        "bisognare",
        "bisogno",
        "bocca",
        "bosco",
        "braccio",
        "bravo",
        "breve",
        "bruciare",
        "brutto",
        "buio",
        "buono",
        "buttare",
        "cadere",
        "caffè",
        "calcio",
        "caldo",
        "cambiare",
        "camera",
        "camminare",
        "campagna",
        "campo",
        "cane",
        "cantare",
        "capace",
        "capello",
        "capire",
        "capitare",
        "capo",
        "carattere",
        "caratteristico",
        "carne",
        "caro",
        "carta",
        "casa",
        "caso",
        "cattivo",
        "cattolico",
        "causa",
        "cavallo",
        "celebrare",
        "centrale",
        "centro",
        "cercare",
        "certamente",
        "certo",
        "che",
        "chi",
        "chiamare",
        "chiaro",
        "chiave",
        "chiedere",
        "chiesa",
        "chilometro",
        "chissà",
        "chiudere",
        "ci",
        "ciascuno",
        "cielo",
        "cioè",
        "circa",
        "cittadino",
        "città",
        "civile",
        "civiltà",
        "ciò",
        "classe",
        "collina",
        "collo",
        "colore",
        "coloro",
        "colpa",
        "colpire",
        "colpo",
        "come",
        "cominciare",
        "commercio",
        "commissione",
        "comodo",
        "compagnia",
        "compagno",
        "compiere",
        "completamente",
        "comporre",
        "comprare",
        "comprendere",
        "comune",
        "comunicazione",
        "comunque",
        "con",
        "concedere",
        "concetto",
        "concludere",
        "condizione",
        "condurre",
        "confessare",
        "confronto",
        "congresso",
        "conoscenza",
        "conoscere",
        "conseguenza",
        "consentire",
        "conservare",
        "considerare",
        "consiglio",
        "contadino",
        "contare",
        "contatto",
        "contenere",
        "contento",
        "continuare",
        "continuo",
        "conto",
        "contrario",
        "contro",
        "controllo",
        "convincere",
        "coprire",
        "coraggio",
        "corpo",
        "corrente",
        "correre",
        "corsa",
        "corso",
        "cortile",
        "cosa",
        "coscienza",
        "costa",
        "costituire",
        "costringere",
        "costruire",
        "costruzione",
        "creare",
        "credere",
        "crescere",
        "crisi",
        "cristiano",
        "croce",
        "cucina",
        "cui",
        "cultura",
        "cuore",
        "cura",
        "da",
        "dare",
        "davanti",
        "davvero",
        "decidere",
        "decisione",
        "dedicare",
        "denaro",
        "dente",
        "dentro",
        "descrivere",
        "desiderare",
        "desiderio",
        "destino",
        "destro",
        "determinare",
        "di",
        "dichiarare",
        "dietro",
        "difendere",
        "difesa",
        "differenza",
        "difficile",
        "difficoltà",
        "diffondere",
        "dimenticare",
        "dimostrare",
        "dinanzi",
        "dio",
        "dipendere",
        "dire",
        "diretto",
        "direttore",
        "direzione",
        "dirigere",
        "diritto",
        "discorso",
        "discutere",
        "disporre",
        "disposizione",
        "distanza",
        "distinguere",
        "distruggere",
        "dito",
        "divenire",
        "diventare",
        "diverso",
        "divertire",
        "dividere",
        "dolce",
        "dolore",
        "domanda",
        "domandare",
        "domani",
        "domenica",
        "don",
        "donna",
        "dopo",
        "dormire",
        "dottore",
        "dove",
        "dovere",
        "dubbio",
        "dunque",
        "durante",
        "durare",
        "duro",
        "e",
        "eccellenza",
        "eccetera",
        "ecco",
        "economico",
        "effetto",
        "egli",
        "eh",
        "elemento",
        "elettrico",
        "elevare",
        "energia",
        "enorme",
        "entrare",
        "entro",
        "epoca",
        "eppure",
        "erba",
        "errore",
        "esame",
        "escludere",
        "esempio",
        "esercito",
        "esistere",
        "esperienza",
        "esporre",
        "espressione",
        "esprimere",
        "essa",
        "essere",
        "esso",
        "estate",
        "estendere",
        "estero",
        "estremo",
        "età",
        "europeo",
        "evitare",
        "fabbrica",
        "faccia",
        "facile",
        "fame",
        "famiglia",
        "famoso",
        "fantasia",
        "fatica",
        "fatto",
        "favore",
        "fede",
        "felice",
        "fenomeno",
        "ferire",
        "fermare",
        "fermo",
        "ferro",
        "festa",
        "fianco",
        "fiducia",
        "figlia",
        "figlio",
        "figura",
        "figurare",
        "film",
        "filo",
        "finalmente",
        "finché",
        "fine",
        "finestra",
        "finire",
        "fino",
        "fiore",
        "fissare",
        "fiume",
        "foglia",
        "folla",
        "fondare",
        "fondo",
        "forma",
        "formare",
        "fornire",
        "forse",
        "forte",
        "fortuna",
        "forza",
        "fra",
        "francese",
        "frase",
        "fratello",
        "freddo",
        "fresco",
        "fretta",
        "fronte",
        "frutto",
        "fuggire",
        "fumare",
        "funzione",
        "fuoco",
        "fuori",
        "futuro",
        "gamba",
        "gatto",
        "generale",
        "genere",
        "gente",
        "gesto",
        "gettare",
        "giallo",
        "giardino",
        "giocare",
        "gioco",
        "gioia",
        "giornale",
        "giornata",
        "giorno",
        "giovane",
        "giovanotto",
        "girare",
        "giro",
        "giudicare",
        "giudizio",
        "giugno",
        "giungere",
        "giustizia",
        "giusto",
        "già",
        "giù",
        "godere",
        "governo",
        "grado",
        "grande",
        "grave",
        "grazia",
        "grazie",
        "greco",
        "gridare",
        "grigio",
        "grosso",
        "gruppo",
        "guardare",
        "guardia",
        "guerra",
        "guidare",
        "gusto",
        "idea",
        "ieri",
        "il",
        "immaginare",
        "immagine",
        "imparare",
        "impedire",
        "imporre",
        "importante",
        "importanza",
        "importare",
        "impossibile",
        "impressione",
        "improvviso",
        "in",
        "incontrare",
        "indicare",
        "indietro",
        "industria",
        "industriale",
        "infatti",
        "infine",
        "inglese",
        "iniziare",
        "inizio",
        "innamorare",
        "inoltre",
        "insegnare",
        "insieme",
        "insistere",
        "insomma",
        "intanto",
        "intendere",
        "intenzione",
        "interessante",
        "interessare",
        "interesse",
        "internazionale",
        "interno",
        "intero",
        "intorno",
        "inutile",
        "invece",
        "inverno",
        "invitare",
        "io",
        "isola",
        "istante",
        "istituto",
        "italiano",
        "labbro",
        "lago",
        "lanciare",
        "largo",
        "lasciare",
        "latino",
        "lato",
        "latte",
        "lavorare",
        "lavoro",
        "legare",
        "legge",
        "leggere",
        "leggero",
        "lei",
        "lettera",
        "letto",
        "levare",
        "li",
        "liberare",
        "libero",
        "libertà",
        "libro",
        "limitare",
        "limite",
        "linea",
        "lingua",
        "lira",
        "lo",
        "lontano",
        "loro",
        "lotta",
        "luce",
        "lui",
        "luna",
        "lungo",
        "luogo",
        "là",
        "lì",
        "ma",
        "macchina",
        "madre",
        "maestro",
        "magari",
        "maggio",
        "maggiore",
        "malattia",
        "male",
        "mamma",
        "mancare",
        "mandare",
        "mangiare",
        "maniera",
        "mano",
        "mantenere",
        "mare",
        "marito",
        "massa",
        "massimo",
        "materia",
        "matrimonio",
        "mattina",
        "mattino",
        "medesimo",
        "medico",
        "medio",
        "meglio",
        "memoria",
        "meno",
        "mente",
        "mentre",
        "mercato",
        "meritare",
        "merito",
        "mese",
        "messa",
        "mestiere",
        "metro",
        "mettere",
        "metà",
        "mezzo",
        "mi",
        "migliore",
        "milione",
        "militare",
        "minimo",
        "ministro",
        "minore",
        "minuto",
        "mio",
        "misura",
        "moderno",
        "modo",
        "moglie",
        "molto",
        "momento",
        "mondo",
        "montagna",
        "monte",
        "morale",
        "morire",
        "morte",
        "mostrare",
        "motivo",
        "movimento",
        "muovere",
        "muro",
        "musica",
        "nascere",
        "nascondere",
        "natura",
        "naturale",
        "naturalmente",
        "nave",
        "nazionale",
        "nazione",
        "ne",
        "neanche",
        "necessario",
        "necessità",
        "nemico",
        "nemmeno",
        "neppure",
        "nero",
        "nessuno",
        "niente",
        "no",
        "nobile",
        "noi",
        "nome",
        "non",
        "nord",
        "normale",
        "nostro",
        "notare",
        "notevole",
        "notizia",
        "noto",
        "notte",
        "nudo",
        "nulla",
        "numero",
        "numeroso",
        "nuovo",
        "né",
        "o",
        "occasione",
        "occhio",
        "occorrere",
        "odore",
        "offendere",
        "offrire",
        "oggetto",
        "oggi",
        "ogni",
        "ognuno",
        "oh",
        "oltre",
        "ombra",
        "onore",
        "opera",
        "operaio",
        "operazione",
        "opinione",
        "opporre",
        "oppure",
        "ora",
        "oramai",
        "ordinare",
        "ordine",
        "orecchio",
        "organizzare",
        "origine",
        "oro",
        "ospedale",
        "osservare",
        "ottenere",
        "pace",
        "padre",
        "padrone",
        "paese",
        "pagare",
        "pagina",
        "palazzo",
        "pane",
        "papà",
        "parecchio",
        "parere",
        "parete",
        "parlare",
        "parola",
        "parte",
        "partecipare",
        "particolare",
        "partire",
        "partito",
        "passare",
        "passato",
        "passione",
        "passo",
        "patria",
        "paura",
        "pazzo",
        "peccato",
        "peggio",
        "pelle",
        "pena",
        "pensare",
        "pensiero",
        "per",
        "perché",
        "perciò",
        "perdere",
        "perfetto",
        "perfino",
        "pericolo",
        "pericoloso",
        "periodo",
        "permettere",
        "persona",
        "personaggio",
        "personale",
        "però",
        "pesare",
        "peso",
        "pezzo",
        "piacere",
        "piangere",
        "piano",
        "pianta",
        "piantare",
        "pianura",
        "piazza",
        "piccolo",
        "piede",
        "pieno",
        "pietra",
        "pietà",
        "piuttosto",
        "più",
        "poco",
        "poesia",
        "poeta",
        "poiché",
        "politica",
        "politico",
        "polizia",
        "pomeriggio",
        "ponte",
        "popolazione",
        "popolo",
        "porre",
        "porta",
        "portare",
        "porto",
        "posare",
        "posizione",
        "possedere",
        "possibile",
        "possibilità",
        "posto",
        "potenza",
        "potere",
        "povero",
        "pranzo",
        "prato",
        "preciso",
        "preferire",
        "pregare",
        "prendere",
        "preoccupare",
        "preparare",
        "presentare",
        "presente",
        "presenza",
        "presidente",
        "presso",
        "presto",
        "prevedere",
        "prezzo",
        "prima",
        "primo",
        "principale",
        "principe",
        "principio",
        "privato",
        "probabilmente",
        "problema",
        "procedere",
        "processo",
        "prodotto",
        "produrre",
        "produzione",
        "professore",
        "profondo",
        "programma",
        "promettere",
        "pronto",
        "proporre",
        "proposito",
        "proposta",
        "proprio",
        "prossimo",
        "prova",
        "provare",
        "provincia",
        "provocare",
        "provvedere",
        "pubblicare",
        "pubblico",
        "punta",
        "punto",
        "pure",
        "puro",
        "qua",
        "quadro",
        "qualche",
        "qualcosa",
        "qualcuno",
        "quale",
        "qualità",
        "qualsiasi",
        "qualunque",
        "quanto",
        "quarto",
        "quasi",
        "quello",
        "questione",
        "questo",
        "qui",
        "quindi",
        "raccogliere",
        "raccontare",
        "ragazza",
        "ragazzo",
        "raggiungere",
        "ragione",
        "rapido",
        "rapporto",
        "rappresentare",
        "reale",
        "realtà",
        "recare",
        "recente",
        "regione",
        "regno",
        "relazione",
        "religioso",
        "rendere",
        "repubblica",
        "resistere",
        "restare",
        "resto",
        "ricchezza",
        "ricco",
        "ricerca",
        "ricevere",
        "richiedere",
        "riconoscere",
        "ricordare",
        "ricordo",
        "ridere",
        "ridurre",
        "riempire",
        "rientrare",
        "riferire",
        "rifiutare",
        "riguardare",
        "rimanere",
        "rimettere",
        "ringraziare",
        "ripetere",
        "riportare",
        "riprendere",
        "risolvere",
        "rispetto",
        "rispondere",
        "risposta",
        "risultare",
        "risultato",
        "ritenere",
        "ritornare",
        "ritorno",
        "ritrovare",
        "riunire",
        "riuscire",
        "riva",
        "rivedere",
        "rivelare",
        "rivolgere",
        "rivoluzione",
        "roba",
        "romano",
        "rompere",
        "rosso",
        "russo",
        "sacrificio",
        "sacro",
        "sala",
        "salire",
        "saltare",
        "salutare",
        "salvare",
        "sangue",
        "sapere",
        "sbagliare",
        "scala",
        "scappare",
        "scegliere",
        "scena",
        "scendere",
        "scherzare",
        "scienza",
        "scomparire",
        "scopo",
        "scoppiare",
        "scoprire",
        "scorrere",
        "scrittore",
        "scrivere",
        "scuola",
        "scusare",
        "se",
        "secolo",
        "secondo",
        "sede",
        "sedere",
        "segnare",
        "segno",
        "segretario",
        "segreto",
        "seguire",
        "seguito",
        "sembrare",
        "semplice",
        "senso",
        "sentimento",
        "sentire",
        "senza",
        "sera",
        "sereno",
        "serie",
        "serio",
        "servire",
        "servizio",
        "settimana",
        "sforzo",
        "sguardo",
        "si",
        "sicurezza",
        "sicuro",
        "significare",
        "signora",
        "signore",
        "signorina",
        "silenzio",
        "simile",
        "sinistro",
        "sino",
        "sistema",
        "situazione",
        "smettere",
        "sociale",
        "società",
        "soffrire",
        "sognare",
        "sogno",
        "soldato",
        "sole",
        "solito",
        "solo",
        "soltanto",
        "soluzione",
        "sonno",
        "sopra",
        "soprattutto",
        "sorella",
        "sorgere",
        "sorprendere",
        "sorridere",
        "sorriso",
        "sostenere",
        "sottile",
        "sotto",
        "spalla",
        "spazio",
        "speciale",
        "specie",
        "spegnere",
        "speranza",
        "sperare",
        "spesa",
        "spesso",
        "spettacolo",
        "spiegare",
        "spingere",
        "spirito",
        "sposare",
        "stabilire",
        "staccare",
        "stagione",
        "stamattina",
        "stampa",
        "stanco",
        "stanza",
        "stare",
        "stasera",
        "stato",
        "stazione",
        "stella",
        "stesso",
        "storia",
        "storico",
        "strada",
        "straniero",
        "strano",
        "straordinario",
        "stringere",
        "strumento",
        "studiare",
        "studio",
        "stupido",
        "su",
        "subito",
        "succedere",
        "successo",
        "sud",
        "suo",
        "suonare",
        "superare",
        "superiore",
        "svegliare",
        "sviluppo",
        "svolgere",
        "sì",
        "tacere",
        "tagliare",
        "tale",
        "tanto",
        "tardi",
        "tavola",
        "tavolo",
        "teatro",
        "tecnico",
        "tedesco",
        "temere",
        "tempo",
        "tendere",
        "tenere",
        "tentare",
        "termine",
        "terreno",
        "territorio",
        "terzo",
        "testa",
        "tipo",
        "tirare",
        "titolo",
        "toccare",
        "togliere",
        "tono",
        "tornare",
        "tra",
        "tranquillo",
        "trarre",
        "trascinare",
        "trasformare",
        "trattare",
        "tratto",
        "treno",
        "triste",
        "troppo",
        "trovare",
        "tu",
        "tuo",
        "tuttavia",
        "tutto",
        "uccidere",
        "udire",
        "ufficiale",
        "ufficio",
        "uguale",
        "ultimo",
        "umano",
        "un",
        "unico",
        "unire",
        "università",
        "uno",
        "uomo",
        "usare",
        "uscire",
        "uso",
        "utile",
        "valere",
        "valle",
        "valore",
        "vario",
        "vasto",
        "vecchio",
        "vedere",
        "vendere",
        "venire",
        "vento",
        "veramente",
        "verde",
        "verità",
        "vero",
        "verso",
        "vestire",
        "vestito",
        "vi",
        "via",
        "viaggio",
        "vicino",
        "villa",
        "vincere",
        "vino",
        "visita",
        "viso",
        "vista",
        "vita",
        "vivere",
        "vivo",
        "voce",
        "voglia",
        "voi",
        "volare",
        "volere",
        "volgere",
        "volontà",
        "volta",
        "voltare",
        "volto",
        "vostro",
        "vuoto",
        "zia",
        "zio",
        "zitto",
        "zona",
    )

    parts_of_speech: Dict[str, tuple] = {
        "verb": (
            "abaliena",
            "abbaiano",
            "abbandonatevi",
            "abbaruffavano",
            "abbelisca",
            "abbicava",
            "abbisciammo",
            "abbonati",
            "abborriva",
            "abbraciava",
            "abbrividisco",
            "abbrumavi",
            "abbrustoleremo",
            "abburattavano",
            "abiliterete",
            "abondai",
            "accadrebbe",
            "accalorammo",
            "accanalarono",
            "accapezzato",
            "accappucciasti",
            "accartoccerà",
            "accastellinando",
            "accavalcia",
            "acceleravo",
            "accentreremo",
            "accerti",
            "acchiocciolerò",
            "acciarpando",
            "accingerebbero",
            "accivettassero",
            "accoccavate",
            "accomiatano",
            "acconciavamo",
            "accoppiandosi",
            "accoriamo",
            "accottimeremo",
            "accucciolato",
            "accusiamoci",
            "acquadernassero",
            "acqueterebbero",
            "acuisci",
            "addebbiasti",
            "addentravo",
            "addimostrante",
            "addizionammo",
            "addolciai",
            "addormentatevi",
            "adduco",
            "aderiremmo",
            "adiuverei",
            "adonterei",
            "adsorbiremmo",
            "adunghierei",
            "aerotrasportò",
            "affamammo",
            "affaticarsi",
            "afferrassero",
            "affidano",
            "affilare",
            "affisate",
            "affluiresti",
            "affonderebbero",
            "affranchiamoci",
            "affretto",
            "affusolasse",
            "aggangherante",
            "aggettiverai",
            "aggiogherò",
            "aggiunteranno",
            "aggradiscano",
            "aggraticciavano",
            "aggriccio",
            "aggrotto",
            "agguanterete",
            "agitavi",
            "aguneremo",
            "albeggiando",
            "alchimierete",
            "alesi",
            "alimentammo",
            "allarga",
            "alleggerirebbero",
            "alleniremo",
            "allettati",
            "allicciavo",
            "allocchiresti",
            "allucchettassi",
            "alluminiò",
            "alò",
            "alternarono",
            "ambiasse",
            "ammacchereste",
            "ammanicatevi",
            "ammansirete",
            "ammassavi",
            "ammazzeranno",
            "ammezza",
            "ammiserireste",
            "ammollavi",
            "ammorbiate",
            "ammorzasse",
            "ammuffisca",
            "ammutolisti",
            "amplio",
            "anatomizzammo",
            "andicappava",
            "angariavamo",
            "animato",
            "annebbierai",
            "annichilavi",
            "annoderemmo",
            "annuissi",
            "anodizzava",
            "anterghereste",
            "antivenire",
            "aontato",
            "appacificherà",
            "appanetterà",
            "apparo",
            "appelleranno",
            "appesisco",
            "appiastreresti",
            "appiccoliste",
            "appisolantesi",
            "appoppantesi",
            "appresentiate",
            "approderete",
            "approprierai",
            "appulcreranno",
            "aprite",
            "arcaizzato",
            "ardiate",
            "argomento",
            "armonizzò",
            "arraffiare",
            "arrapinato",
            "arremberemo",
            "arricciarsi",
            "arrisicheresti",
            "arrolavamo",
            "arrostente",
            "arroventerebbero",
            "arrugginite",
            "articolerete",
            "ascoltai",
            "aspetterò",
            "assaltassero",
            "assedieranno",
            "assembro",
            "asservito",
            "assicurino",
            "assimilarono",
            "assoggettiamoci",
            "assommarono",
            "assordiresti",
            "assurgeranno",
            "astrologassi",
            "attardammo",
            "attendo",
            "atterzato",
            "attivare",
            "attortigliare",
            "attrappivano",
            "attruppavamo",
            "auggiarono",
            "aureolerebbero",
            "autocandidantesi",
            "autofinanziamoci",
            "autonominerebbero",
            "autorizzo",
            "avallò",
            "aviotrasportavate",
            "avvantaggereste",
            "avverare",
            "avvicinandosi",
            "avvinazzino",
            "avvitavamo",
            "avvolgesse",
            "azzanneremmo",
            "azzittivamo",
            "bacchettai",
            "bagorderà",
            "ballo",
            "bamboleggeresti",
            "baraccheranno",
            "barbugliavano",
            "barrire",
            "bassavate",
            "batteva",
            "beccheggiare",
            "benavrei",
            "benmeritino",
            "biancheggerà",
            "bidonassi",
            "bilanciante",
            "biondeggiaste",
            "biseco",
            "bituminaste",
            "blinderebbero",
            "boccio",
            "bonderizzavi",
            "bordo",
            "bramassero",
            "braserebbero",
            "brillantino",
            "brogliavano",
            "brulicherei",
            "bucando",
            "bugnate",
            "burlerebbe",
            "butterino",
            "cachiamoci",
            "cagionammo",
            "calcereste",
            "caletterebbe",
            "calunnierebbero",
            "campeggiano",
            "cancellassi",
            "cannassimo",
            "canteremo",
            "capendosi",
            "capitolavate",
            "capotteremmo",
            "carambolino",
            "carbossilai",
            "carezzate",
            "carpionassero",
            "carteggiavano",
            "cassassero",
            "catalogherebbe",
            "catramiate",
            "cavalcano",
            "cazziate",
            "celiavo",
            "censisti",
            "centrasse",
            "cernerai",
            "cheratinizzavano",
            "chiarificato",
            "chiedevate",
            "chinò",
            "choccassero",
            "cianfruglieranno",
            "cicatrizzerete",
            "cilindrarono",
            "cingerei",
            "circoncidete",
            "circonfondevamo",
            "circuivo",
            "ciulando",
            "clamavate",
            "clicchereste",
            "coabitare",
            "coccolarsi",
            "cogestirono",
            "cointeressa",
            "colettavo",
            "collettivizzerai",
            "colloquiereste",
            "coloritevi",
            "coltreremo",
            "comicizzerete",
            "commercializzi",
            "commisurerei",
            "compartente",
            "compattante",
            "compiacciate",
            "complessero",
            "complotterò",
            "compreremo",
            "computeresti",
            "concedono",
            "concetterebbero",
            "conclamassi",
            "concretizzare",
            "condescendendo",
            "conducevamo",
            "confettammo",
            "confinarono",
            "conformarono",
            "congedino",
            "congloba",
            "conguagliò",
            "connumerino",
            "conseguirete",
            "consocia",
            "constante",
            "contabilizzammo",
            "conteggiai",
            "contese",
            "contorcono",
            "contradissi",
            "contrarierò",
            "contravvenne",
            "controfirmasti",
            "controproverà",
            "controsterzino",
            "convenzionato",
            "convito",
            "coobavi",
            "copierà",
            "corazzi",
            "cornificarono",
            "corresponsabilizzerete",
            "corrucceremo",
            "cortocircuitarono",
            "cospiravi",
            "costicchiereste",
            "costudisco",
            "cracca",
            "crepitammo",
            "criptaste",
            "crivellava",
            "crollati",
            "crucciamoci",
            "culminate",
            "curvava",
            "dannato",
            "dattiloscritto",
            "debellate",
            "decaffeinizzerebbe",
            "decapò",
            "decellerate",
            "decideva",
            "declassificammo",
            "decompartimentate",
            "decongelavamo",
            "decorreva",
            "decriminalizziamo",
            "deducano",
            "deferirebbero",
            "defiscalizzavamo",
            "defluissero",
            "defosforò",
            "deglobalizzate",
            "deidrogenavamo",
            "delegifichiamo",
            "deliziamoci",
            "demanializzassero",
            "demilitarizzeranno",
            "demolivi",
            "demotivantesi",
            "denigrassimo",
            "denuclearizzerei",
            "deossigenerei",
            "deperivi",
            "depoliticizzai",
            "depravassimo",
            "deprivavi",
            "deratizzerei",
            "deresponsabilizzino",
            "desalaste",
            "deselezionavo",
            "desio",
            "desossidaste",
            "destatalizziamo",
            "destruggerebbe",
            "deterioreremo",
            "detronizzasti",
            "deventerei",
            "dia",
            "dialogizzavamo",
            "dieseranno",
            "differissero",
            "digitalizzavate",
            "digrigniate",
            "dilatantesi",
            "diligemmo",
            "dimagrirò",
            "dimetterete",
            "dimungessimo",
            "dipartissi",
            "diramate",
            "dirompente",
            "disaccentasse",
            "disacidiresti",
            "disamavano",
            "disappannavamo",
            "disarticolerete",
            "disattesi",
            "discaddero",
            "discernessero",
            "discioglievate",
            "discomporremo",
            "disconverresti",
            "discrediti",
            "disdegnassero",
            "disegnerebbe",
            "disgeleremmo",
            "disimballassi",
            "disincentivate",
            "disinformeranno",
            "disinnestavo",
            "disintendevi",
            "disloceresti",
            "disorganizzerò",
            "dispaiono",
            "disperdete",
            "disponente",
            "disqualificammo",
            "dissanguati",
            "dissentirò",
            "disseteresti",
            "dissodi",
            "distacchiate",
            "distolgano",
            "distringeresti",
            "disuniamoci",
            "disvolente",
            "divampate",
            "diversificheremmo",
            "divinerebbero",
            "documentavano",
            "domammo",
            "dondolava",
            "dormivi",
            "drappeggerà",
            "dubitò",
            "durerai",
            "eccettuato",
            "editate",
            "efficientasti",
            "eguaglierebbe",
            "elementarizzare",
            "elettrolizzavano",
            "elogiammo",
            "emanavi",
            "emettereste",
            "emungete",
            "entreresti",
            "epuriate",
            "equivalente",
            "ereditassimo",
            "eroicizzavo",
            "erutterà",
            "esaminavo",
            "esciresti",
            "escotete",
            "esento",
            "esigi",
            "esondò",
            "espatria",
            "espiavano",
            "esplorerò",
            "espungevate",
            "esterificherai",
            "estinguevo",
            "estraniaste",
            "estubano",
            "eterizzate",
            "euforizzeranno",
            "evidenziai",
            "evoluimmo",
            "fagocitavo",
            "falsifichiate",
            "farneticheremo",
            "fatturerebbero",
            "feda",
            "feltrò",
            "ferriamo",
            "fiacco",
            "ficcasti",
            "figliate",
            "filosofeggiò",
            "finlandizzavo",
            "fioretterei",
            "fischiettassero",
            "flambasti",
            "flocculerai",
            "fluorizzò",
            "fognassimo",
            "fondantesi",
            "forbissimo",
            "formavano",
            "fortificheranno",
            "fosforilo",
            "fracasserei",
            "frammischiava",
            "frappammo",
            "fraternizzato",
            "freme",
            "friggerebbero",
            "frodavi",
            "frullerebbe",
            "fucinai",
            "fumeggiamo",
            "fuorviasse",
            "gabellerai",
            "gambizza",
            "garrire",
            "gatteggiassimo",
            "gemeva",
            "gentrifico",
            "gessassero",
            "ghettizzassimo",
            "gibollerai",
            "giocheremmo",
            "gioverebbe",
            "girovagherà",
            "giuracchiavamo",
            "glassato",
            "glosserebbero",
            "gommiate",
            "governassero",
            "gradisti",
            "grafitante",
            "granulano",
            "grattugeresti",
            "gridavi",
            "gronderesti",
            "gualca",
            "guastiamoci",
            "gustante",
            "ideaste",
            "idrogenavamo",
            "illanguidisca",
            "imbaldanzirai",
            "imbarbarentesi",
            "imbastivi",
            "imbestierete",
            "imbietto",
            "imborghesentesi",
            "imbozzimando",
            "imbreccereste",
            "imbronciatevi",
            "imbullettammo",
            "imitavamo",
            "immergerà",
            "immiseriva",
            "impacceremmo",
            "impallai",
            "impaniante",
            "imparentatevi",
            "impastocchio",
            "impazzino",
            "impelagantesi",
            "imperiamo",
            "imperverserò",
            "impiastrò",
            "impiegherete",
            "impillaccheriamo",
            "implementavamo",
            "impoltroniscono",
            "importavo",
            "imprecasti",
            "impreziosirebbe",
            "improvviserei",
            "imputridissero",
            "inacidissi",
            "inalveerei",
            "inaridisti",
            "incadaveriste",
            "incamererò",
            "incannerai",
            "incappottavi",
            "incaricate",
            "incartate",
            "incastellerebbe",
            "incaveremmo",
            "incendieresti",
            "inceriamo",
            "inchiederai",
            "incideremmo",
            "incivilirai",
            "incoiavo",
            "incomincia",
            "incornicerete",
            "incresceresti",
            "incrostano",
            "inculchiate",
            "incuriosiscono",
            "indemaniavano",
            "indirebbero",
            "individueranno",
            "indovinerete",
            "industrializzerete",
            "infanatichisca",
            "infeltrirei",
            "infeudante",
            "infibulasse",
            "infilzato",
            "infiochisci",
            "inflazionasti",
            "infoderavi",
            "informavi",
            "infradiciò",
            "infrango",
            "infronzolava",
            "ingannate",
            "ingeneriamoci",
            "ingialliranno",
            "inglobano",
            "ingolosiate",
            "ingranando",
            "ingraziarsi",
            "inguaiassero",
            "iniettato",
            "innacquo",
            "innervosì",
            "innocuizziamo",
            "inorpellerete",
            "insabbierebbero",
            "insanguinò",
            "insedi",
            "inseristi",
            "insolentivi",
            "insozzo",
            "instilleremmo",
            "insulterete",
            "intarliamoci",
            "intelammo",
            "intensificheresti",
            "intercettano",
            "intercorrendo",
            "interfoliante",
            "intermezzerebbero",
            "interpenetrò",
            "interrompe",
            "intessevamo",
            "intingereste",
            "intonavamo",
            "intortavate",
            "intrappolerai",
            "intravveniva",
            "intrinseco",
            "intrometteste",
            "intruglieranno",
            "inumava",
            "invasare",
            "inventerai",
            "investiate",
            "invigoriranno",
            "invocano",
            "inzaccherammo",
            "inzuccherato",
            "ipostatizzante",
            "irraggi",
            "irrigidisti",
            "irrugginiste",
            "isomerizzassi",
            "istallarono",
            "istituzionalizzasse",
            "italianizzassero",
            "laccaste",
            "laicizzava",
            "lanciano",
            "largheggiate",
            "latitammo",
            "lavoracchiando",
            "legassimo",
            "legittimizzerei",
            "lesse",
            "liberesti",
            "limitavi",
            "liofilizzeremmo",
            "listerebbero",
            "localizzeremo",
            "lorderemo",
            "lucrano",
            "lussureggiarono",
            "macelleremmo",
            "maggiorò",
            "malignammo",
            "malversavi",
            "manganellante",
            "manimetti",
            "mansuefecero",
            "marcasse",
            "marginalizzereste",
            "marnai",
            "mascherassi",
            "massellarono",
            "masticheranno",
            "mattoneremmo",
            "medicalizzasti",
            "menassi",
            "menzionavate",
            "meridionalizzassi",
            "mesci",
            "mestruavi",
            "metamorfoserete",
            "miagolò",
            "migrasse",
            "mimeografiate",
            "mingeste",
            "miracoliamo",
            "missa",
            "mitizzano",
            "mobilizzava",
            "modernizzavamo",
            "molleggia",
            "monetarizzavo",
            "monopolizzano",
            "mordenzarono",
            "morsicava",
            "motorizzato",
            "muffisti",
            "multare",
            "muova",
            "mutizzando",
            "nasalizzate",
            "naufragavi",
            "nazionalizziate",
            "negozia",
            "nettavi",
            "nidificavate",
            "nitrì",
            "nomare",
            "notificatevi",
            "nudricavo",
            "nuotino",
            "obietta",
            "obnubilandosi",
            "occorrano",
            "odorizzammo",
            "offuscando",
            "oliando",
            "omaggiate",
            "omogenizzo",
            "onorarono",
            "oppignoravamo",
            "opsonizzerai",
            "ordiresti",
            "orgasmato",
            "orizzontate",
            "orpellate",
            "oscillasse",
            "osservano",
            "ossitonizzeresti",
            "ostruissimo",
            "ottonando",
            "ovariectomizzarono",
            "ovviavi",
            "pacifichino",
            "paginaste",
            "palettizzerà",
            "palpiteremmo",
            "paracadutiate",
            "parallelizzante",
            "parcheggiai",
            "parlamentavate",
            "parteggiammo",
            "parzializzereste",
            "passivi",
            "patinando",
            "pattuisse",
            "pazzierò",
            "peggiorate",
            "penderai",
            "pensò",
            "percolarono",
            "perdurerà",
            "performate",
            "permarrei",
            "perpetuerò",
            "persistei",
            "pervademmo",
            "petrarcheggerebbero",
            "piagnucolare",
            "piantonammo",
            "picchettaste",
            "pieghetterà",
            "pignorerà",
            "pinzino",
            "piroettino",
            "pitturaste",
            "planavi",
            "plissettiamo",
            "polemizza",
            "pomicerebbe",
            "popolarizzerai",
            "portende",
            "posizionerei",
            "posticipiate",
            "potettero",
            "preannunzieremo",
            "precingere",
            "preconfezionammo",
            "predefinite",
            "predireste",
            "prefatto",
            "preformarono",
            "preluderei",
            "premise",
            "prenotavate",
            "preponevo",
            "preregolereste",
            "prescrivo",
            "preservassimo",
            "prestarsi",
            "pretrattavamo",
            "preverremo",
            "privatizzerei",
            "procrastinarono",
            "proferire",
            "profilatevi",
            "prognosticheremmo",
            "proletarizzeresti",
            "promettevano",
            "pronunzieremmo",
            "propinano",
            "prorompente",
            "prospettassimo",
            "proteggente",
            "protrudono",
            "provoco",
            "pubblicasse",
            "pullulavamo",
            "punteggiò",
            "purificate",
            "quadravano",
            "quantificherai",
            "quietanzeresti",
            "rabboccante",
            "raccapezzare",
            "racchiuderemmo",
            "raccorcirebbero",
            "radazzavate",
            "radduceva",
            "radioassistette",
            "radiomarcai",
            "raffigurai",
            "raffrenò",
            "raggirassi",
            "raggranellassero",
            "ragguagliare",
            "ramate",
            "rammemorava",
            "rampicassero",
            "randomizzerebbe",
            "rapineremmo",
            "rapporteresti",
            "raschiettammo",
            "rassetterà",
            "rastrellato",
            "rattizzerebbe",
            "rauneremmo",
            "ravviserei",
            "razionerai",
            "recapiteranno",
            "recidivò",
            "reclude",
            "reddere",
            "refertavi",
            "refuti",
            "registrai",
            "regredivi",
            "reimpasta",
            "reincaricava",
            "reingaggiare",
            "reinseristi",
            "reinventeremmo",
            "remassi",
            "rendesti",
            "reputerebbero",
            "residuiate",
            "responde",
            "restringevamo",
            "retribuivi",
            "revisionassimo",
            "riabbracciasse",
            "riaccettai",
            "riaccostassimo",
            "riaddestravi",
            "riaffioravate",
            "riaggravavate",
            "riallineavano",
            "riammodernate",
            "riappacificasti",
            "riapplicavi",
            "riardeste",
            "riasfalterete",
            "riassettare",
            "riassunsi",
            "riattraversare",
            "riavvincente",
            "ribaltando",
            "riberrebbero",
            "ricadente",
            "ricalibravi",
            "ricapitalizzavi",
            "ricatterete",
            "ricevente",
            "riclassificarono",
            "ricolorarsi",
            "ricomparirebbe",
            "ricomponga",
            "riconciliatevi",
            "riconfondesse",
            "riconquistasti",
            "ricontattasse",
            "riconvertano",
            "ricordare",
            "ricostringano",
            "ricresciamo",
            "ridacchiamo",
            "ridestando",
            "ridimensioniamoci",
            "ridisegni",
            "ridiventare",
            "ridorato",
            "rieducavano",
            "riepilogherai",
            "rieserciterei",
            "riesumo",
            "rifenderai",
            "rifiggemmo",
            "rifirmavo",
            "rifoderavi",
            "riformulaste",
            "rifugiarono",
            "rigermoglieremo",
            "rigiudicavano",
            "riguardati",
            "rilavorasti",
            "rimagliavate",
            "rimarchiando",
            "rimbaldanzireste",
            "rimbellii",
            "rimboscasti",
            "rimenavate",
            "rimiraste",
            "rimondavo",
            "rimotivo",
            "rimpatriando",
            "rimpiccolimmo",
            "rimproverandosi",
            "rinacqui",
            "rincappano",
            "rincentrasti",
            "rincitrullirono",
            "rincoraggiasti",
            "rinculcate",
            "rinfagottarono",
            "rinfoderano",
            "ringagliardendo",
            "ringorgammo",
            "rinnovantesi",
            "rinsaccato",
            "rinselvatichiresti",
            "rintenderò",
            "rintonacheresti",
            "rintuzzano",
            "rinvaserai",
            "rinvilisce",
            "rinzeppiamo",
            "riordinino",
            "riparametrizzante",
            "ripercotemmo",
            "ripianante",
            "ripigliassi",
            "riponesti",
            "ripossedei",
            "riprincipiammo",
            "riprometterei",
            "ripugnerà",
            "riquadreremo",
            "risalti",
            "riscappai",
            "risciacquandosi",
            "riscoppiamo",
            "risedere",
            "riseppellisca",
            "risistemavate",
            "risolveresti",
            "risospendevate",
            "rispecchierei",
            "rispinse",
            "rissò",
            "ristenderemo",
            "ristuccare",
            "risusciteranno",
            "ritareremmo",
            "riterse",
            "ritornerebbero",
            "ritrasformerete",
            "ritufferete",
            "rivaccinandosi",
            "rivelano",
            "riverniciare",
            "rivitalizzai",
            "rivoltavamo",
            "roborate",
            "romanticizzante",
            "ronfavano",
            "rotacizzerete",
            "rovinerete",
            "rullando",
            "russificavi",
            "saccarificherò",
            "sagginasse",
            "saldiate",
            "salmodiamo",
            "salutati",
            "sanguinavamo",
            "saprà",
            "satireggiavate",
            "sbaciucchieremo",
            "sballottano",
            "sbandierarono",
            "sbarcarono",
            "sbatacchiavi",
            "sbendasse",
            "sbianchisce",
            "sbirbavano",
            "sbocciassero",
            "sborrerete",
            "sbozzolammo",
            "sbraniamo",
            "sbrilluccicherò",
            "sbucceresti",
            "sbullonereste",
            "scafa",
            "scalcerai",
            "scalfisce",
            "scalpiterebbe",
            "scampanaste",
            "scandagliereste",
            "scannerizzarono",
            "scapigliai",
            "scappottate",
            "scarcererei",
            "scarmiglieresti",
            "scarrozzaste",
            "scartellarono",
            "scatenammo",
            "scavezzavamo",
            "scenderete",
            "scheggiarsi",
            "schernissimo",
            "schiantai",
            "schierandosi",
            "schiudemmo",
            "sciabolassi",
            "sciamanizzato",
            "scimmieggino",
            "sciolinare",
            "sciupaste",
            "scoccavate",
            "scolarizzerai",
            "scolorissero",
            "scommettevo",
            "scompenserebbero",
            "sconciato",
            "sconfondendo",
            "sconquassano",
            "scontorceresti",
            "scoperchierebbe",
            "scoraggiremo",
            "scoreggiò",
            "scorpori",
            "scorticherebbero",
            "scotennasti",
            "scoverete",
            "screpolo",
            "scritturate",
            "scrosterà",
            "sculetta",
            "scuso",
            "sdilinquisti",
            "sdrucciolava",
            "secreterà",
            "seghettassimo",
            "segretassi",
            "sembravo",
            "sensibilizziamo",
            "seppelliste",
            "serpeggiavate",
            "setaccino",
            "sfaccendaste",
            "sfaldò",
            "sfarineresti",
            "sfavoriva",
            "sferza",
            "sfiderai",
            "sfinirà",
            "sfocia",
            "sfolleranno",
            "sformino",
            "sfracella",
            "sfregheremmo",
            "sfrucugliammo",
            "sgamavi",
            "sgarbugliavano",
            "sghiacciavano",
            "sgomentiate",
            "sgorgammo",
            "sgrammaticavate",
            "sgraveranno",
            "sgropperò",
            "sguarniate",
            "shuntavo",
            "silenziavo",
            "simmetrizzai",
            "sindacalizzando",
            "sinterizzato",
            "situati",
            "slappolavate",
            "slinguerai",
            "smacca",
            "smaliziantesi",
            "smanettava",
            "smarrisci",
            "smemorassi",
            "smerletteranno",
            "smineremo",
            "smobilitiate",
            "smorbi",
            "smurino",
            "snelliste",
            "snodò",
            "soccombente",
            "sofferire",
            "soffriggano",
            "soggiacessimo",
            "solarizzerebbe",
            "solfiterei",
            "solleciteremmo",
            "solviate",
            "somministrarono",
            "sopiremmo",
            "sopporterai",
            "sopraeleverei",
            "soprapose",
            "soprastampare",
            "sopravvivessero",
            "sorbisce",
            "sorradevo",
            "sorveglierò",
            "sostantivando",
            "sostituivate",
            "sottoalimentasse",
            "sottolineavi",
            "sottorappresenterai",
            "sottoutilizzo",
            "sovracapitalizzano",
            "sovraffollasti",
            "sovrapponiamoci",
            "sovrasterzai",
            "sovrintendere",
            "spacciando",
            "spalca",
            "spampinerei",
            "spantanerete",
            "spargerebbe",
            "spartiva",
            "spaventerebbero",
            "spazzoleresti",
            "speculiamo",
            "spenderai",
            "sperarono",
            "speronereste",
            "spettegolassi",
            "spezzono",
            "spiattelleranno",
            "spicconerai",
            "spigassero",
            "spiluccava",
            "spirantizzò",
            "spodestavi",
            "spollonerete",
            "spomperò",
            "sporgerei",
            "spostai",
            "sprigionandosi",
            "spromettere",
            "spugnerai",
            "spupazzai",
            "squagliaste",
            "squilibravate",
            "srotolerei",
            "stabuleremo",
            "stagionammo",
            "stampigliammo",
            "stanziò",
            "stasino",
            "stazzonò",
            "stenderai",
            "sterilizzerà",
            "stigmatizzavi",
            "stimolereste",
            "stiracchieremmo",
            "stomacheremmo",
            "storicizzerò",
            "strabenedissero",
            "stracchiamo",
            "stralunarono",
            "straniassi",
            "strapiomberò",
            "strasformereste",
            "stravolge",
            "stretto",
            "striminzire",
            "striscerò",
            "stromberà",
            "stroppieresti",
            "strusciavate",
            "stuelliate",
            "stuteresti",
            "subdelega",
            "sublocassimo",
            "succedendo",
            "sucheremo",
            "suffondi",
            "suicideremo",
            "superiate",
            "supportate",
            "surriscaldavo",
            "sussisteste",
            "svaligiante",
            "svaporeremo",
            "svelereste",
            "sventasti",
            "svermineremmo",
            "svicolammo",
            "svilupperebbe",
            "sviscerassi",
            "svolgevano",
            "tabulate",
            "taciuto",
            "tallonarono",
            "tangeste",
            "tariffammo",
            "tartassano",
            "tatuato",
            "teflonerete",
            "telematizzai",
            "tematizzare",
            "temporeggiano",
            "tentarono",
            "terebrate",
            "terrificherà",
            "tesero",
            "tifa",
            "tipicizzava",
            "titolerei",
            "tombolerò",
            "tonsurassimo",
            "tornasti",
            "tosasti",
            "totalizzeranno",
            "traccheggiasti",
            "trafficherai",
            "traguarderemmo",
            "tramestasse",
            "trancerò",
            "transcriverebbero",
            "transiteremmo",
            "trapaniate",
            "trapungerebbe",
            "trascendere",
            "trasducemmo",
            "trasfuso",
            "trasmodai",
            "traspongo",
            "trasvolgevo",
            "travalichereste",
            "travisi",
            "trescaste",
            "trilleremo",
            "tripartì",
            "trituraste",
            "troneggiato",
            "trucchiamo",
            "tumuliate",
            "tutelai",
            "ubiquitinassero",
            "ufficializzando",
            "ulcerereste",
            "umanizza",
            "unente",
            "universaleggerebbero",
            "urinassi",
            "usciolereste",
            "usureranno",
            "vacilli",
            "vagillando",
            "valicherete",
            "vanerai",
            "vantiate",
            "vasectomizzò",
            "veicolai",
            "vellicato",
            "vendicchiassi",
            "ventagliò",
            "vergheggiavate",
            "verniciare",
            "vessavi",
            "vezzeggiarsi",
            "videochattino",
            "vidimassero",
            "vilificheranno",
            "vinifico",
            "virgoletteranno",
            "visualizzavano",
            "vivacchierete",
            "vocabolarizzando",
            "volantinasse",
            "volicchio",
            "volturiamo",
            "votai",
            "zaffano",
            "zampognavo",
            "zavorrino",
            "zinnasti",
            "zoccolerà",
            "zoomo",
            "zumato",
        ),
        "noun": (
            "casa",
            "macchina",
            "albero",
            "libro",
            "penna",
            "bicicletta",
            "telefono",
            "tavolo",
            "sedia",
            "cane",
            "gatto",
            "finestra",
            "porta",
            "lampada",
            "letto",
            "divano",
            "televisione",
            "computer",
            "schermo",
            "tastiera",
            "mouse",
            "quaderno",
            "zaino",
            "cuscino",
            "coperta",
            "armadio",
            "scarpa",
            "calza",
            "maglietta",
            "pantaloni",
            "giacca",
            "cappello",
            "orologio",
            "occhiali",
            "borsa",
            "portafoglio",
            "ombrello",
            "cintura",
            "chiavi",
            "orologio",
            "spazzolino",
            "dentifricio",
            "sapone",
            "shampoo",
            "asciugamano",
            "specchio",
            "pettine",
            "rasoio",
            "profumo",
            "crema",
            "saponetta",
            "spugna",
            "lavandino",
            "doccia",
            "vasca",
            "bidet",
            "toilette",
            "lavatrice",
            "asciugatrice",
            "frigorifero",
            "forno",
            "microonde",
            "fornelli",
            "cappa",
            "lavastoviglie",
            "tostapane",
            "frullatore",
            "bollitore",
            "caffettiera",
            "teiera",
            "padella",
            "pentola",
            "coltello",
            "forchetta",
            "cucchiaio",
            "cucchiaino",
            "piatto",
            "bicchiere",
            "tazza",
            "ciotola",
            "vassoio",
            "bottiglia",
            "barattolo",
            "scatola",
            "sacco",
            "borsa",
            "secchio",
            "sacco",
            "pattumiera",
            "scopa",
            "paletta",
            "mocio",
            "straccio",
            "panno",
            "aspirapolvere",
            "ferro",
            "spazzola",
            "mollette",
            "stendibiancheria",
            "ventilatore",
            "condizionatore",
            "caldaia",
            "termosifone",
            "stufa",
            "camino",
            "caminetto",
            "candele",
            "accendino",
            "fiammiferi",
            "carta",
            "penna",
            "matita",
            "gomma",
            "righello",
            "compasso",
            "temperamatite",
            "calcolatrice",
            "agenda",
            "notes",
            "post-it",
            "cartella",
            "cartellina",
            "fascicoli",
            "archivio",
            "scaffale",
            "libreria",
            "poltrona",
            "tappeto",
            "tenda",
            "persiana",
            "quadri",
            "cornice",
            "scultura",
            "vasi",
            "fiori",
            "pianta",
            "albero",
            "cespuglio",
            "erba",
            "piante",
            "terra",
            "sabbia",
            "ghiaia",
            "roccia",
            "pietra",
            "marmo",
            "granito",
            "mattoni",
            "cemento",
            "intonaco",
            "pittura",
            "vernice",
            "pennello",
            "rullo",
            "spatola",
            "cazzuola",
            "secchio",
            "trapano",
            "cacciavite",
            "martello",
            "pinze",
            "tenaglie",
            "chiave",
            "livella",
            "metro",
            "nastro",
            "colla",
            "chiodo",
            "vite",
            "bullone",
            "dado",
            "rondella",
            "tassello",
            "calcestruzzo",
            "intonaco",
            "gesso",
            "stucco",
            "cartongesso",
            "saldatrice",
            "trapano",
            "avvitatore",
            "seghetto",
            "sega",
            "taglierina",
            "forbici",
            "taglierino",
            "scalpello",
            "pialla",
            "raspa",
            "levigatrice",
            "piallatrice",
            "fresa",
            "tornio",
            "trapano",
            "morsa",
            "mola",
            "smerigliatrice",
            "compensato",
            "legno",
            "tavola",
            "asse",
            "trave",
            "palo",
            "paletto",
            "pilastro",
            "colonna",
            "architrave",
            "tetto",
            "grondaia",
            "canale",
            "pluviale",
            "scarico",
            "pozzetto",
            "tombino",
            "serbatoio",
            "cisterna",
            "pozzo",
            "pompa",
            "tubo",
            "rubinetto",
            "valvola",
            "serratura",
            "chiavistello",
            "cardine",
            "cerniera",
            "catena",
            "lucchetto",
            "cavo",
            "filo",
            "corda",
            "spago",
            "nastro",
            "fune",
            "catena",
            "carrello",
            "ruota",
            "pneumatico",
            "cerchio",
            "disco",
            "pastiglie",
            "freno",
            "pedale",
            "acceleratore",
            "frizione",
            "cambio",
            "marcia",
            "retromarcia",
            "sterzo",
            "volante",
            "clacson",
            "specchietto",
            "parabrezza",
            "finestrino",
            "portiera",
            "bagagliaio",
            "cofano",
            "paraurti",
            "fanale",
            "faro",
            "fendinebbia",
            "targa",
            "siluro",
            "scarico",
            "marmitta",
            "filtro",
            "radiatore",
            "ventola",
            "alternatore",
            "batteria",
            "accensione",
            "candele",
            "serbatoio",
            "benzina",
            "olio",
            "liquido",
            "refrigerante",
            "acqua",
            "tergicristalli",
            "lavafari",
            "sbrinatore",
            "riscaldamento",
            "ventilazione",
            "condizionamento",
            "aria",
            "cambio",
            "differenziale",
            "trasmissione",
            "albero",
            "cardano",
            "giunto",
            "semiasse",
            "gomma",
            "pneumatico",
            "cerchio",
            "camera d'aria",
            "valvola",
            "pompa",
            "compressore",
            "manometro",
            "cric",
            "paranco",
            "sollevatore",
            "martinetto",
            "chiave",
            "torcia",
            "lampadina",
            "faretto",
            "luci",
            "led",
            "lampada",
            "neon",
            "faro",
            "luci",
            "frecce",
            "indicatori",
            "segnalatori",
            "triangolo",
            "gilet",
            "cintura",
            "airbag",
            "seggiolino",
            "portabiciclette",
            "portapacchi",
            "catene da neve",
            "copricerchi",
            "tappetini",
            "coprisedili",
            "parasole",
            "cuscini",
            "bracciolo",
            "poggiatesta",
            "poggiapiedi",
            "volante",
            "pomello",
            "maniglia",
            "pulsante",
            "interruttore",
            "levetta",
            "pedaliera",
            "console",
            "cruscotto",
            "tachimetro",
            "contachilometri",
            "indicatore",
            "termometro",
            "manometro",
            "contagiri",
            "indicatore",
            "spie",
            "avvisatori",
            "sensori",
            "radar",
            "telecamera",
            "parcheggio",
            "navigatore",
            "autoradio",
            "stereo",
            "altoparlanti",
            "subwoofer",
            "antenna",
            "ricevitore",
            "trasmettitore",
            "microfono",
            "vivavoce",
            "bluetooth",
            "USB",
            "presa",
            "cavo",
            "adattatore",
            "cuffie",
            "auricolari",
            "caricabatterie",
            "supporto",
            "cruscotto",
            "parabrezza",
            "tergicristalli",
            "specchietti",
            "fendinebbia",
            "fari",
            "fanali",
            "luci",
            "indicatori",
            "stop",
            "paraurti",
            "parafanghi",
            "minigonne",
            "spoiler",
            "tettuccio",
            "tetto",
            "bagagliaio",
            "cofano motore",
            "griglia",
            "mascherina",
            "logo",
            "stemma",
            "serratura",
        ),
        "adverb": (
            "sempre",
            "mai",
            "forse",
            "ancora",
            "ora",
            "subito",
            "prima",
            "poi",
            "dopo",
            "tardi",
            "presto",
            "qui",
            "lì",
            "lontano",
            "vicino",
            "sopra",
            "sotto",
            "davanti",
            "dietro",
            "fuori",
            "dentro",
            "insieme",
            "separatamente",
            "lentamente",
            "velocemente",
            "pianamente",
            "fortemente",
            "debolmente",
            "esattamente",
            "precisamente",
            "più",
            "meno",
            "molto",
            "poco",
            "abbastanza",
            "quasi",
            "affatto",
            "completamente",
            "parzialmente",
            "totalmente",
            "esattamente",
            "circa",
            "approssimativamente",
            "particolarmente",
            "specialmente",
            "tipicamente",
            "principalmente",
            "assolutamente",
            "relativamente",
            "ovviamente",
            "naturalmente",
            "certamente",
            "probabilmente",
            "immediatamente",
            "attentamente",
            "silenziosamente",
            "rumorosamente",
            "gentilmente",
            "bruscamente",
            "duramente",
            "facilmente",
            "difficilmente",
            "pericolosamente",
            "sicuramente",
            "così",
            "diversamente",
            "ugualmente",
            "altrimenti",
            "ancora",
            "già",
            "appena",
            "finora",
            "spesso",
            "raramente",
            "regolarmente",
            "casualmente",
            "necessariamente",
            "sicuramente",
            "evidentemente",
            "involontariamente",
            "volontariamente",
            "innocentemente",
            "maliziosamente",
            "strategicamente",
            "tatticamente",
            "efficacemente",
            "inefficacemente",
            "positivamente",
            "negativamente",
            "legalmente",
            "illegalmente",
            "temporaneamente",
            "permanentemente",
            "sistematicamente",
            "sporadicamente",
            "abitualmente",
            "occasionalmente",
            "frequentemente",
            "regolarmente",
            "puntualmente",
        ),
        "adjective": (
            "bello",
            "grande",
            "piccolo",
            "alto",
            "basso",
            "vecchio",
            "giovane",
            "nuovo",
            "forte",
            "debole",
            "veloce",
            "lento",
            "caldo",
            "freddo",
            "luminoso",
            "scuro",
            "ricco",
            "povero",
            "facile",
            "difficile",
            "pulito",
            "sporco",
            "felice",
            "triste",
            "intelligente",
            "stupido",
            "coraggioso",
            "codardo",
            "dolce",
            "amaro",
            "silenzioso",
            "rumoroso",
            "liscio",
            "ruvido",
            "gentile",
            "scortese",
            "tranquillo",
            "nervoso",
            "amichevole",
            "ostile",
            "serio",
            "allegro",
            "giusto",
            "sbagliato",
            "vero",
            "falso",
            "ordinato",
            "disordinato",
            "umido",
            "secco",
            "rotondo",
            "quadrato",
            "magro",
            "grasso",
            "chiaro",
            "opaco",
            "corto",
            "lungo",
            "affamato",
            "sazio",
            "amaro",
            "salato",
            "gentile",
            "sincero",
            "generoso",
            "egoista",
            "laborioso",
            "pigro",
            "onesto",
            "disonesto",
            "prudente",
            "avventato",
            "sicuro",
            "pericoloso",
            "fresco",
            "stanco",
            "noioso",
            "interessante",
            "curioso",
            "tranquillo",
            "vivace",
            "antipatico",
            "simpatico",
            "gentile",
            "maleducato",
            "contento",
            "arrabbiato",
            "innamorato",
            "geloso",
            "spaventato",
            "tranquillo",
            "stressato",
            "soddisfatto",
            "insoddisfatto",
            "creativo",
            "noioso",
            "timido",
            "estroverso",
            "affettuoso",
            "freddo",
        ),
    }
