package devices

import (
    "context"
    i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f "github.com/microsoft/kiota-abstractions-go"
    ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a "github.com/microsoftgraph/msgraph-sdk-go/models/odataerrors"
)

// ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder provides operations to count the resources in the collection.
type ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder struct {
    i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.BaseRequestBuilder
}
// ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderGetQueryParameters get the number of the resource
type ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderGetQueryParameters struct {
    // Filter items by property values
    Filter *string `uriparametername:"%24filter"`
    // Search items by search phrases
    Search *string `uriparametername:"%24search"`
}
// ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderGetRequestConfiguration configuration for the request such as headers, query parameters, and middleware options.
type ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderGetRequestConfiguration struct {
    // Request headers
    Headers *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestHeaders
    // Request options
    Options []i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestOption
    // Request query parameters
    QueryParameters *ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderGetQueryParameters
}
// NewItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderInternal instantiates a new ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder and sets the default values.
func NewItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderInternal(pathParameters map[string]string, requestAdapter i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestAdapter)(*ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder) {
    m := &ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder{
        BaseRequestBuilder: *i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewBaseRequestBuilder(requestAdapter, "{+baseurl}/devices/{device%2Did}/registeredOwners/graph.appRoleAssignment/$count{?%24filter,%24search}", pathParameters),
    }
    return m
}
// NewItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder instantiates a new ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder and sets the default values.
func NewItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder(rawUrl string, requestAdapter i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestAdapter)(*ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder) {
    urlParams := make(map[string]string)
    urlParams["request-raw-url"] = rawUrl
    return NewItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderInternal(urlParams, requestAdapter)
}
// Get get the number of the resource
// returns a *int32 when successful
// returns a ODataError error when the service returns a 4XX or 5XX status code
func (m *ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder) Get(ctx context.Context, requestConfiguration *ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderGetRequestConfiguration)(*int32, error) {
    requestInfo, err := m.ToGetRequestInformation(ctx, requestConfiguration);
    if err != nil {
        return nil, err
    }
    errorMapping := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.ErrorMappings {
        "XXX": ia572726a95efa92ddd544552cd950653dc691023836923576b2f4bf716cf204a.CreateODataErrorFromDiscriminatorValue,
    }
    res, err := m.BaseRequestBuilder.RequestAdapter.SendPrimitive(ctx, requestInfo, "int32", errorMapping)
    if err != nil {
        return nil, err
    }
    if res == nil {
        return nil, nil
    }
    return res.(*int32), nil
}
// ToGetRequestInformation get the number of the resource
// returns a *RequestInformation when successful
func (m *ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder) ToGetRequestInformation(ctx context.Context, requestConfiguration *ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilderGetRequestConfiguration)(*i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.RequestInformation, error) {
    requestInfo := i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.NewRequestInformationWithMethodAndUrlTemplateAndPathParameters(i2ae4187f7daee263371cb1c977df639813ab50ffa529013b7437480d1ec0158f.GET, m.BaseRequestBuilder.UrlTemplate, m.BaseRequestBuilder.PathParameters)
    if requestConfiguration != nil {
        if requestConfiguration.QueryParameters != nil {
            requestInfo.AddQueryParameters(*(requestConfiguration.QueryParameters))
        }
        requestInfo.Headers.AddAll(requestConfiguration.Headers)
        requestInfo.AddRequestOptions(requestConfiguration.Options)
    }
    requestInfo.Headers.TryAdd("Accept", "text/plain;q=0.9")
    return requestInfo, nil
}
// WithUrl returns a request builder with the provided arbitrary URL. Using this method means any other path or query parameters are ignored.
// returns a *ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder when successful
func (m *ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder) WithUrl(rawUrl string)(*ItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder) {
    return NewItemRegisteredOwnersGraphAppRoleAssignmentCountRequestBuilder(rawUrl, m.BaseRequestBuilder.RequestAdapter);
}
