/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JpmsConfiguration {
    private static final List<String> GROOVY_JPMS_ARGS_9 = Collections.unmodifiableList(Arrays.asList("--add-opens=java.base/java.lang=ALL-UNNAMED", "--add-opens=java.base/java.lang.invoke=ALL-UNNAMED", "--add-opens=java.base/java.util=ALL-UNNAMED", "--add-opens=java.prefs/java.util.prefs=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.api=ALL-UNNAMED", "--add-exports=jdk.compiler/com.sun.tools.javac.util=ALL-UNNAMED"));
    private static final List<String> GRADLE_SHARED_JPMS_ARGS_24 = Collections.singletonList("--enable-native-access=ALL-UNNAMED");
    private static final List<String> GRADLE_WORKER_JPMS_ARGS_24 = GRADLE_SHARED_JPMS_ARGS_24;
    private static final List<String> GRADLE_DAEMON_JPMS_ARGS_9;
    private static final List<String> GRADLE_DAEMON_JPMS_ARGS_24;

    public static List<String> forGroovyProcesses(int majorVersion) {
        if (majorVersion < 9) {
            return Collections.emptyList();
        }
        return GROOVY_JPMS_ARGS_9;
    }

    public static List<String> forWorkerProcesses(int majorVersion, boolean usingNativeServices) {
        if (majorVersion < 24 || !usingNativeServices) {
            return Collections.emptyList();
        }
        return GRADLE_WORKER_JPMS_ARGS_24;
    }

    public static List<String> forDaemonProcesses(int majorVersion, boolean usingNativeServices) {
        if (majorVersion < 9) {
            return Collections.emptyList();
        }
        if (majorVersion < 24 || !usingNativeServices) {
            return GRADLE_DAEMON_JPMS_ARGS_9;
        }
        return GRADLE_DAEMON_JPMS_ARGS_24;
    }

    static {
        ArrayList<String> gradleDaemonJvmArgs = new ArrayList<String>(GROOVY_JPMS_ARGS_9);
        List<String> configurationCacheJpmsArgs = Collections.unmodifiableList(Arrays.asList("--add-opens=java.base/java.util=ALL-UNNAMED", "--add-opens=java.prefs/java.util.prefs=ALL-UNNAMED", "--add-opens=java.base/java.nio.charset=ALL-UNNAMED", "--add-opens=java.base/java.net=ALL-UNNAMED", "--add-opens=java.base/java.util.concurrent.atomic=ALL-UNNAMED", "--add-opens=java.xml/javax.xml.namespace=ALL-UNNAMED"));
        gradleDaemonJvmArgs.addAll(configurationCacheJpmsArgs);
        GRADLE_DAEMON_JPMS_ARGS_9 = Collections.unmodifiableList(gradleDaemonJvmArgs);
        ArrayList<String> gradleDaemonJvmArgs24 = new ArrayList<String>(GRADLE_DAEMON_JPMS_ARGS_9);
        gradleDaemonJvmArgs24.addAll(GRADLE_SHARED_JPMS_ARGS_24);
        GRADLE_DAEMON_JPMS_ARGS_24 = Collections.unmodifiableList(gradleDaemonJvmArgs24);
    }
}

