
# test basic operation with -a option

echo abcde >TEST
binfind -a a TEST
=> 0
0
--

echo abcde >TEST
binfind -a b TEST
=> 0
1
--

echo abcde >TEST
binfind -a e TEST
=> 0
4
--

echo abcde >TEST
binfind -a abcde TEST
=> 0
0
--

echo abcde >TEST
binfind -a bcde TEST
=> 0
1
--

echo abcde >TEST
binfind -a bcd TEST
=> 0
1
--

echo abcde >TEST
binfind -a bc -a d TEST
=> 0
1
--

echo abcde >TEST
binfind -a bc -a x TEST
=> 1
--

echo abcde >TEST
binfind -a x TEST
=> 1
--

# test basic operation with -x option

echo abcde >TEST
binfind -x 0a TEST
=> 0
5
--

echo abcde >TEST
binfind -x 0A TEST
=> 0
5
--

echo abcde >TEST
binfind -x 61 TEST
=> 0
0
--

echo abcde >TEST
binfind -x 62 -x 63 TEST
=> 0
1
--

echo abcde >TEST
binfind -x 6263 TEST
=> 0
1
--

echo abcde >TEST
binfind -B -x 6263 TEST
=> 0
1
--

echo abcde >TEST
binfind -L -x 6362 TEST
=> 0
1
--

echo abcde >TEST
binfind -x 6263 -L TEST
=> 0
1
--

# test missing file error

binfind -a x DOESNOTEXIST
=> 2
--

# test missing pattern error

binfind
=> 2
--

#NOTE: there are spaces behind the -a
binfind -a    
=> 2
--

# test invalid option error

echo abcde >TEST
binfind -a a --invalid TEST
=> 2
--

echo abcde >TEST
binfind -a a TEST --invalid
=> 2
--


