/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.util.List;
import java.util.Map;
import net.sourceforge.argparse4j.inf.Namespace;
import org.asamk.signal.util.Util;

final class JsonRpcNamespace
extends Namespace {
    public JsonRpcNamespace(Map<String, Object> attrs) {
        super(attrs);
    }

    public <T> T get(String dest) {
        Object value = super.get(dest);
        if (value != null) {
            return (T)value;
        }
        String camelCaseString = Util.dashSeparatedToCamelCaseString(dest);
        return (T)super.get(camelCaseString);
    }

    public <E> List<E> getList(String dest) {
        try {
            List value = super.getList(dest);
            if (value != null) {
                return value;
            }
        }
        catch (ClassCastException e) {
            return List.of(this.get(dest));
        }
        return super.getList(dest + "s");
    }
}

