/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import com.fasterxml.jackson.core.type.TypeReference;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.BaseConfig;
import org.asamk.signal.OutputType;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.JsonRpcMultiLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.MultiAccountManager;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;

public class VersionCommand
implements JsonRpcLocalCommand,
JsonRpcMultiLocalCommand {
    @Override
    public String getName() {
        return "version";
    }

    @Override
    public List<OutputType> getSupportedOutputTypes() {
        return List.of(OutputType.PLAIN_TEXT, OutputType.JSON);
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        this.outputVersion(outputWriter);
    }

    @Override
    public void handleCommand(Namespace ns, MultiAccountManager c, OutputWriter outputWriter) throws CommandException {
        this.outputVersion(outputWriter);
    }

    @Override
    public TypeReference<Map<String, Object>> getRequestType() {
        return new TypeReference<Map<String, Object>>(this){};
    }

    private void outputVersion(OutputWriter outputWriter) {
        String projectName = BaseConfig.PROJECT_NAME == null ? "signal-cli" : BaseConfig.PROJECT_NAME;
        String version = BaseConfig.PROJECT_VERSION == null ? "unknown" : BaseConfig.PROJECT_VERSION;
        OutputWriter outputWriter2 = outputWriter;
        Objects.requireNonNull(outputWriter2);
        OutputWriter outputWriter3 = outputWriter2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonWriter.class, PlainTextWriter.class}, (Object)outputWriter3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                JsonWriter jsonWriter = (JsonWriter)outputWriter3;
                jsonWriter.write(Map.of("version", version));
                break;
            }
            case 1: {
                PlainTextWriter plainTextWriter = (PlainTextWriter)outputWriter3;
                plainTextWriter.println("{} {}", projectName, version);
            }
        }
    }
}

