/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.api;

import java.util.Base64;
import java.util.Locale;
import org.signal.libsignal.protocol.util.Hex;

public sealed interface IdentityVerificationCode {
    public static IdentityVerificationCode parse(String code) throws Exception {
        if ((code = code.replaceAll(" ", "")).length() == 66) {
            byte[] fingerprintBytes = Hex.fromStringCondensed((String)code.toLowerCase(Locale.ROOT));
            return new Fingerprint(fingerprintBytes);
        }
        if (code.length() == 60) {
            return new SafetyNumber(code);
        }
        byte[] scannableSafetyNumber = Base64.getDecoder().decode(code);
        return new ScannableSafetyNumber(scannableSafetyNumber);
    }

    public record Fingerprint(byte[] fingerprint) implements IdentityVerificationCode
    {
    }

    public record SafetyNumber(String safetyNumber) implements IdentityVerificationCode
    {
    }

    public record ScannableSafetyNumber(byte[] safetyNumber) implements IdentityVerificationCode
    {
    }
}

