/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.internal;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.RegistrationManager;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.IncorrectPinException;
import org.asamk.signal.manager.api.NonNormalizedPhoneNumberException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PinLockMissingException;
import org.asamk.signal.manager.api.PinLockedException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.UpdateProfile;
import org.asamk.signal.manager.api.VerificationMethodNotAvailableException;
import org.asamk.signal.manager.config.ServiceEnvironmentConfig;
import org.asamk.signal.manager.helper.AccountFileUpdater;
import org.asamk.signal.manager.helper.PinHelper;
import org.asamk.signal.manager.internal.ManagerImpl;
import org.asamk.signal.manager.internal.PathConfig;
import org.asamk.signal.manager.internal.ReentrantSignalSessionLock;
import org.asamk.signal.manager.internal.SignalDependencies;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.util.KeyUtils;
import org.asamk.signal.manager.util.NumberVerificationUtils;
import org.asamk.signal.manager.util.Utils;
import org.signal.libsignal.usernames.BaseUsernameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.SignalServiceAccountManager;
import org.whispersystems.signalservice.api.account.PreKeyCollection;
import org.whispersystems.signalservice.api.kbs.MasterKey;
import org.whispersystems.signalservice.api.push.ServiceId;
import org.whispersystems.signalservice.api.push.ServiceIdType;
import org.whispersystems.signalservice.api.push.exceptions.AlreadyVerifiedException;
import org.whispersystems.signalservice.api.push.exceptions.DeprecatedVersionException;
import org.whispersystems.signalservice.api.registration.RegistrationApi;
import org.whispersystems.signalservice.api.svr.SecureValueRecovery;
import org.whispersystems.signalservice.internal.configuration.SignalServiceConfiguration;
import org.whispersystems.signalservice.internal.push.VerifyAccountResponse;

public class RegistrationManagerImpl
implements RegistrationManager {
    private static final Logger logger = LoggerFactory.getLogger(RegistrationManagerImpl.class);
    private SignalAccount account;
    private final PathConfig pathConfig;
    private final ServiceEnvironmentConfig serviceEnvironmentConfig;
    private final String userAgent;
    private final Consumer<Manager> newManagerListener;
    private final SignalServiceAccountManager unauthenticatedAccountManager;
    private final PinHelper pinHelper;
    private final AccountFileUpdater accountFileUpdater;

    public RegistrationManagerImpl(SignalAccount account, PathConfig pathConfig, ServiceEnvironmentConfig serviceEnvironmentConfig, String userAgent, Consumer<Manager> newManagerListener, AccountFileUpdater accountFileUpdater) {
        this.account = account;
        this.pathConfig = pathConfig;
        this.accountFileUpdater = accountFileUpdater;
        this.serviceEnvironmentConfig = serviceEnvironmentConfig;
        this.userAgent = userAgent;
        this.newManagerListener = newManagerListener;
        this.unauthenticatedAccountManager = SignalServiceAccountManager.createWithStaticCredentials((SignalServiceConfiguration)serviceEnvironmentConfig.signalServiceConfiguration(), null, null, (String)account.getNumber(), (int)1, (String)account.getPassword(), (String)userAgent, (boolean)true, (int)1001);
        List<SecureValueRecovery> secureValueRecovery = serviceEnvironmentConfig.svr2Mrenclaves().stream().map(mr -> this.unauthenticatedAccountManager.getSecureValueRecoveryV2(mr)).toList();
        this.pinHelper = new PinHelper(secureValueRecovery);
    }

    @Override
    public void register(boolean voiceVerification, String captcha, boolean forceRegister) throws IOException, CaptchaRequiredException, NonNormalizedPhoneNumberException, RateLimitException, VerificationMethodNotAvailableException {
        if (this.account.isRegistered() && this.account.getServiceEnvironment() != null && this.account.getServiceEnvironment() != this.serviceEnvironmentConfig.type()) {
            throw new IOException("Account is registered in another environment: " + String.valueOf((Object)this.account.getServiceEnvironment()));
        }
        try {
            String recoveryPassword;
            if (!forceRegister) {
                if (this.account.isRegistered()) {
                    throw new IOException("Account is already registered");
                }
                if (this.account.getAci() != null && this.attemptReactivateAccount()) {
                    return;
                }
            }
            if ((recoveryPassword = this.account.getRecoveryPassword()) != null && this.account.isPrimaryDevice() && this.attemptReregisterAccount(recoveryPassword)) {
                return;
            }
            RegistrationApi registrationApi = this.unauthenticatedAccountManager.getRegistrationApi();
            logger.trace("Creating verification session");
            String sessionId = NumberVerificationUtils.handleVerificationSession(registrationApi, this.account.getSessionId(this.account.getNumber()), id -> this.account.setSessionId(this.account.getNumber(), (String)id), voiceVerification, captcha);
            logger.trace("Requesting verification code");
            NumberVerificationUtils.requestVerificationCode(registrationApi, sessionId, voiceVerification);
            logger.debug("Successfully requested verification code");
            this.account.setRegistered(false);
        }
        catch (DeprecatedVersionException e) {
            logger.debug("Signal-Server returned deprecated version exception", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void verifyAccount(String verificationCode, String pin) throws IOException, PinLockedException, IncorrectPinException, PinLockMissingException {
        if (this.account.isRegistered()) {
            throw new IOException("Account is already registered");
        }
        if (this.account.getPniIdentityKeyPair() == null) {
            this.account.setPniIdentityKeyPair(KeyUtils.generateIdentityKeyPair());
        }
        PreKeyCollection aciPreKeys = KeyUtils.generatePreKeysForType(this.account.getAccountData(ServiceIdType.ACI));
        PreKeyCollection pniPreKeys = KeyUtils.generatePreKeysForType(this.account.getAccountData(ServiceIdType.PNI));
        Pair<VerifyAccountResponse, MasterKey> result = NumberVerificationUtils.verifyNumber(this.account.getSessionId(this.account.getNumber()), verificationCode, pin, this.pinHelper, (sessionId1, verificationCode1, registrationLock) -> this.verifyAccountWithCode(sessionId1, verificationCode1, registrationLock, aciPreKeys, pniPreKeys));
        VerifyAccountResponse response = result.first();
        MasterKey masterKey = result.second();
        if (masterKey == null) {
            pin = null;
        }
        this.finishAccountRegistration(response, pin, masterKey, aciPreKeys, pniPreKeys);
    }

    @Override
    public void deleteLocalAccountData() throws IOException {
        this.account.deleteAccountData();
        this.accountFileUpdater.removeAccount();
        this.account = null;
    }

    @Override
    public boolean isRegistered() {
        return this.account.isRegistered();
    }

    private boolean attemptReregisterAccount(String recoveryPassword) {
        try {
            if (this.account.getPniIdentityKeyPair() == null) {
                this.account.setPniIdentityKeyPair(KeyUtils.generateIdentityKeyPair());
            }
            PreKeyCollection aciPreKeys = KeyUtils.generatePreKeysForType(this.account.getAccountData(ServiceIdType.ACI));
            PreKeyCollection pniPreKeys = KeyUtils.generatePreKeysForType(this.account.getAccountData(ServiceIdType.PNI));
            RegistrationApi registrationApi = this.unauthenticatedAccountManager.getRegistrationApi();
            VerifyAccountResponse response = (VerifyAccountResponse)Utils.handleResponseException(registrationApi.registerAccount(null, recoveryPassword, this.account.getAccountAttributes(null), aciPreKeys, pniPreKeys, null, true));
            this.finishAccountRegistration(response, this.account.getRegistrationLockPin(), this.account.getPinBackedMasterKey(), aciPreKeys, pniPreKeys);
            logger.info("Reregistered existing account, verify is not necessary.");
            return true;
        }
        catch (IOException e) {
            logger.debug("Failed to reregister account with recovery password", (Throwable)e);
            return false;
        }
    }

    private boolean attemptReactivateAccount() {
        try {
            SignalDependencies dependencies = new SignalDependencies(this.serviceEnvironmentConfig, this.userAgent, this.account.getCredentialsProvider(), this.account.getSignalServiceDataStore(), null, new ReentrantSignalSessionLock());
            Utils.handleResponseException(dependencies.getAccountApi().setAccountAttributes(this.account.getAccountAttributes(null)));
            this.account.setRegistered(true);
            logger.info("Reactivated existing account, verify is not necessary.");
            if (this.newManagerListener != null) {
                ManagerImpl m = new ManagerImpl(this.account, this.pathConfig, this.accountFileUpdater, this.serviceEnvironmentConfig, this.userAgent);
                this.account = null;
                this.newManagerListener.accept(m);
            }
            return true;
        }
        catch (IOException e) {
            logger.debug("Failed to reactivate account");
            return false;
        }
    }

    private VerifyAccountResponse verifyAccountWithCode(String sessionId, String verificationCode, String registrationLock, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys) throws IOException {
        RegistrationApi registrationApi = this.unauthenticatedAccountManager.getRegistrationApi();
        try {
            Utils.handleResponseException(registrationApi.verifyAccount(sessionId, verificationCode));
        }
        catch (AlreadyVerifiedException alreadyVerifiedException) {
            // empty catch block
        }
        return (VerifyAccountResponse)Utils.handleResponseException(registrationApi.registerAccount(sessionId, null, this.account.getAccountAttributes(registrationLock), aciPreKeys, pniPreKeys, null, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishAccountRegistration(VerifyAccountResponse response, String pin, MasterKey masterKey, PreKeyCollection aciPreKeys, PreKeyCollection pniPreKeys) throws IOException {
        ServiceId.ACI aci = ServiceId.ACI.parseOrThrow((String)response.getUuid());
        ServiceId.PNI pni = ServiceId.PNI.parseOrThrow((String)response.getPni());
        this.account.finishRegistration(aci, pni, masterKey, pin, aciPreKeys, pniPreKeys);
        this.accountFileUpdater.updateAccountIdentifiers(this.account.getNumber(), aci);
        try (ManagerImpl m = null;){
            m = new ManagerImpl(this.account, this.pathConfig, this.accountFileUpdater, this.serviceEnvironmentConfig, this.userAgent);
            this.account = null;
            m.refreshPreKeys();
            if (response.isStorageCapable()) {
                m.syncRemoteStorage();
            }
            try {
                m.updateProfile(UpdateProfile.newBuilder().build());
            }
            catch (NoClassDefFoundError e) {
                logger.warn("Failed to set default profile: {}", (Object)e.getMessage());
            }
            try {
                m.refreshCurrentUsername();
            }
            catch (IOException | BaseUsernameException e) {
                logger.warn("Failed to refresh current username", e);
            }
            if (this.newManagerListener != null) {
                this.newManagerListener.accept(m);
                m = null;
            }
        }
    }

    @Override
    public void close() {
        if (this.account != null) {
            this.account.close();
            this.account = null;
        }
    }
}

