/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.storage.identities;

import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.asamk.signal.manager.api.TrustLevel;
import org.asamk.signal.manager.api.TrustNewIdentity;
import org.asamk.signal.manager.storage.Database;
import org.asamk.signal.manager.storage.Utils;
import org.asamk.signal.manager.storage.identities.IdentityInfo;
import org.asamk.signal.manager.storage.recipients.RecipientStore;
import org.signal.libsignal.protocol.IdentityKey;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.state.IdentityKeyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.ServiceId;

public class IdentityKeyStore {
    private static final Logger logger = LoggerFactory.getLogger(IdentityKeyStore.class);
    private static final String TABLE_IDENTITY = "identity";
    private final Database database;
    private final TrustNewIdentity trustNewIdentity;
    private final RecipientStore recipientStore;
    private final PublishSubject<ServiceId> identityChanges = PublishSubject.create();
    private boolean isRetryingDecryption = false;

    public static void createSql(Connection connection) throws SQLException {
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate("CREATE TABLE identity (\n  _id INTEGER PRIMARY KEY,\n  address TEXT UNIQUE NOT NULL,\n  identity_key BLOB NOT NULL,\n  added_timestamp INTEGER NOT NULL,\n  trust_level INTEGER NOT NULL\n) STRICT;\n");
        }
    }

    public IdentityKeyStore(Database database, TrustNewIdentity trustNewIdentity, RecipientStore recipientStore) {
        this.database = database;
        this.trustNewIdentity = trustNewIdentity;
        this.recipientStore = recipientStore;
    }

    public Observable<ServiceId> getIdentityChanges() {
        return this.identityChanges;
    }

    public IdentityKeyStore.IdentityChange saveIdentity(ServiceId serviceId, IdentityKey identityKey) {
        return this.saveIdentity(serviceId.toString(), identityKey);
    }

    public IdentityKeyStore.IdentityChange saveIdentity(Connection connection, ServiceId serviceId, IdentityKey identityKey) throws SQLException {
        return this.saveIdentity(connection, serviceId.toString(), identityKey);
    }

    IdentityKeyStore.IdentityChange saveIdentity(String address, IdentityKey identityKey) {
        IdentityKeyStore.IdentityChange identityChange;
        block9: {
            if (this.isRetryingDecryption) {
                return IdentityKeyStore.IdentityChange.NEW_OR_UNCHANGED;
            }
            Connection connection = this.database.getConnection();
            try {
                identityChange = this.saveIdentity(connection, address, identityKey);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed update identity store", e);
                }
            }
            connection.close();
        }
        return identityChange;
    }

    private IdentityKeyStore.IdentityChange saveIdentity(Connection connection, String address, IdentityKey identityKey) throws SQLException {
        IdentityInfo identityInfo = this.loadIdentity(connection, address);
        if (identityInfo == null) {
            this.saveNewIdentity(connection, address, identityKey, true);
            return IdentityKeyStore.IdentityChange.NEW_OR_UNCHANGED;
        }
        if (identityInfo.getIdentityKey().equals((Object)identityKey)) {
            logger.trace("Not storing new identity for recipient {}, identity already stored", (Object)address);
            return IdentityKeyStore.IdentityChange.NEW_OR_UNCHANGED;
        }
        this.saveNewIdentity(connection, address, identityKey, false);
        return IdentityKeyStore.IdentityChange.REPLACED_EXISTING;
    }

    public void setRetryingDecryption(boolean retryingDecryption) {
        this.isRetryingDecryption = retryingDecryption;
    }

    public boolean setIdentityTrustLevel(ServiceId serviceId, IdentityKey identityKey, TrustLevel trustLevel) {
        boolean bl;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                bl = this.setIdentityTrustLevel(connection, serviceId, identityKey, trustLevel);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed update identity store", e);
                }
            }
            connection.close();
        }
        return bl;
    }

    public boolean setIdentityTrustLevel(Connection connection, ServiceId serviceId, IdentityKey identityKey, TrustLevel trustLevel) throws SQLException {
        String address = serviceId.toString();
        IdentityInfo identityInfo = this.loadIdentity(connection, address);
        if (identityInfo == null) {
            logger.debug("Not updating trust level for recipient {}, identity not found", (Object)serviceId);
            return false;
        }
        if (!identityInfo.getIdentityKey().equals((Object)identityKey)) {
            logger.debug("Not updating trust level for recipient {}, different identity found", (Object)serviceId);
            return false;
        }
        if (identityInfo.getTrustLevel() == trustLevel) {
            logger.trace("Not updating trust level for recipient {}, trust level already matches", (Object)serviceId);
            return false;
        }
        logger.debug("Updating trust level for recipient {} with trust {}", (Object)serviceId, (Object)trustLevel);
        IdentityInfo newIdentityInfo = new IdentityInfo(address, identityKey, trustLevel, identityInfo.getDateAddedTimestamp());
        this.storeIdentity(connection, newIdentityInfo);
        return true;
    }

    public boolean isTrustedIdentity(ServiceId serviceId, IdentityKey identityKey, IdentityKeyStore.Direction direction) {
        return this.isTrustedIdentity(serviceId.toString(), identityKey, direction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTrustedIdentity(String address, IdentityKey identityKey, IdentityKeyStore.Direction direction) {
        if (this.trustNewIdentity == TrustNewIdentity.ALWAYS) {
            return true;
        }
        try (Connection connection = this.database.getConnection();){
            IdentityInfo identityInfo = this.loadIdentity(connection, address);
            if (identityInfo == null) {
                logger.debug("Initial identity found for {}, saving.", (Object)address);
                this.saveNewIdentity(connection, address, identityKey, true);
                identityInfo = this.loadIdentity(connection, address);
            } else if (!identityInfo.getIdentityKey().equals((Object)identityKey)) {
                if (direction != IdentityKeyStore.Direction.SENDING) {
                    logger.trace("Trusting identity for {} for {}: {}", new Object[]{address, direction, false});
                    boolean bl2 = false;
                    return bl2;
                }
                logger.debug("Changed identity found for {}, saving.", (Object)address);
                this.saveNewIdentity(connection, address, identityKey, false);
                identityInfo = this.loadIdentity(connection, address);
            }
            boolean isTrusted = identityInfo != null && identityInfo.isTrusted();
            logger.trace("Trusting identity for {} for {}: {}", new Object[]{address, direction, isTrusted});
            boolean bl = isTrusted;
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from identity store", e);
        }
    }

    public IdentityInfo getIdentityInfo(ServiceId serviceId) {
        return this.getIdentityInfo(serviceId.toString());
    }

    public IdentityInfo getIdentityInfo(String address) {
        IdentityInfo identityInfo;
        block8: {
            Connection connection = this.database.getConnection();
            try {
                identityInfo = this.loadIdentity(connection, address);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed read from identity store", e);
                }
            }
            connection.close();
        }
        return identityInfo;
    }

    public IdentityInfo getIdentityInfo(Connection connection, String address) throws SQLException {
        return this.loadIdentity(connection, address);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<IdentityInfo> getIdentities() {
        try (Connection connection = this.database.getConnection();){
            List<IdentityInfo> list;
            block14: {
                String sql = "SELECT i.address, i.identity_key, i.added_timestamp, i.trust_level\nFROM %s AS i\n".formatted(TABLE_IDENTITY);
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    list = Utils.executeQueryForStream(statement, this::getIdentityInfoFromResultSet).filter(Objects::nonNull).toList();
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return list;
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed read from identity store", e);
        }
    }

    public void deleteIdentity(ServiceId serviceId) {
        try (Connection connection = this.database.getConnection();){
            this.deleteIdentity(connection, serviceId.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update identity store", e);
        }
    }

    void addLegacyIdentities(Collection<IdentityInfo> identities) {
        logger.debug("Migrating legacy identities to database");
        long start = System.nanoTime();
        try (Connection connection = this.database.getConnection();){
            connection.setAutoCommit(false);
            for (IdentityInfo identityInfo : identities) {
                this.storeIdentity(connection, identityInfo);
            }
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed update identity store", e);
        }
        logger.debug("Complete identities migration took {}ms", (Object)((System.nanoTime() - start) / 1000000L));
    }

    private IdentityInfo loadIdentity(Connection connection, String address) throws SQLException {
        String sql = "SELECT i.address, i.identity_key, i.added_timestamp, i.trust_level\nFROM %s AS i\nWHERE i.address = ?\n".formatted(TABLE_IDENTITY);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, address);
            IdentityInfo identityInfo = Utils.executeQueryForOptional(statement, this::getIdentityInfoFromResultSet).orElse(null);
            return identityInfo;
        }
    }

    private void saveNewIdentity(Connection connection, String address, IdentityKey identityKey, boolean firstIdentity) throws SQLException {
        TrustLevel trustLevel = this.trustNewIdentity == TrustNewIdentity.ALWAYS || this.trustNewIdentity == TrustNewIdentity.ON_FIRST_USE && firstIdentity ? TrustLevel.TRUSTED_UNVERIFIED : TrustLevel.UNTRUSTED;
        logger.debug("Storing new identity for recipient {} with trust {}", (Object)address, (Object)trustLevel);
        IdentityInfo newIdentityInfo = new IdentityInfo(address, identityKey, trustLevel, System.currentTimeMillis());
        this.storeIdentity(connection, newIdentityInfo);
        ServiceId serviceId = ServiceId.parseOrNull((String)address);
        if (serviceId != null) {
            this.identityChanges.onNext((Object)serviceId);
        }
    }

    private void storeIdentity(Connection connection, IdentityInfo identityInfo) throws SQLException {
        logger.trace("Storing identity info for {}, trust: {}, added: {}", new Object[]{identityInfo.getServiceId(), identityInfo.getTrustLevel(), identityInfo.getDateAddedTimestamp()});
        String sql = "INSERT INTO %s (address, identity_key, added_timestamp, trust_level)\nVALUES (?, ?, ?, ?)\nON CONFLICT (address) DO UPDATE SET identity_key=excluded.identity_key, added_timestamp=excluded.added_timestamp, trust_level=excluded.trust_level\n".formatted(TABLE_IDENTITY);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, identityInfo.getAddress());
            statement.setBytes(2, identityInfo.getIdentityKey().serialize());
            statement.setLong(3, identityInfo.getDateAddedTimestamp());
            statement.setInt(4, identityInfo.getTrustLevel().ordinal());
            statement.executeUpdate();
        }
        this.recipientStore.rotateStorageId(connection, identityInfo.getServiceId());
    }

    private void deleteIdentity(Connection connection, String address) throws SQLException {
        String sql = "DELETE FROM %s AS i\nWHERE i.address = ?\n".formatted(TABLE_IDENTITY);
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, address);
            statement.executeUpdate();
        }
    }

    private IdentityInfo getIdentityInfoFromResultSet(ResultSet resultSet) throws SQLException {
        try {
            String address = resultSet.getString("address");
            IdentityKey id = new IdentityKey(resultSet.getBytes("identity_key"));
            TrustLevel trustLevel = TrustLevel.fromInt(resultSet.getInt("trust_level"));
            long added = resultSet.getLong("added_timestamp");
            return new IdentityInfo(address, id, trustLevel, added);
        }
        catch (InvalidKeyException e) {
            logger.warn("Failed to load identity key, resetting: {}", (Object)e.getMessage());
            return null;
        }
    }
}

