/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import okio.ByteString;
import org.asamk.signal.manager.api.Profile;
import org.asamk.signal.manager.internal.JobExecutor;
import org.asamk.signal.manager.jobs.DownloadProfileAvatarJob;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.recipients.Recipient;
import org.asamk.signal.manager.storage.recipients.RecipientId;
import org.asamk.signal.manager.syncStorage.DefaultStorageRecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageRecordUpdate;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.util.KeyUtils;
import org.asamk.signal.manager.util.Utils;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.profiles.ProfileKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.push.UsernameLinkComponents;
import org.whispersystems.signalservice.api.storage.AccountRecordExtensionsKt;
import org.whispersystems.signalservice.api.storage.IAPSubscriptionId;
import org.whispersystems.signalservice.api.storage.SignalAccountRecord;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.api.util.UuidUtil;
import org.whispersystems.signalservice.internal.storage.protos.AccountRecord;
import org.whispersystems.signalservice.internal.storage.protos.OptionalBool;
import org.whispersystems.signalservice.internal.storage.protos.Payments;

public class AccountRecordProcessor
extends DefaultStorageRecordProcessor<SignalAccountRecord> {
    private static final Logger logger = LoggerFactory.getLogger(AccountRecordProcessor.class);
    private final SignalAccountRecord localAccountRecord;
    private final SignalAccount account;
    private final Connection connection;
    private final JobExecutor jobExecutor;

    public AccountRecordProcessor(SignalAccount account, Connection connection, JobExecutor jobExecutor) throws SQLException {
        this.account = account;
        this.connection = connection;
        this.jobExecutor = jobExecutor;
        RecipientId selfRecipientId = account.getSelfRecipientId();
        Recipient recipient = account.getRecipientStore().getRecipient(connection, selfRecipientId);
        StorageId storageId = account.getRecipientStore().getSelfStorageId(connection);
        this.localAccountRecord = new SignalAccountRecord(storageId, StorageSyncModels.localToRemoteRecord(connection, account.getConfigurationStore(), recipient, account.getUsernameLink()));
    }

    @Override
    protected boolean isInvalid(SignalAccountRecord remote) {
        return false;
    }

    @Override
    protected Optional<SignalAccountRecord> getMatching(SignalAccountRecord record) {
        return Optional.of(this.localAccountRecord);
    }

    @Override
    protected SignalAccountRecord merge(SignalAccountRecord remoteRecord, SignalAccountRecord localRecord) {
        IAPSubscriptionId backupsPurchaseToken;
        ByteString backupsSubscriberId;
        String donationSubscriberCurrencyCode;
        ByteString donationSubscriberId;
        Payments payments;
        String familyName;
        String givenName;
        AccountRecord remote = remoteRecord.getProto();
        AccountRecord local = localRecord.getProto();
        if (!remote.givenName.isEmpty() || !remote.familyName.isEmpty()) {
            givenName = remote.givenName;
            familyName = remote.familyName;
        } else {
            givenName = local.givenName;
            familyName = local.familyName;
        }
        Payments payments2 = payments = remote.payments != null && remote.payments.entropy.size() > 0 ? remote.payments : local.payments;
        if (remote.subscriberId.size() > 0) {
            donationSubscriberId = remote.subscriberId;
            donationSubscriberCurrencyCode = remote.subscriberCurrencyCode;
        } else {
            donationSubscriberId = local.subscriberId;
            donationSubscriberCurrencyCode = local.subscriberCurrencyCode;
        }
        AccountRecord.IAPSubscriberData remoteBackupSubscriberData = remote.backupSubscriberData;
        if (remoteBackupSubscriberData != null && remoteBackupSubscriberData.subscriberId.size() > 0) {
            backupsSubscriberId = remoteBackupSubscriberData.subscriberId;
            backupsPurchaseToken = IAPSubscriptionId.Companion.from(remoteBackupSubscriberData);
        } else {
            backupsSubscriberId = local.backupSubscriberData != null ? local.backupSubscriberData.subscriberId : ByteString.EMPTY;
            backupsPurchaseToken = IAPSubscriptionId.Companion.from(local.backupSubscriberData);
        }
        AccountRecord.Builder mergedBuilder = remote.newBuilder().givenName(givenName).familyName(familyName).avatarUrlPath(Utils.firstNonEmpty(remote.avatarUrlPath, local.avatarUrlPath)).profileKey(Utils.firstNonEmpty(remote.profileKey, local.profileKey)).noteToSelfArchived(remote.noteToSelfArchived).noteToSelfMarkedUnread(remote.noteToSelfMarkedUnread).readReceipts(remote.readReceipts).typingIndicators(remote.typingIndicators).sealedSenderIndicators(remote.sealedSenderIndicators).linkPreviews(remote.linkPreviews).unlistedPhoneNumber(remote.unlistedPhoneNumber).phoneNumberSharingMode(remote.phoneNumberSharingMode).pinnedConversations(remote.pinnedConversations).preferContactAvatars(remote.preferContactAvatars).universalExpireTimer(remote.universalExpireTimer).preferredReactionEmoji(Utils.firstNonEmpty(remote.preferredReactionEmoji, local.preferredReactionEmoji)).subscriberId(Utils.firstNonEmpty(remote.subscriberId, local.subscriberId)).subscriberCurrencyCode(Utils.firstNonEmpty(remote.subscriberCurrencyCode, local.subscriberCurrencyCode)).displayBadgesOnProfile(remote.displayBadgesOnProfile).subscriptionManuallyCancelled(remote.subscriptionManuallyCancelled).keepMutedChatsArchived(remote.keepMutedChatsArchived).hasSetMyStoriesPrivacy(remote.hasSetMyStoriesPrivacy).hasViewedOnboardingStory(remote.hasViewedOnboardingStory || local.hasViewedOnboardingStory).storiesDisabled(remote.storiesDisabled).hasSeenGroupStoryEducationSheet(remote.hasSeenGroupStoryEducationSheet || local.hasSeenGroupStoryEducationSheet).hasCompletedUsernameOnboarding(remote.hasCompletedUsernameOnboarding || local.hasCompletedUsernameOnboarding).storyViewReceiptsEnabled(remote.storyViewReceiptsEnabled == OptionalBool.UNSET ? local.storyViewReceiptsEnabled : remote.storyViewReceiptsEnabled).username(remote.username).usernameLink(remote.usernameLink).avatarColor(remote.avatarColor);
        AccountRecordExtensionsKt.safeSetPayments((AccountRecord.Builder)mergedBuilder, (payments != null && payments.enabled ? 1 : 0) != 0, payments == null ? null : payments.entropy.toByteArray());
        AccountRecordExtensionsKt.safeSetSubscriber((AccountRecord.Builder)mergedBuilder, (ByteString)donationSubscriberId, (String)donationSubscriberCurrencyCode);
        AccountRecordExtensionsKt.safeSetBackupsSubscriber((AccountRecord.Builder)mergedBuilder, (ByteString)backupsSubscriberId, (IAPSubscriptionId)backupsPurchaseToken);
        AccountRecord merged = mergedBuilder.build();
        boolean matchesRemote = AccountRecordProcessor.doProtosMatch(merged, remote);
        if (matchesRemote) {
            return remoteRecord;
        }
        boolean matchesLocal = AccountRecordProcessor.doProtosMatch(merged, local);
        if (matchesLocal) {
            return localRecord;
        }
        return new SignalAccountRecord(StorageId.forAccount((byte[])KeyUtils.createRawStorageId()), mergedBuilder.build());
    }

    @Override
    protected void insertLocal(SignalAccountRecord record) {
        throw new UnsupportedOperationException("We should always have a local AccountRecord, so we should never been inserting a new one.");
    }

    @Override
    protected void updateLocal(StorageRecordUpdate<SignalAccountRecord> update) throws SQLException {
        Profile profile;
        SignalAccountRecord accountRecord = update.newRecord();
        AccountRecord accountProto = accountRecord.getProto();
        this.account.getConfigurationStore().setReadReceipts(this.connection, accountProto.readReceipts);
        this.account.getConfigurationStore().setTypingIndicators(this.connection, accountProto.typingIndicators);
        this.account.getConfigurationStore().setUnidentifiedDeliveryIndicators(this.connection, accountProto.sealedSenderIndicators);
        this.account.getConfigurationStore().setLinkPreviews(this.connection, accountProto.linkPreviews);
        this.account.getConfigurationStore().setPhoneNumberSharingMode(this.connection, StorageSyncModels.remoteToLocal(accountProto.phoneNumberSharingMode));
        this.account.getConfigurationStore().setPhoneNumberUnlisted(this.connection, accountProto.unlistedPhoneNumber);
        this.account.setUsername(!accountProto.username.isEmpty() ? accountProto.username : null);
        if (accountProto.usernameLink != null) {
            AccountRecord.UsernameLink usernameLink = accountProto.usernameLink;
            this.account.setUsernameLink(new UsernameLinkComponents(usernameLink.entropy.toByteArray(), UuidUtil.parseOrThrow((byte[])usernameLink.serverId.toByteArray())));
            this.account.getConfigurationStore().setUsernameLinkColor(this.connection, usernameLink.color.name());
        }
        if (accountProto.profileKey.size() > 0) {
            ProfileKey profileKey;
            try {
                profileKey = new ProfileKey(accountProto.profileKey.toByteArray());
            }
            catch (InvalidInputException e) {
                logger.debug("Received invalid profile key from storage");
                profileKey = null;
            }
            if (profileKey != null) {
                this.account.setProfileKey(profileKey);
                String avatarPath = accountProto.avatarUrlPath.isEmpty() ? null : accountProto.avatarUrlPath;
                this.jobExecutor.enqueueJob(new DownloadProfileAvatarJob(avatarPath));
            }
        }
        Profile.Builder builder = (profile = this.account.getRecipientStore().getProfile(this.connection, this.account.getSelfRecipientId())) == null ? Profile.newBuilder() : Profile.newBuilder(profile);
        builder.withGivenName(accountProto.givenName);
        builder.withFamilyName(accountProto.familyName);
        this.account.getRecipientStore().storeProfile(this.connection, this.account.getSelfRecipientId(), builder.build());
        this.account.getRecipientStore().storeStorageRecord(this.connection, this.account.getSelfRecipientId(), accountRecord.getId(), accountProto.encode());
    }

    @Override
    public int compare(SignalAccountRecord lhs, SignalAccountRecord rhs) {
        return 0;
    }

    private static boolean doProtosMatch(AccountRecord merged, AccountRecord other) {
        return Arrays.equals(merged.encode(), other.encode());
    }
}

