//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalekey?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSLocaleKey = NSString;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocale?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSLocale;
);

unsafe impl Send for NSLocale {}

unsafe impl Sync for NSLocale {}

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<NSLocale> for CFLocale {
    #[inline]
    fn as_ref(&self) -> &NSLocale {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<CFLocale> for NSLocale {
    #[inline]
    fn as_ref(&self) -> &CFLocale {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCoding for NSLocale {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSCopying for NSLocale {}
);

#[cfg(feature = "NSObject")]
unsafe impl CopyingHelper for NSLocale {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSLocale {}
);

#[cfg(feature = "NSObject")]
extern_conformance!(
    unsafe impl NSSecureCoding for NSLocale {}
);

impl NSLocale {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(objectForKey:))]
        #[unsafe(method_family = none)]
        pub fn objectForKey(&self, key: &NSLocaleKey) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSString")]
        /// # Safety
        ///
        /// `value` should be of the correct type.
        #[unsafe(method(displayNameForKey:value:))]
        #[unsafe(method_family = none)]
        pub unsafe fn displayNameForKey_value(
            &self,
            key: &NSLocaleKey,
            value: &AnyObject,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithLocaleIdentifier:))]
        #[unsafe(method_family = init)]
        pub fn initWithLocaleIdentifier(this: Allocated<Self>, string: &NSString)
            -> Retained<Self>;

        #[cfg(feature = "NSCoder")]
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// NSExtendedLocale.
impl NSLocale {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(localeIdentifier))]
        #[unsafe(method_family = none)]
        pub fn localeIdentifier(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localizedStringForLocaleIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn localizedStringForLocaleIdentifier(
            &self,
            locale_identifier: &NSString,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(languageCode))]
        #[unsafe(method_family = none)]
        pub fn languageCode(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localizedStringForLanguageCode:))]
        #[unsafe(method_family = none)]
        pub fn localizedStringForLanguageCode(
            &self,
            language_code: &NSString,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Returns the identifier for the language part of the locale. For example, returns "en-US" for "en_US@rg=gbzzzz"  locale.
        #[unsafe(method(languageIdentifier))]
        #[unsafe(method_family = none)]
        pub fn languageIdentifier(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[deprecated]
        #[unsafe(method(countryCode))]
        #[unsafe(method_family = none)]
        pub fn countryCode(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localizedStringForCountryCode:))]
        #[unsafe(method_family = none)]
        pub fn localizedStringForCountryCode(
            &self,
            country_code: &NSString,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Returns the region code of the locale.
        /// If the `rg` subtag is present, the value of the subtag will be used. For example,  returns "GB" for "en_US@rg=gbzzzz" locale.
        /// If the `localeIdentifier` doesn’t contain a region, returns `nil`.
        #[unsafe(method(regionCode))]
        #[unsafe(method_family = none)]
        pub fn regionCode(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(scriptCode))]
        #[unsafe(method_family = none)]
        pub fn scriptCode(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localizedStringForScriptCode:))]
        #[unsafe(method_family = none)]
        pub fn localizedStringForScriptCode(
            &self,
            script_code: &NSString,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(variantCode))]
        #[unsafe(method_family = none)]
        pub fn variantCode(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localizedStringForVariantCode:))]
        #[unsafe(method_family = none)]
        pub fn localizedStringForVariantCode(
            &self,
            variant_code: &NSString,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSCharacterSet")]
        #[unsafe(method(exemplarCharacterSet))]
        #[unsafe(method_family = none)]
        pub fn exemplarCharacterSet(&self) -> Retained<NSCharacterSet>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(calendarIdentifier))]
        #[unsafe(method_family = none)]
        pub fn calendarIdentifier(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localizedStringForCalendarIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn localizedStringForCalendarIdentifier(
            &self,
            calendar_identifier: &NSString,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(collationIdentifier))]
        #[unsafe(method_family = none)]
        pub fn collationIdentifier(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localizedStringForCollationIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn localizedStringForCollationIdentifier(
            &self,
            collation_identifier: &NSString,
        ) -> Option<Retained<NSString>>;

        #[unsafe(method(usesMetricSystem))]
        #[unsafe(method_family = none)]
        pub fn usesMetricSystem(&self) -> bool;

        #[cfg(feature = "NSString")]
        #[unsafe(method(decimalSeparator))]
        #[unsafe(method_family = none)]
        pub fn decimalSeparator(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(groupingSeparator))]
        #[unsafe(method_family = none)]
        pub fn groupingSeparator(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(currencySymbol))]
        #[unsafe(method_family = none)]
        pub fn currencySymbol(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(currencyCode))]
        #[unsafe(method_family = none)]
        pub fn currencyCode(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localizedStringForCurrencyCode:))]
        #[unsafe(method_family = none)]
        pub fn localizedStringForCurrencyCode(
            &self,
            currency_code: &NSString,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(collatorIdentifier))]
        #[unsafe(method_family = none)]
        pub fn collatorIdentifier(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localizedStringForCollatorIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn localizedStringForCollatorIdentifier(
            &self,
            collator_identifier: &NSString,
        ) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(quotationBeginDelimiter))]
        #[unsafe(method_family = none)]
        pub fn quotationBeginDelimiter(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(quotationEndDelimiter))]
        #[unsafe(method_family = none)]
        pub fn quotationEndDelimiter(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(alternateQuotationBeginDelimiter))]
        #[unsafe(method_family = none)]
        pub fn alternateQuotationBeginDelimiter(&self) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(alternateQuotationEndDelimiter))]
        #[unsafe(method_family = none)]
        pub fn alternateQuotationEndDelimiter(&self) -> Retained<NSString>;
    );
}

/// NSLocaleCreation.
impl NSLocale {
    extern_methods!(
        #[unsafe(method(autoupdatingCurrentLocale))]
        #[unsafe(method_family = none)]
        pub fn autoupdatingCurrentLocale() -> Retained<NSLocale>;

        #[unsafe(method(currentLocale))]
        #[unsafe(method_family = none)]
        pub fn currentLocale() -> Retained<NSLocale>;

        #[unsafe(method(systemLocale))]
        #[unsafe(method_family = none)]
        pub fn systemLocale() -> Retained<NSLocale>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localeWithLocaleIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn localeWithLocaleIdentifier(ident: &NSString) -> Retained<Self>;
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalelanguagedirection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSLocaleLanguageDirection(pub NSUInteger);
impl NSLocaleLanguageDirection {
    #[doc(alias = "NSLocaleLanguageDirectionUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "NSLocaleLanguageDirectionLeftToRight")]
    pub const LeftToRight: Self = Self(1);
    #[doc(alias = "NSLocaleLanguageDirectionRightToLeft")]
    pub const RightToLeft: Self = Self(2);
    #[doc(alias = "NSLocaleLanguageDirectionTopToBottom")]
    pub const TopToBottom: Self = Self(3);
    #[doc(alias = "NSLocaleLanguageDirectionBottomToTop")]
    pub const BottomToTop: Self = Self(4);
}

unsafe impl Encode for NSLocaleLanguageDirection {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSLocaleLanguageDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// NSLocaleGeneralInfo.
impl NSLocale {
    extern_methods!(
        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(availableLocaleIdentifiers))]
        #[unsafe(method_family = none)]
        pub fn availableLocaleIdentifiers() -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(ISOLanguageCodes))]
        #[unsafe(method_family = none)]
        pub fn ISOLanguageCodes() -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(ISOCountryCodes))]
        #[unsafe(method_family = none)]
        pub fn ISOCountryCodes() -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(ISOCurrencyCodes))]
        #[unsafe(method_family = none)]
        pub fn ISOCurrencyCodes() -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(commonISOCurrencyCodes))]
        #[unsafe(method_family = none)]
        pub fn commonISOCurrencyCodes() -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSArray", feature = "NSString"))]
        #[unsafe(method(preferredLanguages))]
        #[unsafe(method_family = none)]
        pub fn preferredLanguages() -> Retained<NSArray<NSString>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(componentsFromLocaleIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn componentsFromLocaleIdentifier(
            string: &NSString,
        ) -> Retained<NSDictionary<NSString, NSString>>;

        #[cfg(all(feature = "NSDictionary", feature = "NSString"))]
        #[unsafe(method(localeIdentifierFromComponents:))]
        #[unsafe(method_family = none)]
        pub fn localeIdentifierFromComponents(
            dict: &NSDictionary<NSString, NSString>,
        ) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(canonicalLocaleIdentifierFromString:))]
        #[unsafe(method_family = none)]
        pub fn canonicalLocaleIdentifierFromString(string: &NSString) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(canonicalLanguageIdentifierFromString:))]
        #[unsafe(method_family = none)]
        pub fn canonicalLanguageIdentifierFromString(string: &NSString) -> Retained<NSString>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(localeIdentifierFromWindowsLocaleCode:))]
        #[unsafe(method_family = none)]
        pub fn localeIdentifierFromWindowsLocaleCode(lcid: u32) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(windowsLocaleCodeFromLocaleIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn windowsLocaleCodeFromLocaleIdentifier(locale_identifier: &NSString) -> u32;

        #[cfg(feature = "NSString")]
        #[unsafe(method(characterDirectionForLanguage:))]
        #[unsafe(method_family = none)]
        pub fn characterDirectionForLanguage(iso_lang_code: &NSString)
            -> NSLocaleLanguageDirection;

        #[cfg(feature = "NSString")]
        #[unsafe(method(lineDirectionForLanguage:))]
        #[unsafe(method_family = none)]
        pub fn lineDirectionForLanguage(iso_lang_code: &NSString) -> NSLocaleLanguageDirection;
    );
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nscurrentlocaledidchangenotification?language=objc)
    #[cfg(all(feature = "NSNotification", feature = "NSString"))]
    pub static NSCurrentLocaleDidChangeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocaleidentifier?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleIdentifier: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalelanguagecode?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleLanguageCode: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalecountrycode?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleCountryCode: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalescriptcode?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleScriptCode: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalevariantcode?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleVariantCode: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocaleexemplarcharacterset?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleExemplarCharacterSet: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalecalendar?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleCalendar: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalecollationidentifier?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleCollationIdentifier: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocaleusesmetricsystem?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleUsesMetricSystem: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalemeasurementsystem?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleMeasurementSystem: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocaledecimalseparator?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleDecimalSeparator: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalegroupingseparator?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleGroupingSeparator: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalecurrencysymbol?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleCurrencySymbol: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalecurrencycode?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleCurrencyCode: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalecollatoridentifier?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleCollatorIdentifier: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalequotationbegindelimiterkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleQuotationBeginDelimiterKey: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalequotationenddelimiterkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleQuotationEndDelimiterKey: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalealternatequotationbegindelimiterkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleAlternateQuotationBeginDelimiterKey: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nslocalealternatequotationenddelimiterkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSLocaleAlternateQuotationEndDelimiterKey: &'static NSLocaleKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsgregoriancalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSGregorianCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsbuddhistcalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSBuddhistCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nschinesecalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSChineseCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nshebrewcalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSHebrewCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsislamiccalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSIslamicCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsislamiccivilcalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSIslamicCivilCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsjapanesecalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSJapaneseCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsrepublicofchinacalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSRepublicOfChinaCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nspersiancalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSPersianCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsindiancalendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSIndianCalendar: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsiso8601calendar?language=objc)
    #[cfg(feature = "NSString")]
    #[deprecated]
    pub static NSISO8601Calendar: &'static NSString;
}
