/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.RuleStatusInfo;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.automation.internal.RuleEngineImpl;
import org.openhab.core.common.ThreadPoolManager;

@NonNullByDefault
public class TriggerHandlerCallbackImpl
implements TriggerHandlerCallback {
    private final RuleEngineImpl re;
    private final String ruleUID;
    private ScheduledExecutorService executor;
    private @Nullable Future<?> future;

    protected TriggerHandlerCallbackImpl(RuleEngineImpl re, String ruleUID) {
        this.re = re;
        this.ruleUID = ruleUID;
        this.executor = ThreadPoolManager.getPoolBasedSequentialScheduledExecutorService((String)"rules", (String)("rule-" + ruleUID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggered(Trigger trigger, Map<String, ?> context) {
        TriggerHandlerCallbackImpl triggerHandlerCallbackImpl = this;
        synchronized (triggerHandlerCallbackImpl) {
            this.future = this.executor.submit(new TriggerData(trigger, context));
        }
        this.re.logger.debug("The trigger '{}' of rule '{}' is triggered.", (Object)trigger.getId(), (Object)this.ruleUID);
    }

    public boolean isRunning() {
        Future<?> future = this.future;
        return future == null || !future.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        TriggerHandlerCallbackImpl triggerHandlerCallbackImpl = this;
        synchronized (triggerHandlerCallbackImpl) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public @Nullable Boolean isEnabled(String ruleUID) {
        return this.re.isEnabled(ruleUID);
    }

    @Override
    public void setEnabled(String uid, boolean isEnabled) {
        this.re.setEnabled(uid, isEnabled);
    }

    @Override
    public @Nullable RuleStatusInfo getStatusInfo(String ruleUID) {
        return this.re.getStatusInfo(ruleUID);
    }

    @Override
    public @Nullable RuleStatus getStatus(String ruleUID) {
        return this.re.getStatus(ruleUID);
    }

    @Override
    public void runNow(String uid) {
        this.re.runNow(uid);
    }

    @Override
    public void runNow(String uid, boolean considerConditions, @Nullable Map<String, Object> context) {
        this.re.runNow(uid, considerConditions, context);
    }

    @Override
    public ScheduledExecutorService getScheduler() {
        return this.executor;
    }

    class TriggerData
    implements Runnable {
        private final Trigger trigger;
        private final @Nullable Map<String, ?> outputs;

        public Trigger getTrigger() {
            return this.trigger;
        }

        public @Nullable Map<String, ?> getOutputs() {
            return this.outputs;
        }

        public TriggerData(@Nullable Trigger t, Map<String, ?> outputs) {
            this.trigger = t;
            this.outputs = outputs;
        }

        @Override
        public void run() {
            TriggerHandlerCallbackImpl.this.re.runRule(TriggerHandlerCallbackImpl.this.ruleUID, this);
        }
    }
}

