/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.commands.common.EventManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIElementAlignment;
import org.jkiss.dbeaver.ui.UIElementFontStyle;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.DefaultColorSelector;
import org.jkiss.dbeaver.ui.controls.TextWithDropDown;
import org.jkiss.dbeaver.ui.controls.bool.BooleanMode;
import org.jkiss.dbeaver.ui.controls.bool.BooleanState;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyle;
import org.jkiss.dbeaver.ui.controls.bool.BooleanStyleSet;
import org.jkiss.dbeaver.ui.preferences.PrefPageMiscellaneousAbstract;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.utils.CommonUtils;

public class PrefPageMiscellaneous
extends PrefPageMiscellaneousAbstract
implements IWorkbenchPreferencePage {
    private Button holidayDecorationsCheck;
    private final List<Consumer<BooleanStyleSet>> booleanStylesChangeListeners = new ArrayList<Consumer<BooleanStyleSet>>();
    private BooleanPanel booleanCheckedPanel;
    private BooleanPanel booleanUncheckedPanel;
    private BooleanPanel booleanNullPanel;
    private RGB defaultColor;

    public PrefPageMiscellaneous() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    protected Object getConfiguratorObject() {
        return super.getConfiguratorObject();
    }

    public void init(IWorkbench workbench) {
    }

    @NotNull
    protected Control createPreferenceContent(@NotNull Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1, (int)5);
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        Composite groupEditors = UIUtils.createTitledComposite((Composite)composite, (String)CoreMessages.pref_page_ui_general_boolean, (int)3, (int)768);
        UIUtils.createControlLabel((Composite)groupEditors, (String)CoreMessages.pref_page_ui_general_boolean_label_mode);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
                BooleanMode mode = (BooleanMode)e.widget.getData();
                PrefPageMiscellaneous.this.notifyBooleanStylesChanged(BooleanStyleSet.getDefaultStyles((DBPPreferenceStore)store, (BooleanMode)mode));
            }
        };
        this.booleanStylesChangeListeners.add(value -> {
            this.booleanCheckedPanel.loadStyle(value.getCheckedStyle(), value.getDefaultColor());
            this.booleanUncheckedPanel.loadStyle(value.getUncheckedStyle(), value.getDefaultColor());
            this.booleanNullPanel.loadStyle(value.getNullStyle(), value.getDefaultColor());
            this.defaultColor = value.getDefaultColor();
        });
        for (BooleanMode mode : BooleanMode.values()) {
            Button button = UIUtils.createRadioButton((Composite)groupEditors, (String)mode.getName(), (Object)mode, null);
            button.setToolTipText(mode.getDescription());
            button.addSelectionListener((SelectionListener)selectionListener);
            button.setData((Object)mode);
            this.booleanStylesChangeListeners.add(value -> button.setSelection(button.getData() == value.getMode()));
        }
        Composite group = new Composite(groupEditors, 0);
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(7).create());
        group.setLayoutData((Object)GridDataFactory.swtDefaults().span(3, 1).create());
        UIUtils.createLabel((Composite)group, (String)CoreMessages.pref_page_ui_general_boolean_label_state);
        UIUtils.createPlaceholder((Composite)group, (int)1);
        UIUtils.createControlLabel((Composite)group, (String)CoreMessages.pref_page_ui_general_boolean_label_text);
        UIUtils.createPlaceholder((Composite)group, (int)1);
        UIUtils.createControlLabel((Composite)group, (String)CoreMessages.pref_page_ui_general_boolean_label_align);
        UIUtils.createPlaceholder((Composite)group, (int)1);
        UIUtils.createControlLabel((Composite)group, (String)CoreMessages.pref_page_ui_general_boolean_label_color);
        BooleanStyleSet savedStyles = BooleanStyleSet.getDefaultStyles((DBPPreferenceStore)DBWorkbench.getPlatform().getPreferenceStore());
        BooleanStyleSet defaultStyles = BooleanStyleSet.getDefaultStyleSet();
        this.booleanCheckedPanel = new BooleanPanel(group, BooleanState.CHECKED, savedStyles.getStyle(BooleanState.CHECKED).getMode() == BooleanMode.TEXT ? savedStyles.getStyle(BooleanState.CHECKED).getText() : defaultStyles.getStyle(BooleanState.CHECKED).getText());
        this.booleanUncheckedPanel = new BooleanPanel(group, BooleanState.UNCHECKED, savedStyles.getStyle(BooleanState.UNCHECKED).getMode() == BooleanMode.TEXT ? savedStyles.getStyle(BooleanState.UNCHECKED).getText() : defaultStyles.getStyle(BooleanState.UNCHECKED).getText());
        this.booleanNullPanel = new BooleanPanel(group, BooleanState.NULL, savedStyles.getStyle(BooleanState.NULL).getMode() == BooleanMode.TEXT ? savedStyles.getStyle(BooleanState.NULL).getText() : defaultStyles.getStyle(BooleanState.NULL).getText());
        this.notifyBooleanStylesChanged(savedStyles);
        Composite group2 = UIUtils.createTitledComposite((Composite)composite, (String)"Holiday decorations", (int)1, (int)768);
        this.holidayDecorationsCheck = UIUtils.createCheckbox((Composite)group2, (String)"Show holiday decorations", (boolean)false);
        this.holidayDecorationsCheck.setLayoutData((Object)new GridData());
        this.holidayDecorationsCheck.setSelection(store.getBoolean("ui.show.holiday.decorations"));
        UIUtils.createInfoLabel((Composite)group2, (String)CoreMessages.pref_page_ui_general_label_options_take_effect_after_restart);
        this.injectConfigurators(composite);
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.holidayDecorationsCheck.setSelection(store.getDefaultBoolean("ui.show.holiday.decorations"));
        this.notifyBooleanStylesChanged(BooleanStyleSet.getDefaultStyleSet());
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("ui.show.holiday.decorations", this.holidayDecorationsCheck.getSelection());
        BooleanStyleSet.setDefaultStyles((DBPPreferenceStore)store, (BooleanStyleSet)new BooleanStyleSet(this.booleanCheckedPanel.saveStyle(), this.booleanUncheckedPanel.saveStyle(), this.booleanNullPanel.saveStyle(), this.defaultColor));
        return super.performOk();
    }

    private void notifyBooleanStylesChanged(@NotNull BooleanStyleSet set) {
        for (Consumer<BooleanStyleSet> listener : this.booleanStylesChangeListeners) {
            listener.accept(set);
        }
    }

    private void updateBooleanValidState() {
        boolean valid;
        boolean bl = valid = this.booleanCheckedPanel.isValid() && this.booleanUncheckedPanel.isValid() && this.booleanNullPanel.isValid();
        if (valid) {
            this.setErrorMessage(null);
            this.setValid(true);
        } else {
            this.setErrorMessage(CoreMessages.pref_page_ui_general_boolean_invalid_values);
            this.setValid(false);
        }
    }

    private class BooleanPanel
    extends EventManager {
        private static final String PROP_MODE = "modeValue";
        private static final String PROP_FONT = "fontValue";
        private static final String PROP_TEXT = "textValue";
        private static final String PROP_ALIGN = "alignValue";
        private static final String PROP_COLOR = "colorValue";
        private static final String PROP_DEFAULT_COLOR = "defaultColorValue";
        private static final int MENU_PRESET_ID = 1;
        private static final int MENU_FONT_ID = 2;
        private static final int MENU_RESET_COLOR_ID = 3;
        private final Composite parent;
        private final BooleanState state;
        private final Font normalFont;
        private final Font boldFont;
        private final Font italicFont;
        private BooleanMode currentMode;
        private String currentText;
        private String savedText;
        private UIElementAlignment currentAlignment;
        private UIElementFontStyle currentFontStyle;
        private RGB currentColor;
        private RGB currentDefaultColor;

        public BooleanPanel(@NotNull Composite parent, @NotNull BooleanState state, String savedText) {
            this.parent = parent;
            this.state = state;
            this.savedText = savedText;
            FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)parent.getFont());
            this.normalFont = parent.getFont();
            this.boldFont = fontDescriptor.setStyle(1).createFont((Device)parent.getDisplay());
            this.italicFont = fontDescriptor.setStyle(2).createFont((Device)parent.getDisplay());
            parent.addDisposeListener(e -> {
                UIUtils.dispose((Resource)this.boldFont);
                UIUtils.dispose((Resource)this.italicFont);
            });
            Label icon = UIUtils.createLabel((Composite)parent, (DBPImage)state.getIcon());
            icon.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            icon.setToolTipText(state.getLabel());
            UIUtils.createLabel((Composite)parent, (DBPImage)UIIcon.SEPARATOR_V);
            ModifyListener textModifyListener = e -> {
                this.currentText = ((Text)e.widget).getText();
                PrefPageMiscellaneous.this.updateBooleanValidState();
            };
            SelectionAdapter menuSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MenuItem menu = (MenuItem)e.widget;
                    switch (menu.getID()) {
                        case 1: {
                            BooleanPanel.this.notifyPropertyChanged(e.widget, BooleanPanel.PROP_TEXT, menu.getText());
                            break;
                        }
                        case 2: {
                            BooleanPanel.this.notifyPropertyChanged(e.widget, BooleanPanel.PROP_FONT, menu.getData());
                            break;
                        }
                        case 3: {
                            BooleanPanel.this.notifyPropertyChanged(e.widget, BooleanPanel.PROP_COLOR, BooleanPanel.this.currentDefaultColor);
                        }
                    }
                }
            };
            for (UIElementAlignment alignment : UIElementAlignment.values()) {
                TextWithDropDown text = new TextWithDropDown(parent, 2048, alignment.getStyle(), (SelectionListener)menuSelectionListener);
                text.getTextComponent().addModifyListener(textModifyListener);
                text.setData((Object)alignment);
                for (String variant : state.getPresets()) {
                    text.addMenuItem(variant).setID(1);
                }
                text.addMenuSeparator();
                text.addMenuItemWithMenu(CoreMessages.pref_page_ui_general_boolean_styles, null, menu -> {
                    for (UIElementFontStyle value : UIElementFontStyle.values()) {
                        MenuItem item = text.addMenuItem(menu, value.getLabel(), null, (Object)value, 16);
                        item.setID(2);
                        this.addPropertyChangeListener(event -> {
                            if (event.getProperty().equals(PROP_FONT)) {
                                item.setSelection(event.getNewValue() == item.getData());
                            }
                        });
                    }
                });
                text.addMenuItemWithMenu(CoreMessages.pref_page_ui_general_boolean_color, null, menu -> {
                    MenuItem item = text.addMenuItem(menu, CoreMessages.pref_page_ui_general_boolean_color_use_theme_color, null, null, 32);
                    item.setID(3);
                    this.addPropertyChangeListener(event -> {
                        if (event.getProperty().equals(PROP_COLOR)) {
                            item.setSelection(event.getNewValue() == this.currentDefaultColor);
                        }
                    });
                });
                ((GridData)text.getLayoutData()).widthHint = 120;
                this.addPropertyChangeListener(event -> {
                    switch (event.getProperty()) {
                        case "textValue": {
                            text.getTextComponent().setText((String)event.getNewValue());
                            break;
                        }
                        case "fontValue": {
                            switch ((UIElementFontStyle)event.getNewValue()) {
                                case NORMAL: {
                                    text.getTextComponent().setFont(this.normalFont);
                                    break;
                                }
                                case ITALIC: {
                                    text.getTextComponent().setFont(this.italicFont);
                                    break;
                                }
                                case BOLD: {
                                    text.getTextComponent().setFont(this.boldFont);
                                }
                            }
                            break;
                        }
                        case "modeValue": {
                            UIUtils.enableWithChildren((Control)text, (event.getNewValue() == BooleanMode.TEXT ? 1 : 0) != 0);
                            if (event.getNewValue() == BooleanMode.TEXT) {
                                text.getTextComponent().setText(this.savedText);
                                break;
                            }
                            text.getTextComponent().setText("");
                            break;
                        }
                        case "colorValue": {
                            text.getTextComponent().setForeground(UIUtils.getSharedColor((RGB)((RGB)event.getNewValue())));
                            break;
                        }
                        case "alignValue": {
                            UIUtils.setControlVisible((Control)text, (event.getNewValue() == text.getData() ? 1 : 0) != 0);
                            text.getTextComponent().setText(this.currentText);
                        }
                    }
                });
            }
            UIUtils.createLabel((Composite)parent, (DBPImage)UIIcon.SEPARATOR_V);
            ToolBar alignToolBar = new ToolBar(parent, 256);
            alignToolBar.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
            SelectionAdapter selectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((ToolItem)e.widget).getSelection()) {
                        BooleanPanel.this.notifyPropertyChanged(e.widget, BooleanPanel.PROP_ALIGN, e.widget.getData());
                    }
                }
            };
            for (UIElementAlignment alignment : UIElementAlignment.values()) {
                ToolItem item = new ToolItem(alignToolBar, 16);
                item.setImage(DBeaverIcons.getImage((DBPImage)alignment.getIcon()));
                item.setToolTipText(alignment.getLabel());
                item.addSelectionListener((SelectionListener)selectionListener);
                item.setData((Object)alignment);
                this.addPropertyChangeListener(event -> {
                    if (event.getProperty().equals(PROP_ALIGN)) {
                        item.setSelection(event.getNewValue() == item.getData());
                    }
                });
            }
            UIUtils.createLabel((Composite)parent, (DBPImage)UIIcon.SEPARATOR_V);
            DefaultColorSelector selector = new DefaultColorSelector(parent, false);
            selector.setColorValue(new RGB(0, 0, 0));
            selector.setDefaultColorValue(new RGB(0, 0, 0));
            selector.addListener(e -> this.notifyPropertyChanged(selector, PROP_COLOR, selector.getColorValue()));
            this.addPropertyChangeListener(event -> {
                if (event.getSource() == selector) {
                    return;
                }
                switch (event.getProperty()) {
                    case "modeValue": {
                        selector.setEnabled(event.getNewValue() == BooleanMode.TEXT);
                        break;
                    }
                    case "colorValue": {
                        selector.setColorValue((RGB)event.getNewValue());
                        break;
                    }
                    case "defaultColorValue": {
                        selector.setDefaultColorValue((RGB)event.getNewValue());
                    }
                }
            });
            this.addPropertyChangeListener(event -> {
                switch (event.getProperty()) {
                    case "modeValue": {
                        this.currentMode = (BooleanMode)event.getNewValue();
                        break;
                    }
                    case "textValue": {
                        this.currentText = (String)event.getNewValue();
                        break;
                    }
                    case "alignValue": {
                        this.currentAlignment = (UIElementAlignment)event.getNewValue();
                        this.parent.layout(true);
                        break;
                    }
                    case "fontValue": {
                        this.currentFontStyle = (UIElementFontStyle)event.getNewValue();
                        break;
                    }
                    case "colorValue": {
                        this.currentColor = (RGB)event.getNewValue();
                        break;
                    }
                    case "defaultColorValue": {
                        this.currentDefaultColor = (RGB)event.getNewValue();
                    }
                }
                PrefPageMiscellaneous.this.updateBooleanValidState();
            });
        }

        public void loadStyle(@NotNull BooleanStyle style, @NotNull RGB defaultColor) {
            if (style.getMode() == BooleanMode.TEXT) {
                this.notifyPropertyChanged((Object)this, PROP_TEXT, style.getText());
                this.notifyPropertyChanged((Object)this, PROP_FONT, style.getFontStyle());
                this.notifyPropertyChanged((Object)this, PROP_DEFAULT_COLOR, defaultColor);
                this.notifyPropertyChanged((Object)this, PROP_COLOR, style.getColor());
            } else {
                this.notifyPropertyChanged((Object)this, PROP_TEXT, "");
            }
            this.notifyPropertyChanged((Object)this, PROP_ALIGN, style.getAlignment());
            this.notifyPropertyChanged((Object)this, PROP_MODE, style.getMode());
        }

        @NotNull
        public BooleanStyle saveStyle() {
            if (this.currentMode == BooleanMode.TEXT) {
                this.savedText = this.currentText;
                return BooleanStyle.usingText((String)this.currentText, (UIElementAlignment)this.currentAlignment, (RGB)this.currentColor, (UIElementFontStyle)this.currentFontStyle);
            }
            return BooleanStyle.usingIcon((DBIcon)this.state.getIcon(), (UIElementAlignment)this.currentAlignment);
        }

        public boolean isValid() {
            return this.currentMode == BooleanMode.ICON || !CommonUtils.isEmptyTrimmed((String)this.currentText);
        }

        public void addPropertyChangeListener(@NotNull IPropertyChangeListener listener) {
            this.addListenerObject(listener);
        }

        public void notifyPropertyChanged(@NotNull Object source, @NotNull String property, @Nullable Object value) {
            Object[] listeners = this.getListeners();
            if (listeners.length > 0) {
                PropertyChangeEvent event = new PropertyChangeEvent(source, property, null, value);
                for (Object listener : listeners) {
                    ((IPropertyChangeListener)listener).propertyChange(event);
                }
            }
        }
    }
}

