/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.url;

import java.net.URLStreamHandler;
import java.security.AccessController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.equinox.plurl.PlurlStreamHandlerFactory;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.internal.framework.EquinoxBundle;
import org.eclipse.osgi.internal.framework.EquinoxContainer;
import org.eclipse.osgi.internal.url.URLStreamHandlerProxy;
import org.eclipse.osgi.storage.url.bundleresource.Handler;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public class URLStreamHandlerFactoryImpl
implements PlurlStreamHandlerFactory {
    protected static final String URLSTREAMHANDLERCLASS = "org.osgi.service.url.URLStreamHandlerService";
    public static final String PROTOCOL_REFERENCE = "reference";
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final BundleContext context;
    private final EquinoxContainer container;
    private final Map<String, URLStreamHandlerProxy> proxies;

    public URLStreamHandlerFactoryImpl(BundleContext context, EquinoxContainer container) {
        this.context = context;
        this.container = container;
        this.proxies = new ConcurrentHashMap<String, URLStreamHandlerProxy>();
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        try {
            return this.createInternalURLStreamHandler(protocol);
        }
        catch (Throwable t) {
            this.container.getLogServices().log(URLStreamHandlerFactoryImpl.class.getName(), 4, "Unexpected error in factory.", t);
            return null;
        }
    }

    private URLStreamHandler getFrameworkHandler(String protocol) {
        if ("bundleentry".equals(protocol)) {
            return new org.eclipse.osgi.storage.url.bundleentry.Handler(this.container.getStorage().getModuleContainer(), null);
        }
        if ("bundleresource".equals(protocol)) {
            return new Handler(this.container.getStorage().getModuleContainer(), null);
        }
        if (PROTOCOL_REFERENCE.equals(protocol)) {
            return new org.eclipse.osgi.storage.url.reference.Handler(this.container.getConfiguration().getConfiguration("osgi.install.area"));
        }
        return null;
    }

    private URLStreamHandler createInternalURLStreamHandler(String protocol) {
        URLStreamHandler frameworkHandler = this.getFrameworkHandler(protocol);
        if (frameworkHandler != null) {
            return frameworkHandler;
        }
        URLStreamHandlerProxy handler = this.proxies.computeIfAbsent(protocol, p -> new URLStreamHandlerProxy((String)p, this.context));
        if (handler.isActive()) {
            return handler;
        }
        return null;
    }

    @Override
    public boolean shouldHandle(Class<?> clazz) {
        Bundle b = FrameworkUtil.getBundle(clazz);
        if (!(b instanceof EquinoxBundle)) {
            return false;
        }
        return this.container.getStorage().getModuleContainer() == ((EquinoxBundle)b).getModule().getContainer();
    }
}

