/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.athena.ui.views;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.athena.model.AWSRegion;
import org.jkiss.dbeaver.ext.athena.ui.AthenaActivator;
import org.jkiss.dbeaver.ext.athena.ui.internal.AthenaMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystem;
import org.jkiss.dbeaver.model.navigator.fs.DBNFileSystems;
import org.jkiss.dbeaver.model.navigator.fs.DBNPathBase;
import org.jkiss.dbeaver.registry.fs.FileSystemProviderRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;
import org.jkiss.dbeaver.ui.navigator.dialogs.ObjectBrowserDialogBase;
import org.jkiss.utils.CommonUtils;

public class AthenaConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Combo awsRegionCombo;
    private Text s3LocationText;
    private static final ImageDescriptor logoImage = AthenaActivator.getImageDescriptor("icons/aws_athena_logo.png");
    private final DriverPropertiesDialogPage driverPropsPage = new DriverPropertiesDialogPage((ConnectionPageAbstract)this);
    private Button showCatalogsCheck;

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite composite) {
        this.setImageDescriptor(logoImage);
        Composite settingsGroup = new Composite(composite, 0);
        settingsGroup.setLayout((Layout)new GridLayout(1, false));
        settingsGroup.setLayoutData((Object)new GridData(1808));
        ModifyListener textListener = e -> this.site.updateButtons();
        Composite addrGroup = UIUtils.createTitledComposite((Composite)settingsGroup, (String)AthenaMessages.label_connection, (int)2, (int)768);
        this.awsRegionCombo = UIUtils.createLabelCombo((Composite)addrGroup, (String)AthenaMessages.label_region, (int)4);
        this.awsRegionCombo.addModifyListener(textListener);
        UIUtils.setDefaultTextControlWidthHint((Control)this.awsRegionCombo);
        UIUtils.createControlLabel((Composite)addrGroup, (String)AthenaMessages.label_s3_location);
        Composite s3Group = UIUtils.createComposite((Composite)addrGroup, (int)1);
        s3Group.setLayoutData((Object)new GridData(768));
        this.s3LocationText = new Text(s3Group, 2048);
        this.s3LocationText.setToolTipText(AthenaMessages.label_s3_output_location);
        this.s3LocationText.addModifyListener(textListener);
        this.s3LocationText.setLayoutData((Object)new GridData(768));
        UIUtils.setDefaultTextControlWidthHint((Control)this.s3LocationText);
        if (FileSystemProviderRegistry.getInstance().getProvider("aws-s3") != null) {
            ++((GridLayout)s3Group.getLayout()).numColumns;
            UIUtils.createPushButton((Composite)s3Group, (String)UIConnectionMessages.controls_client_home_selector_browse, (Image)DBeaverIcons.getImage((DBPImage)UIIcon.OPEN), (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    String newS3Path;
                    DBNNode s3Node;
                    List selectedObjects;
                    ObjectBrowserDialogBase dialog;
                    DBNProject projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode((DBPProject)AthenaConnectionPage.this.getSite().getProject());
                    DBNFileSystems fsRootNode = (DBNFileSystems)projectNode.getExtraNode(DBNFileSystems.class);
                    if (fsRootNode == null) {
                        DBWorkbench.getPlatformUI().showMessageBox("Cloud support required", "Project file system node not found", true);
                        return;
                    }
                    DBNNode selectedNode = null;
                    String oldS3Path = AthenaConnectionPage.this.s3LocationText.getText();
                    if (!CommonUtils.isEmpty((String)oldS3Path) && oldS3Path.startsWith("s3:/")) {
                        selectedNode = AthenaConnectionPage.this.findFileSystemNode(fsRootNode, oldS3Path);
                    }
                    if ((dialog = new ObjectBrowserDialogBase(this, AthenaConnectionPage.this.s3LocationText.getShell(), "S3 browser", (DBNNode)fsRootNode, CommonUtils.singletonOrEmpty((Object)selectedNode), true){

                        protected boolean matchesResultNode(DBNNode node) {
                            return node instanceof DBNPathBase && Files.isDirectory(((DBNPathBase)node).getPath(), new LinkOption[0]);
                        }

                        protected ViewerFilter createViewerFilter() {
                            return new ViewerFilter(){

                                public boolean select(Viewer viewer, Object parentElement, Object element) {
                                    return element instanceof TreeNodeSpecial || element instanceof DBNFileSystem || element instanceof DBNNode && this.matchesResultNode((DBNNode)element);
                                }
                            };
                        }
                    }).open() == 0 && (selectedObjects = dialog.getSelectedObjects()).size() == 1 && (s3Node = (DBNNode)selectedObjects.get(0)) instanceof DBNPathBase && (newS3Path = ((DBNPathBase)s3Node).getPath().toString()).startsWith("s3:/")) {
                        try {
                            URI uri = new URI(newS3Path);
                            URI patchedURI = new URI(uri.getScheme(), null, null, 0, uri.getPath(), uri.getQuery(), null);
                            AthenaConnectionPage.this.s3LocationText.setText(patchedURI.toString());
                        }
                        catch (URISyntaxException ex) {
                            DBWorkbench.getPlatformUI().showError("Bad URI", "Bad URI '" + newS3Path + "'", (Throwable)ex);
                        }
                    }
                }
            });
        }
        UIUtils.addVariablesToControl((Control)this.s3LocationText, (String[])this.getAvailableVariables(), (String)"S3 location pattern");
        this.showCatalogsCheck = UIUtils.createCheckbox((Composite)addrGroup, (String)"Show catalogs", (String)"To show multiple data catalogs with Athena (for example, when using an external Hive metastore or federated queries)", (boolean)false, (int)2);
        this.createAuthPanel(settingsGroup, 1);
        this.createDriverPanel(settingsGroup);
        this.setControl((Control)settingsGroup);
    }

    private DBNNode findFileSystemNode(DBNFileSystems fsRootNode, String s3Path) {
        try {
            return (DBNNode)DBWorkbench.getPlatformUI().runWithProgress(monitor -> fsRootNode.findNodeByPath(monitor, s3Path, true));
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Error opening file system", "Error while opening S3 file system", (Throwable)e);
            return null;
        }
    }

    public boolean isComplete() {
        return this.awsRegionCombo != null && !CommonUtils.isEmpty((String)this.awsRegionCombo.getText()) && this.s3LocationText != null && !CommonUtils.isEmpty((String)this.s3LocationText.getText()) && super.isComplete();
    }

    public void loadSettings() {
        super.loadSettings();
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        if (this.awsRegionCombo != null) {
            this.awsRegionCombo.removeAll();
            for (AWSRegion region : AWSRegion.values()) {
                this.awsRegionCombo.add(region.getId());
            }
            if (!CommonUtils.isEmpty((String)connectionInfo.getServerName())) {
                this.awsRegionCombo.setText(connectionInfo.getServerName());
            }
            if (this.awsRegionCombo.getText().isEmpty()) {
                this.awsRegionCombo.setText(AWSRegion.us_west_1.getId());
            }
        }
        if (this.s3LocationText != null) {
            String databaseName = connectionInfo.getDatabaseName();
            if (CommonUtils.isEmpty((String)databaseName) && CommonUtils.isEmpty((String)(databaseName = connectionInfo.getProviderProperty("OutputLocation")))) {
                databaseName = "s3://aws-athena-query-results-";
            }
            this.s3LocationText.setText(databaseName);
        }
        if (this.showCatalogsCheck != null) {
            this.showCatalogsCheck.setSelection(CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("show-aws-catalogs")));
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration connectionInfo = dataSource.getConnectionConfiguration();
        if (this.awsRegionCombo != null) {
            connectionInfo.setServerName(this.awsRegionCombo.getText().trim());
        }
        if (this.s3LocationText != null) {
            connectionInfo.setProviderProperty("OutputLocation", this.s3LocationText.getText().trim());
            connectionInfo.setDatabaseName(this.s3LocationText.getText().trim());
        }
        if (this.showCatalogsCheck != null) {
            connectionInfo.setProviderProperty("show-aws-catalogs", String.valueOf(this.showCatalogsCheck.getSelection()));
        }
        super.saveSettings(dataSource);
    }

    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{this.driverPropsPage};
    }

    @NotNull
    private String[] getAvailableVariables() {
        return (String[])Arrays.stream(DBPConnectionConfiguration.INTERNAL_CONNECT_VARIABLES).map(x -> x[0]).toArray(String[]::new);
    }
}

