//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-cloud-kit")]
use objc2_cloud_kit::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uistatusbarstyle?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIStatusBarStyle(pub NSInteger);
impl UIStatusBarStyle {
    #[doc(alias = "UIStatusBarStyleDefault")]
    pub const Default: Self = Self(0);
    #[doc(alias = "UIStatusBarStyleLightContent")]
    pub const LightContent: Self = Self(1);
    #[doc(alias = "UIStatusBarStyleDarkContent")]
    pub const DarkContent: Self = Self(3);
    #[doc(alias = "UIStatusBarStyleBlackTranslucent")]
    #[deprecated]
    pub const BlackTranslucent: Self = Self(1);
    #[doc(alias = "UIStatusBarStyleBlackOpaque")]
    #[deprecated]
    pub const BlackOpaque: Self = Self(2);
}

unsafe impl Encode for UIStatusBarStyle {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIStatusBarStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uistatusbaranimation?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIStatusBarAnimation(pub NSInteger);
impl UIStatusBarAnimation {
    #[doc(alias = "UIStatusBarAnimationNone")]
    pub const None: Self = Self(0);
    #[doc(alias = "UIStatusBarAnimationFade")]
    pub const Fade: Self = Self(1);
    #[doc(alias = "UIStatusBarAnimationSlide")]
    pub const Slide: Self = Self(2);
}

unsafe impl Encode for UIStatusBarAnimation {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIStatusBarAnimation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationinvalidinterfaceorientationexception?language=objc)
    pub static UIApplicationInvalidInterfaceOrientationException: &'static NSExceptionName;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiremotenotificationtype?language=objc)
// NS_OPTIONS
#[deprecated = "Use UserNotifications Framework's UNAuthorizationOptions for user notifications and registerForRemoteNotifications for receiving remote notifications instead."]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIRemoteNotificationType(pub NSUInteger);
bitflags::bitflags! {
    impl UIRemoteNotificationType: NSUInteger {
        #[doc(alias = "UIRemoteNotificationTypeNone")]
#[deprecated = "Use UserNotifications Framework's UNAuthorizationOptions for user notifications and registerForRemoteNotifications for receiving remote notifications instead."]
        const None = 0;
        #[doc(alias = "UIRemoteNotificationTypeBadge")]
#[deprecated = "Use UserNotifications Framework's UNAuthorizationOptions for user notifications and registerForRemoteNotifications for receiving remote notifications instead."]
        const Badge = 1<<0;
        #[doc(alias = "UIRemoteNotificationTypeSound")]
#[deprecated = "Use UserNotifications Framework's UNAuthorizationOptions for user notifications and registerForRemoteNotifications for receiving remote notifications instead."]
        const Sound = 1<<1;
        #[doc(alias = "UIRemoteNotificationTypeAlert")]
#[deprecated = "Use UserNotifications Framework's UNAuthorizationOptions for user notifications and registerForRemoteNotifications for receiving remote notifications instead."]
        const Alert = 1<<2;
        #[doc(alias = "UIRemoteNotificationTypeNewsstandContentAvailability")]
#[deprecated = "Use UserNotifications Framework's UNAuthorizationOptions for user notifications and registerForRemoteNotifications for receiving remote notifications instead."]
        const NewsstandContentAvailability = 1<<3;
    }
}

unsafe impl Encode for UIRemoteNotificationType {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIRemoteNotificationType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uibackgroundfetchresult?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIBackgroundFetchResult(pub NSUInteger);
impl UIBackgroundFetchResult {
    #[doc(alias = "UIBackgroundFetchResultNewData")]
    pub const NewData: Self = Self(0);
    #[doc(alias = "UIBackgroundFetchResultNoData")]
    pub const NoData: Self = Self(1);
    #[doc(alias = "UIBackgroundFetchResultFailed")]
    pub const Failed: Self = Self(2);
}

unsafe impl Encode for UIBackgroundFetchResult {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for UIBackgroundFetchResult {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uibackgroundrefreshstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIBackgroundRefreshStatus(pub NSInteger);
impl UIBackgroundRefreshStatus {
    #[doc(alias = "UIBackgroundRefreshStatusRestricted")]
    pub const Restricted: Self = Self(0);
    #[doc(alias = "UIBackgroundRefreshStatusDenied")]
    pub const Denied: Self = Self(1);
    #[doc(alias = "UIBackgroundRefreshStatusAvailable")]
    pub const Available: Self = Self(2);
}

unsafe impl Encode for UIBackgroundRefreshStatus {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIBackgroundRefreshStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationstate?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIApplicationState(pub NSInteger);
impl UIApplicationState {
    #[doc(alias = "UIApplicationStateActive")]
    pub const Active: Self = Self(0);
    #[doc(alias = "UIApplicationStateInactive")]
    pub const Inactive: Self = Self(1);
    #[doc(alias = "UIApplicationStateBackground")]
    pub const Background: Self = Self(2);
}

unsafe impl Encode for UIApplicationState {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIApplicationState {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uibackgroundtaskidentifier?language=objc)
// NS_TYPED_ENUM
pub type UIBackgroundTaskIdentifier = NSUInteger;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uibackgroundtaskinvalid?language=objc)
    pub static UIBackgroundTaskInvalid: UIBackgroundTaskIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiminimumkeepalivetimeout?language=objc)
    #[deprecated = "Please use PushKit for VoIP applications."]
    pub static UIMinimumKeepAliveTimeout: NSTimeInterval;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationbackgroundfetchintervalminimum?language=objc)
    pub static UIApplicationBackgroundFetchIntervalMinimum: NSTimeInterval;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationbackgroundfetchintervalnever?language=objc)
    pub static UIApplicationBackgroundFetchIntervalNever: NSTimeInterval;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopenexternalurloptionskey?language=objc)
// NS_TYPED_ENUM
pub type UIApplicationOpenExternalURLOptionsKey = NSString;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplication?language=objc)
    #[unsafe(super(UIResponder, NSObject))]
    #[thread_kind = MainThreadOnly]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "UIResponder")]
    pub struct UIApplication;
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl NSObjectProtocol for UIApplication {}
);

#[cfg(feature = "UIResponder")]
extern_conformance!(
    unsafe impl UIResponderStandardEditActions for UIApplication {}
);

#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[unsafe(method(sharedApplication))]
        #[unsafe(method_family = none)]
        pub fn sharedApplication(mtm: MainThreadMarker) -> Retained<UIApplication>;

        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(
            &self,
        ) -> Option<Retained<ProtocolObject<dyn UIApplicationDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// # Safety
        ///
        /// This is unretained, you must ensure the object is kept alive while in use.
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(
            &self,
            delegate: Option<&ProtocolObject<dyn UIApplicationDelegate>>,
        );

        #[deprecated = "Use UIView's userInteractionEnabled property instead"]
        #[unsafe(method(beginIgnoringInteractionEvents))]
        #[unsafe(method_family = none)]
        pub fn beginIgnoringInteractionEvents(&self);

        #[deprecated = "Use UIView's userInteractionEnabled property instead"]
        #[unsafe(method(endIgnoringInteractionEvents))]
        #[unsafe(method_family = none)]
        pub fn endIgnoringInteractionEvents(&self);

        #[deprecated = "Use UIView's userInteractionEnabled property instead"]
        #[unsafe(method(isIgnoringInteractionEvents))]
        #[unsafe(method_family = none)]
        pub fn isIgnoringInteractionEvents(&self) -> bool;

        #[unsafe(method(isIdleTimerDisabled))]
        #[unsafe(method_family = none)]
        pub fn isIdleTimerDisabled(&self) -> bool;

        /// Setter for [`isIdleTimerDisabled`][Self::isIdleTimerDisabled].
        #[unsafe(method(setIdleTimerDisabled:))]
        #[unsafe(method_family = none)]
        pub fn setIdleTimerDisabled(&self, idle_timer_disabled: bool);

        #[deprecated]
        #[unsafe(method(openURL:))]
        #[unsafe(method_family = none)]
        pub fn openURL(&self, url: &NSURL) -> bool;

        #[unsafe(method(canOpenURL:))]
        #[unsafe(method_family = none)]
        pub fn canOpenURL(&self, url: &NSURL) -> bool;

        #[cfg(feature = "block2")]
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[unsafe(method(openURL:options:completionHandler:))]
        #[unsafe(method_family = none)]
        pub unsafe fn openURL_options_completionHandler(
            &self,
            url: &NSURL,
            options: &NSDictionary<UIApplicationOpenExternalURLOptionsKey, AnyObject>,
            completion: Option<&block2::DynBlock<dyn Fn(Bool)>>,
        );

        #[cfg(feature = "UIEvent")]
        #[unsafe(method(sendEvent:))]
        #[unsafe(method_family = none)]
        pub fn sendEvent(&self, event: &UIEvent);

        #[cfg(all(feature = "UIView", feature = "UIWindow"))]
        #[deprecated = "Should not be used for applications that support multiple scenes as it returns a key window across all connected scenes"]
        #[unsafe(method(keyWindow))]
        #[unsafe(method_family = none)]
        pub fn keyWindow(&self) -> Option<Retained<UIWindow>>;

        #[cfg(all(feature = "UIView", feature = "UIWindow"))]
        #[deprecated = "Use UIWindowScene.windows on a relevant window scene instead"]
        #[unsafe(method(windows))]
        #[unsafe(method_family = none)]
        pub fn windows(&self) -> Retained<NSArray<UIWindow>>;

        #[cfg(feature = "UIEvent")]
        /// # Safety
        ///
        /// - `action` must be a valid selector.
        /// - `target` should be of the correct type.
        /// - `sender` should be of the correct type.
        #[unsafe(method(sendAction:to:from:forEvent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn sendAction_to_from_forEvent(
            &self,
            action: Sel,
            target: Option<&AnyObject>,
            sender: Option<&AnyObject>,
            event: Option<&UIEvent>,
        ) -> bool;

        #[deprecated = "Provide a custom network activity UI in your app if desired."]
        #[unsafe(method(isNetworkActivityIndicatorVisible))]
        #[unsafe(method_family = none)]
        pub fn isNetworkActivityIndicatorVisible(&self) -> bool;

        /// Setter for [`isNetworkActivityIndicatorVisible`][Self::isNetworkActivityIndicatorVisible].
        #[deprecated = "Provide a custom network activity UI in your app if desired."]
        #[unsafe(method(setNetworkActivityIndicatorVisible:))]
        #[unsafe(method_family = none)]
        pub fn setNetworkActivityIndicatorVisible(&self, network_activity_indicator_visible: bool);

        #[cfg(all(feature = "UIOrientation", feature = "UIView", feature = "UIWindow"))]
        #[unsafe(method(supportedInterfaceOrientationsForWindow:))]
        #[unsafe(method_family = none)]
        pub fn supportedInterfaceOrientationsForWindow(
            &self,
            window: Option<&UIWindow>,
        ) -> UIInterfaceOrientationMask;

        #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
        #[unsafe(method(statusBarOrientationAnimationDuration))]
        #[unsafe(method_family = none)]
        pub fn statusBarOrientationAnimationDuration(&self) -> NSTimeInterval;

        #[cfg(feature = "objc2-core-foundation")]
        #[deprecated = "Use the statusBarManager property of the window scene instead."]
        #[unsafe(method(statusBarFrame))]
        #[unsafe(method_family = none)]
        pub fn statusBarFrame(&self) -> CGRect;

        #[deprecated = "Use -[UNUserNotificationCenter setBadgeCount:withCompletionHandler:] instead."]
        #[unsafe(method(applicationIconBadgeNumber))]
        #[unsafe(method_family = none)]
        pub fn applicationIconBadgeNumber(&self) -> NSInteger;

        /// Setter for [`applicationIconBadgeNumber`][Self::applicationIconBadgeNumber].
        #[deprecated = "Use -[UNUserNotificationCenter setBadgeCount:withCompletionHandler:] instead."]
        #[unsafe(method(setApplicationIconBadgeNumber:))]
        #[unsafe(method_family = none)]
        pub fn setApplicationIconBadgeNumber(&self, application_icon_badge_number: NSInteger);

        #[unsafe(method(applicationSupportsShakeToEdit))]
        #[unsafe(method_family = none)]
        pub fn applicationSupportsShakeToEdit(&self) -> bool;

        /// Setter for [`applicationSupportsShakeToEdit`][Self::applicationSupportsShakeToEdit].
        #[unsafe(method(setApplicationSupportsShakeToEdit:))]
        #[unsafe(method_family = none)]
        pub fn setApplicationSupportsShakeToEdit(&self, application_supports_shake_to_edit: bool);

        #[unsafe(method(applicationState))]
        #[unsafe(method_family = none)]
        pub fn applicationState(&self) -> UIApplicationState;

        #[unsafe(method(backgroundTimeRemaining))]
        #[unsafe(method_family = none)]
        pub fn backgroundTimeRemaining(&self) -> NSTimeInterval;

        #[cfg(feature = "block2")]
        #[unsafe(method(beginBackgroundTaskWithExpirationHandler:))]
        #[unsafe(method_family = none)]
        pub fn beginBackgroundTaskWithExpirationHandler(
            &self,
            handler: Option<&block2::DynBlock<dyn Fn()>>,
        ) -> UIBackgroundTaskIdentifier;

        #[cfg(feature = "block2")]
        #[unsafe(method(beginBackgroundTaskWithName:expirationHandler:))]
        #[unsafe(method_family = none)]
        pub fn beginBackgroundTaskWithName_expirationHandler(
            &self,
            task_name: Option<&NSString>,
            handler: Option<&block2::DynBlock<dyn Fn()>>,
        ) -> UIBackgroundTaskIdentifier;

        #[unsafe(method(endBackgroundTask:))]
        #[unsafe(method_family = none)]
        pub fn endBackgroundTask(&self, identifier: UIBackgroundTaskIdentifier);

        /// The system guarantees that it will not wake up your application for a background fetch more
        /// frequently than the interval provided. Set to UIApplicationBackgroundFetchIntervalMinimum to be
        /// woken as frequently as the system desires, or to UIApplicationBackgroundFetchIntervalNever (the
        /// default) to never be woken for a background fetch.
        ///
        /// This setter will have no effect unless your application has the "fetch"
        /// UIBackgroundMode. See the UIApplicationDelegate method
        /// `application:performFetchWithCompletionHandler:` for more.
        #[deprecated = "Use a BGAppRefreshTask in the BackgroundTasks framework instead"]
        #[unsafe(method(setMinimumBackgroundFetchInterval:))]
        #[unsafe(method_family = none)]
        pub fn setMinimumBackgroundFetchInterval(
            &self,
            minimum_background_fetch_interval: NSTimeInterval,
        );

        /// When background refresh is available for an application, it may launched or resumed in the background to handle significant
        /// location changes, remote notifications, background fetches, etc. Observe UIApplicationBackgroundRefreshStatusDidChangeNotification to
        /// be notified of changes.
        #[unsafe(method(backgroundRefreshStatus))]
        #[unsafe(method_family = none)]
        pub fn backgroundRefreshStatus(&self) -> UIBackgroundRefreshStatus;

        #[unsafe(method(isProtectedDataAvailable))]
        #[unsafe(method_family = none)]
        pub fn isProtectedDataAvailable(&self) -> bool;

        #[cfg(feature = "UIInterface")]
        #[unsafe(method(userInterfaceLayoutDirection))]
        #[unsafe(method_family = none)]
        pub fn userInterfaceLayoutDirection(&self) -> UIUserInterfaceLayoutDirection;

        #[cfg(feature = "UIContentSizeCategory")]
        #[unsafe(method(preferredContentSizeCategory))]
        #[unsafe(method_family = none)]
        pub fn preferredContentSizeCategory(&self) -> Retained<UIContentSizeCategory>;

        #[cfg(feature = "UIScene")]
        #[unsafe(method(connectedScenes))]
        #[unsafe(method_family = none)]
        pub fn connectedScenes(&self) -> Retained<NSSet<UIScene>>;

        #[cfg(feature = "UISceneSession")]
        #[unsafe(method(openSessions))]
        #[unsafe(method_family = none)]
        pub fn openSessions(&self) -> Retained<NSSet<UISceneSession>>;

        #[unsafe(method(supportsMultipleScenes))]
        #[unsafe(method_family = none)]
        pub fn supportsMultipleScenes(&self) -> bool;

        #[cfg(all(feature = "UISceneSessionActivationRequest", feature = "block2"))]
        /// Asks the system to activate an existing scene, or create a new scene and associate it with your app.
        /// - Parameters:
        /// - request: The activation request.
        /// - errorHandler: A handler to be called if the request fails.
        #[unsafe(method(activateSceneSessionForRequest:errorHandler:))]
        #[unsafe(method_family = none)]
        pub fn activateSceneSessionForRequest_errorHandler(
            &self,
            request: &UISceneSessionActivationRequest,
            error_handler: Option<&block2::DynBlock<dyn Fn(NonNull<NSError>)>>,
        );

        #[cfg(all(
            feature = "UISceneOptions",
            feature = "UISceneSession",
            feature = "block2"
        ))]
        #[deprecated = "Please use activateSceneSessionForRequest:errorHandler:"]
        #[unsafe(method(requestSceneSessionActivation:userActivity:options:errorHandler:))]
        #[unsafe(method_family = none)]
        pub fn requestSceneSessionActivation_userActivity_options_errorHandler(
            &self,
            scene_session: Option<&UISceneSession>,
            user_activity: Option<&NSUserActivity>,
            options: Option<&UISceneActivationRequestOptions>,
            error_handler: Option<&block2::DynBlock<dyn Fn(NonNull<NSError>)>>,
        );

        #[cfg(all(
            feature = "UISceneOptions",
            feature = "UISceneSession",
            feature = "block2"
        ))]
        #[unsafe(method(requestSceneSessionDestruction:options:errorHandler:))]
        #[unsafe(method_family = none)]
        pub fn requestSceneSessionDestruction_options_errorHandler(
            &self,
            scene_session: &UISceneSession,
            options: Option<&UISceneDestructionRequestOptions>,
            error_handler: Option<&block2::DynBlock<dyn Fn(NonNull<NSError>)>>,
        );

        #[cfg(feature = "UISceneSession")]
        #[unsafe(method(requestSceneSessionRefresh:))]
        #[unsafe(method_family = none)]
        pub fn requestSceneSessionRefresh(&self, scene_session: &UISceneSession);
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// UIRemoteNotifications.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[unsafe(method(registerForRemoteNotifications))]
        #[unsafe(method_family = none)]
        pub fn registerForRemoteNotifications(&self);

        #[unsafe(method(unregisterForRemoteNotifications))]
        #[unsafe(method_family = none)]
        pub fn unregisterForRemoteNotifications(&self);

        #[unsafe(method(isRegisteredForRemoteNotifications))]
        #[unsafe(method_family = none)]
        pub fn isRegisteredForRemoteNotifications(&self) -> bool;

        #[deprecated = "Use -[UIApplication registerForRemoteNotifications] and UserNotifications Framework's -[UNUserNotificationCenter requestAuthorizationWithOptions:completionHandler:]"]
        #[unsafe(method(registerForRemoteNotificationTypes:))]
        #[unsafe(method_family = none)]
        pub fn registerForRemoteNotificationTypes(&self, types: UIRemoteNotificationType);

        #[deprecated = "Use -[UIApplication isRegisteredForRemoteNotifications] and UserNotifications Framework's -[UNUserNotificationCenter getNotificationSettingsWithCompletionHandler:] to retrieve user-enabled remote notification and user notification settings"]
        #[unsafe(method(enabledRemoteNotificationTypes))]
        #[unsafe(method_family = none)]
        pub fn enabledRemoteNotificationTypes(&self) -> UIRemoteNotificationType;
    );
}

/// UILocalNotifications.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[cfg(feature = "UILocalNotification")]
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenter addNotificationRequest:withCompletionHandler:]"]
        #[unsafe(method(presentLocalNotificationNow:))]
        #[unsafe(method_family = none)]
        pub fn presentLocalNotificationNow(&self, notification: &UILocalNotification);

        #[cfg(feature = "UILocalNotification")]
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenter addNotificationRequest:withCompletionHandler:]"]
        #[unsafe(method(scheduleLocalNotification:))]
        #[unsafe(method_family = none)]
        pub fn scheduleLocalNotification(&self, notification: &UILocalNotification);

        #[cfg(feature = "UILocalNotification")]
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenter removePendingNotificationRequestsWithIdentifiers:]"]
        #[unsafe(method(cancelLocalNotification:))]
        #[unsafe(method_family = none)]
        pub fn cancelLocalNotification(&self, notification: &UILocalNotification);

        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenter removeAllPendingNotificationRequests]"]
        #[unsafe(method(cancelAllLocalNotifications))]
        #[unsafe(method_family = none)]
        pub fn cancelAllLocalNotifications(&self);

        #[cfg(feature = "UILocalNotification")]
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenter getPendingNotificationRequestsWithCompletionHandler:]"]
        #[unsafe(method(scheduledLocalNotifications))]
        #[unsafe(method_family = none)]
        pub fn scheduledLocalNotifications(&self)
            -> Option<Retained<NSArray<UILocalNotification>>>;

        #[cfg(feature = "UILocalNotification")]
        /// Setter for [`scheduledLocalNotifications`][Self::scheduledLocalNotifications].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenter getPendingNotificationRequestsWithCompletionHandler:]"]
        #[unsafe(method(setScheduledLocalNotifications:))]
        #[unsafe(method_family = none)]
        pub fn setScheduledLocalNotifications(
            &self,
            scheduled_local_notifications: Option<&NSArray<UILocalNotification>>,
        );
    );
}

/// UIUserNotificationSettings.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[cfg(feature = "UIUserNotificationSettings")]
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenter requestAuthorizationWithOptions:completionHandler:] and -[UNUserNotificationCenter setNotificationCategories:]"]
        #[unsafe(method(registerUserNotificationSettings:))]
        #[unsafe(method_family = none)]
        pub fn registerUserNotificationSettings(
            &self,
            notification_settings: &UIUserNotificationSettings,
        );

        #[cfg(feature = "UIUserNotificationSettings")]
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenter getNotificationSettingsWithCompletionHandler:] and -[UNUserNotificationCenter getNotificationCategoriesWithCompletionHandler:]"]
        #[unsafe(method(currentUserNotificationSettings))]
        #[unsafe(method_family = none)]
        pub fn currentUserNotificationSettings(
            &self,
        ) -> Option<Retained<UIUserNotificationSettings>>;
    );
}

/// UIRemoteControlEvents.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[unsafe(method(beginReceivingRemoteControlEvents))]
        #[unsafe(method_family = none)]
        pub fn beginReceivingRemoteControlEvents(&self);

        #[unsafe(method(endReceivingRemoteControlEvents))]
        #[unsafe(method_family = none)]
        pub fn endReceivingRemoteControlEvents(&self);
    );
}

/// UINewsstand.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[cfg(feature = "UIImage")]
        #[deprecated = "Newsstand apps now behave like normal apps on SpringBoard"]
        #[unsafe(method(setNewsstandIconImage:))]
        #[unsafe(method_family = none)]
        pub fn setNewsstandIconImage(&self, image: Option<&UIImage>);
    );
}

/// UIShortcutItems.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[cfg(feature = "UIApplicationShortcutItem")]
        #[unsafe(method(shortcutItems))]
        #[unsafe(method_family = none)]
        pub fn shortcutItems(&self) -> Option<Retained<NSArray<UIApplicationShortcutItem>>>;

        #[cfg(feature = "UIApplicationShortcutItem")]
        /// Setter for [`shortcutItems`][Self::shortcutItems].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setShortcutItems:))]
        #[unsafe(method_family = none)]
        pub fn setShortcutItems(&self, shortcut_items: Option<&NSArray<UIApplicationShortcutItem>>);
    );
}

/// UIAlternateApplicationIcons.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[unsafe(method(supportsAlternateIcons))]
        #[unsafe(method_family = none)]
        pub fn supportsAlternateIcons(&self) -> bool;

        #[cfg(feature = "block2")]
        #[unsafe(method(setAlternateIconName:completionHandler:))]
        #[unsafe(method_family = none)]
        pub fn setAlternateIconName_completionHandler(
            &self,
            alternate_icon_name: Option<&NSString>,
            completion_handler: Option<&block2::DynBlock<dyn Fn(*mut NSError)>>,
        );

        #[unsafe(method(alternateIconName))]
        #[unsafe(method_family = none)]
        pub fn alternateIconName(&self) -> Option<Retained<NSString>>;
    );
}

/// UIStateRestoration.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[unsafe(method(extendStateRestoration))]
        #[unsafe(method_family = none)]
        pub unsafe fn extendStateRestoration(&self);

        #[unsafe(method(completeStateRestoration))]
        #[unsafe(method_family = none)]
        pub unsafe fn completeStateRestoration(&self);

        #[unsafe(method(ignoreSnapshotOnNextApplicationLaunch))]
        #[unsafe(method_family = none)]
        pub fn ignoreSnapshotOnNextApplicationLaunch(&self);

        #[cfg(feature = "UIStateRestoration")]
        #[unsafe(method(registerObjectForStateRestoration:restorationIdentifier:))]
        #[unsafe(method_family = none)]
        pub fn registerObjectForStateRestoration_restorationIdentifier(
            object: &ProtocolObject<dyn UIStateRestoring>,
            restoration_identifier: &NSString,
        );
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationcategory?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIApplicationCategory(pub NSInteger);
impl UIApplicationCategory {
    #[doc(alias = "UIApplicationCategoryWebBrowser")]
    pub const WebBrowser: Self = Self(1);
}

unsafe impl Encode for UIApplicationCategory {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIApplicationCategory {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// The default status of an application for some category.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationcategorydefaultstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIApplicationCategoryDefaultStatus(pub NSInteger);
impl UIApplicationCategoryDefaultStatus {
    /// The status was not available. This is an error condition and the returned error object has more information.
    #[doc(alias = "UIApplicationCategoryDefaultStatusUnavailable")]
    pub const Unavailable: Self = Self(0);
    /// The application is the default for the category.
    #[doc(alias = "UIApplicationCategoryDefaultStatusIsDefault")]
    pub const IsDefault: Self = Self(1);
    /// The application is not the default for the category.
    #[doc(alias = "UIApplicationCategoryDefaultStatusNotDefault")]
    pub const NotDefault: Self = Self(2);
}

unsafe impl Encode for UIApplicationCategoryDefaultStatus {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIApplicationCategoryDefaultStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationcategorydefaulterrordomain?language=objc)
    pub static UIApplicationCategoryDefaultErrorDomain: &'static NSErrorDomain;
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationcategorydefaulterrorcode?language=objc)
// NS_ERROR_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct UIApplicationCategoryDefaultErrorCode(pub NSInteger);
impl UIApplicationCategoryDefaultErrorCode {
    /// The application is rate-limited.
    #[doc(alias = "UIApplicationCategoryDefaultErrorRateLimited")]
    pub const RateLimited: Self = Self(1);
}

unsafe impl Encode for UIApplicationCategoryDefaultErrorCode {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for UIApplicationCategoryDefaultErrorCode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// Supplied in userInfo when the application is rate-limited: the last date on which data was
    /// retrieved.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationcategorydefaultstatuslastprovideddateerrorkey?language=objc)
    pub static UIApplicationCategoryDefaultStatusLastProvidedDateErrorKey:
        &'static NSErrorUserInfoKey;
}

extern "C" {
    /// Supplied in userInfo when the application is rate-limited: the date after which the app will no
    /// longer be rate-limited
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationcategorydefaultretryavailabilitydateerrorkey?language=objc)
    pub static UIApplicationCategoryDefaultRetryAvailabilityDateErrorKey:
        &'static NSErrorUserInfoKey;
}

/// DefaultApplication.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!();
}

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionskey?language=objc)
// NS_TYPED_ENUM
pub type UIApplicationLaunchOptionsKey = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopenurloptionskey?language=objc)
#[deprecated = "Use UIScene lifecycle and equivalent properties on UISceneOpenURLOptions from a UIOpenURLContext in UIScene.ConnectionOptions.URLContexts instead."]
// NS_TYPED_ENUM
pub type UIApplicationOpenURLOptionsKey = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationextensionpointidentifier?language=objc)
// NS_TYPED_ENUM
pub type UIApplicationExtensionPointIdentifier = NSString;

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationdelegate?language=objc)
    pub unsafe trait UIApplicationDelegate: NSObjectProtocol + MainThreadOnly {
        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(applicationDidFinishLaunching:))]
        #[unsafe(method_family = none)]
        fn applicationDidFinishLaunching(&self, application: &UIApplication);

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `launch_options` generic should be of the correct type.
        #[optional]
        #[unsafe(method(application:willFinishLaunchingWithOptions:))]
        #[unsafe(method_family = none)]
        unsafe fn application_willFinishLaunchingWithOptions(
            &self,
            application: &UIApplication,
            launch_options: Option<&NSDictionary<UIApplicationLaunchOptionsKey, AnyObject>>,
        ) -> bool;

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `launch_options` generic should be of the correct type.
        #[optional]
        #[unsafe(method(application:didFinishLaunchingWithOptions:))]
        #[unsafe(method_family = none)]
        unsafe fn application_didFinishLaunchingWithOptions(
            &self,
            application: &UIApplication,
            launch_options: Option<&NSDictionary<UIApplicationLaunchOptionsKey, AnyObject>>,
        ) -> bool;

        #[cfg(feature = "UIResponder")]
        /// Tells the delegate that the application has become active
        /// - Note: This method is not called if `UIScene` lifecycle has been adopted.
        #[deprecated = "Use UIScene lifecycle and sceneDidBecomeActive(_:) from UISceneDelegate or the UIApplication.didBecomeActiveNotification instead."]
        #[optional]
        #[unsafe(method(applicationDidBecomeActive:))]
        #[unsafe(method_family = none)]
        fn applicationDidBecomeActive(&self, application: &UIApplication);

        #[cfg(feature = "UIResponder")]
        /// Tells the delegate that the application is about to become inactive
        /// - Note: This method is not called if `UIScene` lifecycle has been adopted.
        #[deprecated = "Use UIScene lifecycle and sceneWillResignActive(_:) from UISceneDelegate or the UIApplication.willResignActiveNotification instead."]
        #[optional]
        #[unsafe(method(applicationWillResignActive:))]
        #[unsafe(method_family = none)]
        fn applicationWillResignActive(&self, application: &UIApplication);

        #[cfg(feature = "UIResponder")]
        /// Tells the delegate that the application is now in the background
        /// - Note: This method is not called if `UIScene` lifecycle has been adopted.
        #[deprecated = "Use UIScene lifecycle and sceneDidEnterBackground(_:) from UISceneDelegate or the UIApplication.didEnterBackgroundNotification instead."]
        #[optional]
        #[unsafe(method(applicationDidEnterBackground:))]
        #[unsafe(method_family = none)]
        fn applicationDidEnterBackground(&self, application: &UIApplication);

        #[cfg(feature = "UIResponder")]
        /// Tells the delegate that the application is about to enter the foreground
        /// - Note: This method is not called if `UIScene` lifecycle has been adopted.
        #[deprecated = "Use UIScene lifecycle and sceneWillEnterForeground(_:) from UISceneDelegate or the UIApplication.willEnterForegroundNotification instead."]
        #[optional]
        #[unsafe(method(applicationWillEnterForeground:))]
        #[unsafe(method_family = none)]
        fn applicationWillEnterForeground(&self, application: &UIApplication);

        #[cfg(feature = "UIResponder")]
        #[deprecated]
        #[optional]
        #[unsafe(method(application:handleOpenURL:))]
        #[unsafe(method_family = none)]
        fn application_handleOpenURL(&self, application: &UIApplication, url: &NSURL) -> bool;

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `annotation` should be of the correct type.
        #[deprecated]
        #[optional]
        #[unsafe(method(application:openURL:sourceApplication:annotation:))]
        #[unsafe(method_family = none)]
        unsafe fn application_openURL_sourceApplication_annotation(
            &self,
            application: &UIApplication,
            url: &NSURL,
            source_application: Option<&NSString>,
            annotation: &AnyObject,
        ) -> bool;

        #[cfg(feature = "UIResponder")]
        /// Return NO if the application can't open the `url` for some reason
        ///
        /// # Safety
        ///
        /// `options` generic should be of the correct type.
        #[deprecated = "Use UIScene lifecycle and scene(_:openURLContexts:) from UISceneDelegate instead."]
        #[optional]
        #[unsafe(method(application:openURL:options:))]
        #[unsafe(method_family = none)]
        unsafe fn application_openURL_options(
            &self,
            app: &UIApplication,
            url: &NSURL,
            options: &NSDictionary<UIApplicationOpenURLOptionsKey, AnyObject>,
        ) -> bool;

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(applicationDidReceiveMemoryWarning:))]
        #[unsafe(method_family = none)]
        fn applicationDidReceiveMemoryWarning(&self, application: &UIApplication);

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(applicationWillTerminate:))]
        #[unsafe(method_family = none)]
        fn applicationWillTerminate(&self, application: &UIApplication);

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(applicationSignificantTimeChange:))]
        #[unsafe(method_family = none)]
        fn applicationSignificantTimeChange(&self, application: &UIApplication);

        #[cfg(all(feature = "UIOrientation", feature = "UIResponder"))]
        #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
        #[optional]
        #[unsafe(method(application:willChangeStatusBarOrientation:duration:))]
        #[unsafe(method_family = none)]
        fn application_willChangeStatusBarOrientation_duration(
            &self,
            application: &UIApplication,
            new_status_bar_orientation: UIInterfaceOrientation,
            duration: NSTimeInterval,
        );

        #[cfg(all(feature = "UIOrientation", feature = "UIResponder"))]
        #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
        #[optional]
        #[unsafe(method(application:didChangeStatusBarOrientation:))]
        #[unsafe(method_family = none)]
        fn application_didChangeStatusBarOrientation(
            &self,
            application: &UIApplication,
            old_status_bar_orientation: UIInterfaceOrientation,
        );

        #[cfg(all(feature = "UIResponder", feature = "objc2-core-foundation"))]
        #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
        #[optional]
        #[unsafe(method(application:willChangeStatusBarFrame:))]
        #[unsafe(method_family = none)]
        fn application_willChangeStatusBarFrame(
            &self,
            application: &UIApplication,
            new_status_bar_frame: CGRect,
        );

        #[cfg(all(feature = "UIResponder", feature = "objc2-core-foundation"))]
        #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
        #[optional]
        #[unsafe(method(application:didChangeStatusBarFrame:))]
        #[unsafe(method_family = none)]
        fn application_didChangeStatusBarFrame(
            &self,
            application: &UIApplication,
            old_status_bar_frame: CGRect,
        );

        #[cfg(all(feature = "UIResponder", feature = "UIUserNotificationSettings"))]
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenter requestAuthorizationWithOptions:completionHandler:]"]
        #[optional]
        #[unsafe(method(application:didRegisterUserNotificationSettings:))]
        #[unsafe(method_family = none)]
        fn application_didRegisterUserNotificationSettings(
            &self,
            application: &UIApplication,
            notification_settings: &UIUserNotificationSettings,
        );

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(application:didRegisterForRemoteNotificationsWithDeviceToken:))]
        #[unsafe(method_family = none)]
        fn application_didRegisterForRemoteNotificationsWithDeviceToken(
            &self,
            application: &UIApplication,
            device_token: &NSData,
        );

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(application:didFailToRegisterForRemoteNotificationsWithError:))]
        #[unsafe(method_family = none)]
        fn application_didFailToRegisterForRemoteNotificationsWithError(
            &self,
            application: &UIApplication,
            error: &NSError,
        );

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `user_info` generic should be of the correct type.
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenterDelegate willPresentNotification:withCompletionHandler:] or -[UNUserNotificationCenterDelegate didReceiveNotificationResponse:withCompletionHandler:] for user visible notifications and -[UIApplicationDelegate application:didReceiveRemoteNotification:fetchCompletionHandler:] for silent remote notifications"]
        #[optional]
        #[unsafe(method(application:didReceiveRemoteNotification:))]
        #[unsafe(method_family = none)]
        unsafe fn application_didReceiveRemoteNotification(
            &self,
            application: &UIApplication,
            user_info: &NSDictionary,
        );

        #[cfg(all(feature = "UILocalNotification", feature = "UIResponder"))]
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenterDelegate willPresentNotification:withCompletionHandler:] or -[UNUserNotificationCenterDelegate didReceiveNotificationResponse:withCompletionHandler:]"]
        #[optional]
        #[unsafe(method(application:didReceiveLocalNotification:))]
        #[unsafe(method_family = none)]
        fn application_didReceiveLocalNotification(
            &self,
            application: &UIApplication,
            notification: &UILocalNotification,
        );

        #[cfg(all(
            feature = "UILocalNotification",
            feature = "UIResponder",
            feature = "block2"
        ))]
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenterDelegate didReceiveNotificationResponse:withCompletionHandler:]"]
        #[optional]
        #[unsafe(method(application:handleActionWithIdentifier:forLocalNotification:completionHandler:))]
        #[unsafe(method_family = none)]
        fn application_handleActionWithIdentifier_forLocalNotification_completionHandler(
            &self,
            application: &UIApplication,
            identifier: Option<&NSString>,
            notification: &UILocalNotification,
            completion_handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(all(feature = "UIResponder", feature = "block2"))]
        /// # Safety
        ///
        /// - `user_info` generic should be of the correct type.
        /// - `response_info` generic should be of the correct type.
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenterDelegate didReceiveNotificationResponse:withCompletionHandler:]"]
        #[optional]
        #[unsafe(method(application:handleActionWithIdentifier:forRemoteNotification:withResponseInfo:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn application_handleActionWithIdentifier_forRemoteNotification_withResponseInfo_completionHandler(
            &self,
            application: &UIApplication,
            identifier: Option<&NSString>,
            user_info: &NSDictionary,
            response_info: &NSDictionary,
            completion_handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(all(feature = "UIResponder", feature = "block2"))]
        /// # Safety
        ///
        /// `user_info` generic should be of the correct type.
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenterDelegate didReceiveNotificationResponse:withCompletionHandler:]"]
        #[optional]
        #[unsafe(method(application:handleActionWithIdentifier:forRemoteNotification:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn application_handleActionWithIdentifier_forRemoteNotification_completionHandler(
            &self,
            application: &UIApplication,
            identifier: Option<&NSString>,
            user_info: &NSDictionary,
            completion_handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(all(
            feature = "UILocalNotification",
            feature = "UIResponder",
            feature = "block2"
        ))]
        /// # Safety
        ///
        /// `response_info` generic should be of the correct type.
        #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenterDelegate didReceiveNotificationResponse:withCompletionHandler:]"]
        #[optional]
        #[unsafe(method(application:handleActionWithIdentifier:forLocalNotification:withResponseInfo:completionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn application_handleActionWithIdentifier_forLocalNotification_withResponseInfo_completionHandler(
            &self,
            application: &UIApplication,
            identifier: Option<&NSString>,
            notification: &UILocalNotification,
            response_info: &NSDictionary,
            completion_handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(all(feature = "UIResponder", feature = "block2"))]
        /// This delegate method offers an opportunity for applications with the "remote-notification" background mode to fetch appropriate new data in response to an incoming remote notification. You should call the fetchCompletionHandler as soon as you're finished performing that operation, so the system can accurately estimate its power and data cost.
        ///
        /// This method will be invoked even if the application was launched or resumed because of the remote notification. The respective delegate methods will be invoked first. Note that this behavior is in contrast to application:didReceiveRemoteNotification:, which is not called in those cases, and which will not be invoked if this method is implemented. !
        ///
        /// # Safety
        ///
        /// `user_info` generic should be of the correct type.
        #[optional]
        #[unsafe(method(application:didReceiveRemoteNotification:fetchCompletionHandler:))]
        #[unsafe(method_family = none)]
        unsafe fn application_didReceiveRemoteNotification_fetchCompletionHandler(
            &self,
            application: &UIApplication,
            user_info: &NSDictionary,
            completion_handler: &block2::DynBlock<dyn Fn(UIBackgroundFetchResult)>,
        );

        #[cfg(all(feature = "UIResponder", feature = "block2"))]
        /// Applications with the "fetch" background mode may be given opportunities to fetch updated content in the background or when it is convenient for the system. This method will be called in these situations. You should call the fetchCompletionHandler as soon as you're finished performing that operation, so the system can accurately estimate its power and data cost.
        #[deprecated = "Use a BGAppRefreshTask in the BackgroundTasks framework instead"]
        #[optional]
        #[unsafe(method(application:performFetchWithCompletionHandler:))]
        #[unsafe(method_family = none)]
        fn application_performFetchWithCompletionHandler(
            &self,
            application: &UIApplication,
            completion_handler: &block2::DynBlock<dyn Fn(UIBackgroundFetchResult)>,
        );

        #[cfg(all(
            feature = "UIApplicationShortcutItem",
            feature = "UIResponder",
            feature = "block2"
        ))]
        /// Called when the user activates your application by selecting a shortcut on the home screen, except when `application(_:willFinishLaunchingWithOptions:)`
        /// or `application(_:didFinishLaunchingWithOptions:)` returns `false`.
        #[deprecated = "Use UIScene lifecycle and windowScene(_:performActionFor:completionHandler:) from UIWindowSceneDelegate instead."]
        #[optional]
        #[unsafe(method(application:performActionForShortcutItem:completionHandler:))]
        #[unsafe(method_family = none)]
        fn application_performActionForShortcutItem_completionHandler(
            &self,
            application: &UIApplication,
            shortcut_item: &UIApplicationShortcutItem,
            completion_handler: &block2::DynBlock<dyn Fn(Bool)>,
        );

        #[cfg(all(feature = "UIResponder", feature = "block2"))]
        #[optional]
        #[unsafe(method(application:handleEventsForBackgroundURLSession:completionHandler:))]
        #[unsafe(method_family = none)]
        fn application_handleEventsForBackgroundURLSession_completionHandler(
            &self,
            application: &UIApplication,
            identifier: &NSString,
            completion_handler: &block2::DynBlock<dyn Fn()>,
        );

        #[cfg(all(feature = "UIResponder", feature = "block2"))]
        /// # Safety
        ///
        /// `user_info` generic should be of the correct type.
        #[optional]
        #[unsafe(method(application:handleWatchKitExtensionRequest:reply:))]
        #[unsafe(method_family = none)]
        unsafe fn application_handleWatchKitExtensionRequest_reply(
            &self,
            application: &UIApplication,
            user_info: Option<&NSDictionary>,
            reply: &block2::DynBlock<dyn Fn(*mut NSDictionary)>,
        );

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(applicationShouldRequestHealthAuthorization:))]
        #[unsafe(method_family = none)]
        fn applicationShouldRequestHealthAuthorization(&self, application: &UIApplication);

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(applicationProtectedDataWillBecomeUnavailable:))]
        #[unsafe(method_family = none)]
        fn applicationProtectedDataWillBecomeUnavailable(&self, application: &UIApplication);

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(applicationProtectedDataDidBecomeAvailable:))]
        #[unsafe(method_family = none)]
        fn applicationProtectedDataDidBecomeAvailable(&self, application: &UIApplication);

        #[cfg(all(feature = "UIResponder", feature = "UIView", feature = "UIWindow"))]
        #[optional]
        #[unsafe(method(window))]
        #[unsafe(method_family = none)]
        fn window(&self) -> Option<Retained<UIWindow>>;

        #[cfg(all(feature = "UIResponder", feature = "UIView", feature = "UIWindow"))]
        /// Setter for [`window`][Self::window].
        #[optional]
        #[unsafe(method(setWindow:))]
        #[unsafe(method_family = none)]
        fn setWindow(&self, window: Option<&UIWindow>);

        #[cfg(all(
            feature = "UIOrientation",
            feature = "UIResponder",
            feature = "UIView",
            feature = "UIWindow"
        ))]
        #[optional]
        #[unsafe(method(application:supportedInterfaceOrientationsForWindow:))]
        #[unsafe(method_family = none)]
        fn application_supportedInterfaceOrientationsForWindow(
            &self,
            application: &UIApplication,
            window: Option<&UIWindow>,
        ) -> UIInterfaceOrientationMask;

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(application:shouldAllowExtensionPointIdentifier:))]
        #[unsafe(method_family = none)]
        fn application_shouldAllowExtensionPointIdentifier(
            &self,
            application: &UIApplication,
            extension_point_identifier: &UIApplicationExtensionPointIdentifier,
        ) -> bool;

        #[cfg(all(feature = "UIResponder", feature = "UIViewController"))]
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[optional]
        #[unsafe(method(application:viewControllerWithRestorationIdentifierPath:coder:))]
        #[unsafe(method_family = none)]
        unsafe fn application_viewControllerWithRestorationIdentifierPath_coder(
            &self,
            application: &UIApplication,
            identifier_components: &NSArray<NSString>,
            coder: &NSCoder,
        ) -> Option<Retained<UIViewController>>;

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[optional]
        #[unsafe(method(application:shouldSaveSecureApplicationState:))]
        #[unsafe(method_family = none)]
        unsafe fn application_shouldSaveSecureApplicationState(
            &self,
            application: &UIApplication,
            coder: &NSCoder,
        ) -> bool;

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[optional]
        #[unsafe(method(application:shouldRestoreSecureApplicationState:))]
        #[unsafe(method_family = none)]
        unsafe fn application_shouldRestoreSecureApplicationState(
            &self,
            application: &UIApplication,
            coder: &NSCoder,
        ) -> bool;

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[optional]
        #[unsafe(method(application:willEncodeRestorableStateWithCoder:))]
        #[unsafe(method_family = none)]
        unsafe fn application_willEncodeRestorableStateWithCoder(
            &self,
            application: &UIApplication,
            coder: &NSCoder,
        );

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[optional]
        #[unsafe(method(application:didDecodeRestorableStateWithCoder:))]
        #[unsafe(method_family = none)]
        unsafe fn application_didDecodeRestorableStateWithCoder(
            &self,
            application: &UIApplication,
            coder: &NSCoder,
        );

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[deprecated = "Use application:shouldSaveSecureApplicationState: instead"]
        #[optional]
        #[unsafe(method(application:shouldSaveApplicationState:))]
        #[unsafe(method_family = none)]
        unsafe fn application_shouldSaveApplicationState(
            &self,
            application: &UIApplication,
            coder: &NSCoder,
        ) -> bool;

        #[cfg(feature = "UIResponder")]
        /// # Safety
        ///
        /// `coder` possibly has further requirements.
        #[deprecated = "Use application:shouldRestoreSecureApplicationState: instead"]
        #[optional]
        #[unsafe(method(application:shouldRestoreApplicationState:))]
        #[unsafe(method_family = none)]
        unsafe fn application_shouldRestoreApplicationState(
            &self,
            application: &UIApplication,
            coder: &NSCoder,
        ) -> bool;

        #[cfg(feature = "UIResponder")]
        /// Called on the main thread as soon as the user indicates they want to continue an activity in your application. The ``NSUserActivity`` object may not be available
        /// instantly, so use this as an opportunity to show the user that an activity will be continued shortly.
        ///
        /// For each `application(_:willContinueUserActivityWithType:)` invocation, you are guaranteed to get exactly one invocation of `application(_:continue:restorationHandler:)`
        /// on success, or `application(_:didFailToContinueUserActivityWithType:error:)` if an error was encountered.
        #[deprecated = "Use UIScene lifecycle and scene(_:willContinueUserActivityWithType:) from UISceneDelegate instead."]
        #[optional]
        #[unsafe(method(application:willContinueUserActivityWithType:))]
        #[unsafe(method_family = none)]
        fn application_willContinueUserActivityWithType(
            &self,
            application: &UIApplication,
            user_activity_type: &NSString,
        ) -> bool;

        #[cfg(all(
            feature = "UIResponder",
            feature = "UIUserActivity",
            feature = "block2"
        ))]
        /// Called on the main thread after the ``NSUserActivity`` object is available. Use the data you stored in the ``NSUserActivity`` object to re-create what the user
        /// was doing. You can create/fetch any restorable objects associated with the user activity, and pass them to the `restorationHandler`. They will then have the
        /// `UIResponder` `restoreUserActivityState:` method invoked with the user activity. Invoking the `restorationHandler` is optional. It may be copied and
        /// invoked later, and it will bounce to the main thread to complete its work and call `restoreUserActivityState` on all objects.
        #[deprecated = "Use UIScene lifecycle and scene(_:continue:) from UISceneDelegate instead."]
        #[optional]
        #[unsafe(method(application:continueUserActivity:restorationHandler:))]
        #[unsafe(method_family = none)]
        fn application_continueUserActivity_restorationHandler(
            &self,
            application: &UIApplication,
            user_activity: &NSUserActivity,
            restoration_handler: &block2::DynBlock<
                dyn Fn(*mut NSArray<ProtocolObject<dyn UIUserActivityRestoring>>),
            >,
        ) -> bool;

        #[cfg(feature = "UIResponder")]
        /// If the user activity cannot be fetched after `application(_:willContinueUserActivityWithType:)` is called, this will be called on the main thread when implemented.
        #[deprecated = "Use UIScene lifecycle and scene(_:didFailToContinueUserActivityWithType:error:) from UISceneDelegate instead."]
        #[optional]
        #[unsafe(method(application:didFailToContinueUserActivityWithType:error:))]
        #[unsafe(method_family = none)]
        fn application_didFailToContinueUserActivityWithType_error(
            &self,
            application: &UIApplication,
            user_activity_type: &NSString,
            error: &NSError,
        );

        #[cfg(feature = "UIResponder")]
        /// This is called on the main thread when a user activity managed by UIKit has been updated. You can use this as a last chance to add additional data to the userActivity.
        #[deprecated = "Use UIScene lifecycle and scene(_:didUpdate) from UISceneDelegate instead."]
        #[optional]
        #[unsafe(method(application:didUpdateUserActivity:))]
        #[unsafe(method_family = none)]
        fn application_didUpdateUserActivity(
            &self,
            application: &UIApplication,
            user_activity: &NSUserActivity,
        );

        #[cfg(all(feature = "UIResponder", feature = "objc2-cloud-kit"))]
        /// This will be called on the main thread after the user indicates they want to accept a CloudKit sharing invitation in your application.
        /// You should use the `CKShareMetadata` object's `shareURL` and `containerIdentifier` to schedule a `CKAcceptSharesOperation`, then start using
        /// the resulting `CKShare` and its associated record(s), which will appear in the `CKContainer`'s shared database in a zone matching that of the record's owner.
        #[deprecated = "Use UIScene lifecycle and windowScene(_:userDidAcceptCloudKitShareWith:) from UIWindowSceneDelegate instead."]
        #[optional]
        #[unsafe(method(application:userDidAcceptCloudKitShareWithMetadata:))]
        #[unsafe(method_family = none)]
        fn application_userDidAcceptCloudKitShareWithMetadata(
            &self,
            application: &UIApplication,
            cloud_kit_share_metadata: &CKShareMetadata,
        );

        #[cfg(all(
            feature = "UIResponder",
            feature = "UISceneConfiguration",
            feature = "UISceneOptions",
            feature = "UISceneSession"
        ))]
        #[optional]
        #[unsafe(method(application:configurationForConnectingSceneSession:options:))]
        #[unsafe(method_family = none)]
        fn application_configurationForConnectingSceneSession_options(
            &self,
            application: &UIApplication,
            connecting_scene_session: &UISceneSession,
            options: &UISceneConnectionOptions,
        ) -> Retained<UISceneConfiguration>;

        #[cfg(all(feature = "UIResponder", feature = "UISceneSession"))]
        #[optional]
        #[unsafe(method(application:didDiscardSceneSessions:))]
        #[unsafe(method_family = none)]
        fn application_didDiscardSceneSessions(
            &self,
            application: &UIApplication,
            scene_sessions: &NSSet<UISceneSession>,
        );

        #[cfg(feature = "UIResponder")]
        #[optional]
        #[unsafe(method(applicationShouldAutomaticallyLocalizeKeyCommands:))]
        #[unsafe(method_family = none)]
        fn applicationShouldAutomaticallyLocalizeKeyCommands(
            &self,
            application: &UIApplication,
        ) -> bool;
    }
);

/// UIApplicationDeprecated.
#[cfg(feature = "UIResponder")]
impl UIApplication {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(isProximitySensingEnabled))]
        #[unsafe(method_family = none)]
        pub fn isProximitySensingEnabled(&self) -> bool;

        /// Setter for [`isProximitySensingEnabled`][Self::isProximitySensingEnabled].
        #[deprecated]
        #[unsafe(method(setProximitySensingEnabled:))]
        #[unsafe(method_family = none)]
        pub fn setProximitySensingEnabled(&self, proximity_sensing_enabled: bool);

        #[deprecated = "Use -[UIViewController prefersStatusBarHidden]"]
        #[unsafe(method(setStatusBarHidden:animated:))]
        #[unsafe(method_family = none)]
        pub fn setStatusBarHidden_animated(&self, hidden: bool, animated: bool);

        #[cfg(feature = "UIOrientation")]
        /// Setter for [`statusBarOrientation`][Self::statusBarOrientation].
        #[deprecated = "Explicit setting of the status bar orientation is more limited in iOS 6.0 and later"]
        #[unsafe(method(setStatusBarOrientation:))]
        #[unsafe(method_family = none)]
        pub fn setStatusBarOrientation(&self, status_bar_orientation: UIInterfaceOrientation);

        #[cfg(feature = "UIOrientation")]
        #[deprecated = "Explicit setting of the status bar orientation is more limited in iOS 6.0 and later"]
        #[unsafe(method(setStatusBarOrientation:animated:))]
        #[unsafe(method_family = none)]
        pub fn setStatusBarOrientation_animated(
            &self,
            interface_orientation: UIInterfaceOrientation,
            animated: bool,
        );

        /// Setter for [`statusBarStyle`][Self::statusBarStyle].
        #[deprecated = "Use -[UIViewController preferredStatusBarStyle]"]
        #[unsafe(method(setStatusBarStyle:))]
        #[unsafe(method_family = none)]
        pub fn setStatusBarStyle(&self, status_bar_style: UIStatusBarStyle);

        #[deprecated = "Use -[UIViewController preferredStatusBarStyle]"]
        #[unsafe(method(setStatusBarStyle:animated:))]
        #[unsafe(method_family = none)]
        pub fn setStatusBarStyle_animated(
            &self,
            status_bar_style: UIStatusBarStyle,
            animated: bool,
        );

        /// Setter for [`isStatusBarHidden`][Self::isStatusBarHidden].
        #[deprecated = "Use -[UIViewController prefersStatusBarHidden]"]
        #[unsafe(method(setStatusBarHidden:))]
        #[unsafe(method_family = none)]
        pub fn setStatusBarHidden(&self, status_bar_hidden: bool);

        #[deprecated = "Use -[UIViewController prefersStatusBarHidden]"]
        #[unsafe(method(setStatusBarHidden:withAnimation:))]
        #[unsafe(method_family = none)]
        pub fn setStatusBarHidden_withAnimation(
            &self,
            hidden: bool,
            animation: UIStatusBarAnimation,
        );

        #[cfg(feature = "block2")]
        #[deprecated = "Please use PushKit for VoIP applications instead of calling this method"]
        #[unsafe(method(setKeepAliveTimeout:handler:))]
        #[unsafe(method_family = none)]
        pub fn setKeepAliveTimeout_handler(
            &self,
            timeout: NSTimeInterval,
            keep_alive_handler: Option<&block2::DynBlock<dyn Fn()>>,
        ) -> bool;

        #[deprecated = "Please use PushKit for VoIP applications instead of calling this method"]
        #[unsafe(method(clearKeepAliveTimeout))]
        #[unsafe(method_family = none)]
        pub fn clearKeepAliveTimeout(&self);
    );
}

#[cfg(feature = "UIResponder")]
impl UIApplication {
    /// # Safety
    ///
    /// `argv` must be a valid pointer.
    #[doc(alias = "UIApplicationMain")]
    #[inline]
    pub(crate) unsafe fn __main(
        argc: c_int,
        argv: NonNull<*mut c_char>,
        principal_class_name: Option<&NSString>,
        delegate_class_name: Option<&NSString>,
    ) -> c_int {
        extern "C-unwind" {
            fn UIApplicationMain(
                argc: c_int,
                argv: NonNull<*mut c_char>,
                principal_class_name: Option<&NSString>,
                delegate_class_name: Option<&NSString>,
            ) -> c_int;
        }
        unsafe { UIApplicationMain(argc, argv, principal_class_name, delegate_class_name) }
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uitrackingrunloopmode?language=objc)
    pub static UITrackingRunLoopMode: &'static NSRunLoopMode;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationdidenterbackgroundnotification?language=objc)
    pub static UIApplicationDidEnterBackgroundNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationwillenterforegroundnotification?language=objc)
    pub static UIApplicationWillEnterForegroundNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationdidfinishlaunchingnotification?language=objc)
    pub static UIApplicationDidFinishLaunchingNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationdidbecomeactivenotification?language=objc)
    pub static UIApplicationDidBecomeActiveNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationwillresignactivenotification?language=objc)
    pub static UIApplicationWillResignActiveNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationdidreceivememorywarningnotification?language=objc)
    pub static UIApplicationDidReceiveMemoryWarningNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationwillterminatenotification?language=objc)
    pub static UIApplicationWillTerminateNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationsignificanttimechangenotification?language=objc)
    pub static UIApplicationSignificantTimeChangeNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationwillchangestatusbarorientationnotification?language=objc)
    #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
    pub static UIApplicationWillChangeStatusBarOrientationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationdidchangestatusbarorientationnotification?language=objc)
    #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
    pub static UIApplicationDidChangeStatusBarOrientationNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationstatusbarorientationuserinfokey?language=objc)
    #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
    pub static UIApplicationStatusBarOrientationUserInfoKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationwillchangestatusbarframenotification?language=objc)
    #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
    pub static UIApplicationWillChangeStatusBarFrameNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationdidchangestatusbarframenotification?language=objc)
    #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
    pub static UIApplicationDidChangeStatusBarFrameNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationstatusbarframeuserinfokey?language=objc)
    #[deprecated = "Use viewWillTransitionToSize:withTransitionCoordinator: instead."]
    pub static UIApplicationStatusBarFrameUserInfoKey: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationbackgroundrefreshstatusdidchangenotification?language=objc)
    pub static UIApplicationBackgroundRefreshStatusDidChangeNotification:
        &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationprotecteddatawillbecomeunavailable?language=objc)
    pub static UIApplicationProtectedDataWillBecomeUnavailable: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationprotecteddatadidbecomeavailable?language=objc)
    pub static UIApplicationProtectedDataDidBecomeAvailable: &'static NSNotificationName;
}

extern "C" {
    /// UserInfo contains a ``NSURL`` with launch URL to open
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionsurlkey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UIScene.ConnectionOptions.URLContexts instead."]
    pub static UIApplicationLaunchOptionsURLKey: &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// UserInfo contains a ``NSString`` with the bundle ID of the originating application; non-nil if the originating application and this application share the same team identifier
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionssourceapplicationkey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UIScene.ConnectionOptions.sourceApplication instead."]
    pub static UIApplicationLaunchOptionsSourceApplicationKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// UserInfo contains a ``NSDictionary`` notification payload with property-list objects plus ``NSNull``
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionsremotenotificationkey?language=objc)
    #[deprecated = "Continue using UIApplicationDelegate's application(_:didReceiveRemoteNotification:fetchCompletionHandler:) to process silent remote notifications after scene connection."]
    pub static UIApplicationLaunchOptionsRemoteNotificationKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// UserInfo contains a ``UILocalNotification``
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionslocalnotificationkey?language=objc)
    #[deprecated = "Use UserNotifications Framework's -[UNUserNotificationCenterDelegate didReceiveNotificationResponse:withCompletionHandler:]"]
    pub static UIApplicationLaunchOptionsLocalNotificationKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// UserInfo contains a property list annotation object
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionsannotationkey?language=objc)
    #[deprecated = "This dictionary key is no longer used."]
    pub static UIApplicationLaunchOptionsAnnotationKey: &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// The app was launched in response to a CoreLocation event
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionslocationkey?language=objc)
    #[deprecated = "Adopt CLLocationUpdate or CLMonitor, or use CLLocationManagerDelegate from CoreLocation to handle expected location events after scene connection."]
    pub static UIApplicationLaunchOptionsLocationKey: &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// UserInfo contains an ``NSArray`` of ``NKAssetDownload`` identifiers
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionsnewsstanddownloadskey?language=objc)
    #[deprecated = "This dictionary key is no longer used."]
    pub static UIApplicationLaunchOptionsNewsstandDownloadsKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// UserInfo contains an ``NSArray`` of ``CBCentralManager`` restore identifiers
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionsbluetoothcentralskey?language=objc)
    #[deprecated = "Store restoration identifiers and reinstantiate central managers with those identifiers on app launch to resume previous functionality."]
    pub static UIApplicationLaunchOptionsBluetoothCentralsKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// UserInfo contains an ``NSArray`` of ``CBPeripheralManager`` restore identifiers
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionsbluetoothperipheralskey?language=objc)
    #[deprecated = "Store restoration identifiers and reinstantiate peripheral managers with those identifiers on app launch to resume previous functionality."]
    pub static UIApplicationLaunchOptionsBluetoothPeripheralsKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// UserInfo contains the ``UIApplicationShortcutItem`` used to launch the app
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionsshortcutitemkey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UIScene.ConnectionOptions.shortcutItem instead."]
    pub static UIApplicationLaunchOptionsShortcutItemKey: &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// UserInfo contains a ``UIEventAttribution`` to go along with a URL open on launch
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionseventattributionkey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UIScene.ConnectionOptions.eventAttribution instead."]
    pub static UIApplicationLaunchOptionsEventAttributionKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// Key in options dictionary passed to `application(_:willFinishLaunchingWithOptions:)` and `application(_:didFinishLaunchingWithOptions:)`
    /// and info for `UIApplication.didFinishLaunchingNotification`. Sub-Dictionary present in launch options when user activity is present.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionsuseractivitydictionarykey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UIScene.ConnectionOptions.userActivities instead."]
    pub static UIApplicationLaunchOptionsUserActivityDictionaryKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// Key in user activity dictionary for the activity type
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionsuseractivitytypekey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UIScene.ConnectionOptions.handoffUserActivityType instead."]
    pub static UIApplicationLaunchOptionsUserActivityTypeKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// The presence of this key indicates that the app was launched in order to handle a CloudKit sharing invitation. The value of this key is a ``CKShareMetadata`` object.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationlaunchoptionscloudkitsharemetadatakey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UIScene.ConnectionOptions.cloudKitShareMetadata instead."]
    pub static UIApplicationLaunchOptionsCloudKitShareMetadataKey:
        &'static UIApplicationLaunchOptionsKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopensettingsurlstring?language=objc)
    pub static UIApplicationOpenSettingsURLString: &'static NSString;
}

extern "C" {
    /// The URL string you use to deep link to settings for default app selection in the Settings app.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopendefaultapplicationssettingsurlstring?language=objc)
    pub static UIApplicationOpenDefaultApplicationsSettingsURLString: &'static NSString;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopennotificationsettingsurlstring?language=objc)
    pub static UIApplicationOpenNotificationSettingsURLString: &'static NSString;
}

extern "C" {
    /// An options key for `application(_:open:options:)`. The value is an ``NSString`` containing the bundle ID of the originating application; non-nil if the originating
    /// application and this application share the same team identifier.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopenurloptionssourceapplicationkey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UISceneOpenURLOptions.sourceApplication from a UIOpenURLContext in UIScene.ConnectionOptions.URLContexts instead."]
    pub static UIApplicationOpenURLOptionsSourceApplicationKey:
        &'static UIApplicationOpenURLOptionsKey;
}

extern "C" {
    /// An options key for `application(_:open:options:)`. The value is a property-list typed object corresponding to what the originating application passed in
    /// `UIDocumentInteractionController`'s annotation property.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopenurloptionsannotationkey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UISceneOpenURLOptions.annotation from a UIOpenURLContext in UIScene.ConnectionOptions.URLContexts instead."]
    pub static UIApplicationOpenURLOptionsAnnotationKey: &'static UIApplicationOpenURLOptionsKey;
}

extern "C" {
    /// An options key for `application(_:open:options:)`. The value is a bool `NSNumber`. Copy the file before use if this value is NO, or is not present.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopenurloptionsopeninplacekey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UISceneOpenURLOptions.openInPlace from a UIOpenURLContext in UIScene.ConnectionOptions.URLContexts instead."]
    pub static UIApplicationOpenURLOptionsOpenInPlaceKey: &'static UIApplicationOpenURLOptionsKey;
}

extern "C" {
    /// An options key for `application(_:open:options:)`. The value is a `UIEventAttribution` to go along with the URL to open.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopenurloptionseventattributionkey?language=objc)
    #[deprecated = "Use UIScene lifecycle and UISceneOpenURLOptions.eventAttribution from a UIOpenURLContext in UIScene.ConnectionOptions.URLContexts instead."]
    pub static UIApplicationOpenURLOptionsEventAttributionKey:
        &'static UIApplicationOpenURLOptionsKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationuserdidtakescreenshotnotification?language=objc)
    pub static UIApplicationUserDidTakeScreenshotNotification: &'static NSNotificationName;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationkeyboardextensionpointidentifier?language=objc)
    pub static UIApplicationKeyboardExtensionPointIdentifier:
        &'static UIApplicationExtensionPointIdentifier;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopenurloptionuniversallinksonly?language=objc)
    pub static UIApplicationOpenURLOptionUniversalLinksOnly:
        &'static UIApplicationOpenExternalURLOptionsKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/uikit/uiapplicationopenexternalurloptionseventattributionkey?language=objc)
    pub static UIApplicationOpenExternalURLOptionsEventAttributionKey:
        &'static UIApplicationOpenExternalURLOptionsKey;
}

extern "C-unwind" {
    #[deprecated = "renamed to `UIApplication::__main`"]
    pub fn UIApplicationMain(
        argc: c_int,
        argv: NonNull<*mut c_char>,
        principal_class_name: Option<&NSString>,
        delegate_class_name: Option<&NSString>,
    ) -> c_int;
}
