/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4j.jsonrpc.services;

import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.lsp4j.jsonrpc.services.JsonDelegate;
import org.eclipse.lsp4j.jsonrpc.services.JsonNotification;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;

public final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static void findDelegateSegments(Class<?> clazz, Set<Class<?>> visited, Consumer<Method> acceptor) {
        if (clazz == null || !visited.add(clazz)) {
            return;
        }
        AnnotationUtil.findDelegateSegments(clazz.getSuperclass(), visited, acceptor);
        for (Class<?> clazz2 : clazz.getInterfaces()) {
            AnnotationUtil.findDelegateSegments(clazz2, visited, acceptor);
        }
        for (GenericDeclaration genericDeclaration : clazz.getDeclaredMethods()) {
            if (!AnnotationUtil.isDelegateMethod((Method)genericDeclaration)) continue;
            acceptor.accept((Method)genericDeclaration);
        }
    }

    public static boolean isDelegateMethod(Method method) {
        JsonDelegate jsonDelegate;
        if (!method.isSynthetic() && (jsonDelegate = method.getAnnotation(JsonDelegate.class)) != null) {
            if (method.getParameterCount() != 0 || !method.getReturnType().isInterface()) {
                throw new IllegalStateException("The method " + method.toString() + " is not a proper @JsonDelegate method.");
            }
            return true;
        }
        return false;
    }

    public static void findRpcMethods(Class<?> clazz, Set<Class<?>> visited, Consumer<MethodInfo> acceptor) {
        if (clazz == null || !visited.add(clazz)) {
            return;
        }
        AnnotationUtil.findRpcMethods(clazz.getSuperclass(), visited, acceptor);
        for (Class<?> interf : clazz.getInterfaces()) {
            AnnotationUtil.findRpcMethods(interf, visited, acceptor);
        }
        String segment = AnnotationUtil.getSegment(clazz);
        for (Method method : clazz.getDeclaredMethods()) {
            MethodInfo methodInfo = AnnotationUtil.createMethodInfo(method, segment);
            if (methodInfo == null) continue;
            acceptor.accept(methodInfo);
        }
    }

    protected static String getSegment(Class<?> clazz) {
        JsonSegment jsonSegment = clazz.getAnnotation(JsonSegment.class);
        return jsonSegment == null ? "" : jsonSegment.value() + "/";
    }

    protected static MethodInfo createMethodInfo(Method method, String segment) {
        if (!method.isSynthetic()) {
            JsonRequest jsonRequest = method.getAnnotation(JsonRequest.class);
            if (jsonRequest != null) {
                return AnnotationUtil.createRequestInfo(method, segment, jsonRequest);
            }
            JsonNotification jsonNotification = method.getAnnotation(JsonNotification.class);
            if (jsonNotification != null) {
                return AnnotationUtil.createNotificationInfo(method, segment, jsonNotification);
            }
        }
        return null;
    }

    protected static MethodInfo createNotificationInfo(Method method, String segment, JsonNotification jsonNotification) {
        MethodInfo methodInfo = AnnotationUtil.createMethodInfo(method, jsonNotification.useSegment(), segment, jsonNotification.value());
        methodInfo.isNotification = true;
        return methodInfo;
    }

    protected static MethodInfo createRequestInfo(Method method, String segment, JsonRequest jsonRequest) {
        return AnnotationUtil.createMethodInfo(method, jsonRequest.useSegment(), segment, jsonRequest.value());
    }

    protected static MethodInfo createMethodInfo(Method method, boolean useSegment, String segment, String value) {
        method.setAccessible(true);
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.method = method;
        methodInfo.parameterTypes = AnnotationUtil.getParameterTypes(method);
        methodInfo.name = AnnotationUtil.getMethodName(method, useSegment, segment, value);
        return methodInfo;
    }

    protected static String getMethodName(Method method, boolean useSegment, String segment, String value) {
        String name = value != null && value.length() > 0 ? value : method.getName();
        return useSegment ? segment + name : name;
    }

    protected static Type[] getParameterTypes(Method method) {
        return (Type[])Arrays.stream(method.getParameters()).map(Parameter::getParameterizedType).toArray(Type[]::new);
    }

    static class DelegateInfo {
        public Method method;
        public Object delegate;

        DelegateInfo() {
        }
    }

    static class MethodInfo {
        private static Type[] EMPTY_TYPE_ARRAY = new Type[0];
        public String name;
        public Method method;
        public Type[] parameterTypes = EMPTY_TYPE_ARRAY;
        public boolean isNotification = false;

        MethodInfo() {
        }
    }
}

