/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.rule.runtime.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.RuleProvider;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.util.ActionBuilder;
import org.openhab.core.automation.util.RuleBuilder;
import org.openhab.core.automation.util.TriggerBuilder;
import org.openhab.core.common.registry.Provider;
import org.openhab.core.common.registry.ProviderChangeListener;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.model.core.EventType;
import org.openhab.core.model.core.ModelRepository;
import org.openhab.core.model.core.ModelRepositoryChangeListener;
import org.openhab.core.model.rule.rules.ChangedEventTrigger;
import org.openhab.core.model.rule.rules.CommandEventTrigger;
import org.openhab.core.model.rule.rules.DateTimeTrigger;
import org.openhab.core.model.rule.rules.EventEmittedTrigger;
import org.openhab.core.model.rule.rules.EventTrigger;
import org.openhab.core.model.rule.rules.GroupMemberChangedEventTrigger;
import org.openhab.core.model.rule.rules.GroupMemberCommandEventTrigger;
import org.openhab.core.model.rule.rules.GroupMemberUpdateEventTrigger;
import org.openhab.core.model.rule.rules.Rule;
import org.openhab.core.model.rule.rules.RuleModel;
import org.openhab.core.model.rule.rules.SystemOnShutdownTrigger;
import org.openhab.core.model.rule.rules.SystemOnStartupTrigger;
import org.openhab.core.model.rule.rules.SystemStartlevelTrigger;
import org.openhab.core.model.rule.rules.ThingStateChangedEventTrigger;
import org.openhab.core.model.rule.rules.ThingStateUpdateEventTrigger;
import org.openhab.core.model.rule.rules.TimerTrigger;
import org.openhab.core.model.rule.rules.UpdateEventTrigger;
import org.openhab.core.model.rule.runtime.internal.RuleContextHelper;
import org.openhab.core.model.script.runtime.DSLScriptContextProvider;
import org.openhab.core.model.script.script.Script;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyMarkerFilter;
import org.openhab.core.service.ReadyService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={DSLRuleProvider.class, RuleProvider.class, DSLScriptContextProvider.class})
public class DSLRuleProvider
implements RuleProvider,
ModelRepositoryChangeListener,
DSLScriptContextProvider,
ReadyService.ReadyTracker {
    static final String MIMETYPE_OPENHAB_DSL_RULE = "application/vnd.openhab.dsl.rule";
    private final Logger logger = LoggerFactory.getLogger(DSLRuleProvider.class);
    private final Collection<ProviderChangeListener<org.openhab.core.automation.Rule>> listeners = new ArrayList<ProviderChangeListener<org.openhab.core.automation.Rule>>();
    private final Map<String, org.openhab.core.automation.Rule> rules = new ConcurrentHashMap<String, org.openhab.core.automation.Rule>();
    private final Map<String, IEvaluationContext> contexts = new ConcurrentHashMap<String, IEvaluationContext>();
    private final Map<String, XExpression> xExpressions = new ConcurrentHashMap<String, XExpression>();
    private final ReadyMarker marker = new ReadyMarker("rules", "dslprovider");
    private int triggerId = 0;
    private final ModelRepository modelRepository;
    private final ReadyService readyService;

    @Activate
    public DSLRuleProvider(@Reference ModelRepository modelRepository, @Reference ReadyService readyService) {
        this.modelRepository = modelRepository;
        this.readyService = readyService;
    }

    @Activate
    protected void activate() {
        this.readyService.registerTracker((ReadyService.ReadyTracker)this, new ReadyMarkerFilter().withType("rules").withIdentifier("refresh"));
    }

    @Deactivate
    protected void deactivate() {
        this.modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.rules.clear();
        this.contexts.clear();
        this.xExpressions.clear();
    }

    public void addProviderChangeListener(ProviderChangeListener<org.openhab.core.automation.Rule> listener) {
        this.listeners.add(listener);
    }

    public Collection<org.openhab.core.automation.Rule> getAll() {
        return this.rules.values();
    }

    public void removeProviderChangeListener(ProviderChangeListener<org.openhab.core.automation.Rule> listener) {
        this.listeners.remove(listener);
    }

    public void modelChanged(String modelFileName, EventType type) {
        String ruleModelType = modelFileName.substring(modelFileName.lastIndexOf(".") + 1);
        if ("rules".equalsIgnoreCase(ruleModelType)) {
            String ruleModelName = modelFileName.substring(0, modelFileName.lastIndexOf("."));
            ArrayList<ModelRulePair> modelRules = new ArrayList<ModelRulePair>();
            switch (type) {
                case ADDED: {
                    EObject model = this.modelRepository.getModel(modelFileName);
                    if (!(model instanceof RuleModel)) break;
                    RuleModel ruleModel = (RuleModel)model;
                    int index = 1;
                    for (Rule rule : ruleModel.getRules()) {
                        org.openhab.core.automation.Rule newRule = this.toRule(ruleModelName, rule, index);
                        this.rules.put(newRule.getUID(), newRule);
                        this.xExpressions.put(ruleModelName + "-" + index, (XExpression)rule.getScript());
                        modelRules.add(new ModelRulePair(newRule, null));
                        ++index;
                    }
                    this.handleVarDeclarations(ruleModelName, ruleModel);
                    break;
                }
                case MODIFIED: {
                    this.removeRuleModel(ruleModelName);
                    EObject modifiedModel = this.modelRepository.getModel(modelFileName);
                    if (!(modifiedModel instanceof RuleModel)) break;
                    RuleModel ruleModel = (RuleModel)modifiedModel;
                    int index = 1;
                    for (Rule rule : ruleModel.getRules()) {
                        org.openhab.core.automation.Rule newRule = this.toRule(ruleModelName, rule, index);
                        org.openhab.core.automation.Rule oldRule = this.rules.remove(ruleModelName);
                        this.rules.put(newRule.getUID(), newRule);
                        this.xExpressions.put(ruleModelName + "-" + index, (XExpression)rule.getScript());
                        modelRules.add(new ModelRulePair(newRule, oldRule));
                        ++index;
                    }
                    this.handleVarDeclarations(ruleModelName, ruleModel);
                    break;
                }
                case REMOVED: {
                    this.removeRuleModel(ruleModelName);
                    break;
                }
                default: {
                    this.logger.debug("Unknown event type.");
                }
            }
            this.notifyProviderChangeListeners(modelRules);
        } else if ("script".equals(ruleModelType)) {
            ArrayList<ModelRulePair> modelRules = new ArrayList<ModelRulePair>();
            switch (type) {
                case ADDED: 
                case MODIFIED: {
                    EObject model = this.modelRepository.getModel(modelFileName);
                    if (!(model instanceof Script)) break;
                    Script script = (Script)model;
                    org.openhab.core.automation.Rule oldRule = this.rules.remove(modelFileName);
                    org.openhab.core.automation.Rule newRule = this.toRule(modelFileName, script);
                    this.rules.put(newRule.getUID(), newRule);
                    modelRules.add(new ModelRulePair(newRule, oldRule));
                    break;
                }
                case REMOVED: {
                    org.openhab.core.automation.Rule oldRule = this.rules.remove(modelFileName);
                    if (oldRule == null) break;
                    this.listeners.forEach(listener -> listener.removed((Provider)this, (Object)oldRule));
                    break;
                }
                default: {
                    this.logger.debug("Unknown event type.");
                }
            }
            this.notifyProviderChangeListeners(modelRules);
        }
    }

    public @Nullable IEvaluationContext getContext(String contextName) {
        return this.contexts.get(contextName);
    }

    public @Nullable XExpression getParsedScript(String modelName, String index) {
        return this.xExpressions.get(modelName + "-" + index);
    }

    private void handleVarDeclarations(String modelName, RuleModel ruleModel) {
        IEvaluationContext context = RuleContextHelper.getContext(ruleModel);
        this.contexts.put(modelName, context);
    }

    private void removeRuleModel(String modelName) {
        Iterator<Map.Entry<String, org.openhab.core.automation.Rule>> it = this.rules.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, org.openhab.core.automation.Rule> entry = it.next();
            if (!this.belongsToModel(entry.getKey(), modelName)) continue;
            this.listeners.forEach(listener -> listener.removed((Provider)this, (Object)((org.openhab.core.automation.Rule)entry.getValue())));
            it.remove();
        }
        Iterator<Map.Entry<String, XExpression>> it2 = this.xExpressions.entrySet().iterator();
        while (it2.hasNext()) {
            Map.Entry<String, XExpression> entry = it2.next();
            if (!this.belongsToModel(entry.getKey(), modelName)) continue;
            it2.remove();
        }
        this.contexts.remove(modelName);
    }

    private boolean belongsToModel(String id, String modelName) {
        int idx = id.lastIndexOf("-");
        if (idx >= 0) {
            String prefix = id.substring(0, idx);
            return prefix.equals(modelName);
        }
        return false;
    }

    private org.openhab.core.automation.Rule toRule(String modelName, Script script) {
        String scriptText = NodeModelUtils.findActualNodeFor((EObject)script).getText();
        Configuration cfg = new Configuration();
        cfg.put("script", (Object)this.removeIndentation(scriptText));
        cfg.put("type", (Object)MIMETYPE_OPENHAB_DSL_RULE);
        List<Action> actions = List.of(((ActionBuilder)((ActionBuilder)((ActionBuilder)ActionBuilder.create().withId("script")).withTypeUID("script.ScriptAction")).withConfiguration(cfg)).build());
        return RuleBuilder.create((String)modelName).withTags(new String[]{"Script"}).withName(modelName).withActions(actions).build();
    }

    private org.openhab.core.automation.Rule toRule(String modelName, Rule rule, int index) {
        String name = rule.getName();
        String uid = modelName + "-" + index;
        this.triggerId = 0;
        ArrayList<Trigger> triggers = new ArrayList<Trigger>();
        for (EventTrigger t : rule.getEventtrigger()) {
            Trigger trigger = this.mapTrigger(t);
            if (trigger == null) continue;
            triggers.add(trigger);
        }
        String context = "// context: " + modelName + "-" + index + "\n";
        XBlockExpression expression = rule.getScript();
        String script = NodeModelUtils.findActualNodeFor((EObject)expression).getText();
        Configuration cfg = new Configuration();
        cfg.put("script", (Object)(context + this.removeIndentation(script)));
        cfg.put("type", (Object)MIMETYPE_OPENHAB_DSL_RULE);
        List<Action> actions = List.of(((ActionBuilder)((ActionBuilder)((ActionBuilder)ActionBuilder.create().withId("script")).withTypeUID("script.ScriptAction")).withConfiguration(cfg)).build());
        return RuleBuilder.create((String)uid).withName(name).withTriggers(triggers).withActions(actions).build();
    }

    private String removeIndentation(String script) {
        String firstLine;
        Object s = script;
        if (((String)s).startsWith("\n")) {
            s = ((String)s).substring(1);
        }
        if (((String)s).startsWith("\r\n")) {
            s = ((String)s).substring(2);
        }
        if (!((String)s).endsWith("\n\n") && !((String)s).endsWith("\r\n\r\n")) {
            s = (String)s + "\n\n";
        }
        String indentation = (firstLine = ((String)s).lines().findFirst().orElse("")) == null ? "" : firstLine.substring(0, firstLine.length() - firstLine.stripLeading().length());
        return ((String)s).lines().map(line -> line.startsWith(indentation) ? line.substring(indentation.length()) : line).collect(Collectors.joining("\n"));
    }

    private @Nullable Trigger mapTrigger(EventTrigger t) {
        if (t instanceof SystemOnStartupTrigger) {
            Configuration cfg = new Configuration();
            cfg.put("startlevel", (Object)40);
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.SystemStartlevelTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof SystemStartlevelTrigger) {
            SystemStartlevelTrigger slTrigger = (SystemStartlevelTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("startlevel", (Object)slTrigger.getLevel());
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.SystemStartlevelTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof SystemOnShutdownTrigger) {
            this.logger.warn("System shutdown rule triggers are no longer supported!");
            return null;
        }
        if (t instanceof CommandEventTrigger) {
            CommandEventTrigger ceTrigger = (CommandEventTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("itemName", (Object)ceTrigger.getItem());
            if (ceTrigger.getCommand() != null) {
                cfg.put("command", (Object)ceTrigger.getCommand().getValue());
            }
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.ItemCommandTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof GroupMemberCommandEventTrigger) {
            GroupMemberCommandEventTrigger ceTrigger = (GroupMemberCommandEventTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("groupName", (Object)ceTrigger.getGroup());
            if (ceTrigger.getCommand() != null) {
                cfg.put("command", (Object)ceTrigger.getCommand().getValue());
            }
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.GroupCommandTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof UpdateEventTrigger) {
            UpdateEventTrigger ueTrigger = (UpdateEventTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("itemName", (Object)ueTrigger.getItem());
            if (ueTrigger.getState() != null) {
                cfg.put("state", (Object)ueTrigger.getState().getValue());
            }
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.ItemStateUpdateTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof GroupMemberUpdateEventTrigger) {
            GroupMemberUpdateEventTrigger ueTrigger = (GroupMemberUpdateEventTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("groupName", (Object)ueTrigger.getGroup());
            if (ueTrigger.getState() != null) {
                cfg.put("state", (Object)ueTrigger.getState().getValue());
            }
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.GroupStateUpdateTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof ChangedEventTrigger) {
            ChangedEventTrigger ceTrigger = (ChangedEventTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("itemName", (Object)ceTrigger.getItem());
            if (ceTrigger.getNewState() != null) {
                cfg.put("state", (Object)ceTrigger.getNewState().getValue());
            }
            if (ceTrigger.getOldState() != null) {
                cfg.put("previousState", (Object)ceTrigger.getOldState().getValue());
            }
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.ItemStateChangeTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof GroupMemberChangedEventTrigger) {
            GroupMemberChangedEventTrigger ceTrigger = (GroupMemberChangedEventTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("groupName", (Object)ceTrigger.getGroup());
            if (ceTrigger.getNewState() != null) {
                cfg.put("state", (Object)ceTrigger.getNewState().getValue());
            }
            if (ceTrigger.getOldState() != null) {
                cfg.put("previousState", (Object)ceTrigger.getOldState().getValue());
            }
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.GroupStateChangeTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof TimerTrigger) {
            TimerTrigger tt = (TimerTrigger)t;
            Configuration cfg = new Configuration();
            if (tt.getCron() != null) {
                String id = tt.getCron();
                cfg.put("cronExpression", (Object)tt.getCron());
            } else {
                String id = tt.getTime();
                if ("noon".equals(id)) {
                    cfg.put("cronExpression", (Object)"0 0 12 * * ?");
                } else if ("midnight".equals(id)) {
                    cfg.put("cronExpression", (Object)"0 0 0 * * ?");
                } else {
                    this.logger.warn("Unrecognized time expression '{}' in rule trigger", (Object)tt.getTime());
                    return null;
                }
            }
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("timer.GenericCronTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof DateTimeTrigger) {
            DateTimeTrigger tt = (DateTimeTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("itemName", (Object)tt.getItem());
            cfg.put("timeOnly", (Object)tt.isTimeOnly());
            cfg.put("offset", (Object)tt.getOffset());
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("timer.DateTimeTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof EventEmittedTrigger) {
            EventEmittedTrigger eeTrigger = (EventEmittedTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("channelUID", (Object)eeTrigger.getChannel());
            if (eeTrigger.getTrigger() != null) {
                cfg.put("event", (Object)eeTrigger.getTrigger().getValue());
            }
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.ChannelEventTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof ThingStateUpdateEventTrigger) {
            ThingStateUpdateEventTrigger tsuTrigger = (ThingStateUpdateEventTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("thingUID", (Object)tsuTrigger.getThing());
            cfg.put("status", (Object)tsuTrigger.getState());
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.ThingStatusUpdateTrigger")).withConfiguration(cfg)).build();
        }
        if (t instanceof ThingStateChangedEventTrigger) {
            ThingStateChangedEventTrigger tscTrigger = (ThingStateChangedEventTrigger)t;
            Configuration cfg = new Configuration();
            cfg.put("thingUID", (Object)tscTrigger.getThing());
            cfg.put("status", (Object)tscTrigger.getNewState());
            cfg.put("previousStatus", (Object)tscTrigger.getOldState());
            return ((TriggerBuilder)((TriggerBuilder)((TriggerBuilder)TriggerBuilder.create().withId(Integer.toString(this.triggerId++))).withTypeUID("core.ThingStatusChangeTrigger")).withConfiguration(cfg)).build();
        }
        this.logger.warn("Unknown trigger type '{}' - ignoring it.", (Object)t.getClass().getSimpleName());
        return null;
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        for (String ruleFileName : this.modelRepository.getAllModelNamesOfType("rules")) {
            EObject model = this.modelRepository.getModel(ruleFileName);
            String ruleModelName = ruleFileName.substring(0, ruleFileName.indexOf("."));
            if (!(model instanceof RuleModel)) continue;
            RuleModel ruleModel = (RuleModel)model;
            int index = 1;
            ArrayList<ModelRulePair> modelRules = new ArrayList<ModelRulePair>();
            for (Rule rule : ruleModel.getRules()) {
                org.openhab.core.automation.Rule newRule = this.toRule(ruleModelName, rule, index);
                this.xExpressions.put(ruleModelName + "-" + index, (XExpression)rule.getScript());
                modelRules.add(new ModelRulePair(newRule, null));
                ++index;
            }
            this.handleVarDeclarations(ruleModelName, ruleModel);
            this.notifyProviderChangeListeners(modelRules);
        }
        this.modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        this.readyService.markReady(this.marker);
    }

    private void notifyProviderChangeListeners(List<ModelRulePair> modelRules) {
        modelRules.forEach(rulePair -> {
            org.openhab.core.automation.Rule oldRule = rulePair.oldRule();
            if (oldRule != null) {
                this.rules.remove(oldRule.getUID());
                this.rules.put(rulePair.newRule().getUID(), rulePair.newRule());
                this.listeners.forEach(listener -> listener.updated((Provider)this, (Object)oldRule, (Object)rulePair.newRule()));
            } else {
                this.rules.put(rulePair.newRule().getUID(), rulePair.newRule());
                this.listeners.forEach(listener -> listener.added((Provider)this, (Object)rulePair.newRule()));
            }
        });
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        this.readyService.unmarkReady(this.marker);
    }

    private record ModelRulePair(org.openhab.core.automation.Rule newRule, @Nullable org.openhab.core.automation.Rule oldRule) {
    }
}

