/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.channels;

import com.intellij.station.comms.common.netty.channels.DomainServerSocketChannel;
import com.intellij.station.comms.common.netty.channels.NioDomainServerSocketChannelConfig;
import com.intellij.station.comms.common.netty.channels.NioDomainSocketChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.nio.AbstractNioMessageChannel;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.net.UnixDomainSocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\t\u0010\u000bJ\n\u0010\u0014\u001a\u0004\u0018\u00010\u000fH\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0014J\n\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0014J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0018H\u0014J\b\u0010\u001c\u001a\u00020\u001bH\u0014J\b\u0010\u001d\u001a\u00020\u001bH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\u001c\u0010 \u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u00182\b\u0010\u0014\u001a\u0004\u0018\u00010\u0018H\u0014J\b\u0010!\u001a\u00020\u001bH\u0014J\u0016\u0010\"\u001a\u00020\b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$H\u0014J\u001c\u0010&\u001a\u00020\u00112\b\u0010'\u001a\u0004\u0018\u00010%2\b\u0010(\u001a\u0004\u0018\u00010)H\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/station/comms/common/netty/channels/NioDomainServerSocketChannel;", "Lio/netty/channel/nio/AbstractNioMessageChannel;", "Lcom/intellij/station/comms/common/netty/channels/DomainServerSocketChannel;", "parent", "Lio/netty/channel/Channel;", "ch", "Ljava/nio/channels/SelectableChannel;", "readInterestOp", "", "<init>", "(Lio/netty/channel/Channel;Ljava/nio/channels/SelectableChannel;I)V", "()V", "metadata", "Lio/netty/channel/ChannelMetadata;", "local", "Ljava/net/UnixDomainSocketAddress;", "active", "", "config", "Lcom/intellij/station/comms/common/netty/channels/NioDomainServerSocketChannelConfig;", "localAddress", "remoteAddress", "isActive", "localAddress0", "Ljava/net/SocketAddress;", "remoteAddress0", "doBind", "", "doDisconnect", "doClose", "javaChannel", "Ljava/nio/channels/ServerSocketChannel;", "doConnect", "doFinishConnect", "doReadMessages", "buf", "", "", "doWriteMessage", "msg", "in", "Lio/netty/channel/ChannelOutboundBuffer;", "intellij.station.comms.common"})
public final class NioDomainServerSocketChannel
extends AbstractNioMessageChannel
implements DomainServerSocketChannel {
    @NotNull
    private final ChannelMetadata metadata = new ChannelMetadata(false, 16);
    @Nullable
    private UnixDomainSocketAddress local;
    private boolean active;
    @NotNull
    private final NioDomainServerSocketChannelConfig config = new NioDomainServerSocketChannelConfig((Channel)this, this.javaChannel());

    private NioDomainServerSocketChannel(Channel parent, SelectableChannel ch, int readInterestOp) {
        super(parent, ch, readInterestOp);
    }

    public NioDomainServerSocketChannel() {
        this(null, SelectorProvider.provider().openServerSocketChannel(StandardProtocolFamily.UNIX), 16);
    }

    @Override
    @Nullable
    public UnixDomainSocketAddress localAddress() {
        SocketAddress socketAddress = super.localAddress();
        return socketAddress instanceof UnixDomainSocketAddress ? (UnixDomainSocketAddress)socketAddress : null;
    }

    @Override
    @Nullable
    public UnixDomainSocketAddress remoteAddress() {
        SocketAddress socketAddress = super.remoteAddress();
        return socketAddress instanceof UnixDomainSocketAddress ? (UnixDomainSocketAddress)socketAddress : null;
    }

    @NotNull
    public NioDomainServerSocketChannelConfig config() {
        return this.config;
    }

    public boolean isActive() {
        return this.isOpen() && this.active;
    }

    @NotNull
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Nullable
    protected SocketAddress localAddress0() {
        return this.local;
    }

    @Nullable
    protected SocketAddress remoteAddress0() {
        return null;
    }

    protected void doBind(@NotNull SocketAddress localAddress) {
        Intrinsics.checkNotNullParameter((Object)localAddress, (String)"localAddress");
        UnixDomainSocketAddress unixDomainAddress = (UnixDomainSocketAddress)localAddress;
        this.javaChannel().bind(unixDomainAddress, this.config.getBacklog());
        this.local = unixDomainAddress;
        this.active = true;
    }

    protected void doDisconnect() {
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doClose() {
        try {
            super.doClose();
            this.javaChannel().close();
        }
        finally {
            UnixDomainSocketAddress local = this.local;
            if (local != null) {
                Path socketPath = local.getPath();
                boolean bl = Files.deleteIfExists(socketPath);
            }
        }
    }

    @NotNull
    protected ServerSocketChannel javaChannel() {
        SelectableChannel selectableChannel = super.javaChannel();
        Intrinsics.checkNotNull((Object)selectableChannel, (String)"null cannot be cast to non-null type java.nio.channels.ServerSocketChannel");
        return (ServerSocketChannel)selectableChannel;
    }

    protected boolean doConnect(@Nullable SocketAddress remoteAddress, @Nullable SocketAddress localAddress) {
        throw new UnsupportedOperationException("Domain server socket channel doesn't support doConnect()");
    }

    protected void doFinishConnect() {
        throw new UnsupportedOperationException("Domain server socket channel doesn't support doFinishConnect()");
    }

    protected int doReadMessages(@NotNull List<Object> buf) {
        block4: {
            Intrinsics.checkNotNullParameter(buf, (String)"buf");
            SocketChannel socketChannel = this.javaChannel().accept();
            if (socketChannel == null) break block4;
            SocketChannel it = socketChannel;
            boolean bl = false;
            try {
                buf.add(new NioDomainSocketChannel(this, it));
                return 1;
            }
            catch (Throwable t) {
                try {
                    it.close();
                }
                catch (Throwable throwable) {
                }
            }
        }
        return 0;
    }

    protected boolean doWriteMessage(@Nullable Object msg, @Nullable ChannelOutboundBuffer in) {
        throw new UnsupportedOperationException("Domain server socket channel doesn't support doWriteMessage()");
    }
}

