/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.diagnostic.Logger;
import io.netty.channel.Channel;
import io.netty.util.ReferenceCountUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.AttachStateManager;
import org.jetbrains.debugger.StandaloneVmHelperKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.rpc.MessageProcessor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0001\u0017B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u0004\u0018\u00010\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u0016H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/debugger/StandaloneVmHelper;", "Lorg/jetbrains/debugger/AttachStateManager;", "vm", "Lorg/jetbrains/debugger/Vm;", "messageProcessor", "Lorg/jetbrains/rpc/MessageProcessor;", "channel", "Lio/netty/channel/Channel;", "<init>", "(Lorg/jetbrains/debugger/Vm;Lorg/jetbrains/rpc/MessageProcessor;Lio/netty/channel/Channel;)V", "getChannelIfActive", "write", "", "content", "", "isAttached", "()Z", "detach", "Lorg/jetbrains/concurrency/Promise;", "closeChannel", "", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "VmEx", "intellij.platform.scriptDebugger.backend"})
@ApiStatus.Internal
public class StandaloneVmHelper
implements AttachStateManager {
    @NotNull
    private final Vm vm;
    @NotNull
    private final MessageProcessor messageProcessor;
    @Nullable
    private volatile Channel channel;

    public StandaloneVmHelper(@NotNull Vm vm, @NotNull MessageProcessor messageProcessor, @NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
        Intrinsics.checkNotNullParameter((Object)messageProcessor, (String)"messageProcessor");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.vm = vm;
        this.messageProcessor = messageProcessor;
        this.channel = channel;
    }

    @Nullable
    public final Channel getChannelIfActive() {
        Channel currentChannel = this.channel;
        return currentChannel == null || !currentChannel.isActive() ? null : currentChannel;
    }

    public final boolean write(@NotNull Object content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Channel channel = this.getChannelIfActive();
        if (channel != null) {
            return !channel.writeAndFlush(content).isCancelled();
        }
        ReferenceCountUtil.release((Object)content);
        return false;
    }

    @Override
    public boolean isAttached() {
        return this.channel != null;
    }

    @Override
    @NotNull
    public Promise<?> detach() {
        Channel channel = this.channel;
        if (channel == null) {
            return Promises.nullPromise();
        }
        Channel currentChannel = channel;
        this.messageProcessor.cancelWaitingRequests();
        Vm vm = this.vm;
        VmEx vmEx = vm instanceof VmEx ? (VmEx)vm : null;
        Request<? extends Object> disconnectRequest = vmEx != null ? vmEx.createDisconnectRequest() : null;
        AsyncPromise promise = new AsyncPromise();
        if (disconnectRequest == null) {
            this.messageProcessor.closed();
            this.channel = null;
        } else {
            this.messageProcessor.send(disconnectRequest).onError(arg_0 -> StandaloneVmHelper.detach$lambda$1(StandaloneVmHelper::detach$lambda$0, arg_0));
            currentChannel.flush();
            this.messageProcessor.closed();
            this.channel = null;
            this.messageProcessor.cancelWaitingRequests();
        }
        this.closeChannel(currentChannel, (AsyncPromise<Object>)promise);
        return (Promise)promise;
    }

    protected void closeChannel(@NotNull Channel channel, @NotNull AsyncPromise<Object> promise) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter(promise, (String)"promise");
        StandaloneVmHelperKt.doCloseChannel(channel, promise);
    }

    private static final Unit detach$lambda$0(Throwable it) {
        if (!Intrinsics.areEqual((Object)it.getMessage(), (Object)"Connection closed")) {
            Logger logger = CommandProcessorKt.getLOG();
            Intrinsics.checkNotNull((Object)it);
            Promises.errorIfNotMessage((Logger)logger, (Throwable)it);
        }
        return Unit.INSTANCE;
    }

    private static final void detach$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/debugger/StandaloneVmHelper$VmEx;", "Lorg/jetbrains/debugger/Vm;", "createDisconnectRequest", "Lorg/jetbrains/jsonProtocol/Request;", "", "intellij.platform.scriptDebugger.backend"})
    public static interface VmEx
    extends Vm {
        @Nullable
        public Request<? extends Object> createDisconnectRequest();
    }
}

