/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.progress.ProgressIndicator;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

final class ProgressMonitorInputStream
extends InputStream {
    private final ProgressIndicator myIndicator;
    private final InputStream myStream;
    private final double myAvailable;
    private long count;

    ProgressMonitorInputStream(@NotNull ProgressIndicator indicator, @NotNull InputStream stream, long length) {
        if (indicator == null) {
            ProgressMonitorInputStream.$$$reportNull$$$0(0);
        }
        if (stream == null) {
            ProgressMonitorInputStream.$$$reportNull$$$0(1);
        }
        this.myIndicator = indicator;
        this.myStream = stream;
        this.myAvailable = length;
    }

    @Override
    public int read() throws IOException {
        int c = this.myStream.read();
        this.updateProgress(c >= 0 ? 1L : 0L);
        return c;
    }

    private void updateProgress(long increment) {
        this.myIndicator.checkCanceled();
        if (increment > 0L) {
            this.count += increment;
            if (!this.myIndicator.isIndeterminate()) {
                this.myIndicator.setFraction((double)this.count / this.myAvailable);
            }
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.myStream.read(b);
        this.updateProgress(r);
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.myStream.read(b, off, len);
        this.updateProgress(r);
        return r;
    }

    @Override
    public long skip(long n) throws IOException {
        long r = this.myStream.skip(n);
        this.updateProgress(r);
        return r;
    }

    @Override
    public void close() throws IOException {
        this.myStream.close();
    }

    @Override
    public int available() throws IOException {
        return this.myStream.available();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stream";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/io/ProgressMonitorInputStream";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

