/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows.winpty;

import com.pty4j.PtyProcess;
import com.pty4j.PtyProcessOptions;
import com.pty4j.WinSize;
import com.pty4j.windows.winpty.WinPTYInputStream;
import com.pty4j.windows.winpty.WinPTYOutputStream;
import com.pty4j.windows.winpty.WinPty;
import com.pty4j.windows.winpty.WinPtyException;
import com.sun.jna.platform.win32.Advapi32Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WinPtyProcess
extends PtyProcess {
    private final WinPty myWinPty;
    private final WinPTYInputStream myInputStream;
    private final InputStream myErrorStream;
    private final WinPTYOutputStream myOutputStream;
    private final List<String> myCommand;
    private final boolean myConsoleMode;
    private boolean myUsedInputStream = false;
    private boolean myUsedOutputStream = false;
    private boolean myUsedErrorStream = false;

    @Deprecated
    public WinPtyProcess(String[] command, String[] environment, String workingDirectory, boolean consoleMode) throws IOException {
        this(command, WinPtyProcess.convertEnvironment(environment), workingDirectory, consoleMode);
    }

    private static String convertEnvironment(String[] environment) {
        StringBuilder envString = new StringBuilder();
        for (String s : environment) {
            envString.append(s).append('\u0000');
        }
        envString.append('\u0000');
        return envString.toString();
    }

    @Deprecated
    public WinPtyProcess(String[] command, String environment, String workingDirectory, boolean consoleMode) throws IOException {
        this(command, environment, workingDirectory, null, null, consoleMode, false);
    }

    public WinPtyProcess(@NotNull PtyProcessOptions options, boolean consoleMode) throws IOException {
        this(options.getCommand(), WinPtyProcess.convertEnvironment(options.getEnvironment()), options.getDirectory(), options.getInitialColumns(), options.getInitialRows(), consoleMode, options.isWindowsAnsiColorEnabled());
    }

    @NotNull
    private static String convertEnvironment(@Nullable Map<String, String> environment) {
        return Advapi32Util.getEnvironmentBlock(environment != null ? environment : Collections.emptyMap());
    }

    private WinPtyProcess(@NotNull String[] command, @NotNull String environment, @Nullable String workingDirectory, @Nullable Integer initialColumns, @Nullable Integer initialRows, boolean consoleMode, boolean enableAnsiColor) throws IOException {
        this.myConsoleMode = consoleMode;
        this.myCommand = List.of(command);
        try {
            this.myWinPty = new WinPty(WinPtyProcess.joinCmdArgs(command), workingDirectory, environment, consoleMode, initialColumns, initialRows, enableAnsiColor);
        }
        catch (WinPtyException e) {
            throw new IOException("Couldn't create PTY", e);
        }
        this.myInputStream = new WinPTYInputStream(this.myWinPty, this.myWinPty.getInputPipe());
        this.myOutputStream = new WinPTYOutputStream(this.myWinPty, this.myWinPty.getOutputPipe(), consoleMode, true);
        this.myErrorStream = !consoleMode ? new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        } : new WinPTYInputStream(this.myWinPty, this.myWinPty.getErrorPipe());
    }

    public static String joinCmdArgs(String[] commands) {
        StringBuilder cmd = new StringBuilder();
        boolean flag = false;
        for (String s : commands) {
            if (flag) {
                cmd.append(' ');
            } else {
                flag = true;
            }
            if (s.indexOf(32) >= 0 || s.indexOf(9) >= 0) {
                if (s.charAt(0) != '\"') {
                    cmd.append('\"').append(s);
                    if (s.endsWith("\\")) {
                        cmd.append("\\");
                    }
                    cmd.append('\"');
                    continue;
                }
                cmd.append(s);
                continue;
            }
            cmd.append(s);
        }
        return cmd.toString();
    }

    @NotNull
    public List<String> getCommand() {
        return this.myCommand;
    }

    @Override
    public boolean isConsoleMode() {
        return this.myConsoleMode;
    }

    @Override
    public void setWinSize(@NotNull WinSize winSize) {
        try {
            this.myWinPty.setWinSize(winSize);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    @NotNull
    public WinSize getWinSize() throws IOException {
        return this.myWinPty.getWinSize();
    }

    @Override
    public long pid() {
        return this.myWinPty.getChildProcessId();
    }

    @Nullable
    public String getWorkingDirectory() throws IOException {
        return this.myWinPty.getWorkingDirectory();
    }

    public int getConsoleProcessCount() throws IOException {
        return this.myWinPty.getConsoleProcessList();
    }

    @Override
    public synchronized OutputStream getOutputStream() {
        this.myUsedOutputStream = true;
        return this.myOutputStream;
    }

    @Override
    public synchronized InputStream getInputStream() {
        this.myUsedInputStream = true;
        return this.myInputStream;
    }

    @Override
    public synchronized InputStream getErrorStream() {
        this.myUsedErrorStream = true;
        return this.myErrorStream;
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.myWinPty.waitFor();
    }

    public int getChildProcessId() {
        return this.myWinPty.getChildProcessId();
    }

    @Override
    public int exitValue() {
        return this.myWinPty.exitValue();
    }

    @Override
    public synchronized void destroy() {
        this.myWinPty.close();
        if (!this.myUsedInputStream) {
            try {
                this.myInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.myUsedOutputStream) {
            try {
                this.myOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!this.myUsedErrorStream) {
            try {
                this.myErrorStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

