/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers;

import com.intellij.ide.startup.importSettings.db.KnownLafs;
import com.intellij.ide.startup.importSettings.models.BundledEditorColorScheme;
import com.intellij.ide.startup.importSettings.models.BundledLookAndFeel;
import com.intellij.ide.startup.importSettings.models.ILookAndFeel;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vsmac.mappings.ThemesMappings;
import com.intellij.ide.startup.importSettings.transfer.backend.db.KnownColorSchemes;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.mappings.SchemesMappings;
import com.intellij.ide.startup.importSettings.transfer.backend.providers.vsmac.parsers.GeneralSettingsParserKt;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/GeneralSettingsParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "<init>", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "currentLaf", "Lcom/intellij/ide/startup/importSettings/models/ILookAndFeel;", "associatedScheme", "", "Lcom/intellij/ide/startup/importSettings/models/BundledLookAndFeel;", "Lcom/intellij/ide/startup/importSettings/models/BundledEditorColorScheme;", "process", "", "file", "Ljava/io/File;", "processThemeAndScheme", "root", "Lorg/jdom/Element;", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nGeneralSettingsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GeneralSettingsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/GeneralSettingsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,73:1\n1863#2,2:74\n*S KotlinDebug\n*F\n+ 1 GeneralSettingsParser.kt\ncom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/GeneralSettingsParser\n*L\n45#1:74,2\n*E\n"})
public final class GeneralSettingsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private ILookAndFeel currentLaf;
    @NotNull
    private final Map<BundledLookAndFeel, BundledEditorColorScheme> associatedScheme;
    @NotNull
    private static final String KEY = "key";
    @NotNull
    private static final String VALUE = "value";
    @NotNull
    private static final String THEME = "MonoDevelop.Ide.UserInterfaceTheme";
    @NotNull
    private static final String SCHEME = "ColorScheme";
    @NotNull
    private static final String SCHEME_DARK = "ColorScheme-Dark";

    public GeneralSettingsParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        ILookAndFeel iLookAndFeel = this.settings.getLaf();
        if (iLookAndFeel == null) {
            iLookAndFeel = KnownLafs.INSTANCE.getLight();
        }
        this.currentLaf = iLookAndFeel;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)KnownLafs.INSTANCE.getLight(), (Object)KnownColorSchemes.INSTANCE.getLight()), TuplesKt.to((Object)KnownLafs.INSTANCE.getDarcula(), (Object)KnownColorSchemes.INSTANCE.getDarcula())};
        this.associatedScheme = MapsKt.mutableMapOf((Pair[])pairArray);
    }

    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            GeneralSettingsParserKt.access$getLogger$p().info("Processing a file: " + file);
            Element element = JDOMUtil.load((File)file);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            Element root = element;
            this.processThemeAndScheme(root);
        }
        catch (Throwable t) {
            GeneralSettingsParserKt.access$getLogger$p().warn(t);
        }
    }

    private final void processThemeAndScheme(Element root) {
        try {
            List list = root.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            block9: for (Object element$iv : $this$forEach$iv) {
                Element element = (Element)element$iv;
                boolean bl = false;
                try {
                    BundledEditorColorScheme bundledEditorColorScheme;
                    BundledLookAndFeel bundledLookAndFeel;
                    Map<BundledLookAndFeel, BundledEditorColorScheme> map;
                    Object value;
                    block12: {
                        Object object;
                        Object attributes;
                        Object object2 = element;
                        if (object2 == null) continue;
                        if ((object2 = object2.getAttributes()) == null || (attributes = object2).size() != 2) continue;
                        Object object3 = (Attribute)attributes.get(0);
                        boolean bl2 = object3 != null && (object3 = object3.getName()) != null ? ((String)object3).equals(KEY) : false;
                        if (!bl2) continue;
                        Object object4 = (Attribute)attributes.get(1);
                        boolean bl3 = object4 != null && (object4 = object4.getName()) != null ? ((String)object4).equals(VALUE) : false;
                        if (!bl3 || (object = (Attribute)attributes.get(0)) == null || (object = object.getValue()) == null) continue;
                        Object settingId = object;
                        Object object5 = (Attribute)attributes.get(1);
                        if (object5 == null || (object5 = object5.getValue()) == null) continue;
                        value = object5;
                        Object object6 = settingId;
                        switch (((String)object6).hashCode()) {
                            case 1274568571: {
                                if (!((String)object6).equals(SCHEME_DARK)) {
                                    continue block9;
                                }
                                break block12;
                            }
                            case -1660902712: {
                                if (((String)object6).equals(SCHEME)) break;
                                continue block9;
                            }
                            case -288411309: {
                                if (!((String)object6).equals(THEME)) continue block9;
                                BundledLookAndFeel bundledLookAndFeel2 = ThemesMappings.INSTANCE.themeMap((String)value);
                                if (bundledLookAndFeel2 == null) {
                                    continue block9;
                                }
                                this.currentLaf = bundledLookAndFeel2;
                                continue block9;
                            }
                        }
                        map = this.associatedScheme;
                        bundledLookAndFeel = KnownLafs.INSTANCE.getLight();
                        if (SchemesMappings.INSTANCE.schemeMap((String)value) == null) continue;
                        map.put(bundledLookAndFeel, bundledEditorColorScheme);
                        continue;
                    }
                    map = this.associatedScheme;
                    bundledLookAndFeel = KnownLafs.INSTANCE.getDarcula();
                    if (SchemesMappings.INSTANCE.schemeMap((String)value) == null) continue;
                    map.put(bundledLookAndFeel, bundledEditorColorScheme);
                }
                catch (Throwable t) {
                    GeneralSettingsParserKt.access$getLogger$p().warn(t);
                }
            }
            this.settings.setLaf(this.currentLaf);
            this.settings.setSyntaxScheme(this.associatedScheme.get(this.currentLaf));
        }
        catch (Throwable t) {
            GeneralSettingsParserKt.access$getLogger$p().warn(t);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ide/startup/importSettings/transfer/backend/providers/vsmac/parsers/GeneralSettingsParser$Companion;", "", "<init>", "()V", "KEY", "", "VALUE", "THEME", "SCHEME", "SCHEME_DARK", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

