/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.details;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.componentsList.components.ScrollablePanel;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.SeparatorComponent;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanelKt;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u00012\u00020\u00022\u00020\u0003:\u00016B)\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u00020\u00192\b\b\u0001\u0010\u001c\u001a\u00020\u001dJ\u001b\u0010\u001e\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0000\u00a2\u0006\u0002\b J\u0016\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'H\u0014J \u0010(\u001a\u00020\u00192\u0018\u0010)\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190*J \u0010+\u001a\u00020\u00192\u0018\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00190*J\u0014\u0010-\u001a\u00020\u00192\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020.0\u000eJ\u0006\u0010/\u001a\u00020\u0019J\b\u00100\u001a\u00020\u0011H\u0016J\u0012\u00101\u001a\u00020\u00192\b\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u000205H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/editor/colors/EditorColorsListener;", "Lcom/intellij/util/ui/ComponentWithEmptyText;", "project", "Lcom/intellij/openapi/project/Project;", "parent", "Lcom/intellij/openapi/Disposable;", "createDetailsPanel", "Lkotlin/Function0;", "Lcom/intellij/vcs/log/ui/details/commit/CommitDetailsPanel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;)V", "displayedCommits", "", "Lcom/intellij/vcs/log/CommitId;", "statusText", "Lcom/intellij/util/ui/StatusText;", "detailsPanel", "Ljavax/swing/JPanel;", "viewPanel", "Lcom/intellij/openapi/roots/ui/componentsList/components/ScrollablePanel;", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "startLoadingDetails", "", "stopLoadingDetails", "setStatusText", "text", "", "rebuildPanel", "commits", "rebuildPanel$intellij_platform_vcs_log_impl", "showOverflowLabelIfNeeded", "max", "", "requested", "paintChildren", "g", "Ljava/awt/Graphics;", "forEachPanelIndexed", "f", "Lkotlin/Function2;", "forEachPanel", "consumer", "setCommits", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "update", "getEmptyText", "globalSchemeChange", "scheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getMinimumSize", "Ljava/awt/Dimension;", "Companion", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nCommitDetailsListPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitDetailsListPanel.kt\ncom/intellij/vcs/log/ui/details/CommitDetailsListPanel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n13409#2,2:198\n13409#2,2:204\n1557#3:200\n1628#3,3:201\n*S KotlinDebug\n*F\n+ 1 CommitDetailsListPanel.kt\ncom/intellij/vcs/log/ui/details/CommitDetailsListPanel\n*L\n157#1:198,2\n182#1:204,2\n173#1:200\n173#1:201,3\n*E\n"})
public final class CommitDetailsListPanel
extends BorderLayoutPanel
implements EditorColorsListener,
ComponentWithEmptyText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Function0<CommitDetailsPanel> createDetailsPanel;
    @NotNull
    private List<CommitId> displayedCommits;
    @NotNull
    private final StatusText statusText;
    @NotNull
    private final JPanel detailsPanel;
    @NotNull
    private final ScrollablePanel viewPanel;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    private static final int MIN_SIZE = 20;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public CommitDetailsListPanel(@NotNull Project project, @NotNull Disposable parent, @NotNull Function0<CommitDetailsPanel> createDetailsPanel) {
        JBScrollPane jBScrollPane;
        void $this$loadingPanel_u24lambda_u244;
        JPanel $this$viewPanel_u24lambda_u242;
        JPanel $this$detailsPanel_u24lambda_u241;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(createDetailsPanel, (String)"createDetailsPanel");
        this.project = project;
        this.createDetailsPanel = createDetailsPanel;
        this.displayedCommits = CollectionsKt.emptyList();
        this.statusText = new StatusText(this){
            final /* synthetic */ CommitDetailsListPanel this$0;
            {
                this.this$0 = $receiver;
                super((JComponent)((Object)$receiver));
            }

            protected boolean isStatusVisible() {
                return CommitDetailsListPanel.access$getDisplayedCommits$p(this.this$0).isEmpty();
            }
        };
        JPanel jPanel2 = jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
        CommitDetailsListPanel commitDetailsListPanel = this;
        boolean bl = false;
        $this$detailsPanel_u24lambda_u241.setOpaque(false);
        $this$detailsPanel_u24lambda_u241.setBorder((Border)JBUI.Borders.empty());
        commitDetailsListPanel.detailsPanel = jPanel;
        $this$detailsPanel_u24lambda_u241 = jPanel = new ScrollablePanel((LayoutManager)new BorderLayout());
        commitDetailsListPanel = this;
        boolean bl2 = false;
        $this$viewPanel_u24lambda_u242.setOpaque(false);
        $this$viewPanel_u24lambda_u242.setBorder((Border)JBUI.Borders.empty());
        $this$viewPanel_u24lambda_u242.add(this.detailsPanel, "Center");
        commitDetailsListPanel.viewPanel = jPanel;
        $this$viewPanel_u24lambda_u242 = jPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), parent, 300);
        commitDetailsListPanel = this;
        boolean bl3 = false;
        $this$loadingPanel_u24lambda_u244.setOpaque(false);
        JBScrollPane $this$loadingPanel_u24lambda_u244_u24lambda_u243 = jBScrollPane = new JBScrollPane((Component)this.viewPanel, 20, 31);
        boolean bl4 = false;
        $this$loadingPanel_u24lambda_u244_u24lambda_u243.setBorder((Border)JBUI.Borders.empty());
        $this$loadingPanel_u24lambda_u244_u24lambda_u243.setViewportBorder((Border)JBUI.Borders.empty());
        $this$loadingPanel_u24lambda_u244_u24lambda_u243.setOpaque(false);
        $this$loadingPanel_u24lambda_u244_u24lambda_u243.getViewport().setOpaque(false);
        JBScrollPane scrollPane = jBScrollPane;
        $this$loadingPanel_u24lambda_u244.add((Component)scrollPane, (Object)"Center");
        commitDetailsListPanel.loadingPanel = jPanel;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect(parent);
        Topic topic = CommitMessageInspectionProfile.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, () -> CommitDetailsListPanel._init_$lambda$5(this));
        String string = VcsLogBundle.message("vcs.log.commit.details.status", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.setStatusText(string);
        this.setBackground(CommitDetailsPanelKt.getCommitDetailsBackground());
        this.addToCenter((Component)this.loadingPanel);
        this.putClientProperty(UIUtil.NOT_IN_HIERARCHY_COMPONENTS, this.statusText.getWrappedFragmentsIterable());
    }

    public /* synthetic */ CommitDetailsListPanel(Project project, Disposable disposable, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = CommitDetailsListPanel::_init_$lambda$0;
        }
        this(project, disposable, (Function0<CommitDetailsPanel>)function0);
    }

    public final void startLoadingDetails() {
        this.loadingPanel.startLoading();
    }

    public final void stopLoadingDetails() {
        this.loadingPanel.stopLoading();
    }

    public final void setStatusText(@Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.statusText.setText(text);
    }

    public final void rebuildPanel$intellij_platform_vcs_log_impl(@NotNull List<CommitId> commits) {
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        int oldRowsCount = this.displayedCommits.size();
        this.displayedCommits = commits;
        int newRowsCount = this.displayedCommits.size();
        for (int i = oldRowsCount; i < newRowsCount; ++i) {
            CommitDetailsPanel panel = (CommitDetailsPanel)this.createDetailsPanel.invoke();
            if (i != 0) {
                this.detailsPanel.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            }
            this.detailsPanel.add(panel);
        }
        while (this.detailsPanel.getComponentCount() != 0 && this.detailsPanel.getComponentCount() > 2 * newRowsCount - 1) {
            this.detailsPanel.remove(this.detailsPanel.getComponentCount() - 1);
        }
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public final void showOverflowLabelIfNeeded(int max, int requested) {
        int componentCount = this.viewPanel.getComponentCount();
        if (componentCount > 1) {
            this.viewPanel.remove(componentCount - 1);
        }
        if (requested > max) {
            void $this$showOverflowLabelIfNeeded_u24lambda_u247_u24lambda_u246;
            JPanel jPanel;
            JPanel $this$showOverflowLabelIfNeeded_u24lambda_u247 = jPanel = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0, 0, true, false));
            boolean bl = false;
            $this$showOverflowLabelIfNeeded_u24lambda_u247.setOpaque(false);
            $this$showOverflowLabelIfNeeded_u24lambda_u247.add((Component)new SeparatorComponent(0, OnePixelDivider.BACKGROUND, null));
            Object[] objectArray = new Object[]{max, requested};
            Object[] objectArray2 = objectArray = new JBLabel(VcsLogBundle.message("vcs.log.details.showing.selected.commits", objectArray));
            JPanel jPanel2 = $this$showOverflowLabelIfNeeded_u24lambda_u247;
            boolean bl2 = false;
            $this$showOverflowLabelIfNeeded_u24lambda_u247_u24lambda_u246.setFont(FontUtil.getCommitMetadataFont());
            $this$showOverflowLabelIfNeeded_u24lambda_u247_u24lambda_u246.setBorder((Border)JBUI.Borders.emptyLeft((int)14));
            jPanel2.add((Component)objectArray);
            JPanel overflowLabelPanel = jPanel;
            this.viewPanel.add((Component)overflowLabelPanel, (Object)"South");
        }
        this.viewPanel.revalidate();
        this.viewPanel.repaint();
    }

    protected void paintChildren(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.statusText.paint((Component)((Object)this), g);
        super.paintChildren(g);
    }

    public final void forEachPanelIndexed(@NotNull Function2<? super Integer, ? super CommitDetailsPanel, Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        int idx = 0;
        Component[] componentArray = this.detailsPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            if (!(it instanceof CommitDetailsPanel)) continue;
            f.invoke((Object)idx, (Object)it);
            ++idx;
        }
        this.update();
    }

    public final void forEachPanel(@NotNull Function2<? super CommitId, ? super CommitDetailsPanel, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)(arg_0, arg_1) -> CommitDetailsListPanel.forEachPanel$lambda$9(consumer, this, arg_0, arg_1)));
    }

    /*
     * WARNING - void declaration
     */
    public final void setCommits(@NotNull List<? extends VcsCommitMetadata> commits) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(commits, (String)"commits");
        Iterable iterable = commits;
        CommitDetailsListPanel commitDetailsListPanel = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new CommitId((Hash)it.getId(), it.getRoot()));
        }
        commitDetailsListPanel.rebuildPanel$intellij_platform_vcs_log_impl((List)destination$iv$iv);
        this.forEachPanelIndexed((Function2<? super Integer, ? super CommitDetailsPanel, Unit>)((Function2)(arg_0, arg_1) -> CommitDetailsListPanel.setCommits$lambda$11(commits, this, arg_0, arg_1)));
    }

    public final void update() {
        Component[] componentArray = this.detailsPanel.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            if (!(it instanceof CommitDetailsPanel)) continue;
            ((CommitDetailsPanel)it).update();
        }
    }

    @NotNull
    public StatusText getEmptyText() {
        return this.statusText;
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        this.update();
    }

    @NotNull
    public Dimension getMinimumSize() {
        Dimension minimumSize = super.getMinimumSize();
        return new Dimension(Math.max(minimumSize.width, JBUIScale.scale((int)20)), Math.max(minimumSize.height, JBUIScale.scale((int)20)));
    }

    @JvmOverloads
    public CommitDetailsListPanel(@NotNull Project project, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this(project, parent, null, 4, null);
    }

    private static final CommitDetailsPanel _init_$lambda$0() {
        return new CommitDetailsPanel(null, 1, null);
    }

    private static final void _init_$lambda$5(CommitDetailsListPanel this$0) {
        this$0.update();
    }

    private static final Unit forEachPanel$lambda$9(Function2 $consumer, CommitDetailsListPanel this$0, int idx, CommitDetailsPanel panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        $consumer.invoke((Object)this$0.displayedCommits.get(idx), (Object)panel);
        return Unit.INSTANCE;
    }

    private static final Unit setCommits$lambda$11(List $commits, CommitDetailsListPanel this$0, int i, CommitDetailsPanel panel) {
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        VcsCommitMetadata commit = (VcsCommitMetadata)$commits.get(i);
        CommitPresentationUtil.CommitPresentation commitPresentation = CommitPresentationUtil.buildPresentation(this$0.project, commit, new LinkedHashSet());
        Intrinsics.checkNotNullExpressionValue((Object)commitPresentation, (String)"buildPresentation(...)");
        CommitPresentationUtil.CommitPresentation presentation = commitPresentation;
        panel.setCommit(presentation);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ List access$getDisplayedCommits$p(CommitDetailsListPanel $this) {
        return $this.displayedCommits;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/log/ui/details/CommitDetailsListPanel$Companion;", "", "<init>", "()V", "MIN_SIZE", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

