/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.diagnostic.Logger;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0002\"#BS\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000f\u0010\u0011B=\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u000f\u0010\u0015J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dJ\u0006\u0010\u001e\u001a\u00020\u0013J\b\u0010\u001f\u001a\u00020\u0005H\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010!\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006$"}, d2={"Lgit4idea/branch/GitRebaseParams;", "", "version", "Lgit4idea/config/GitVersion;", "branch", "", "newBase", "upstream", "selectedOptions", "", "Lgit4idea/rebase/GitRebaseOption;", "autoSquash", "Lgit4idea/branch/GitRebaseParams$AutoSquashOption;", "editorHandler", "Lgit4idea/rebase/GitRebaseEditorHandler;", "<init>", "(Lgit4idea/config/GitVersion;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;Lgit4idea/branch/GitRebaseParams$AutoSquashOption;Lgit4idea/rebase/GitRebaseEditorHandler;)V", "(Lgit4idea/config/GitVersion;Ljava/lang/String;)V", "interactive", "", "preserveMerges", "(Lgit4idea/config/GitVersion;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZ)V", "getUpstream", "()Ljava/lang/String;", "getEditorHandler", "()Lgit4idea/rebase/GitRebaseEditorHandler;", "getBranch", "getNewBase", "asCommandLineArguments", "", "isInteractive", "toString", "handleRebaseMergesOption", "rebaseMergesAvailable", "Companion", "AutoSquashOption", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRebaseParams.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRebaseParams.kt\ngit4idea/branch/GitRebaseParams\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n1#2:109\n1#2:120\n1611#3,9:110\n1863#3:119\n1864#3:121\n1620#3:122\n1863#3,2:123\n14#4:125\n*S KotlinDebug\n*F\n+ 1 GitRebaseParams.kt\ngit4idea/branch/GitRebaseParams\n*L\n58#1:120\n58#1:110,9\n58#1:119\n58#1:121\n58#1:122\n64#1:123,2\n18#1:125\n*E\n"})
public final class GitRebaseParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitVersion version;
    @Nullable
    private final String upstream;
    @NotNull
    private final Set<GitRebaseOption> selectedOptions;
    @NotNull
    private final AutoSquashOption autoSquash;
    @Nullable
    private final GitRebaseEditorHandler editorHandler;
    @Nullable
    private final String branch;
    @Nullable
    private final String newBase;
    @NotNull
    private static final Logger LOG;

    public GitRebaseParams(@NotNull GitVersion version, @Nullable String branch, @Nullable String newBase, @Nullable String upstream, @NotNull Set<? extends GitRebaseOption> selectedOptions, @NotNull AutoSquashOption autoSquash, @Nullable GitRebaseEditorHandler editorHandler) {
        String string;
        String string2;
        boolean bl;
        String it;
        GitRebaseParams gitRebaseParams;
        String string3;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter(selectedOptions, (String)"selectedOptions");
        Intrinsics.checkNotNullParameter((Object)((Object)autoSquash), (String)"autoSquash");
        this.version = version;
        this.upstream = upstream;
        this.selectedOptions = selectedOptions;
        this.autoSquash = autoSquash;
        this.editorHandler = editorHandler;
        GitRebaseParams gitRebaseParams2 = this;
        String string4 = branch;
        if (string4 != null) {
            String string5 = string3 = string4;
            gitRebaseParams = gitRebaseParams2;
            boolean bl2 = false;
            bl = !StringsKt.isBlank((CharSequence)it);
            gitRebaseParams2 = gitRebaseParams;
            string2 = bl ? string3 : null;
        } else {
            string2 = null;
        }
        gitRebaseParams2.branch = string2;
        GitRebaseParams gitRebaseParams3 = this;
        String string6 = newBase;
        if (string6 != null) {
            it = string3 = string6;
            gitRebaseParams = gitRebaseParams3;
            boolean bl3 = false;
            bl = !StringsKt.isBlank((CharSequence)it);
            gitRebaseParams3 = gitRebaseParams;
            string = bl ? string3 : null;
        } else {
            string = null;
        }
        gitRebaseParams3.newBase = string;
    }

    public /* synthetic */ GitRebaseParams(GitVersion gitVersion, String string, String string2, String string3, Set set, AutoSquashOption autoSquashOption, GitRebaseEditorHandler gitRebaseEditorHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            autoSquashOption = AutoSquashOption.DEFAULT;
        }
        if ((n & 0x40) != 0) {
            gitRebaseEditorHandler = null;
        }
        this(gitVersion, string, string2, string3, set, autoSquashOption, gitRebaseEditorHandler);
    }

    @Nullable
    public final String getUpstream() {
        return this.upstream;
    }

    @Nullable
    public final GitRebaseEditorHandler getEditorHandler() {
        return this.editorHandler;
    }

    @Nullable
    public final String getBranch() {
        return this.branch;
    }

    @Nullable
    public final String getNewBase() {
        return this.newBase;
    }

    public GitRebaseParams(@NotNull GitVersion version, @NotNull String upstream) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
        this(version, null, null, upstream, false, false);
    }

    public GitRebaseParams(@NotNull GitVersion version, @Nullable String branch, @Nullable String newBase, @NotNull String upstream, boolean interactive, boolean preserveMerges) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)upstream, (String)"upstream");
        this(version, branch, newBase, upstream, GitRebaseParams.Companion.collectOptions(interactive, preserveMerges), AutoSquashOption.DEFAULT, null, 64, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> asCommandLineArguments() {
        Object object;
        void $this$forEach$iv;
        void $this$mapNotNullTo$iv$iv;
        List list;
        List $this$asCommandLineArguments_u24lambda_u244 = list = (List)new ArrayList();
        boolean bl = false;
        Iterable $this$mapNotNull$iv = this.selectedOptions;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            GitRebaseOption option = (GitRebaseOption)((Object)element$iv$iv);
            boolean bl3 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[option.ordinal()]) {
                case 1: {
                    string = this.handleRebaseMergesOption();
                    break;
                }
                case 2: {
                    string = null;
                    break;
                }
                default: {
                    string = option.getOption(this.version);
                }
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            String option = (String)element$iv;
            boolean bl5 = false;
            $this$asCommandLineArguments_u24lambda_u244.add(option);
        }
        switch (WhenMappings.$EnumSwitchMapping$1[this.autoSquash.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                $this$asCommandLineArguments_u24lambda_u244.add("--autosquash");
                break;
            }
            case 3: {
                $this$asCommandLineArguments_u24lambda_u244.add("--no-autosquash");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (this.newBase != null) {
            object = new String[]{"--onto", this.newBase};
            $this$asCommandLineArguments_u24lambda_u244.addAll(CollectionsKt.listOf((Object[])object));
        }
        if (!((object = (CharSequence)this.upstream) == null || object.length() == 0)) {
            $this$asCommandLineArguments_u24lambda_u244.add(this.upstream);
        }
        if (this.selectedOptions.contains((Object)GitRebaseOption.ROOT)) {
            object = this.upstream;
            if (object == null || object.length() == 0) {
                $this$asCommandLineArguments_u24lambda_u244.add(GitRebaseOption.ROOT.getOption(this.version));
            } else {
                LOG.error("Git rebase --root option is incompatible with upstream and will be omitted");
            }
        }
        if (this.branch != null) {
            $this$asCommandLineArguments_u24lambda_u244.add(this.branch);
        }
        return list;
    }

    public final boolean isInteractive() {
        return this.selectedOptions.contains((Object)GitRebaseOption.INTERACTIVE);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.asCommandLineArguments(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final String handleRebaseMergesOption() {
        String string;
        if (!this.rebaseMergesAvailable() && this.isInteractive()) {
            LOG.error("Git rebase --preserve-merges option is incompatible with --interactive and will be omitted");
            string = null;
        } else {
            string = GitRebaseOption.REBASE_MERGES.getOption(this.version);
        }
        return string;
    }

    private final boolean rebaseMergesAvailable() {
        return GitVersionSpecialty.REBASE_MERGES_REPLACES_PRESERVE_MERGES.existsIn(this.version);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitRebaseParams.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgit4idea/branch/GitRebaseParams$AutoSquashOption;", "", "<init>", "(Ljava/lang/String;I)V", "DEFAULT", "ENABLE", "DISABLE", "intellij.vcs.git"})
    public static final class AutoSquashOption
    extends Enum<AutoSquashOption> {
        public static final /* enum */ AutoSquashOption DEFAULT = new AutoSquashOption();
        public static final /* enum */ AutoSquashOption ENABLE = new AutoSquashOption();
        public static final /* enum */ AutoSquashOption DISABLE = new AutoSquashOption();
        private static final /* synthetic */ AutoSquashOption[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AutoSquashOption[] values() {
            return (AutoSquashOption[])$VALUES.clone();
        }

        public static AutoSquashOption valueOf(String value) {
            return Enum.valueOf(AutoSquashOption.class, value);
        }

        @NotNull
        public static EnumEntries<AutoSquashOption> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = autoSquashOptionArray = new AutoSquashOption[]{AutoSquashOption.DEFAULT, AutoSquashOption.ENABLE, AutoSquashOption.DISABLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lgit4idea/branch/GitRebaseParams$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "editCommits", "Lgit4idea/branch/GitRebaseParams;", "version", "Lgit4idea/config/GitVersion;", "base", "", "editorHandler", "Lgit4idea/rebase/GitRebaseEditorHandler;", "preserveMerges", "", "autoSquash", "Lgit4idea/branch/GitRebaseParams$AutoSquashOption;", "collectOptions", "", "Lgit4idea/rebase/GitRebaseOption;", "interactive", "rebaseMerges", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final GitRebaseParams editCommits(@NotNull GitVersion version, @NotNull String base, @Nullable GitRebaseEditorHandler editorHandler, boolean preserveMerges, @NotNull AutoSquashOption autoSquash) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            Intrinsics.checkNotNullParameter((Object)((Object)autoSquash), (String)"autoSquash");
            return new GitRebaseParams(version, null, null, base, this.collectOptions(true, preserveMerges), autoSquash, editorHandler);
        }

        public static /* synthetic */ GitRebaseParams editCommits$default(Companion companion, GitVersion gitVersion, String string, GitRebaseEditorHandler gitRebaseEditorHandler, boolean bl, AutoSquashOption autoSquashOption, int n, Object object) {
            if ((n & 0x10) != 0) {
                autoSquashOption = AutoSquashOption.DEFAULT;
            }
            return companion.editCommits(gitVersion, string, gitRebaseEditorHandler, bl, autoSquashOption);
        }

        private final Set<GitRebaseOption> collectOptions(boolean interactive, boolean rebaseMerges) {
            Set set;
            Set $this$collectOptions_u24lambda_u240 = set = (Set)new LinkedHashSet();
            boolean bl = false;
            if (interactive) {
                $this$collectOptions_u24lambda_u240.add(GitRebaseOption.INTERACTIVE);
            }
            if (rebaseMerges) {
                $this$collectOptions_u24lambda_u240.add(GitRebaseOption.REBASE_MERGES);
            }
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[GitRebaseOption.values().length];
            try {
                nArray[GitRebaseOption.REBASE_MERGES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GitRebaseOption.ROOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AutoSquashOption.values().length];
            try {
                nArray[AutoSquashOption.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoSquashOption.ENABLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AutoSquashOption.DISABLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

