/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.community.ide.impl;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.EnvironmentUtil;
import com.intellij.workspaceModel.ide.JpsProjectLoadedListener;
import com.jetbrains.python.sdk.AddInterpreterActions;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.assertj.swing.internal.annotation.InternalApi;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/pycharm/community/ide/impl/PySdkFromEnvironmentVariableConfigurator;", "Lcom/intellij/workspaceModel/ide/JpsProjectLoadedListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "loaded", "", "checkAndSetSdk", "pycharmPythonPathEnvVariable", "", "findByPath", "Lcom/intellij/openapi/projectRoots/Sdk;", "createSdkByPath", "Companion", "intellij.pycharm.community.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPySdkFromEnvironmentVariableConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PySdkFromEnvironmentVariableConfigurator.kt\ncom/intellij/pycharm/community/ide/impl/PySdkFromEnvironmentVariableConfigurator\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,79:1\n37#2,2:80\n13409#3,2:82\n14#4:84\n*S KotlinDebug\n*F\n+ 1 PySdkFromEnvironmentVariableConfigurator.kt\ncom/intellij/pycharm/community/ide/impl/PySdkFromEnvironmentVariableConfigurator\n*L\n63#1:80,2\n51#1:82,2\n24#1:84\n*E\n"})
public final class PySdkFromEnvironmentVariableConfigurator
implements JpsProjectLoadedListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final String PYCHARM_PYTHON_PATH = "PycharmPythonPath";

    public PySdkFromEnvironmentVariableConfigurator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public void loaded() {
        String pycharmPythonPathEnvVariable = Companion.getPycharmPythonPathProperty();
        if (Strings.isEmptyOrSpaces((CharSequence)pycharmPythonPathEnvVariable)) {
            LOGGER.debug("PycharmPythonPath is null or empty");
            return;
        }
        LOGGER.info("Found PycharmPythonPath='" + Companion.getPycharmPythonPathProperty() + "' system property");
        String string = pycharmPythonPathEnvVariable;
        Intrinsics.checkNotNull((Object)string);
        this.checkAndSetSdk(this.project, string);
    }

    private final void checkAndSetSdk(Project project, String pycharmPythonPathEnvVariable) {
        ActionsKt.runInEdt$default(null, () -> PySdkFromEnvironmentVariableConfigurator.checkAndSetSdk$lambda$1(this, pycharmPythonPathEnvVariable, project), (int)1, null);
    }

    private final Sdk findByPath(String pycharmPythonPathEnvVariable) {
        PythonSdkType sdkType = PythonSdkType.getInstance();
        List list = ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)sdkType);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSdksOfType(...)");
        List sdks = list;
        Collection $this$toTypedArray$iv = sdks;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Sdk sdk2 = SdkConfigurationUtil.findByPath((SdkType)((SdkType)sdkType), (Sdk[])thisCollection$iv.toArray(new Sdk[0]), (String)pycharmPythonPathEnvVariable);
        if (sdk2 != null) {
            LOGGER.info("Found a previous sdk");
        }
        return sdk2;
    }

    private final Sdk createSdkByPath(String pycharmPythonPathEnvVariable) {
        Sdk sdk2 = SdkConfigurationUtil.createAndAddSDK((String)pycharmPythonPathEnvVariable, (SdkType)((SdkType)PythonSdkType.getInstance()));
        if (sdk2 != null) {
            LOGGER.info("No suitable sdk found, created a new one");
        }
        return sdk2;
    }

    private static final Unit checkAndSetSdk$lambda$1(PySdkFromEnvironmentVariableConfigurator this$0, String $pycharmPythonPathEnvVariable, Project $project) {
        Sdk sdk2 = this$0.findByPath($pycharmPythonPathEnvVariable);
        if (sdk2 == null && (sdk2 = this$0.createSdkByPath($pycharmPythonPathEnvVariable)) == null) {
            return Unit.INSTANCE;
        }
        Sdk sdk3 = sdk2;
        Sdk projectSdk = ProjectRootManager.getInstance((Project)$project).getProjectSdk();
        Module[] $this$forEach$iv = ModuleManager.Companion.getInstance($project).getModules();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Module element$iv;
            Module it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            Sdk moduleSdk = PythonSdkUtil.findPythonSdk((Module)it);
            Sdk sdk4 = projectSdk;
            if (Intrinsics.areEqual((Object)$pycharmPythonPathEnvVariable, (Object)(sdk4 != null ? sdk4.getHomePath() : null))) {
                Sdk sdk5 = moduleSdk;
                if (Intrinsics.areEqual((Object)$pycharmPythonPathEnvVariable, (Object)(sdk5 != null ? sdk5.getHomePath() : null))) continue;
            }
            AddInterpreterActions.switchToSdk((Module)it, (Sdk)sdk3, (Sdk)moduleSdk);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PySdkFromEnvironmentVariableConfigurator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/pycharm/community/ide/impl/PySdkFromEnvironmentVariableConfigurator$Companion;", "", "<init>", "()V", "LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "PYCHARM_PYTHON_PATH", "", "getPycharmPythonPathProperty", "intellij.pycharm.community.ide.impl"})
    public static final class Companion {
        private Companion() {
        }

        @InternalApi
        @Nullable
        public final String getPycharmPythonPathProperty() {
            String string = System.getProperty(PySdkFromEnvironmentVariableConfigurator.PYCHARM_PYTHON_PATH);
            if (string == null) {
                string = EnvironmentUtil.getValue((String)"PYCHARM_PYTHON_PATH");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

