/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.sockets;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SocketUtils {
    private static final Logger LOG = Logger.getInstance(SocketUtils.class);

    private SocketUtils() {
    }

    public static boolean shouldPatchSocketsOnMacForIPv6(String host) {
        if (!SocketUtils.systemIsPatchable()) {
            return false;
        }
        try {
            boolean result;
            InetAddress address = InetAddress.getByName(host);
            boolean bl = result = address instanceof Inet6Address && !StringUtil.isEmptyOrSpaces((String)SocketUtils.getBannedInterfaces());
            if (result) {
                LOG.debug("Socket patching needed for " + host);
            }
            return result;
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static boolean systemIsPatchable() {
        return SystemInfo.isMac;
    }

    public static InetAddress getProperAddressIfNeeded(@NotNull InetAddress inetAddress) throws SocketException, UnknownHostException {
        NetworkInterface networkInterface;
        if (inetAddress == null) {
            SocketUtils.$$$reportNull$$$0(0);
        }
        if (SocketUtils.systemIsPatchable() && inetAddress instanceof Inet6Address && (networkInterface = SocketUtils.findProperIpv6HostNetworkInterface()) != null) {
            return SocketUtils.createAddressForInterface(networkInterface, (Inet6Address)inetAddress);
        }
        return null;
    }

    @Nullable
    public static NetworkInterface findProperIpv6HostNetworkInterface() throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        String bannedInterfaces = SocketUtils.getBannedInterfaces();
        NetworkInterface linkLocalInterface = null;
        NetworkInterface loopbackInterface = null;
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (bannedInterfaces.contains(networkInterface.getName())) continue;
            if (!networkInterface.isUp()) {
                LOG.debug("Interface " + networkInterface + " is down ");
                continue;
            }
            for (InterfaceAddress address : networkInterface.getInterfaceAddresses()) {
                InetAddress inetAddress = address.getAddress();
                if (!(inetAddress instanceof Inet6Address)) continue;
                if (networkInterface.isLoopback()) {
                    loopbackInterface = networkInterface;
                    break;
                }
                if (!inetAddress.isLinkLocalAddress()) {
                    LOG.debug("Using interface " + networkInterface);
                    return networkInterface;
                }
                if (linkLocalInterface != null) continue;
                linkLocalInterface = networkInterface;
            }
            LOG.debug("No ipv6 addresses for " + networkInterface);
        }
        if (linkLocalInterface != null) {
            LOG.debug("Using link-local interface " + linkLocalInterface);
            return linkLocalInterface;
        }
        if (loopbackInterface != null) {
            LOG.debug("Using loopback interface " + loopbackInterface);
            return loopbackInterface;
        }
        return null;
    }

    @NotNull
    private static InetAddress createAddressForInterface(@NotNull NetworkInterface anInterface, Inet6Address address) throws UnknownHostException {
        if (anInterface == null) {
            SocketUtils.$$$reportNull$$$0(1);
        }
        Inet6Address inet6Address = Inet6Address.getByAddress(address.getHostAddress(), address.getAddress(), anInterface.getIndex());
        if (inet6Address == null) {
            SocketUtils.$$$reportNull$$$0(2);
        }
        return inet6Address;
    }

    @NotNull
    private static String getBannedInterfaces() {
        String string = Registry.get((String)"deployment.macOs.bannedInterfaces").asString();
        if (string == null) {
            SocketUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inetAddress";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anInterface";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/sockets/SocketUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/sockets/SocketUtils";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddressForInterface";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBannedInterfaces";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProperAddressIfNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createAddressForInterface";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

