/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.foundation.layout.PaddingKt;
import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.foundation.shape.CornerSize;
import androidx.compose.foundation.shape.CornerSizeKt;
import androidx.compose.foundation.shape.RoundedCornerShapeKt;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.text.TextStyle;
import androidx.compose.ui.text.font.FontFamily;
import androidx.compose.ui.text.platform.AwtFontInteropKt;
import androidx.compose.ui.unit.Dp;
import androidx.compose.ui.unit.DpKt;
import androidx.compose.ui.unit.DpSize;
import androidx.compose.ui.unit.TextUnit;
import androidx.compose.ui.unit.TextUnitKt;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.ide.ui.laf.intellij.IdeaPopupMenuUI;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.DirProvider;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.NamedColorUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.BridgeIconDataKt;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.bridge.theme.BridgeCheckboxMetrics;
import org.jetbrains.jewel.bridge.theme.BridgeGlobalColorsKt;
import org.jetbrains.jewel.bridge.theme.BridgeGlobalMetricsKt;
import org.jetbrains.jewel.bridge.theme.BridgeRadioButtonMetrics;
import org.jetbrains.jewel.bridge.theme.BridgeSliderStylingKt;
import org.jetbrains.jewel.bridge.theme.BridgeThemeColorPaletteKt;
import org.jetbrains.jewel.bridge.theme.ClassicUiCheckboxMetrics;
import org.jetbrains.jewel.bridge.theme.ClassicUiRadioButtonMetrics;
import org.jetbrains.jewel.bridge.theme.NewUiCheckboxMetrics;
import org.jetbrains.jewel.bridge.theme.NewUiRadioButtonMetrics;
import org.jetbrains.jewel.bridge.theme.ScrollbarBridgeKt;
import org.jetbrains.jewel.foundation.GlobalColors;
import org.jetbrains.jewel.foundation.GlobalMetrics;
import org.jetbrains.jewel.foundation.Stroke;
import org.jetbrains.jewel.foundation.theme.ThemeColorPalette;
import org.jetbrains.jewel.foundation.theme.ThemeDefinition;
import org.jetbrains.jewel.foundation.theme.ThemeIconData;
import org.jetbrains.jewel.foundation.util.JewelLogger;
import org.jetbrains.jewel.ui.ComponentStyling;
import org.jetbrains.jewel.ui.DefaultComponentStyling;
import org.jetbrains.jewel.ui.component.styling.ButtonColors;
import org.jetbrains.jewel.ui.component.styling.ButtonMetrics;
import org.jetbrains.jewel.ui.component.styling.ButtonStyle;
import org.jetbrains.jewel.ui.component.styling.CheckboxColors;
import org.jetbrains.jewel.ui.component.styling.CheckboxIcons;
import org.jetbrains.jewel.ui.component.styling.CheckboxMetrics;
import org.jetbrains.jewel.ui.component.styling.CheckboxStyle;
import org.jetbrains.jewel.ui.component.styling.ChipColors;
import org.jetbrains.jewel.ui.component.styling.ChipMetrics;
import org.jetbrains.jewel.ui.component.styling.ChipStyle;
import org.jetbrains.jewel.ui.component.styling.CircularProgressStyle;
import org.jetbrains.jewel.ui.component.styling.DividerMetrics;
import org.jetbrains.jewel.ui.component.styling.DividerStyle;
import org.jetbrains.jewel.ui.component.styling.DropdownColors;
import org.jetbrains.jewel.ui.component.styling.DropdownIcons;
import org.jetbrains.jewel.ui.component.styling.DropdownMetrics;
import org.jetbrains.jewel.ui.component.styling.DropdownStyle;
import org.jetbrains.jewel.ui.component.styling.GroupHeaderColors;
import org.jetbrains.jewel.ui.component.styling.GroupHeaderMetrics;
import org.jetbrains.jewel.ui.component.styling.GroupHeaderStyle;
import org.jetbrains.jewel.ui.component.styling.HorizontalProgressBarColors;
import org.jetbrains.jewel.ui.component.styling.HorizontalProgressBarMetrics;
import org.jetbrains.jewel.ui.component.styling.HorizontalProgressBarStyle;
import org.jetbrains.jewel.ui.component.styling.IconButtonColors;
import org.jetbrains.jewel.ui.component.styling.IconButtonMetrics;
import org.jetbrains.jewel.ui.component.styling.IconButtonStyle;
import org.jetbrains.jewel.ui.component.styling.LazyTreeColors;
import org.jetbrains.jewel.ui.component.styling.LazyTreeIcons;
import org.jetbrains.jewel.ui.component.styling.LazyTreeMetrics;
import org.jetbrains.jewel.ui.component.styling.LazyTreeStyle;
import org.jetbrains.jewel.ui.component.styling.LinkColors;
import org.jetbrains.jewel.ui.component.styling.LinkIcons;
import org.jetbrains.jewel.ui.component.styling.LinkMetrics;
import org.jetbrains.jewel.ui.component.styling.LinkStyle;
import org.jetbrains.jewel.ui.component.styling.LinkUnderlineBehavior;
import org.jetbrains.jewel.ui.component.styling.MenuColors;
import org.jetbrains.jewel.ui.component.styling.MenuIcons;
import org.jetbrains.jewel.ui.component.styling.MenuItemColors;
import org.jetbrains.jewel.ui.component.styling.MenuItemMetrics;
import org.jetbrains.jewel.ui.component.styling.MenuMetrics;
import org.jetbrains.jewel.ui.component.styling.MenuStyle;
import org.jetbrains.jewel.ui.component.styling.RadioButtonColors;
import org.jetbrains.jewel.ui.component.styling.RadioButtonIcons;
import org.jetbrains.jewel.ui.component.styling.RadioButtonMetrics;
import org.jetbrains.jewel.ui.component.styling.RadioButtonStyle;
import org.jetbrains.jewel.ui.component.styling.ScrollbarStyle;
import org.jetbrains.jewel.ui.component.styling.SegmentedControlButtonColors;
import org.jetbrains.jewel.ui.component.styling.SegmentedControlButtonMetrics;
import org.jetbrains.jewel.ui.component.styling.SegmentedControlButtonStyle;
import org.jetbrains.jewel.ui.component.styling.SegmentedControlColors;
import org.jetbrains.jewel.ui.component.styling.SegmentedControlMetrics;
import org.jetbrains.jewel.ui.component.styling.SegmentedControlStyle;
import org.jetbrains.jewel.ui.component.styling.SliderColors;
import org.jetbrains.jewel.ui.component.styling.SliderMetrics;
import org.jetbrains.jewel.ui.component.styling.SliderStyle;
import org.jetbrains.jewel.ui.component.styling.SubmenuMetrics;
import org.jetbrains.jewel.ui.component.styling.TabColors;
import org.jetbrains.jewel.ui.component.styling.TabContentAlpha;
import org.jetbrains.jewel.ui.component.styling.TabIcons;
import org.jetbrains.jewel.ui.component.styling.TabMetrics;
import org.jetbrains.jewel.ui.component.styling.TabStyle;
import org.jetbrains.jewel.ui.component.styling.TextAreaColors;
import org.jetbrains.jewel.ui.component.styling.TextAreaMetrics;
import org.jetbrains.jewel.ui.component.styling.TextAreaStyle;
import org.jetbrains.jewel.ui.component.styling.TextFieldColors;
import org.jetbrains.jewel.ui.component.styling.TextFieldMetrics;
import org.jetbrains.jewel.ui.component.styling.TextFieldStyle;
import org.jetbrains.jewel.ui.component.styling.TooltipColors;
import org.jetbrains.jewel.ui.component.styling.TooltipMetrics;
import org.jetbrains.jewel.ui.component.styling.TooltipStyle;
import org.jetbrains.jewel.ui.icon.PathIconKey;
import org.jetbrains.jewel.ui.icons.AllIconsKeys;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u00c6\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u000b\u001a\u00020\fH\u0000\u001a\u0006\u0010\r\u001a\u00020\u000e\u001a\u0006\u0010\u000f\u001a\u00020\u000e\u001a\u0006\u0010\u0010\u001a\u00020\u000e\u001a \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0000\u001a\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\fH\u0000\u001a\b\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\b\u0010\u001c\u001a\u00020\u001bH\u0002\u001a\b\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\b\u0010\u001f\u001a\u00020 H\u0002\u001a\b\u0010!\u001a\u00020\"H\u0002\u001a\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002\u001a\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002\u001a\b\u0010(\u001a\u00020)H\u0002\u001a\b\u0010*\u001a\u00020+H\u0002\u001a\b\u0010,\u001a\u00020-H\u0002\u001a\b\u0010.\u001a\u00020&H\u0002\u001a\b\u0010/\u001a\u000200H\u0002\u001a\b\u00101\u001a\u000202H\u0002\u001a\b\u00103\u001a\u000204H\u0002\u001a\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0012H\u0002\u001a\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002\u001a\b\u0010<\u001a\u00020=H\u0002\u001a\b\u0010>\u001a\u00020?H\u0002\u001a\b\u0010@\u001a\u00020AH\u0002\u001a\b\u0010B\u001a\u00020AH\u0002\u001a\u0010\u0010C\u001a\u00020D2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\b\u0010E\u001a\u00020FH\u0002\u001a\b\u0010G\u001a\u00020HH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\"\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\"\u0014\u0010I\u001a\u00020J8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006M"}, d2={"logger", "Lorg/jetbrains/jewel/foundation/util/JewelLogger;", "uiDefaults", "Ljavax/swing/UIDefaults;", "kotlin.jvm.PlatformType", "getUiDefaults", "()Ljavax/swing/UIDefaults;", "iconsBasePath", "", "getIconsBasePath", "()Ljava/lang/String;", "createBridgeThemeDefinition", "Lorg/jetbrains/jewel/foundation/theme/ThemeDefinition;", "retrieveDefaultTextStyle", "Landroidx/compose/ui/text/TextStyle;", "retrieveEditorTextStyle", "retrieveConsoleTextStyle", "isDark", "", "()Z", "textStyle", "editorTextStyle", "consoleTextStyle", "createBridgeComponentStyling", "Lorg/jetbrains/jewel/ui/ComponentStyling;", "theme", "readDefaultButtonStyle", "Lorg/jetbrains/jewel/ui/component/styling/ButtonStyle;", "readOutlinedButtonStyle", "readCheckboxStyle", "Lorg/jetbrains/jewel/ui/component/styling/CheckboxStyle;", "readChipStyle", "Lorg/jetbrains/jewel/ui/component/styling/ChipStyle;", "readDividerStyle", "Lorg/jetbrains/jewel/ui/component/styling/DividerStyle;", "readDefaultDropdownStyle", "Lorg/jetbrains/jewel/ui/component/styling/DropdownStyle;", "menuStyle", "Lorg/jetbrains/jewel/ui/component/styling/MenuStyle;", "readUndecoratedDropdownStyle", "readGroupHeaderStyle", "Lorg/jetbrains/jewel/ui/component/styling/GroupHeaderStyle;", "readHorizontalProgressBarStyle", "Lorg/jetbrains/jewel/ui/component/styling/HorizontalProgressBarStyle;", "readLinkStyle", "Lorg/jetbrains/jewel/ui/component/styling/LinkStyle;", "readMenuStyle", "readRadioButtonStyle", "Lorg/jetbrains/jewel/ui/component/styling/RadioButtonStyle;", "readSegmentedControlButtonStyle", "Lorg/jetbrains/jewel/ui/component/styling/SegmentedControlButtonStyle;", "readSegmentedControlStyle", "Lorg/jetbrains/jewel/ui/component/styling/SegmentedControlStyle;", "readSliderStyle", "Lorg/jetbrains/jewel/ui/component/styling/SliderStyle;", "dark", "readTextAreaStyle", "Lorg/jetbrains/jewel/ui/component/styling/TextAreaStyle;", "metrics", "Lorg/jetbrains/jewel/ui/component/styling/TextFieldMetrics;", "readTextFieldStyle", "Lorg/jetbrains/jewel/ui/component/styling/TextFieldStyle;", "readLazyTreeStyle", "Lorg/jetbrains/jewel/ui/component/styling/LazyTreeStyle;", "readDefaultTabStyle", "Lorg/jetbrains/jewel/ui/component/styling/TabStyle;", "readEditorTabStyle", "readCircularProgressStyle", "Lorg/jetbrains/jewel/ui/component/styling/CircularProgressStyle;", "readTooltipStyle", "Lorg/jetbrains/jewel/ui/component/styling/TooltipStyle;", "readIconButtonStyle", "Lorg/jetbrains/jewel/ui/component/styling/IconButtonStyle;", "componentArc", "Landroidx/compose/foundation/shape/CornerSize;", "getComponentArc", "()Landroidx/compose/foundation/shape/CornerSize;", "ide-laf-bridge"})
@SourceDebugExtension(value={"SMAP\nIntUiBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntUiBridge.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeKt\n+ 2 TextUnit.kt\nandroidx/compose/ui/unit/TextUnit\n+ 3 Dp.kt\nandroidx/compose/ui/unit/DpKt\n+ 4 Dp.kt\nandroidx/compose/ui/unit/Dp\n+ 5 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1191:1\n147#2,2:1192\n147#2,2:1194\n149#3:1196\n149#3:1197\n159#3:1198\n149#3:1200\n125#3:1201\n149#3:1202\n149#3:1203\n149#3:1204\n149#3:1205\n149#3:1208\n149#3:1209\n149#3:1210\n149#3:1211\n149#3:1212\n149#3:1213\n149#3:1224\n149#3:1225\n149#3:1226\n149#3:1229\n149#3:1230\n149#3:1231\n149#3:1232\n139#3:1233\n125#3:1234\n149#3:1235\n149#3:1237\n149#3:1238\n149#3:1239\n139#3:1240\n125#3:1241\n149#3:1242\n139#3:1243\n125#3:1244\n149#3:1245\n139#3:1246\n125#3:1247\n149#3:1248\n139#3:1249\n125#3:1250\n149#3:1251\n149#3:1252\n149#3:1253\n149#3:1254\n139#3:1255\n125#3:1256\n139#3:1258\n125#3:1259\n149#3:1261\n149#3:1263\n149#3:1264\n149#3:1266\n139#3:1267\n125#3:1268\n149#3:1269\n139#3:1270\n125#3:1271\n149#3:1272\n149#3:1275\n149#3:1276\n139#3:1277\n125#3:1278\n149#3:1279\n149#3:1280\n139#3:1281\n125#3:1282\n149#3:1283\n149#3:1284\n149#3:1285\n139#3:1286\n125#3:1287\n149#3:1288\n139#3:1289\n125#3:1290\n149#3:1291\n149#3:1292\n149#3:1293\n139#3:1294\n125#3:1295\n149#3:1296\n149#3:1300\n149#3:1301\n149#3:1302\n72#4:1199\n51#4:1206\n51#4:1207\n72#4:1236\n72#4:1260\n72#4:1262\n51#4:1265\n51#4:1273\n72#4:1274\n72#4:1299\n72#4:1303\n708#5:1214\n696#5:1215\n708#5:1216\n696#5:1217\n708#5:1218\n696#5:1219\n708#5:1220\n696#5:1221\n708#5:1222\n696#5:1223\n708#5:1227\n696#5:1228\n708#5:1297\n696#5:1298\n1#6:1257\n*S KotlinDebug\n*F\n+ 1 IntUiBridge.kt\norg/jetbrains/jewel/bridge/theme/IntUiBridgeKt\n*L\n155#1:1192,2\n175#1:1194,2\n280#1:1196\n282#1:1197\n283#1:1198\n331#1:1200\n359#1:1201\n480#1:1202\n481#1:1203\n482#1:1204\n483#1:1205\n577#1:1208\n579#1:1209\n591#1:1210\n592#1:1211\n608#1:1212\n612#1:1213\n652#1:1224\n654#1:1225\n655#1:1226\n712#1:1229\n713#1:1230\n714#1:1231\n715#1:1232\n716#1:1233\n716#1:1234\n716#1:1235\n720#1:1237\n721#1:1238\n722#1:1239\n726#1:1240\n726#1:1241\n726#1:1242\n728#1:1243\n728#1:1244\n728#1:1245\n731#1:1246\n731#1:1247\n731#1:1248\n732#1:1249\n732#1:1250\n732#1:1251\n733#1:1252\n734#1:1253\n736#1:1254\n764#1:1255\n764#1:1256\n779#1:1258\n779#1:1259\n854#1:1261\n933#1:1263\n978#1:1264\n979#1:1266\n1002#1:1267\n1002#1:1268\n1002#1:1269\n1003#1:1270\n1003#1:1271\n1003#1:1272\n1011#1:1275\n1012#1:1276\n1013#1:1277\n1013#1:1278\n1013#1:1279\n1014#1:1280\n1056#1:1281\n1056#1:1282\n1056#1:1283\n1058#1:1284\n1059#1:1285\n1060#1:1286\n1060#1:1287\n1060#1:1288\n1109#1:1289\n1109#1:1290\n1109#1:1291\n1111#1:1292\n1112#1:1293\n1113#1:1294\n1113#1:1295\n1113#1:1296\n1165#1:1300\n1166#1:1301\n1167#1:1302\n330#1:1199\n528#1:1206\n575#1:1207\n719#1:1236\n853#1:1260\n882#1:1262\n978#1:1265\n1009#1:1273\n1010#1:1274\n1164#1:1299\n1190#1:1303\n619#1:1214\n619#1:1215\n627#1:1216\n627#1:1217\n632#1:1218\n632#1:1219\n636#1:1220\n636#1:1221\n640#1:1222\n640#1:1223\n676#1:1227\n676#1:1228\n1137#1:1297\n1137#1:1298\n*E\n"})
public final class IntUiBridgeKt {
    @NotNull
    private static final JewelLogger logger = JewelLogger.Companion.getInstance("JewelIntUiBridge");

    public static final UIDefaults getUiDefaults() {
        return UIManager.getDefaults();
    }

    private static final String getIconsBasePath() {
        return new DirProvider().dir();
    }

    @NotNull
    public static final ThemeDefinition createBridgeThemeDefinition() {
        TextStyle textStyle = IntUiBridgeKt.retrieveDefaultTextStyle();
        TextStyle editorTextStyle = IntUiBridgeKt.retrieveEditorTextStyle();
        TextStyle consoleTextStyle = IntUiBridgeKt.retrieveConsoleTextStyle();
        return IntUiBridgeKt.createBridgeThemeDefinition(textStyle, editorTextStyle, consoleTextStyle);
    }

    @NotNull
    public static final TextStyle retrieveDefaultTextStyle() {
        return BridgeUtilsKt.retrieveTextStyle-tD9LlGs$default("Label.font", "Label.foreground", 0L, false, 0, 0L, 60, null);
    }

    @NotNull
    public static final TextStyle retrieveEditorTextStyle() {
        EditorColorsScheme editorColorScheme = BridgeUtilsKt.retrieveEditorColorScheme();
        long fontSize = TextUnitKt.getSp(editorColorScheme.getEditorFontSize());
        TextStyle textStyle = IntUiBridgeKt.retrieveDefaultTextStyle();
        java.awt.Color color = editorColorScheme.getDefaultForeground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getDefaultForeground(...)");
        long l = BridgeUtilsKt.toComposeColor(color);
        Font font2 = editorColorScheme.getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"getFont(...)");
        FontFamily fontFamily = AwtFontInteropKt.asComposeFontFamily(font2);
        float other$iv = editorColorScheme.getLineSpacing();
        boolean bl = false;
        TextUnitKt.checkArithmetic--R2X_6o(fontSize);
        long l2 = TextUnitKt.pack(TextUnit.getRawType-impl(fontSize), TextUnit.getValue-impl(fontSize) * other$iv);
        String string2 = !editorColorScheme.isUseLigatures() ? "liga 0" : "liga 1";
        return TextStyle.copy-p1EtxEg$default(textStyle, l, fontSize, null, null, null, fontFamily, string2, 0L, null, null, null, 0L, null, null, null, 0, 0, l2, null, null, null, 0, 0, null, 16646044, null);
    }

    @NotNull
    public static final TextStyle retrieveConsoleTextStyle() {
        EditorColorsScheme editorColorScheme = BridgeUtilsKt.retrieveEditorColorScheme();
        if (editorColorScheme.isUseEditorFontPreferencesInConsole()) {
            return IntUiBridgeKt.retrieveEditorTextStyle();
        }
        long fontSize = TextUnitKt.getSp(editorColorScheme.getConsoleFontSize());
        java.awt.Color color = editorColorScheme.getColor(ColorKey.createColorKey((String)"BLOCK_TERMINAL_DEFAULT_FOREGROUND"));
        if (color == null) {
            java.awt.Color color2 = editorColorScheme.getDefaultForeground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getDefaultForeground(...)");
        }
        java.awt.Color fontColor = color;
        TextStyle textStyle = IntUiBridgeKt.retrieveDefaultTextStyle();
        long l = BridgeUtilsKt.toComposeColor(fontColor);
        Font font2 = editorColorScheme.getFont(EditorFontType.CONSOLE_PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"getFont(...)");
        FontFamily fontFamily = AwtFontInteropKt.asComposeFontFamily(font2);
        float other$iv = editorColorScheme.getLineSpacing();
        boolean bl = false;
        TextUnitKt.checkArithmetic--R2X_6o(fontSize);
        long l2 = TextUnitKt.pack(TextUnit.getRawType-impl(fontSize), TextUnit.getValue-impl(fontSize) * other$iv);
        String string2 = !editorColorScheme.isUseLigatures() ? "liga 0" : "liga 1";
        return TextStyle.copy-p1EtxEg$default(textStyle, l, fontSize, null, null, null, fontFamily, string2, 0L, null, null, null, 0L, null, null, null, 0, 0, l2, null, null, null, 0, 0, null, 16646044, null);
    }

    private static final boolean isDark() {
        return !JBColor.isBright();
    }

    @NotNull
    public static final ThemeDefinition createBridgeThemeDefinition(@NotNull TextStyle textStyle, @NotNull TextStyle editorTextStyle, @NotNull TextStyle consoleTextStyle) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)editorTextStyle, (String)"editorTextStyle");
        Intrinsics.checkNotNullParameter((Object)consoleTextStyle, (String)"consoleTextStyle");
        logger.debug("Obtaining theme definition from Swing...");
        String string2 = BridgeUtilsKt.lafName();
        boolean bl = IntUiBridgeKt.isDark();
        GlobalColors globalColors = BridgeGlobalColorsKt.readFromLaF(GlobalColors.Companion);
        GlobalMetrics globalMetrics = BridgeGlobalMetricsKt.readFromLaF(GlobalMetrics.Companion);
        java.awt.Color color = JBColor.foreground();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"foreground(...)");
        return new ThemeDefinition(string2, bl, globalColors, globalMetrics, textStyle, editorTextStyle, consoleTextStyle, BridgeUtilsKt.toComposeColor(color), BridgeThemeColorPaletteKt.readFromLaF(ThemeColorPalette.Companion), BridgeIconDataKt.readFromLaF(ThemeIconData.Companion), null);
    }

    @NotNull
    public static final ComponentStyling createBridgeComponentStyling(@NotNull ThemeDefinition theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        logger.debug("Obtaining Int UI component styling from Swing...");
        TextFieldStyle textFieldStyle = IntUiBridgeKt.readTextFieldStyle();
        MenuStyle menuStyle = IntUiBridgeKt.readMenuStyle();
        return new DefaultComponentStyling(IntUiBridgeKt.readCheckboxStyle(), IntUiBridgeKt.readChipStyle(), IntUiBridgeKt.readCircularProgressStyle(theme.isDark()), IntUiBridgeKt.readDefaultButtonStyle(), IntUiBridgeKt.readDefaultDropdownStyle(menuStyle), IntUiBridgeKt.readDefaultTabStyle(), IntUiBridgeKt.readDividerStyle(), IntUiBridgeKt.readEditorTabStyle(), IntUiBridgeKt.readGroupHeaderStyle(), IntUiBridgeKt.readHorizontalProgressBarStyle(), IntUiBridgeKt.readIconButtonStyle(), IntUiBridgeKt.readLazyTreeStyle(), IntUiBridgeKt.readLinkStyle(), menuStyle, IntUiBridgeKt.readOutlinedButtonStyle(), IntUiBridgeKt.readRadioButtonStyle(), ScrollbarBridgeKt.readScrollbarStyle(theme.isDark()), IntUiBridgeKt.readSegmentedControlButtonStyle(), IntUiBridgeKt.readSegmentedControlStyle(), IntUiBridgeKt.readSliderStyle(theme.isDark()), IntUiBridgeKt.readTextAreaStyle(textFieldStyle.getMetrics()), textFieldStyle, IntUiBridgeKt.readTooltipStyle(), IntUiBridgeKt.readUndecoratedDropdownStyle(menuStyle));
    }

    private static final ButtonStyle readDefaultButtonStyle() {
        Object[] objectArray = new Color[2];
        java.awt.Color color = JBUI.CurrentTheme.Button.defaultButtonColorStart();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"defaultButtonColorStart(...)");
        objectArray[0] = Color.box-impl(BridgeUtilsKt.toComposeColor(color));
        java.awt.Color color2 = JBUI.CurrentTheme.Button.defaultButtonColorEnd();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"defaultButtonColorEnd(...)");
        objectArray[1] = Color.box-impl(BridgeUtilsKt.toComposeColor(color2));
        Brush normalBackground = BridgeUtilsKt.createVerticalBrush-8A-3gB4$default(CollectionsKt.listOf((Object[])objectArray), 0.0f, 0.0f, 0, 7, null);
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("Button.default.foreground");
        Object[] objectArray2 = new Color[2];
        java.awt.Color color3 = JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"buttonOutlineColorStart(...)");
        objectArray2[0] = Color.box-impl(BridgeUtilsKt.toComposeColor(color3));
        java.awt.Color color4 = JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"buttonOutlineColorEnd(...)");
        objectArray2[1] = Color.box-impl(BridgeUtilsKt.toComposeColor(color4));
        Brush normalBorder = BridgeUtilsKt.createVerticalBrush-8A-3gB4$default(CollectionsKt.listOf((Object[])objectArray2), 0.0f, 0.0f, 0, 7, null);
        Brush brush = new SolidColor(Color.Companion.getTransparent-0d7_KjU(), null);
        long l = BridgeUtilsKt.retrieveColorOrUnspecified("Button.disabledText");
        java.awt.Color color5 = JBUI.CurrentTheme.Button.disabledOutlineColor();
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"disabledOutlineColor(...)");
        ButtonColors colors = new ButtonColors(normalBackground, brush, normalBackground, normalBackground, normalBackground, normalContent, l, normalContent, normalContent, normalContent, normalBorder, new SolidColor(BridgeUtilsKt.toComposeColor(color5), null), new SolidColor(BridgeUtilsKt.retrieveColorOrUnspecified("Button.default.focusedBorderColor"), null), normalBorder, normalBorder, null);
        Dimension dimension = JBUI.CurrentTheme.Button.minimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"minimumSize(...)");
        long minimumSize = BridgeUtilsKt.toDpSize(dimension);
        String[] stringArray = new String[]{"Button.default.arc", "Button.arc"};
        int $this$dp$iv = 14;
        boolean $i$f$getDp = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-YgX7TsA$default(Dp.constructor-impl($this$dp$iv), 0.0f, 2, null);
        $this$dp$iv = 1;
        $i$f$getDp = false;
        double $this$dp$iv2 = 1.5;
        boolean $i$f$getDp2 = false;
        return new ButtonStyle(colors, new ButtonMetrics(BridgeUtilsKt.retrieveArcAsCornerSizeWithFallbacks(stringArray), paddingValues, DpKt.DpSize-YgX7TsA(DpSize.getWidth-D9Ej5fM(minimumSize), DpSize.getHeight-D9Ej5fM(minimumSize)), Dp.constructor-impl($this$dp$iv), Dp.constructor-impl((float)$this$dp$iv2), null), Stroke.Alignment.Center);
    }

    /*
     * WARNING - void declaration
     */
    private static final ButtonStyle readOutlinedButtonStyle() {
        void arg0$iv;
        Object[] objectArray = new Color[2];
        java.awt.Color color = JBUI.CurrentTheme.Button.buttonColorStart();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"buttonColorStart(...)");
        objectArray[0] = Color.box-impl(BridgeUtilsKt.toComposeColor(color));
        java.awt.Color color2 = JBUI.CurrentTheme.Button.buttonColorEnd();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"buttonColorEnd(...)");
        objectArray[1] = Color.box-impl(BridgeUtilsKt.toComposeColor(color2));
        Brush normalBackground = BridgeUtilsKt.createVerticalBrush-8A-3gB4$default(CollectionsKt.listOf((Object[])objectArray), 0.0f, 0.0f, 0, 7, null);
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("Button.foreground");
        Object[] objectArray2 = new Color[2];
        java.awt.Color color3 = JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"buttonOutlineColorStart(...)");
        objectArray2[0] = Color.box-impl(BridgeUtilsKt.toComposeColor(color3));
        java.awt.Color color4 = JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"buttonOutlineColorEnd(...)");
        objectArray2[1] = Color.box-impl(BridgeUtilsKt.toComposeColor(color4));
        Brush normalBorder = BridgeUtilsKt.createVerticalBrush-8A-3gB4$default(CollectionsKt.listOf((Object[])objectArray2), 0.0f, 0.0f, 0, 7, null);
        Brush brush = new SolidColor(Color.Companion.getTransparent-0d7_KjU(), null);
        long l = BridgeUtilsKt.retrieveColorOrUnspecified("Button.disabledText");
        java.awt.Color color5 = JBUI.CurrentTheme.Button.disabledOutlineColor();
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"disabledOutlineColor(...)");
        Brush brush2 = new SolidColor(BridgeUtilsKt.toComposeColor(color5), null);
        java.awt.Color color6 = JBUI.CurrentTheme.Button.focusBorderColor((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"focusBorderColor(...)");
        ButtonColors colors = new ButtonColors(normalBackground, brush, normalBackground, normalBackground, normalBackground, normalContent, l, normalContent, normalContent, normalContent, normalBorder, brush2, new SolidColor(BridgeUtilsKt.toComposeColor(color6), null), normalBorder, normalBorder, null);
        Dimension dimension = JBUI.CurrentTheme.Button.minimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"minimumSize(...)");
        long minimumSize = BridgeUtilsKt.toDpSize(dimension);
        JBValue jBValue = DarculaUIUtil.BUTTON_ARC;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"BUTTON_ARC");
        float f = BridgeUtilsKt.getDp(jBValue);
        int other$iv = 2;
        boolean bl = false;
        CornerSize cornerSize = CornerSizeKt.CornerSize-0680j_4(Dp.constructor-impl((float)(arg0$iv / (float)other$iv)));
        int $this$dp$iv = 14;
        boolean $i$f$getDp = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-YgX7TsA$default(Dp.constructor-impl($this$dp$iv), 0.0f, 2, null);
        long l2 = DpKt.DpSize-YgX7TsA(DpSize.getWidth-D9Ej5fM(minimumSize), DpSize.getHeight-D9Ej5fM(minimumSize));
        JBValue jBValue2 = DarculaUIUtil.LW;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue2, (String)"LW");
        return new ButtonStyle(colors, new ButtonMetrics(cornerSize, paddingValues, l2, BridgeUtilsKt.getDp(jBValue2), Dp.Companion.getUnspecified-D9Ej5fM(), null), Stroke.Alignment.Center);
    }

    private static final CheckboxStyle readCheckboxStyle() {
        long textColor = BridgeUtilsKt.retrieveColorOrUnspecified("CheckBox.foreground");
        CheckboxColors colors = new CheckboxColors(textColor, BridgeUtilsKt.retrieveColorOrUnspecified("CheckBox.disabledText"), textColor, null);
        boolean newUiTheme = BridgeUtilsKt.isNewUiTheme();
        BridgeCheckboxMetrics metrics = newUiTheme ? (BridgeCheckboxMetrics)NewUiCheckboxMetrics.INSTANCE : (BridgeCheckboxMetrics)ClassicUiCheckboxMetrics.INSTANCE;
        float it = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("CheckBox.iconSize");
        boolean bl = false;
        float $this$isSpecified$iv = it;
        boolean bl2 = false;
        long checkboxSize = !Float.isNaN($this$isSpecified$iv) ? DpKt.DpSize-YgX7TsA(it, it) : metrics.getCheckboxSize-MYxV2XQ();
        CornerSize cornerSize = CornerSizeKt.CornerSize-0680j_4(metrics.getOutlineCornerSize-D9Ej5fM());
        CornerSize cornerSize2 = CornerSizeKt.CornerSize-0680j_4(metrics.getOutlineFocusedCornerSize-D9Ej5fM());
        CornerSize cornerSize3 = CornerSizeKt.CornerSize-0680j_4(metrics.getOutlineSelectedCornerSize-D9Ej5fM());
        CornerSize cornerSize4 = CornerSizeKt.CornerSize-0680j_4(metrics.getOutlineSelectedFocusedCornerSize-D9Ej5fM());
        long l = metrics.getOutlineSize-MYxV2XQ();
        long l2 = metrics.getOutlineSelectedSize-MYxV2XQ();
        long l3 = metrics.getOutlineFocusedSize-MYxV2XQ();
        long l4 = metrics.getOutlineSelectedFocusedSize-MYxV2XQ();
        float f = metrics.getIconContentGap-D9Ej5fM();
        return new CheckboxStyle(colors, new CheckboxMetrics(checkboxSize, cornerSize, cornerSize2, cornerSize3, cornerSize4, l, l3, l2, l4, f, null), new CheckboxIcons(new PathIconKey(IntUiBridgeKt.getIconsBasePath() + "checkBox.svg", CheckboxIcons.class)));
    }

    private static final ChipStyle readChipStyle() {
        String[] stringArray = new String[]{"Button.startBackground", "Button.endBackground"};
        Brush normalBackground = BridgeUtilsKt.createVerticalBrush-8A-3gB4$default(BridgeUtilsKt.retrieveColorsOrUnspecified(stringArray), 0.0f, 0.0f, 0, 7, null);
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("Label.foreground");
        long normalBorder = BridgeUtilsKt.retrieveColorOrUnspecified("Button.startBorderColor");
        long disabledBorder = BridgeUtilsKt.retrieveColorOrUnspecified("Button.disabledBorderColor");
        long selectedBorder = BridgeUtilsKt.retrieveColorOrUnspecified("Component.focusColor");
        ChipColors colors = new ChipColors(normalBackground, normalBackground, normalBackground, normalBackground, normalBackground, normalBackground, normalBackground, normalBackground, normalBackground, normalBackground, normalContent, normalContent, normalContent, normalContent, normalContent, normalContent, normalContent, normalContent, normalContent, normalContent, normalBorder, disabledBorder, normalBorder, normalBorder, normalBorder, selectedBorder, disabledBorder, selectedBorder, selectedBorder, selectedBorder, null);
        int $this$dp$iv = 6;
        boolean $i$f$getDp = false;
        CornerSize cornerSize = CornerSizeKt.CornerSize-0680j_4(Dp.constructor-impl($this$dp$iv));
        $this$dp$iv = 12;
        $i$f$getDp = false;
        float f = Dp.constructor-impl($this$dp$iv);
        $this$dp$iv = 8;
        $i$f$getDp = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-YgX7TsA(f, Dp.constructor-impl($this$dp$iv));
        $this$dp$iv = 1;
        $i$f$getDp = false;
        float f2 = Dp.constructor-impl($this$dp$iv);
        $this$dp$iv = 2;
        $i$f$getDp = false;
        return new ChipStyle(colors, new ChipMetrics(cornerSize, paddingValues, f2, Dp.constructor-impl($this$dp$iv), null));
    }

    private static final DividerStyle readDividerStyle() {
        return new DividerStyle(BridgeUtilsKt.toComposeColorOrUnspecified(JBColor.border()), DividerMetrics.Companion.defaults-YgX7TsA$default(DividerMetrics.Companion, 0.0f, 0.0f, 3, null), null);
    }

    private static final DropdownStyle readDefaultDropdownStyle(MenuStyle menuStyle) {
        long normalBackground = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.nonEditableBackground");
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.foreground");
        long normalBorder = BridgeUtilsKt.retrieveColorOrUnspecified("Component.borderColor");
        long focusedBorder = BridgeUtilsKt.retrieveColorOrUnspecified("Component.focusedBorderColor");
        DropdownColors colors = new DropdownColors(normalBackground, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledBackground"), normalBackground, normalBackground, normalBackground, normalContent, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledForeground"), normalContent, normalContent, normalContent, normalBorder, BridgeUtilsKt.retrieveColorOrUnspecified("Component.disabledBorderColor"), focusedBorder, focusedBorder, normalBorder, Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), null);
        Dimension dimension = JBUI.CurrentTheme.ComboBox.minimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"minimumSize(...)");
        long minimumSize = BridgeUtilsKt.toDpSize(dimension);
        JBValue jBValue = JBUI.CurrentTheme.Component.ARROW_AREA_WIDTH;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"ARROW_AREA_WIDTH");
        float arrowWidth = BridgeUtilsKt.getDp(jBValue);
        long l = DpKt.DpSize-YgX7TsA(arrowWidth, DpSize.getHeight-D9Ej5fM(minimumSize));
        float arg0$iv = DpSize.getWidth-D9Ej5fM(minimumSize);
        boolean bl = false;
        long l2 = DpKt.DpSize-YgX7TsA(Dp.constructor-impl(arg0$iv + arrowWidth), DpSize.getHeight-D9Ej5fM(minimumSize));
        CornerSize cornerSize = IntUiBridgeKt.getComponentArc();
        PaddingValues paddingValues = BridgeUtilsKt.retrieveInsetsAsPaddingValues$default("ComboBox.padding", null, 2, null);
        JBValue jBValue2 = DarculaUIUtil.LW;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue2, (String)"LW");
        return new DropdownStyle(colors, new DropdownMetrics(l, l2, cornerSize, paddingValues, BridgeUtilsKt.getDp(jBValue2), null), new DropdownIcons(AllIconsKeys.General.INSTANCE.getChevronDown()), menuStyle);
    }

    private static final DropdownStyle readUndecoratedDropdownStyle(MenuStyle menuStyle) {
        long normalBackground = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.nonEditableBackground");
        long hoverBackground = BridgeUtilsKt.retrieveColorOrUnspecified("MainToolbar.Dropdown.transparentHoverBackground");
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.foreground");
        DropdownColors colors = new DropdownColors(normalBackground, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledBackground"), normalBackground, normalBackground, hoverBackground, normalContent, BridgeUtilsKt.retrieveColorOrUnspecified("ComboBox.disabledForeground"), normalContent, normalContent, normalContent, Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), null);
        JBValue jBValue = JBUI.CurrentTheme.Component.ARROW_AREA_WIDTH;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"ARROW_AREA_WIDTH");
        float arrowWidth = BridgeUtilsKt.getDp(jBValue);
        Dimension dimension = JBUI.CurrentTheme.Button.minimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"minimumSize(...)");
        long minimumSize = BridgeUtilsKt.toDpSize(dimension);
        long l = DpKt.DpSize-YgX7TsA(arrowWidth, DpSize.getHeight-D9Ej5fM(minimumSize));
        float arg0$iv = DpSize.getWidth-D9Ej5fM(minimumSize);
        boolean bl = false;
        long l2 = DpKt.DpSize-YgX7TsA(Dp.constructor-impl(arg0$iv + arrowWidth), DpSize.getHeight-D9Ej5fM(minimumSize));
        JBValue jBValue2 = JBUI.CurrentTheme.MainToolbar.Dropdown.hoverArc();
        Intrinsics.checkNotNullExpressionValue((Object)jBValue2, (String)"hoverArc(...)");
        int $this$dp$iv = 3;
        boolean $i$f$getDp = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-0680j_4(Dp.constructor-impl($this$dp$iv));
        $this$dp$iv = 0;
        $i$f$getDp = false;
        return new DropdownStyle(colors, new DropdownMetrics(l, l2, CornerSizeKt.CornerSize-0680j_4(BridgeUtilsKt.getDp(jBValue2)), paddingValues, Dp.constructor-impl($this$dp$iv), null), new DropdownIcons(AllIconsKeys.General.INSTANCE.getChevronDown()), menuStyle);
    }

    private static final GroupHeaderStyle readGroupHeaderStyle() {
        boolean $this$dp$iv = true;
        boolean $i$f$getDp = false;
        float f = Dp.constructor-impl((float)$this$dp$iv);
        $this$dp$iv = true;
        $i$f$getDp = false;
        return new GroupHeaderStyle(new GroupHeaderColors(BridgeUtilsKt.retrieveColorOrUnspecified("Separator.separatorColor"), null), new GroupHeaderMetrics(f, Dp.constructor-impl((float)$this$dp$iv), null));
    }

    private static final HorizontalProgressBarStyle readHorizontalProgressBarStyle() {
        int $this$dp$iv = 4;
        boolean $i$f$getDp = false;
        float f = Dp.constructor-impl($this$dp$iv);
        $this$dp$iv = 96;
        $i$f$getDp = false;
        return new HorizontalProgressBarStyle(new HorizontalProgressBarColors(BridgeUtilsKt.retrieveColorOrUnspecified("ProgressBar.trackColor"), BridgeUtilsKt.retrieveColorOrUnspecified("ProgressBar.progressColor"), BridgeUtilsKt.retrieveColorOrUnspecified("ProgressBar.indeterminateStartColor"), BridgeUtilsKt.retrieveColorOrUnspecified("ProgressBar.indeterminateEndColor"), null), new HorizontalProgressBarMetrics(CornerSizeKt.CornerSize(100), f, Dp.constructor-impl($this$dp$iv), null), DurationKt.toDuration((int)800, (DurationUnit)DurationUnit.MILLISECONDS), null);
    }

    private static final LinkStyle readLinkStyle() {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        long l6;
        long l7;
        long l8;
        long l9;
        long normalContent;
        long l10;
        long $this$takeOrElse_u2dDxMtmZc$iv = BridgeUtilsKt.retrieveColorOrUnspecified("Link.activeForeground");
        boolean bl = false;
        long $this$isSpecified$iv$iv = $this$takeOrElse_u2dDxMtmZc$iv;
        boolean bl2 = false;
        if ($this$isSpecified$iv$iv != 16L) {
            l10 = $this$takeOrElse_u2dDxMtmZc$iv;
        } else {
            boolean bl3 = false;
            l10 = BridgeUtilsKt.retrieveColorOrUnspecified("Link.activeForeground");
        }
        long l11 = normalContent = l10;
        long $this$takeOrElse_u2dDxMtmZc$iv2 = BridgeUtilsKt.retrieveColorOrUnspecified("Link.disabledForeground");
        $i$f$takeOrElse-DxMtmZc = false;
        long $this$isSpecified$iv$iv2 = $this$takeOrElse_u2dDxMtmZc$iv2;
        $i$f$isSpecified-8_81llA = false;
        if ($this$isSpecified$iv$iv2 != 16L) {
            l9 = $this$takeOrElse_u2dDxMtmZc$iv2;
        } else {
            l8 = l11;
            boolean bl4 = false;
            l7 = BridgeUtilsKt.retrieveColorOrUnspecified("Label.disabledForeground");
            l11 = l8;
            l9 = l7;
        }
        long l12 = normalContent;
        $this$takeOrElse_u2dDxMtmZc$iv2 = BridgeUtilsKt.retrieveColorOrUnspecified("Link.pressedForeground");
        $i$f$takeOrElse-DxMtmZc = false;
        $this$isSpecified$iv$iv2 = $this$takeOrElse_u2dDxMtmZc$iv2;
        $i$f$isSpecified-8_81llA = false;
        if ($this$isSpecified$iv$iv2 != 16L) {
            l6 = $this$takeOrElse_u2dDxMtmZc$iv2;
        } else {
            l5 = l12;
            l7 = l9;
            l8 = l11;
            boolean bl5 = false;
            l4 = BridgeUtilsKt.retrieveColorOrUnspecified("link.pressed.foreground");
            l11 = l8;
            l9 = l7;
            l12 = l5;
            l6 = l4;
        }
        $this$takeOrElse_u2dDxMtmZc$iv2 = BridgeUtilsKt.retrieveColorOrUnspecified("Link.hoverForeground");
        $i$f$takeOrElse-DxMtmZc = false;
        $this$isSpecified$iv$iv2 = $this$takeOrElse_u2dDxMtmZc$iv2;
        $i$f$isSpecified-8_81llA = false;
        if ($this$isSpecified$iv$iv2 != 16L) {
            l3 = $this$takeOrElse_u2dDxMtmZc$iv2;
        } else {
            l4 = l6;
            l5 = l12;
            l7 = l9;
            l8 = l11;
            boolean bl6 = false;
            l2 = BridgeUtilsKt.retrieveColorOrUnspecified("link.hover.foreground");
            l11 = l8;
            l9 = l7;
            l12 = l5;
            l6 = l4;
            l3 = l2;
        }
        $this$takeOrElse_u2dDxMtmZc$iv2 = BridgeUtilsKt.retrieveColorOrUnspecified("Link.visitedForeground");
        $i$f$takeOrElse-DxMtmZc = false;
        $this$isSpecified$iv$iv2 = $this$takeOrElse_u2dDxMtmZc$iv2;
        $i$f$isSpecified-8_81llA = false;
        if ($this$isSpecified$iv$iv2 != 16L) {
            l = $this$takeOrElse_u2dDxMtmZc$iv2;
        } else {
            l2 = l3;
            l4 = l6;
            l5 = l12;
            l7 = l9;
            l8 = l11;
            boolean bl7 = false;
            long l13 = BridgeUtilsKt.retrieveColorOrUnspecified("link.visited.foreground");
            l11 = l8;
            l9 = l7;
            l12 = l5;
            l6 = l4;
            l3 = l2;
            l = l13;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        long l14 = l;
        long l15 = l3;
        long l16 = l6;
        long l17 = l12;
        long l18 = l9;
        long l19 = l11;
        LinkColors colors = new LinkColors(l19, l18, l17, l16, l15, l14, defaultConstructorMarker);
        int $this$dp$iv = 4;
        boolean $i$f$getDp = false;
        CornerSize cornerSize = BridgeUtilsKt.retrieveArcAsCornerSizeOrDefault("ide.link.button.focus.round.arc", CornerSizeKt.CornerSize-0680j_4(Dp.constructor-impl($this$dp$iv)));
        $this$dp$iv = 4;
        $i$f$getDp = false;
        float f = Dp.constructor-impl($this$dp$iv);
        $this$dp$iv = 16;
        $i$f$getDp = false;
        float f2 = Dp.constructor-impl($this$dp$iv);
        $this$dp$iv = 16;
        $i$f$getDp = false;
        return new LinkStyle(colors, new LinkMetrics(cornerSize, f, DpKt.DpSize-YgX7TsA(f2, Dp.constructor-impl($this$dp$iv)), null), new LinkIcons(AllIconsKeys.General.INSTANCE.getChevronDown(), AllIconsKeys.Ide.INSTANCE.getExternal_link_arrow()), LinkUnderlineBehavior.ShowOnHover);
    }

    /*
     * WARNING - void declaration
     */
    private static final MenuStyle readMenuStyle() {
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        boolean $i$f$getDp;
        boolean $this$dp$iv;
        float f6;
        void arg0$iv22;
        float f7;
        MenuColors menuColors;
        CornerSize cornerSize;
        PaddingValues paddingValues;
        PaddingValues paddingValues2;
        long l;
        float f8;
        float f9;
        long l2;
        long backgroundSelected = BridgeUtilsKt.retrieveColorOrUnspecified("MenuItem.selectionBackground");
        long foregroundSelected = BridgeUtilsKt.retrieveColorOrUnspecified("MenuItem.selectionForeground");
        long keybindingTint = BridgeUtilsKt.retrieveColorOrUnspecified("MenuItem.acceleratorForeground");
        long keybindingTintSelected = Color.Companion.getUnspecified-0d7_KjU();
        long l3 = BridgeUtilsKt.retrieveColorOrUnspecified("PopupMenu.background");
        long $this$takeOrElse_u2dDxMtmZc$iv = BridgeUtilsKt.retrieveColorOrUnspecified("Popup.borderColor");
        boolean bl = false;
        long $this$isSpecified$iv$iv = $this$takeOrElse_u2dDxMtmZc$iv;
        boolean bl2 = false;
        if ($this$isSpecified$iv$iv != 16L) {
            l2 = $this$takeOrElse_u2dDxMtmZc$iv;
        } else {
            long l4 = l3;
            boolean bl3 = false;
            long l5 = BridgeUtilsKt.retrieveColorOrUnspecified("Popup.Border.color");
            l3 = l4;
            l2 = l5;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        MenuItemColors menuItemColors = new MenuItemColors(BridgeUtilsKt.retrieveColorOrUnspecified("MenuItem.background"), BridgeUtilsKt.retrieveColorOrUnspecified("MenuItem.disabledBackground"), backgroundSelected, backgroundSelected, backgroundSelected, BridgeUtilsKt.retrieveColorOrUnspecified("PopupMenu.foreground"), BridgeUtilsKt.retrieveColorOrUnspecified("PopupMenu.disabledForeground"), foregroundSelected, foregroundSelected, foregroundSelected, Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), Color.Companion.getUnspecified-0d7_KjU(), keybindingTint, keybindingTint, keybindingTintSelected, keybindingTintSelected, keybindingTintSelected, BridgeUtilsKt.retrieveColorOrUnspecified("Menu.separatorColor"), null);
        long l6 = Color.copy-wmQWz5c$default(Color.Companion.getBlack-0d7_KjU(), 0.6f, 0.0f, 0.0f, 0.0f, 14, null);
        long l7 = l2;
        long l8 = l3;
        MenuColors colors = new MenuColors(l8, l7, l6, menuItemColors, defaultConstructorMarker);
        boolean bl4 = IntUiBridgeKt.isDark();
        MenuColors menuColors2 = colors;
        JBValue jBValue = IdeaPopupMenuUI.CORNER_RADIUS;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"CORNER_RADIUS");
        CornerSize cornerSize2 = CornerSizeKt.CornerSize-0680j_4(BridgeUtilsKt.getDp(jBValue));
        int $this$dp$iv2 = 0;
        boolean $i$f$getDp2 = false;
        PaddingValues paddingValues3 = PaddingKt.PaddingValues-0680j_4(Dp.constructor-impl($this$dp$iv2));
        $this$dp$iv2 = 0;
        $i$f$getDp2 = false;
        float f10 = Dp.constructor-impl($this$dp$iv2);
        $this$dp$iv2 = 6;
        $i$f$getDp2 = false;
        PaddingValues paddingValues4 = PaddingKt.PaddingValues-YgX7TsA(f10, Dp.constructor-impl($this$dp$iv2));
        $this$dp$iv2 = 0;
        $i$f$getDp2 = false;
        float f11 = Dp.constructor-impl($this$dp$iv2);
        $this$dp$iv2 = 2;
        $i$f$getDp2 = false;
        long l9 = DpKt.DpOffset-YgX7TsA(f11, Dp.constructor-impl($this$dp$iv2));
        $this$dp$iv2 = 12;
        $i$f$getDp2 = false;
        float f12 = Dp.constructor-impl($this$dp$iv2);
        float $this$takeOrElse_u2dD5KLDUw$iv22 = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("Popup.borderWidth");
        boolean $i$f$takeOrElse-D5KLDUw22 = false;
        float $this$isSpecified$iv$iv2 = $this$takeOrElse_u2dD5KLDUw$iv22;
        boolean bl5 = false;
        boolean bl6 = !Float.isNaN($this$isSpecified$iv$iv2);
        if (bl6) {
            f9 = $this$takeOrElse_u2dD5KLDUw$iv22;
        } else {
            f8 = f12;
            l = l9;
            paddingValues2 = paddingValues4;
            paddingValues = paddingValues3;
            cornerSize = cornerSize2;
            menuColors = menuColors2;
            boolean bl7 = bl4;
            boolean bl8 = false;
            boolean $this$dp$iv3 = true;
            boolean $i$f$getDp3 = false;
            f7 = Dp.constructor-impl((float)$this$dp$iv3);
            bl4 = bl7;
            menuColors2 = menuColors;
            cornerSize2 = cornerSize;
            paddingValues3 = paddingValues;
            paddingValues4 = paddingValues2;
            l9 = l;
            f12 = f8;
            f9 = f7;
        }
        JBValue jBValue2 = JBUI.CurrentTheme.PopupMenu.Selection.ARC;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue2, (String)"ARC");
        float $i$f$takeOrElse-D5KLDUw22 = BridgeUtilsKt.getDp(jBValue2);
        int other$iv = 2;
        boolean bl9 = false;
        CornerSize $this$takeOrElse_u2dD5KLDUw$iv22 = CornerSizeKt.CornerSize-0680j_4(Dp.constructor-impl((float)(arg0$iv22 / (float)other$iv)));
        int $this$dp$iv4 = 7;
        boolean $i$f$getDp4 = false;
        PaddingValues arg0$iv22 = PaddingKt.PaddingValues-YgX7TsA$default(Dp.constructor-impl($this$dp$iv4), 0.0f, 2, null);
        int $this$dp$iv5 = 14;
        boolean $i$f$getDp5 = false;
        float f13 = Dp.constructor-impl($this$dp$iv5);
        $this$dp$iv5 = 4;
        $i$f$getDp5 = false;
        PaddingValues paddingValues5 = PaddingKt.PaddingValues-YgX7TsA(f13, Dp.constructor-impl($this$dp$iv5));
        int $this$dp$iv6 = 36;
        boolean $i$f$getDp6 = false;
        PaddingValues paddingValues6 = PaddingKt.PaddingValues-a9UjIt4$default(Dp.constructor-impl($this$dp$iv6), 0.0f, 0.0f, 0.0f, 14, null);
        float $this$takeOrElse_u2dD5KLDUw$iv = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("PopupMenuSeparator.withToEdge");
        boolean bl10 = false;
        float $this$isSpecified$iv$iv3 = $this$takeOrElse_u2dD5KLDUw$iv;
        $i$f$isSpecified-0680j_4 = false;
        boolean bl11 = !Float.isNaN($this$isSpecified$iv$iv3);
        if (bl11) {
            f6 = $this$takeOrElse_u2dD5KLDUw$iv;
        } else {
            f7 = f9;
            f8 = f12;
            l = l9;
            paddingValues2 = paddingValues4;
            paddingValues = paddingValues3;
            cornerSize = cornerSize2;
            menuColors = menuColors2;
            boolean bl12 = bl4;
            boolean bl13 = false;
            $this$dp$iv = true;
            $i$f$getDp = false;
            f5 = Dp.constructor-impl((float)$this$dp$iv);
            bl4 = bl12;
            menuColors2 = menuColors;
            cornerSize2 = cornerSize;
            paddingValues3 = paddingValues;
            paddingValues4 = paddingValues2;
            l9 = l;
            f12 = f8;
            f9 = f7;
            f6 = f5;
        }
        $this$takeOrElse_u2dD5KLDUw$iv = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("PopupMenuSeparator.stripeIndent");
        bl10 = false;
        $this$isSpecified$iv$iv3 = $this$takeOrElse_u2dD5KLDUw$iv;
        $i$f$isSpecified-0680j_4 = false;
        boolean bl14 = !Float.isNaN($this$isSpecified$iv$iv3);
        if (bl14) {
            f4 = $this$takeOrElse_u2dD5KLDUw$iv;
        } else {
            f5 = f6;
            f7 = f9;
            f8 = f12;
            l = l9;
            paddingValues2 = paddingValues4;
            paddingValues = paddingValues3;
            cornerSize = cornerSize2;
            menuColors = menuColors2;
            boolean bl15 = bl4;
            boolean bl16 = false;
            $this$dp$iv = true;
            $i$f$getDp = false;
            float f14 = Dp.constructor-impl((float)$this$dp$iv);
            bl4 = bl15;
            menuColors2 = menuColors;
            cornerSize2 = cornerSize;
            paddingValues3 = paddingValues;
            paddingValues4 = paddingValues2;
            l9 = l;
            f12 = f8;
            f9 = f7;
            f6 = f5;
            f4 = f14;
        }
        PaddingValues paddingValues7 = PaddingKt.PaddingValues-YgX7TsA(f6, f4);
        float $this$takeOrElse_u2dD5KLDUw$iv3 = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("PopupMenuSeparator.stripeWidth");
        $i$f$takeOrElse-D5KLDUw = false;
        float $this$isSpecified$iv$iv4 = $this$takeOrElse_u2dD5KLDUw$iv3;
        $i$f$isSpecified-0680j_4 = false;
        boolean bl17 = !Float.isNaN($this$isSpecified$iv$iv4);
        if (bl17) {
            f3 = $this$takeOrElse_u2dD5KLDUw$iv3;
        } else {
            f7 = f9;
            f8 = f12;
            l = l9;
            paddingValues2 = paddingValues4;
            paddingValues = paddingValues3;
            cornerSize = cornerSize2;
            menuColors = menuColors2;
            boolean bl18 = bl4;
            boolean bl19 = false;
            boolean $this$dp$iv7 = true;
            boolean $i$f$getDp7 = false;
            f5 = Dp.constructor-impl((float)$this$dp$iv7);
            bl4 = bl18;
            menuColors2 = menuColors;
            cornerSize2 = cornerSize;
            paddingValues3 = paddingValues;
            paddingValues4 = paddingValues2;
            l9 = l;
            f12 = f8;
            f9 = f7;
            f3 = f5;
        }
        float f15 = f3;
        float $this$takeOrElse_u2dD5KLDUw$iv4 = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("PopupMenuSeparator.height");
        $i$f$takeOrElse-D5KLDUw = false;
        float $this$isSpecified$iv$iv5 = $this$takeOrElse_u2dD5KLDUw$iv4;
        $i$f$isSpecified-0680j_4 = false;
        boolean bl20 = !Float.isNaN($this$isSpecified$iv$iv5);
        if (bl20) {
            f2 = $this$takeOrElse_u2dD5KLDUw$iv4;
        } else {
            f7 = f9;
            f8 = f12;
            l = l9;
            paddingValues2 = paddingValues4;
            paddingValues = paddingValues3;
            cornerSize = cornerSize2;
            menuColors = menuColors2;
            boolean bl21 = bl4;
            boolean bl22 = false;
            int $this$dp$iv8 = 3;
            boolean $i$f$getDp8 = false;
            f5 = Dp.constructor-impl($this$dp$iv8);
            bl4 = bl21;
            menuColors2 = menuColors;
            cornerSize2 = cornerSize;
            paddingValues3 = paddingValues;
            paddingValues4 = paddingValues2;
            l9 = l;
            f12 = f8;
            f9 = f7;
            f2 = f5;
        }
        float f16 = f2;
        int $this$dp$iv9 = 16;
        boolean $i$f$getDp9 = false;
        float f17 = Dp.constructor-impl($this$dp$iv9);
        if (BridgeUtilsKt.isNewUiTheme()) {
            int $this$dp$iv10 = JBUI.CurrentTheme.List.rowHeight();
            boolean $i$f$getDp10 = false;
            f = Dp.constructor-impl($this$dp$iv10);
        } else {
            f = Dp.Companion.getUnspecified-D9Ej5fM();
        }
        float f18 = f;
        $this$dp$iv = 0;
        $i$f$getDp = false;
        float f19 = Dp.constructor-impl($this$dp$iv);
        $this$dp$iv = -8;
        $i$f$getDp = false;
        DefaultConstructorMarker defaultConstructorMarker2 = null;
        SubmenuMetrics submenuMetrics = new SubmenuMetrics(DpKt.DpOffset-YgX7TsA(f19, Dp.constructor-impl($this$dp$iv)), null);
        MenuItemMetrics menuItemMetrics = new MenuItemMetrics($this$takeOrElse_u2dD5KLDUw$iv22, arg0$iv22, paddingValues5, paddingValues7, paddingValues6, f15, f16, f17, f18, null);
        float f20 = f9;
        float f21 = f12;
        long l10 = l9;
        PaddingValues paddingValues8 = paddingValues4;
        PaddingValues paddingValues9 = paddingValues3;
        CornerSize cornerSize3 = cornerSize2;
        MenuIcons menuIcons = new MenuIcons(AllIconsKeys.General.INSTANCE.getChevronRight());
        MenuMetrics menuMetrics = new MenuMetrics(cornerSize3, paddingValues9, paddingValues8, l10, f21, f20, menuItemMetrics, submenuMetrics, defaultConstructorMarker2);
        MenuColors menuColors3 = menuColors2;
        boolean bl23 = bl4;
        return new MenuStyle(bl23, menuColors3, menuMetrics, menuIcons);
    }

    private static final RadioButtonStyle readRadioButtonStyle() {
        float f;
        float f2;
        float $this$takeOrElse_u2dD5KLDUw$iv;
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("RadioButton.foreground");
        long disabledContent = BridgeUtilsKt.retrieveColorOrUnspecified("RadioButton.disabledText");
        RadioButtonColors colors = new RadioButtonColors(normalContent, normalContent, disabledContent, normalContent, normalContent, disabledContent, null);
        boolean newUiTheme = BridgeUtilsKt.isNewUiTheme();
        BridgeRadioButtonMetrics metrics = newUiTheme ? (BridgeRadioButtonMetrics)NewUiRadioButtonMetrics.INSTANCE : (BridgeRadioButtonMetrics)ClassicUiRadioButtonMetrics.INSTANCE;
        float f3 = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("RadioButton.iconSize");
        boolean bl = false;
        void $this$isSpecified$iv$iv = $this$takeOrElse_u2dD5KLDUw$iv;
        boolean bl2 = false;
        boolean bl3 = !Float.isNaN((float)$this$isSpecified$iv$iv);
        if (bl3) {
            f2 = $this$takeOrElse_u2dD5KLDUw$iv;
        } else {
            boolean bl4 = false;
            f2 = metrics.getRadioButtonSize-D9Ej5fM();
        }
        void it = f2;
        boolean bl5 = false;
        long radioButtonSize = DpKt.DpSize-YgX7TsA((float)it, (float)it);
        RadioButtonColors radioButtonColors = colors;
        long l = radioButtonSize;
        long l2 = metrics.getOutlineSize-MYxV2XQ();
        long l3 = metrics.getOutlineFocusedSize-MYxV2XQ();
        long l4 = metrics.getOutlineSelectedSize-MYxV2XQ();
        long l5 = metrics.getOutlineSelectedFocusedSize-MYxV2XQ();
        $this$takeOrElse_u2dD5KLDUw$iv = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("RadioButton.textIconGap");
        $i$f$takeOrElse-D5KLDUw = false;
        float $this$isSpecified$iv$iv2 = $this$takeOrElse_u2dD5KLDUw$iv;
        bl2 = false;
        boolean bl6 = !Float.isNaN($this$isSpecified$iv$iv2);
        if (bl6) {
            f = $this$takeOrElse_u2dD5KLDUw$iv;
        } else {
            long l6 = l5;
            long l7 = l4;
            long l8 = l3;
            long l9 = l2;
            long l10 = l;
            RadioButtonColors radioButtonColors2 = radioButtonColors;
            boolean bl7 = false;
            float f4 = metrics.getIconContentGap-D9Ej5fM();
            radioButtonColors = radioButtonColors2;
            l = l10;
            l2 = l9;
            l3 = l8;
            l4 = l7;
            l5 = l6;
            f = f4;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        float f5 = f;
        long l11 = l5;
        long l12 = l4;
        long l13 = l3;
        long l14 = l2;
        long l15 = l;
        RadioButtonIcons radioButtonIcons = new RadioButtonIcons(new PathIconKey(IntUiBridgeKt.getIconsBasePath() + "radio.svg", RadioButtonIcons.class));
        RadioButtonMetrics radioButtonMetrics = new RadioButtonMetrics(l15, l14, l13, l12, l11, f5, defaultConstructorMarker);
        RadioButtonColors radioButtonColors3 = radioButtonColors;
        return new RadioButtonStyle(radioButtonColors3, radioButtonMetrics, radioButtonIcons);
    }

    /*
     * WARNING - void declaration
     */
    private static final SegmentedControlButtonStyle readSegmentedControlButtonStyle() {
        void arg0$iv;
        java.awt.Color color = JBUI.CurrentTheme.SegmentedButton.SELECTED_BUTTON_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"SELECTED_BUTTON_COLOR");
        SolidColor selectedBackground = new SolidColor(BridgeUtilsKt.toComposeColor(color), null);
        Object[] objectArray = new Color[2];
        java.awt.Color color2 = JBUI.CurrentTheme.SegmentedButton.SELECTED_START_BORDER_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"SELECTED_START_BORDER_COLOR");
        objectArray[0] = Color.box-impl(BridgeUtilsKt.toComposeColor(color2));
        java.awt.Color color3 = JBUI.CurrentTheme.SegmentedButton.SELECTED_END_BORDER_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"SELECTED_END_BORDER_COLOR");
        objectArray[1] = Color.box-impl(BridgeUtilsKt.toComposeColor(color3));
        Brush normalBorder = BridgeUtilsKt.createVerticalBrush-8A-3gB4$default(CollectionsKt.listOf((Object[])objectArray), 0.0f, 0.0f, 0, 7, null);
        Object[] objectArray2 = new Color[2];
        java.awt.Color color4 = JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"buttonOutlineColorStart(...)");
        objectArray2[0] = Color.box-impl(BridgeUtilsKt.toComposeColor(color4));
        java.awt.Color color5 = JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"buttonOutlineColorEnd(...)");
        objectArray2[1] = Color.box-impl(BridgeUtilsKt.toComposeColor(color5));
        Brush selectedDisabledBorder = BridgeUtilsKt.createVerticalBrush-8A-3gB4$default(CollectionsKt.listOf((Object[])objectArray2), 0.0f, 0.0f, 0, 7, null);
        Brush brush = new SolidColor(Color.Companion.getTransparent-0d7_KjU(), null);
        Brush brush2 = selectedBackground;
        java.awt.Color color6 = JBUI.CurrentTheme.ActionButton.hoverBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"hoverBackground(...)");
        Brush brush3 = new SolidColor(BridgeUtilsKt.toComposeColor(color6), null);
        Brush brush4 = selectedBackground;
        java.awt.Color color7 = JBUI.CurrentTheme.SegmentedButton.FOCUSED_SELECTED_BUTTON_COLOR;
        Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"FOCUSED_SELECTED_BUTTON_COLOR");
        Brush brush5 = new SolidColor(BridgeUtilsKt.toComposeColor(color7), null);
        long l = BridgeUtilsKt.retrieveColorOrUnspecified("Button.foreground");
        long l2 = BridgeUtilsKt.retrieveColorOrUnspecified("Label.disabledForeground");
        java.awt.Color color8 = JBUI.CurrentTheme.Button.focusBorderColor((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color8, (String)"focusBorderColor(...)");
        SegmentedControlButtonColors colors = new SegmentedControlButtonColors(brush, brush2, brush3, brush4, brush5, l, l2, normalBorder, normalBorder, selectedDisabledBorder, new SolidColor(BridgeUtilsKt.toComposeColor(color8), null), null);
        Dimension dimension = JBUI.CurrentTheme.Button.minimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"minimumSize(...)");
        long minimumSize = BridgeUtilsKt.toDpSize(dimension);
        JBValue jBValue = DarculaUIUtil.BUTTON_ARC;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"BUTTON_ARC");
        float f = BridgeUtilsKt.getDp(jBValue);
        int other$iv = 2;
        boolean bl = false;
        CornerSize cornerSize = CornerSizeKt.CornerSize-0680j_4(Dp.constructor-impl((float)(arg0$iv / (float)other$iv)));
        int $this$dp$iv = 14;
        boolean $i$f$getDp = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-YgX7TsA$default(Dp.constructor-impl($this$dp$iv), 0.0f, 2, null);
        long l3 = DpKt.DpSize-YgX7TsA(DpSize.getWidth-D9Ej5fM(minimumSize), DpSize.getHeight-D9Ej5fM(minimumSize));
        JBValue jBValue2 = DarculaUIUtil.LW;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue2, (String)"LW");
        return new SegmentedControlButtonStyle(colors, new SegmentedControlButtonMetrics(cornerSize, paddingValues, l3, BridgeUtilsKt.getDp(jBValue2), null));
    }

    /*
     * WARNING - void declaration
     */
    private static final SegmentedControlStyle readSegmentedControlStyle() {
        void arg0$iv;
        Object[] objectArray = new Color[2];
        java.awt.Color color = JBUI.CurrentTheme.Button.buttonOutlineColorStart((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"buttonOutlineColorStart(...)");
        objectArray[0] = Color.box-impl(BridgeUtilsKt.toComposeColor(color));
        java.awt.Color color2 = JBUI.CurrentTheme.Button.buttonOutlineColorEnd((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"buttonOutlineColorEnd(...)");
        objectArray[1] = Color.box-impl(BridgeUtilsKt.toComposeColor(color2));
        Brush normalBorder = BridgeUtilsKt.createVerticalBrush-8A-3gB4$default(CollectionsKt.listOf((Object[])objectArray), 0.0f, 0.0f, 0, 7, null);
        java.awt.Color color3 = JBUI.CurrentTheme.Button.disabledOutlineColor();
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"disabledOutlineColor(...)");
        Brush brush = new SolidColor(BridgeUtilsKt.toComposeColor(color3), null);
        java.awt.Color color4 = JBUI.CurrentTheme.Button.focusBorderColor((boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"focusBorderColor(...)");
        SegmentedControlColors colors = new SegmentedControlColors(normalBorder, brush, normalBorder, normalBorder, new SolidColor(BridgeUtilsKt.toComposeColor(color4), null));
        JBValue jBValue = DarculaUIUtil.BUTTON_ARC;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"BUTTON_ARC");
        float f = BridgeUtilsKt.getDp(jBValue);
        int other$iv = 2;
        boolean bl = false;
        CornerSize cornerSize = CornerSizeKt.CornerSize-0680j_4(Dp.constructor-impl((float)(arg0$iv / (float)other$iv)));
        JBValue jBValue2 = DarculaUIUtil.LW;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue2, (String)"LW");
        return new SegmentedControlStyle(colors, new SegmentedControlMetrics(cornerSize, BridgeUtilsKt.getDp(jBValue2), null));
    }

    private static final SliderStyle readSliderStyle(boolean dark) {
        SliderColors colors = dark ? BridgeSliderStylingKt.dark-7HESe_I$default(SliderColors.Companion, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, Short.MAX_VALUE, null) : BridgeSliderStylingKt.light-7HESe_I$default(SliderColors.Companion, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, Short.MAX_VALUE, null);
        return new SliderStyle(colors, BridgeSliderStylingKt.defaults-IDSuZpE$default(SliderMetrics.Companion, 0.0f, 0L, 0.0f, 0.0f, 0.0f, 0.0f, 63, null), RoundedCornerShapeKt.getCircleShape());
    }

    private static final TextAreaStyle readTextAreaStyle(TextFieldMetrics metrics) {
        long normalBackground = BridgeUtilsKt.retrieveColorOrUnspecified("TextArea.background");
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("TextArea.foreground");
        java.awt.Color color = DarculaUIUtil.getOutlineColor((boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getOutlineColor(...)");
        long normalBorder = BridgeUtilsKt.toComposeColor(color);
        java.awt.Color color2 = DarculaUIUtil.getOutlineColor((boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getOutlineColor(...)");
        long focusedBorder = BridgeUtilsKt.toComposeColor(color2);
        long normalCaret = BridgeUtilsKt.retrieveColorOrUnspecified("TextArea.caretForeground");
        long l = Color.Companion.getUnspecified-0d7_KjU();
        long l2 = BridgeUtilsKt.retrieveColorOrUnspecified("TextArea.inactiveForeground");
        java.awt.Color color3 = DarculaUIUtil.getOutlineColor((boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getOutlineColor(...)");
        long l3 = BridgeUtilsKt.toComposeColor(color3);
        java.awt.Color color4 = NamedColorUtil.getInactiveTextColor();
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getInactiveTextColor(...)");
        TextAreaColors colors = new TextAreaColors(normalBackground, l, normalBackground, normalBackground, normalBackground, normalContent, l2, normalContent, normalContent, normalContent, normalBorder, l3, focusedBorder, focusedBorder, normalBorder, normalCaret, normalCaret, normalCaret, normalCaret, normalCaret, BridgeUtilsKt.toComposeColor(color4), null);
        CornerSize cornerSize = metrics.getCornerSize();
        int $this$dp$iv = 5;
        boolean $i$f$getDp = false;
        float f = Dp.constructor-impl($this$dp$iv);
        $this$dp$iv = 4;
        $i$f$getDp = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-YgX7TsA(f, Dp.constructor-impl($this$dp$iv));
        long l4 = metrics.getMinSize-MYxV2XQ();
        float f2 = metrics.getBorderWidth-D9Ej5fM();
        return new TextAreaStyle(colors, new TextAreaMetrics(f2, paddingValues, cornerSize, l4, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final TextFieldStyle readTextFieldStyle() {
        void arg0$iv;
        long normalBackground = BridgeUtilsKt.retrieveColorOrUnspecified("TextField.background");
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("TextField.foreground");
        java.awt.Color color = DarculaUIUtil.getOutlineColor((boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getOutlineColor(...)");
        long normalBorder = BridgeUtilsKt.toComposeColor(color);
        java.awt.Color color2 = DarculaUIUtil.getOutlineColor((boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getOutlineColor(...)");
        long focusedBorder = BridgeUtilsKt.toComposeColor(color2);
        long normalCaret = BridgeUtilsKt.retrieveColorOrUnspecified("TextField.caretForeground");
        long l = Color.Companion.getUnspecified-0d7_KjU();
        long l2 = BridgeUtilsKt.retrieveColorOrUnspecified("TextField.inactiveForeground");
        java.awt.Color color3 = DarculaUIUtil.getOutlineColor((boolean)false, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getOutlineColor(...)");
        long l3 = BridgeUtilsKt.toComposeColor(color3);
        java.awt.Color color4 = NamedColorUtil.getInactiveTextColor();
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getInactiveTextColor(...)");
        TextFieldColors colors = new TextFieldColors(normalBackground, l, normalBackground, normalBackground, normalBackground, normalContent, l2, normalContent, normalContent, normalContent, normalBorder, l3, focusedBorder, focusedBorder, normalBorder, normalCaret, normalCaret, normalCaret, normalCaret, normalCaret, BridgeUtilsKt.toComposeColor(color4), null);
        Dimension dimension = JBUI.CurrentTheme.TextField.minimumSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"minimumSize(...)");
        long minimumSize = BridgeUtilsKt.toDpSize(dimension);
        CornerSize cornerSize = IntUiBridgeKt.getComponentArc();
        int $this$dp$iv22 = 8;
        boolean $i$f$getDp = false;
        float $this$dp$iv22 = Dp.constructor-impl($this$dp$iv22);
        JBValue jBValue = DarculaUIUtil.LW;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"LW");
        float other$iv = BridgeUtilsKt.getDp(jBValue);
        boolean bl = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-YgX7TsA$default(Dp.constructor-impl((float)(arg0$iv + other$iv)), 0.0f, 2, null);
        int $this$dp$iv = 144;
        boolean $i$f$getDp2 = false;
        long l4 = DpKt.DpSize-YgX7TsA(Dp.constructor-impl($this$dp$iv), DpSize.getHeight-D9Ej5fM(minimumSize));
        JBValue jBValue2 = DarculaUIUtil.LW;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue2, (String)"LW");
        float f = BridgeUtilsKt.getDp(jBValue2);
        return new TextFieldStyle(colors, new TextFieldMetrics(f, paddingValues, cornerSize, l4, null));
    }

    /*
     * WARNING - void declaration
     */
    private static final LazyTreeStyle readLazyTreeStyle() {
        float f;
        void arg0$iv;
        boolean $i$f$getDp;
        int $this$dp$iv;
        float f2;
        float f3;
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("Tree.foreground");
        long selectedContent = BridgeUtilsKt.retrieveColorOrUnspecified("Tree.selectionForeground");
        long selectedElementBackground = BridgeUtilsKt.retrieveColorOrUnspecified("Tree.selectionBackground");
        long inactiveSelectedElementBackground = BridgeUtilsKt.retrieveColorOrUnspecified("Tree.selectionInactiveBackground");
        long l = Color.Companion.getUnspecified-0d7_KjU();
        LazyTreeColors colors = new LazyTreeColors(l, inactiveSelectedElementBackground, selectedElementBackground, normalContent, normalContent, selectedContent, selectedContent, null);
        float $this$takeOrElse_u2dD5KLDUw$iv = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("Tree.leftChildIndent");
        boolean bl = false;
        float $this$isSpecified$iv$iv = $this$takeOrElse_u2dD5KLDUw$iv;
        boolean bl2 = false;
        boolean bl3 = !Float.isNaN($this$isSpecified$iv$iv);
        if (bl3) {
            f3 = $this$takeOrElse_u2dD5KLDUw$iv;
        } else {
            boolean bl4 = false;
            int $this$dp$iv2 = 7;
            boolean $i$f$getDp2 = false;
            f3 = Dp.constructor-impl($this$dp$iv2);
        }
        float leftIndent = f3;
        float $this$takeOrElse_u2dD5KLDUw$iv2 = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("Tree.rightChildIndent");
        $i$f$takeOrElse-D5KLDUw = false;
        float $this$isSpecified$iv$iv2 = $this$takeOrElse_u2dD5KLDUw$iv2;
        $i$f$isSpecified-0680j_4 = false;
        boolean bl5 = !Float.isNaN($this$isSpecified$iv$iv2);
        if (bl5) {
            f2 = $this$takeOrElse_u2dD5KLDUw$iv2;
        } else {
            boolean bl6 = false;
            $this$dp$iv = 11;
            $i$f$getDp = false;
            f2 = Dp.constructor-impl($this$dp$iv);
        }
        float rightIndent = f2;
        LazyTreeColors lazyTreeColors = colors;
        boolean $i$f$plus-5rwHm252 = false;
        float f4 = Dp.constructor-impl(leftIndent + rightIndent);
        JBValue jBValue = JBUI.CurrentTheme.Tree.ARC;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"ARC");
        float $i$f$plus-5rwHm252 = BridgeUtilsKt.getDp(jBValue);
        int other$iv = 2;
        boolean bl7 = false;
        CornerSize cornerSize = CornerSizeKt.CornerSize-0680j_4(Dp.constructor-impl((float)(arg0$iv / (float)other$iv)));
        int $this$dp$iv3 = 12;
        boolean $i$f$getDp3 = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-YgX7TsA$default(Dp.constructor-impl($this$dp$iv3), 0.0f, 2, null);
        $this$dp$iv3 = 4;
        $i$f$getDp3 = false;
        PaddingValues paddingValues2 = PaddingKt.PaddingValues-0680j_4(Dp.constructor-impl($this$dp$iv3));
        $this$takeOrElse_u2dD5KLDUw$iv = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("Tree.rowHeight");
        $i$f$takeOrElse-D5KLDUw = false;
        $this$isSpecified$iv$iv = $this$takeOrElse_u2dD5KLDUw$iv;
        $i$f$isSpecified-0680j_4 = false;
        boolean bl8 = !Float.isNaN($this$isSpecified$iv$iv);
        if (bl8) {
            f = $this$takeOrElse_u2dD5KLDUw$iv;
        } else {
            PaddingValues paddingValues3 = paddingValues2;
            PaddingValues paddingValues4 = paddingValues;
            CornerSize cornerSize2 = cornerSize;
            float f5 = f4;
            LazyTreeColors lazyTreeColors2 = lazyTreeColors;
            boolean bl9 = false;
            $this$dp$iv = 24;
            $i$f$getDp = false;
            float f6 = Dp.constructor-impl($this$dp$iv);
            lazyTreeColors = lazyTreeColors2;
            f4 = f5;
            cornerSize = cornerSize2;
            paddingValues = paddingValues4;
            paddingValues2 = paddingValues3;
            f = f6;
        }
        $this$dp$iv = 2;
        $i$f$getDp3 = false;
        DefaultConstructorMarker defaultConstructorMarker = null;
        float f7 = Dp.constructor-impl($this$dp$iv);
        float f8 = f;
        PaddingValues paddingValues5 = paddingValues2;
        PaddingValues paddingValues6 = paddingValues;
        CornerSize cornerSize3 = cornerSize;
        float f9 = f4;
        LazyTreeIcons lazyTreeIcons = new LazyTreeIcons(AllIconsKeys.General.INSTANCE.getChevronRight(), AllIconsKeys.General.INSTANCE.getChevronDown(), AllIconsKeys.General.INSTANCE.getChevronRight(), AllIconsKeys.General.INSTANCE.getChevronDown());
        LazyTreeMetrics lazyTreeMetrics = new LazyTreeMetrics(f9, cornerSize3, paddingValues6, paddingValues5, f8, f7, defaultConstructorMarker);
        LazyTreeColors lazyTreeColors3 = lazyTreeColors;
        return new LazyTreeStyle(lazyTreeColors3, lazyTreeMetrics, lazyTreeIcons);
    }

    private static final TabStyle readDefaultTabStyle() {
        float f;
        float f2;
        TabColors tabColors;
        float f3;
        TabColors colors;
        java.awt.Color color = JBUI.CurrentTheme.DefaultTabs.background();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
        long normalBackground = BridgeUtilsKt.toComposeColor(color);
        long selectedBackground = BridgeUtilsKt.toComposeColorOrUnspecified(JBUI.CurrentTheme.DefaultTabs.underlinedTabBackground());
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("TabbedPane.foreground");
        long selectedUnderline = BridgeUtilsKt.retrieveColorOrUnspecified("TabbedPane.underlineColor");
        java.awt.Color color2 = JBUI.CurrentTheme.DefaultTabs.hoverBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"hoverBackground(...)");
        TabColors tabColors2 = colors = new TabColors(normalBackground, normalBackground, selectedBackground, BridgeUtilsKt.toComposeColor(color2), selectedBackground, normalContent, BridgeUtilsKt.retrieveColorOrUnspecified("TabbedPane.disabledForeground"), normalContent, normalContent, normalContent, Color.Companion.getUnspecified-0d7_KjU(), BridgeUtilsKt.retrieveColorOrUnspecified("TabbedPane.disabledUnderlineColor"), selectedUnderline, Color.Companion.getUnspecified-0d7_KjU(), selectedUnderline, null);
        float $this$takeOrElse_u2dD5KLDUw$iv = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("TabbedPane.tabSelectionHeight");
        boolean bl = false;
        float $this$isSpecified$iv$iv = $this$takeOrElse_u2dD5KLDUw$iv;
        boolean bl2 = false;
        boolean bl3 = !Float.isNaN($this$isSpecified$iv$iv);
        if (bl3) {
            f3 = $this$takeOrElse_u2dD5KLDUw$iv;
        } else {
            tabColors = tabColors2;
            boolean bl4 = false;
            int $this$dp$iv = 2;
            boolean $i$f$getDp = false;
            f2 = Dp.constructor-impl($this$dp$iv);
            tabColors2 = tabColors;
            f3 = f2;
        }
        float f4 = f3;
        PaddingValues paddingValues = BridgeUtilsKt.retrieveInsetsAsPaddingValues$default("TabbedPane.tabInsets", null, 2, null);
        int $this$dp$iv = 4;
        boolean $i$f$getDp = false;
        float f5 = Dp.constructor-impl($this$dp$iv);
        int $this$dp$iv2 = 4;
        boolean $i$f$getDp2 = false;
        float f6 = Dp.constructor-impl($this$dp$iv2);
        float $this$takeOrElse_u2dD5KLDUw$iv2 = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("TabbedPane.tabHeight");
        $i$f$takeOrElse-D5KLDUw = false;
        float $this$isSpecified$iv$iv2 = $this$takeOrElse_u2dD5KLDUw$iv2;
        $i$f$isSpecified-0680j_4 = false;
        boolean bl5 = !Float.isNaN($this$isSpecified$iv$iv2);
        if (bl5) {
            f = $this$takeOrElse_u2dD5KLDUw$iv2;
        } else {
            tabColors = tabColors2;
            boolean bl6 = false;
            int $this$dp$iv3 = 24;
            boolean $i$f$getDp3 = false;
            f2 = Dp.constructor-impl($this$dp$iv3);
            tabColors2 = tabColors;
            f = f2;
        }
        float f7 = f;
        ScrollbarStyle scrollbarStyle = ScrollbarBridgeKt.readScrollbarStyle(IntUiBridgeKt.isDark());
        TabContentAlpha tabContentAlpha = new TabContentAlpha(1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        TabIcons tabIcons = new TabIcons(AllIconsKeys.General.INSTANCE.getCloseSmall());
        TabMetrics tabMetrics = new TabMetrics(f4, paddingValues, f7, f6, f5, null);
        TabColors tabColors3 = tabColors2;
        return new TabStyle(tabColors3, tabMetrics, tabIcons, tabContentAlpha, scrollbarStyle);
    }

    private static final TabStyle readEditorTabStyle() {
        float f;
        float f2;
        TabColors tabColors;
        float f3;
        TabColors colors;
        java.awt.Color color = JBUI.CurrentTheme.EditorTabs.background();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"background(...)");
        long normalBackground = BridgeUtilsKt.toComposeColor(color);
        long selectedBackground = BridgeUtilsKt.toComposeColorOrUnspecified(JBUI.CurrentTheme.EditorTabs.underlinedTabBackground());
        long normalContent = BridgeUtilsKt.retrieveColorOrUnspecified("TabbedPane.foreground");
        long selectedUnderline = BridgeUtilsKt.retrieveColorOrUnspecified("TabbedPane.underlineColor");
        java.awt.Color color2 = JBUI.CurrentTheme.EditorTabs.hoverBackground();
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"hoverBackground(...)");
        TabColors tabColors2 = colors = new TabColors(normalBackground, normalBackground, selectedBackground, BridgeUtilsKt.toComposeColor(color2), selectedBackground, normalContent, BridgeUtilsKt.retrieveColorOrUnspecified("TabbedPane.disabledForeground"), normalContent, normalContent, normalContent, Color.Companion.getUnspecified-0d7_KjU(), BridgeUtilsKt.retrieveColorOrUnspecified("TabbedPane.disabledUnderlineColor"), selectedUnderline, Color.Companion.getUnspecified-0d7_KjU(), selectedUnderline, null);
        float $this$takeOrElse_u2dD5KLDUw$iv = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("TabbedPane.tabSelectionHeight");
        boolean bl = false;
        float $this$isSpecified$iv$iv = $this$takeOrElse_u2dD5KLDUw$iv;
        boolean bl2 = false;
        boolean bl3 = !Float.isNaN($this$isSpecified$iv$iv);
        if (bl3) {
            f3 = $this$takeOrElse_u2dD5KLDUw$iv;
        } else {
            tabColors = tabColors2;
            boolean bl4 = false;
            int $this$dp$iv = 2;
            boolean $i$f$getDp = false;
            f2 = Dp.constructor-impl($this$dp$iv);
            tabColors2 = tabColors;
            f3 = f2;
        }
        float f4 = f3;
        PaddingValues paddingValues = BridgeUtilsKt.retrieveInsetsAsPaddingValues$default("TabbedPane.tabInsets", null, 2, null);
        int $this$dp$iv = 4;
        boolean $i$f$getDp = false;
        float f5 = Dp.constructor-impl($this$dp$iv);
        int $this$dp$iv2 = 4;
        boolean $i$f$getDp2 = false;
        float f6 = Dp.constructor-impl($this$dp$iv2);
        float $this$takeOrElse_u2dD5KLDUw$iv2 = BridgeUtilsKt.retrieveIntAsDpOrUnspecified("TabbedPane.tabHeight");
        $i$f$takeOrElse-D5KLDUw = false;
        float $this$isSpecified$iv$iv2 = $this$takeOrElse_u2dD5KLDUw$iv2;
        $i$f$isSpecified-0680j_4 = false;
        boolean bl5 = !Float.isNaN($this$isSpecified$iv$iv2);
        if (bl5) {
            f = $this$takeOrElse_u2dD5KLDUw$iv2;
        } else {
            tabColors = tabColors2;
            boolean bl6 = false;
            int $this$dp$iv3 = 24;
            boolean $i$f$getDp3 = false;
            f2 = Dp.constructor-impl($this$dp$iv3);
            tabColors2 = tabColors;
            f = f2;
        }
        float f7 = f;
        ScrollbarStyle scrollbarStyle = ScrollbarBridgeKt.readScrollbarStyle(IntUiBridgeKt.isDark());
        TabContentAlpha tabContentAlpha = new TabContentAlpha(0.7f, 0.7f, 1.0f, 1.0f, 1.0f, 0.7f, 0.7f, 1.0f, 1.0f, 1.0f);
        TabIcons tabIcons = new TabIcons(AllIconsKeys.General.INSTANCE.getCloseSmall());
        TabMetrics tabMetrics = new TabMetrics(f4, paddingValues, f7, f6, f5, null);
        TabColors tabColors3 = tabColors2;
        return new TabStyle(tabColors3, tabMetrics, tabIcons, tabContentAlpha, scrollbarStyle);
    }

    private static final CircularProgressStyle readCircularProgressStyle(boolean isDark) {
        long l;
        long l2 = DurationKt.toDuration((int)125, (DurationUnit)DurationUnit.MILLISECONDS);
        long $this$takeOrElse_u2dDxMtmZc$iv = BridgeUtilsKt.retrieveColorOrUnspecified("ProgressIcon.color");
        boolean bl = false;
        long $this$isSpecified$iv$iv = $this$takeOrElse_u2dDxMtmZc$iv;
        boolean bl2 = false;
        if ($this$isSpecified$iv$iv != 16L) {
            l = $this$takeOrElse_u2dDxMtmZc$iv;
        } else {
            long l3 = l2;
            boolean bl3 = false;
            long l4 = isDark ? ColorKt.Color(4285494138L) : ColorKt.Color(4289244605L);
            l2 = l3;
            l = l4;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        long l5 = l;
        long l6 = l2;
        return new CircularProgressStyle(l6, l5, defaultConstructorMarker);
    }

    private static final TooltipStyle readTooltipStyle() {
        Insets insets = JBUI.CurrentTheme.HelpTooltip.smallTextBorderInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"smallTextBorderInsets(...)");
        PaddingValues paddingValues = BridgeUtilsKt.toPaddingValues(insets);
        long l = DurationKt.toDuration((int)Registry.Companion.intValue("ide.tooltip.initialDelay"), (DurationUnit)DurationUnit.MILLISECONDS);
        JBValue jBValue = JBUI.CurrentTheme.Tooltip.CORNER_RADIUS;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"CORNER_RADIUS");
        TooltipMetrics tooltipMetrics = TooltipMetrics.Companion.defaults-8qf-r9M$default(TooltipMetrics.Companion, paddingValues, l, CornerSizeKt.CornerSize-0680j_4(BridgeUtilsKt.getDp(jBValue)), 0.0f, 0.0f, null, 56, null);
        long l2 = BridgeUtilsKt.retrieveColorOrUnspecified("ToolTip.foreground");
        long l3 = BridgeUtilsKt.retrieveColorOrUnspecified("ToolTip.background");
        java.awt.Color color = JBUI.CurrentTheme.Tooltip.borderColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"borderColor(...)");
        long l4 = BridgeUtilsKt.toComposeColor(color);
        long l5 = BridgeUtilsKt.retrieveColorOrUnspecified("Notification.Shadow.bottom1Color");
        TooltipColors tooltipColors = new TooltipColors(l3, l2, l4, l5, null);
        return new TooltipStyle(tooltipColors, tooltipMetrics);
    }

    /*
     * WARNING - void declaration
     */
    private static final IconButtonStyle readIconButtonStyle() {
        void arg0$iv;
        JBValue jBValue = DarculaUIUtil.BUTTON_ARC;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"BUTTON_ARC");
        float f = BridgeUtilsKt.getDp(jBValue);
        int other$iv = 2;
        boolean bl = false;
        int $this$dp$iv = 1;
        boolean $i$f$getDp = false;
        float f2 = Dp.constructor-impl($this$dp$iv);
        $this$dp$iv = 0;
        $i$f$getDp = false;
        PaddingValues paddingValues = PaddingKt.PaddingValues-0680j_4(Dp.constructor-impl($this$dp$iv));
        $this$dp$iv = 24;
        $i$f$getDp = false;
        float f3 = Dp.constructor-impl($this$dp$iv);
        $this$dp$iv = 24;
        $i$f$getDp = false;
        IconButtonMetrics iconButtonMetrics = new IconButtonMetrics(CornerSizeKt.CornerSize-0680j_4(Dp.constructor-impl((float)(arg0$iv / (float)other$iv))), f2, paddingValues, DpKt.DpSize-YgX7TsA(f3, Dp.constructor-impl($this$dp$iv)), null);
        long l = BridgeUtilsKt.retrieveColorOrUnspecified("ToolWindow.Button.selectedForeground");
        long l2 = Color.Companion.getUnspecified-0d7_KjU();
        long l3 = Color.Companion.getUnspecified-0d7_KjU();
        long l4 = BridgeUtilsKt.retrieveColorOrUnspecified("ActionButton.pressedBackground");
        long l5 = BridgeUtilsKt.retrieveColorOrUnspecified("ToolWindow.Button.selectedBackground");
        long l6 = BridgeUtilsKt.retrieveColorOrUnspecified("ActionButton.pressedBackground");
        long l7 = BridgeUtilsKt.retrieveColorOrUnspecified("ActionButton.hoverBackground");
        long l8 = BridgeUtilsKt.retrieveColorOrUnspecified("ActionButton.hoverBackground");
        long l9 = Color.Companion.getUnspecified-0d7_KjU();
        long l10 = Color.Companion.getUnspecified-0d7_KjU();
        long l11 = BridgeUtilsKt.retrieveColorOrUnspecified("ActionButton.pressedBackground");
        long l12 = BridgeUtilsKt.retrieveColorOrUnspecified("ToolWindow.Button.selectedBackground");
        long l13 = Color.Companion.getUnspecified-0d7_KjU();
        long l14 = BridgeUtilsKt.retrieveColorOrUnspecified("ActionButton.pressedBorderColor");
        long l15 = BridgeUtilsKt.retrieveColorOrUnspecified("ActionButton.hoverBorderColor");
        IconButtonColors iconButtonColors = new IconButtonColors(l, l2, l3, l4, l5, l8, l6, l7, l9, l10, l11, l12, l13, l14, l15, null);
        return new IconButtonStyle(iconButtonColors, iconButtonMetrics);
    }

    /*
     * WARNING - void declaration
     */
    private static final CornerSize getComponentArc() {
        void arg0$iv;
        JBValue jBValue = DarculaUIUtil.COMPONENT_ARC;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"COMPONENT_ARC");
        float f = BridgeUtilsKt.getDp(jBValue);
        int other$iv = 2;
        boolean bl = false;
        return CornerSizeKt.CornerSize-0680j_4(Dp.constructor-impl((float)(arg0$iv / (float)other$iv)));
    }
}

