###############################################################################
#
# Tests for XlsxWriter.
#
# SPDX-License-Identifier: BSD-2-Clause
#
# Copyright (c), 2013-2025, John McNamara, jmcnamara@cpan.org
#

import unittest
from io import StringIO

from xlsxwriter.worksheet import Worksheet


class TestWriteCustomFilters(unittest.TestCase):
    """
    Test the Worksheet _write_custom_filters() method.

    """

    def setUp(self):
        self.fh = StringIO()
        self.worksheet = Worksheet()
        self.worksheet._set_filehandle(self.fh)

    def test_write_custom_filters_1(self):
        """Test the _write_custom_filters() method"""

        self.worksheet._write_custom_filters([4, 4000])

        exp = """<customFilters><customFilter operator="greaterThan" val="4000"/></customFilters>"""
        got = self.fh.getvalue()

        self.assertEqual(exp, got)

    def test_write_custom_filters_2(self):
        """Test the _write_custom_filters() method"""

        self.worksheet._write_custom_filters([4, 3000, 0, 1, 8000])

        exp = """<customFilters and="1"><customFilter operator="greaterThan" val="3000"/><customFilter operator="lessThan" val="8000"/></customFilters>"""
        got = self.fh.getvalue()

        self.assertEqual(exp, got)
