import _typeof from "@babel/runtime/helpers/typeof";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import { migrateEvaluationDetails, migrateSecondaryExposures } from '../utils';
// Reference: https://github.com/statsig-io/js-lite/blob/main/src/DynamicConfig.ts
export var DynamicConfig = /*#__PURE__*/function () {
  function DynamicConfig(configName, configValue, ruleID, evaluationDetails) {
    var secondaryExposures = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : [];
    var allocatedExperimentName = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : '';
    var onDefaultValueFallback = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : null;
    _classCallCheck(this, DynamicConfig);
    this.value = configValue;
    this._name = configName;
    this._ruleID = ruleID;
    this._secondaryExposures = secondaryExposures;
    this._allocatedExperimentName = allocatedExperimentName;
    this._evaluationDetails = evaluationDetails;
    this._onDefaultValueFallback = onDefaultValueFallback;
  }
  return _createClass(DynamicConfig, [{
    key: "get",
    value: function get(key, defaultValue, typeGuard) {
      var _this$_onDefaultValue2;
      var val = this.getValue(key, defaultValue);
      if (val == null) {
        return defaultValue;
      }
      var expectedType = Array.isArray(defaultValue) ? 'array' : _typeof(defaultValue);
      var actualType = Array.isArray(val) ? 'array' : _typeof(val);
      if (typeGuard) {
        var _this$_onDefaultValue;
        if (typeGuard(val)) {
          this.fireExposure(key);
          return val;
        }
        (_this$_onDefaultValue = this._onDefaultValueFallback) === null || _this$_onDefaultValue === void 0 || _this$_onDefaultValue.call(this, this, key, expectedType, actualType);
        return defaultValue;
      }
      if (defaultValue == null || expectedType === actualType) {
        this.fireExposure(key);
        return val;
      }
      (_this$_onDefaultValue2 = this._onDefaultValueFallback) === null || _this$_onDefaultValue2 === void 0 || _this$_onDefaultValue2.call(this, this, key, expectedType, actualType);
      return defaultValue;
    }
  }, {
    key: "getValue",
    value: function getValue(key, defaultValue) {
      if (key == null) {
        return this.value;
      }
      if (defaultValue == null) {
        defaultValue = null;
      }
      if (this.value[key] == null) {
        return defaultValue;
      }
      this.fireExposure(key);
      return this.value[key];
    }
  }, {
    key: "fireExposure",
    value: function fireExposure(key) {
      // Call the wrapped experiment's get method to fire exposure
      if (this.experiment) {
        this.experiment.get(key);
      }
    }
  }], [{
    key: "fromExperiment",
    value: function fromExperiment(experiment) {
      var _experiment$__evaluat, _experiment$__evaluat2, _experiment$groupName;
      var config = new DynamicConfig(experiment.name, experiment.value, experiment.ruleID, migrateEvaluationDetails(experiment.details), migrateSecondaryExposures((_experiment$__evaluat = (_experiment$__evaluat2 = experiment.__evaluation) === null || _experiment$__evaluat2 === void 0 ? void 0 : _experiment$__evaluat2.secondary_exposures) !== null && _experiment$__evaluat !== void 0 ? _experiment$__evaluat : []), (_experiment$groupName = experiment.groupName) !== null && _experiment$groupName !== void 0 ? _experiment$groupName : undefined);
      config.experiment = experiment;
      return config;
    }

    /** @deprecated - do not use, this is still exported for backwards compatibility but will be removed in the next major version  */
  }]);
}();