"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useLazyCallback;
var _useLazyRef = _interopRequireDefault(require("./use-lazy-ref"));
/**
 * Saves the passed through `callback` to a ref to ensure stability between renders.
 * As a feature this callback will only be created **once**,
 * this means it will have a stale closure on subsequent render.
 *
 * If you need to access things in the parent scope make sure to do it with refs.
 *
 * ```js
 * const callback = useLazyCallback(() => 10);
 * ```
 *
 * @param callback
 */
function useLazyCallback(callback) {
  var ref = (0, _useLazyRef.default)(function () {
    return callback;
  });
  return ref.current;
}