"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const error_1 = require("../utils/error");
/**
 * ## CSS Map
 *
 * Creates a collection of named styles that are statically typed and useable with other Compiled APIs.
 * For further details [read the documentation](https://compiledcssinjs.com/docs/api-cssmap).
 *
 * @example
 * ```
 * const styles = cssMap({
 *  none: { borderStyle: 'none' },
 *  solid: { borderStyle: 'solid' },
 * });
 *
 * <div css={styles.solid} />
 * ```
 */
function cssMap(_styles) {
    throw (0, error_1.createSetupError)();
}
exports.default = cssMap;
//# sourceMappingURL=index.js.map