import * as Constants from '../../constants/settings'
import * as Container from '../../util/container'
import * as RouteTreeGen from '../../actions/route-tree-gen'
import * as SettingsGen from '../../actions/settings-gen'
import Feedback from './index'
import {anyWaiting} from '../../constants/waiting'

type OwnProps = Container.RouteProps<'settingsTabs.feedbackTab'>

export default Container.connect(
  state => ({
    loggedOut: !state.config.loggedIn,
    sendError: state.settings.feedback.error,
    sending: anyWaiting(state, Constants.sendFeedbackWaitingKey),
  }),
  dispatch => ({
    onBack: () => dispatch(RouteTreeGen.createNavigateUp()),
    onSendFeedback: (feedback: string, sendLogs: boolean, sendMaxBytes: boolean) =>
      dispatch(SettingsGen.createSendFeedback({feedback, sendLogs, sendMaxBytes})),
  }),
  (s, d, o: OwnProps) => ({
    ...s,
    ...d,
    feedback: o.route.params?.feedback ?? '',
    onFeedbackDone: () => null,
    showInternalSuccessBanner: true,
  })
)(Feedback)
