The Steam protocol plugin for bitlbee. This plugin uses the Steam Mobile
API allowing it to run alongside the main Steam client. It is worth
noting that the Steam Mobile API is HTTP based, which does lead to mild
latency.

## Package Repositories

There are package repositories available for various distributions.

See: https://jgeboski.github.io

## Building and Installing

Make sure bitlbee and its headers have been installed. If bitlbee came
from the distribution's repository, it will most likely need the
development package, usually bitlbee-dev.

If bitlbee was built by hand (or alike via a script), ensure the make
target `install-dev` is invoked. This target is not called by default,
and will install the headers that are needed.

Do *not* use the source tree headers unless you know what you are
doing. This can lead to mismatched header versions, which often times
will lead to bad things.

    $ git clone https://github.com/jgeboski/bitlbee-steam.git
    $ cd bitlbee-steam

With a "global" (or system) bitlbee installation:

    $ ./autogen.sh
    $ make
    $ make install

Or with a "local" bitlbee installation (location: $HOME/bitlbee):

    $ export BITLBEE_CFLAGS="-I$HOME/bitlbee/include/bitlbee"
    $ export BITLBEE_LIBS=""
    $ ./autogen.sh --libdir=$HOME/bitlbee/lib
    $ make
    $ make install

## Usage

Before continuing, please note, any account which is a "Limited User
Account" will not work with this plugin. These limited accounts have
many features negated from them, which are required for this plugin
to function correctly as a chat client. Please, do not file issues in
the tracker if your account is a limited account.

See: https://support.steampowered.com/kb_article.php?ref=3330-IAGK-7663

Getting started:

    > account add steam <username> <password>
    > account steam on

Authenticating with SteamGuard:

    > account steam set authcode <code>

Captcha interaction may be required:

    > account steam set captcha <text>

Output game play statues to the account channel(s):

    > account steam set game_status true

## Common Issues

Below is a list of common issues and their respective fixes.

### Expired token or session

When the token or session identifier has expired, the user may see
errors thrown by the plugin. Sometimes these errors are one time, but
if they repeatedly and reliably happen, then a new token and session
identifier need to be obtained.

```
Login error: HTTP: 401 Unauthorized
```

Fixing this issue is done by forcing the plugin to re-authenticate:

```
account steam off
account steam set -del token
account steam on
```

The account can also be deleted and re-added, but this will cause all
other local metadata to be lost, such as local buddy aliases.

## Debugging

One of the two supported environment variables can be defined to enable
debugging output. This can be used in unison with debuggers such as
GDB, which should enable easier tracing of bugs.

When posting to the issue tracker, please ensure any sensitive
information has been stripped.

For bitlbee and the plugin:

    $ export BITLBEE_DEBUG=1
    OR
    $ BITLBEE_DEBUG=1 gdb ...

For just the plugin:

    $ export BITLBEE_DEBUG_STEAM=1
    OR
    $ BITLBEE_DEBUG_STEAM=1 gdb ...

Obtaining a GDB backtrace:

    $ gdb \
        -ex 'handle SIGPIPE nostop noprint pass' \
        -ex 'break g_log' -ex run -ex bt \
        --args /usr/sbin/bitlbee -Dnvc /etc/bitlbee/bitlbee.conf
