"use strict";
/*
 * ATTENTION: The "eval" devtool has been used (maybe by default in mode: "development").
 * This devtool is neither made for production nor for readable output files.
 * It uses "eval()" calls to create a separate source file in the browser devtools.
 * If you are trying to read the output file, select a different devtool (https://webpack.js.org/configuration/devtool/)
 * or disable the default devtool with "devtool: false".
 * If you are looking for production-ready output files, see mode: "production" (https://webpack.js.org/configuration/mode/).
 */
(self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] = self["webpackChunk_JUPYTERLAB_CORE_OUTPUT"] || []).push([["vendors-node_modules_lumino_algorithm_dist_index_es6_js"],{

/***/ "../node_modules/@lumino/algorithm/dist/index.es6.js":
/*!***********************************************************!*\
  !*** ../node_modules/@lumino/algorithm/dist/index.es6.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ArrayExt: () => (/* binding */ ArrayExt),\n/* harmony export */   StringExt: () => (/* binding */ StringExt),\n/* harmony export */   chain: () => (/* binding */ chain),\n/* harmony export */   each: () => (/* binding */ each),\n/* harmony export */   empty: () => (/* binding */ empty),\n/* harmony export */   enumerate: () => (/* binding */ enumerate),\n/* harmony export */   every: () => (/* binding */ every),\n/* harmony export */   filter: () => (/* binding */ filter),\n/* harmony export */   find: () => (/* binding */ find),\n/* harmony export */   findIndex: () => (/* binding */ findIndex),\n/* harmony export */   map: () => (/* binding */ map),\n/* harmony export */   max: () => (/* binding */ max),\n/* harmony export */   min: () => (/* binding */ min),\n/* harmony export */   minmax: () => (/* binding */ minmax),\n/* harmony export */   once: () => (/* binding */ once),\n/* harmony export */   range: () => (/* binding */ range),\n/* harmony export */   reduce: () => (/* binding */ reduce),\n/* harmony export */   repeat: () => (/* binding */ repeat),\n/* harmony export */   retro: () => (/* binding */ retro),\n/* harmony export */   some: () => (/* binding */ some),\n/* harmony export */   stride: () => (/* binding */ stride),\n/* harmony export */   take: () => (/* binding */ take),\n/* harmony export */   toArray: () => (/* binding */ toArray),\n/* harmony export */   toObject: () => (/* binding */ toObject),\n/* harmony export */   topologicSort: () => (/* binding */ topologicSort),\n/* harmony export */   zip: () => (/* binding */ zip)\n/* harmony export */ });\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * The namespace for array-specific algorithms.\n */\nvar ArrayExt;\n(function (ArrayExt) {\n    /**\n     * Find the index of the first occurrence of a value in an array.\n     *\n     * @param array - The array-like object to search.\n     *\n     * @param value - The value to locate in the array. Values are\n     *   compared using strict `===` equality.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The index of the first occurrence of the value, or `-1`\n     *   if the value is not found.\n     *\n     * #### Notes\n     * If `stop < start` the search will wrap at the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `start` or `stop` which is non-integral.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = ['one', 'two', 'three', 'four', 'one'];\n     * ArrayExt.firstIndexOf(data, 'red');        // -1\n     * ArrayExt.firstIndexOf(data, 'one');        // 0\n     * ArrayExt.firstIndexOf(data, 'one', 1);     // 4\n     * ArrayExt.firstIndexOf(data, 'two', 2);     // -1\n     * ArrayExt.firstIndexOf(data, 'two', 2, 1);  // 1\n     * ```\n     */\n    function firstIndexOf(array, value, start = 0, stop = -1) {\n        let n = array.length;\n        if (n === 0) {\n            return -1;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        let span;\n        if (stop < start) {\n            span = stop + 1 + (n - start);\n        }\n        else {\n            span = stop - start + 1;\n        }\n        for (let i = 0; i < span; ++i) {\n            let j = (start + i) % n;\n            if (array[j] === value) {\n                return j;\n            }\n        }\n        return -1;\n    }\n    ArrayExt.firstIndexOf = firstIndexOf;\n    /**\n     * Find the index of the last occurrence of a value in an array.\n     *\n     * @param array - The array-like object to search.\n     *\n     * @param value - The value to locate in the array. Values are\n     *   compared using strict `===` equality.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The index of the last occurrence of the value, or `-1`\n     *   if the value is not found.\n     *\n     * #### Notes\n     * If `start < stop` the search will wrap at the front of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `start` or `stop` which is non-integral.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = ['one', 'two', 'three', 'four', 'one'];\n     * ArrayExt.lastIndexOf(data, 'red');        // -1\n     * ArrayExt.lastIndexOf(data, 'one');        // 4\n     * ArrayExt.lastIndexOf(data, 'one', 1);     // 0\n     * ArrayExt.lastIndexOf(data, 'two', 0);     // -1\n     * ArrayExt.lastIndexOf(data, 'two', 0, 1);  // 1\n     * ```\n     */\n    function lastIndexOf(array, value, start = -1, stop = 0) {\n        let n = array.length;\n        if (n === 0) {\n            return -1;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        let span;\n        if (start < stop) {\n            span = start + 1 + (n - stop);\n        }\n        else {\n            span = start - stop + 1;\n        }\n        for (let i = 0; i < span; ++i) {\n            let j = (start - i + n) % n;\n            if (array[j] === value) {\n                return j;\n            }\n        }\n        return -1;\n    }\n    ArrayExt.lastIndexOf = lastIndexOf;\n    /**\n     * Find the index of the first value which matches a predicate.\n     *\n     * @param array - The array-like object to search.\n     *\n     * @param fn - The predicate function to apply to the values.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The index of the first matching value, or `-1` if no\n     *   matching value is found.\n     *\n     * #### Notes\n     * If `stop < start` the search will wrap at the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `start` or `stop` which is non-integral.\n     *\n     * Modifying the length of the array while searching.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * function isEven(value: number): boolean {\n     *   return value % 2 === 0;\n     * }\n     *\n     * let data = [1, 2, 3, 4, 3, 2, 1];\n     * ArrayExt.findFirstIndex(data, isEven);       // 1\n     * ArrayExt.findFirstIndex(data, isEven, 4);    // 5\n     * ArrayExt.findFirstIndex(data, isEven, 6);    // -1\n     * ArrayExt.findFirstIndex(data, isEven, 6, 5); // 1\n     * ```\n     */\n    function findFirstIndex(array, fn, start = 0, stop = -1) {\n        let n = array.length;\n        if (n === 0) {\n            return -1;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        let span;\n        if (stop < start) {\n            span = stop + 1 + (n - start);\n        }\n        else {\n            span = stop - start + 1;\n        }\n        for (let i = 0; i < span; ++i) {\n            let j = (start + i) % n;\n            if (fn(array[j], j)) {\n                return j;\n            }\n        }\n        return -1;\n    }\n    ArrayExt.findFirstIndex = findFirstIndex;\n    /**\n     * Find the index of the last value which matches a predicate.\n     *\n     * @param array - The array-like object to search.\n     *\n     * @param fn - The predicate function to apply to the values.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The index of the last matching value, or `-1` if no\n     *   matching value is found.\n     *\n     * #### Notes\n     * If `start < stop` the search will wrap at the front of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `start` or `stop` which is non-integral.\n     *\n     * Modifying the length of the array while searching.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * function isEven(value: number): boolean {\n     *   return value % 2 === 0;\n     * }\n     *\n     * let data = [1, 2, 3, 4, 3, 2, 1];\n     * ArrayExt.findLastIndex(data, isEven);        // 5\n     * ArrayExt.findLastIndex(data, isEven, 4);     // 3\n     * ArrayExt.findLastIndex(data, isEven, 0);     // -1\n     * ArrayExt.findLastIndex(data, isEven, 0, 1);  // 5\n     * ```\n     */\n    function findLastIndex(array, fn, start = -1, stop = 0) {\n        let n = array.length;\n        if (n === 0) {\n            return -1;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        let d;\n        if (start < stop) {\n            d = start + 1 + (n - stop);\n        }\n        else {\n            d = start - stop + 1;\n        }\n        for (let i = 0; i < d; ++i) {\n            let j = (start - i + n) % n;\n            if (fn(array[j], j)) {\n                return j;\n            }\n        }\n        return -1;\n    }\n    ArrayExt.findLastIndex = findLastIndex;\n    /**\n     * Find the first value which matches a predicate.\n     *\n     * @param array - The array-like object to search.\n     *\n     * @param fn - The predicate function to apply to the values.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The first matching value, or `undefined` if no matching\n     *   value is found.\n     *\n     * #### Notes\n     * If `stop < start` the search will wrap at the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `start` or `stop` which is non-integral.\n     *\n     * Modifying the length of the array while searching.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * function isEven(value: number): boolean {\n     *   return value % 2 === 0;\n     * }\n     *\n     * let data = [1, 2, 3, 4, 3, 2, 1];\n     * ArrayExt.findFirstValue(data, isEven);       // 2\n     * ArrayExt.findFirstValue(data, isEven, 2);    // 4\n     * ArrayExt.findFirstValue(data, isEven, 6);    // undefined\n     * ArrayExt.findFirstValue(data, isEven, 6, 5); // 2\n     * ```\n     */\n    function findFirstValue(array, fn, start = 0, stop = -1) {\n        let index = findFirstIndex(array, fn, start, stop);\n        return index !== -1 ? array[index] : undefined;\n    }\n    ArrayExt.findFirstValue = findFirstValue;\n    /**\n     * Find the last value which matches a predicate.\n     *\n     * @param object - The array-like object to search.\n     *\n     * @param fn - The predicate function to apply to the values.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The last matching value, or `undefined` if no matching\n     *   value is found.\n     *\n     * #### Notes\n     * If `start < stop` the search will wrap at the front of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `start` or `stop` which is non-integral.\n     *\n     * Modifying the length of the array while searching.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * function isEven(value: number): boolean {\n     *   return value % 2 === 0;\n     * }\n     *\n     * let data = [1, 2, 3, 4, 3, 2, 1];\n     * ArrayExt.findLastValue(data, isEven);        // 2\n     * ArrayExt.findLastValue(data, isEven, 4);     // 4\n     * ArrayExt.findLastValue(data, isEven, 0);     // undefined\n     * ArrayExt.findLastValue(data, isEven, 0, 1);  // 2\n     * ```\n     */\n    function findLastValue(array, fn, start = -1, stop = 0) {\n        let index = findLastIndex(array, fn, start, stop);\n        return index !== -1 ? array[index] : undefined;\n    }\n    ArrayExt.findLastValue = findLastValue;\n    /**\n     * Find the index of the first element which compares `>=` to a value.\n     *\n     * @param array - The sorted array-like object to search.\n     *\n     * @param value - The value to locate in the array.\n     *\n     * @param fn - The 3-way comparison function to apply to the values.\n     *   It should return `< 0` if an element is less than a value, `0` if\n     *   an element is equal to a value, or `> 0` if an element is greater\n     *   than a value.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The index of the first element which compares `>=` to the\n     *   value, or `length` if there is no such element. If the computed\n     *   index for `stop` is less than `start`, then the computed index\n     *   for `start` is returned.\n     *\n     * #### Notes\n     * The array must already be sorted in ascending order according to\n     * the comparison function.\n     *\n     * #### Complexity\n     * Logarithmic.\n     *\n     * #### Undefined Behavior\n     * Searching a range which is not sorted in ascending order.\n     *\n     * A `start` or `stop` which is non-integral.\n     *\n     * Modifying the length of the array while searching.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * function numberCmp(a: number, b: number): number {\n     *   return a - b;\n     * }\n     *\n     * let data = [0, 3, 4, 7, 7, 9];\n     * ArrayExt.lowerBound(data, 0, numberCmp);   // 0\n     * ArrayExt.lowerBound(data, 6, numberCmp);   // 3\n     * ArrayExt.lowerBound(data, 7, numberCmp);   // 3\n     * ArrayExt.lowerBound(data, -1, numberCmp);  // 0\n     * ArrayExt.lowerBound(data, 10, numberCmp);  // 6\n     * ```\n     */\n    function lowerBound(array, value, fn, start = 0, stop = -1) {\n        let n = array.length;\n        if (n === 0) {\n            return 0;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        let begin = start;\n        let span = stop - start + 1;\n        while (span > 0) {\n            let half = span >> 1;\n            let middle = begin + half;\n            if (fn(array[middle], value) < 0) {\n                begin = middle + 1;\n                span -= half + 1;\n            }\n            else {\n                span = half;\n            }\n        }\n        return begin;\n    }\n    ArrayExt.lowerBound = lowerBound;\n    /**\n     * Find the index of the first element which compares `>` than a value.\n     *\n     * @param array - The sorted array-like object to search.\n     *\n     * @param value - The value to locate in the array.\n     *\n     * @param fn - The 3-way comparison function to apply to the values.\n     *   It should return `< 0` if an element is less than a value, `0` if\n     *   an element is equal to a value, or `> 0` if an element is greater\n     *   than a value.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The index of the first element which compares `>` than the\n     *   value, or `length` if there is no such element. If the computed\n     *   index for `stop` is less than `start`, then the computed index\n     *   for `start` is returned.\n     *\n     * #### Notes\n     * The array must already be sorted in ascending order according to\n     * the comparison function.\n     *\n     * #### Complexity\n     * Logarithmic.\n     *\n     * #### Undefined Behavior\n     * Searching a range which is not sorted in ascending order.\n     *\n     * A `start` or `stop` which is non-integral.\n     *\n     * Modifying the length of the array while searching.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * function numberCmp(a: number, b: number): number {\n     *   return a - b;\n     * }\n     *\n     * let data = [0, 3, 4, 7, 7, 9];\n     * ArrayExt.upperBound(data, 0, numberCmp);   // 1\n     * ArrayExt.upperBound(data, 6, numberCmp);   // 3\n     * ArrayExt.upperBound(data, 7, numberCmp);   // 5\n     * ArrayExt.upperBound(data, -1, numberCmp);  // 0\n     * ArrayExt.upperBound(data, 10, numberCmp);  // 6\n     * ```\n     */\n    function upperBound(array, value, fn, start = 0, stop = -1) {\n        let n = array.length;\n        if (n === 0) {\n            return 0;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        let begin = start;\n        let span = stop - start + 1;\n        while (span > 0) {\n            let half = span >> 1;\n            let middle = begin + half;\n            if (fn(array[middle], value) > 0) {\n                span = half;\n            }\n            else {\n                begin = middle + 1;\n                span -= half + 1;\n            }\n        }\n        return begin;\n    }\n    ArrayExt.upperBound = upperBound;\n    /**\n     * Test whether two arrays are shallowly equal.\n     *\n     * @param a - The first array-like object to compare.\n     *\n     * @param b - The second array-like object to compare.\n     *\n     * @param fn - The comparison function to apply to the elements. It\n     *   should return `true` if the elements are \"equal\". The default\n     *   compares elements using strict `===` equality.\n     *\n     * @returns Whether the two arrays are shallowly equal.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * Modifying the length of the arrays while comparing.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let d1 = [0, 3, 4, 7, 7, 9];\n     * let d2 = [0, 3, 4, 7, 7, 9];\n     * let d3 = [42];\n     * ArrayExt.shallowEqual(d1, d2);  // true\n     * ArrayExt.shallowEqual(d2, d3);  // false\n     * ```\n     */\n    function shallowEqual(a, b, fn) {\n        // Check for object identity first.\n        if (a === b) {\n            return true;\n        }\n        // Bail early if the lengths are different.\n        if (a.length !== b.length) {\n            return false;\n        }\n        // Compare each element for equality.\n        for (let i = 0, n = a.length; i < n; ++i) {\n            if (fn ? !fn(a[i], b[i]) : a[i] !== b[i]) {\n                return false;\n            }\n        }\n        // The array are shallowly equal.\n        return true;\n    }\n    ArrayExt.shallowEqual = shallowEqual;\n    /**\n     * Create a slice of an array subject to an optional step.\n     *\n     * @param array - The array-like object of interest.\n     *\n     * @param options - The options for configuring the slice.\n     *\n     * @returns A new array with the specified values.\n     *\n     * @throws An exception if the slice `step` is `0`.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `start`, `stop`, or `step` which is non-integral.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = [0, 3, 4, 7, 7, 9];\n     * ArrayExt.slice(data);                         // [0, 3, 4, 7, 7, 9]\n     * ArrayExt.slice(data, { start: 2 });           // [4, 7, 7, 9]\n     * ArrayExt.slice(data, { start: 0, stop: 4 });  // [0, 3, 4, 7]\n     * ArrayExt.slice(data, { step: 2 });            // [0, 4, 7]\n     * ArrayExt.slice(data, { step: -1 });           // [9, 7, 7, 4, 3, 0]\n     * ```\n     */\n    function slice(array, options = {}) {\n        // Extract the options.\n        let { start, stop, step } = options;\n        // Set up the `step` value.\n        if (step === undefined) {\n            step = 1;\n        }\n        // Validate the step size.\n        if (step === 0) {\n            throw new Error('Slice `step` cannot be zero.');\n        }\n        // Look up the length of the array.\n        let n = array.length;\n        // Set up the `start` value.\n        if (start === undefined) {\n            start = step < 0 ? n - 1 : 0;\n        }\n        else if (start < 0) {\n            start = Math.max(start + n, step < 0 ? -1 : 0);\n        }\n        else if (start >= n) {\n            start = step < 0 ? n - 1 : n;\n        }\n        // Set up the `stop` value.\n        if (stop === undefined) {\n            stop = step < 0 ? -1 : n;\n        }\n        else if (stop < 0) {\n            stop = Math.max(stop + n, step < 0 ? -1 : 0);\n        }\n        else if (stop >= n) {\n            stop = step < 0 ? n - 1 : n;\n        }\n        // Compute the slice length.\n        let length;\n        if ((step < 0 && stop >= start) || (step > 0 && start >= stop)) {\n            length = 0;\n        }\n        else if (step < 0) {\n            length = Math.floor((stop - start + 1) / step + 1);\n        }\n        else {\n            length = Math.floor((stop - start - 1) / step + 1);\n        }\n        // Compute the sliced result.\n        let result = [];\n        for (let i = 0; i < length; ++i) {\n            result[i] = array[start + i * step];\n        }\n        // Return the result.\n        return result;\n    }\n    ArrayExt.slice = slice;\n    /**\n     * Move an element in an array from one index to another.\n     *\n     * @param array - The mutable array-like object of interest.\n     *\n     * @param fromIndex - The index of the element to move. Negative\n     *   values are taken as an offset from the end of the array.\n     *\n     * @param toIndex - The target index of the element. Negative\n     *   values are taken as an offset from the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `fromIndex` or `toIndex` which is non-integral.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from from '@lumino/algorithm';\n     *\n     * let data = [0, 1, 2, 3, 4];\n     * ArrayExt.move(data, 1, 2);  // [0, 2, 1, 3, 4]\n     * ArrayExt.move(data, 4, 2);  // [0, 2, 4, 1, 3]\n     * ```\n     */\n    function move(array, fromIndex, toIndex) {\n        let n = array.length;\n        if (n <= 1) {\n            return;\n        }\n        if (fromIndex < 0) {\n            fromIndex = Math.max(0, fromIndex + n);\n        }\n        else {\n            fromIndex = Math.min(fromIndex, n - 1);\n        }\n        if (toIndex < 0) {\n            toIndex = Math.max(0, toIndex + n);\n        }\n        else {\n            toIndex = Math.min(toIndex, n - 1);\n        }\n        if (fromIndex === toIndex) {\n            return;\n        }\n        let value = array[fromIndex];\n        let d = fromIndex < toIndex ? 1 : -1;\n        for (let i = fromIndex; i !== toIndex; i += d) {\n            array[i] = array[i + d];\n        }\n        array[toIndex] = value;\n    }\n    ArrayExt.move = move;\n    /**\n     * Reverse an array in-place.\n     *\n     * @param array - The mutable array-like object of interest.\n     *\n     * @param start - The index of the first element in the range to be\n     *   reversed, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   reversed, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `start` or  `stop` index which is non-integral.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = [0, 1, 2, 3, 4];\n     * ArrayExt.reverse(data, 1, 3);  // [0, 3, 2, 1, 4]\n     * ArrayExt.reverse(data, 3);     // [0, 3, 2, 4, 1]\n     * ArrayExt.reverse(data);        // [1, 4, 2, 3, 0]\n     * ```\n     */\n    function reverse(array, start = 0, stop = -1) {\n        let n = array.length;\n        if (n <= 1) {\n            return;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        while (start < stop) {\n            let a = array[start];\n            let b = array[stop];\n            array[start++] = b;\n            array[stop--] = a;\n        }\n    }\n    ArrayExt.reverse = reverse;\n    /**\n     * Rotate the elements of an array in-place.\n     *\n     * @param array - The mutable array-like object of interest.\n     *\n     * @param delta - The amount of rotation to apply to the elements. A\n     *   positive value will rotate the elements to the left. A negative\n     *   value will rotate the elements to the right.\n     *\n     * @param start - The index of the first element in the range to be\n     *   rotated, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   rotated, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `delta`, `start`, or `stop` which is non-integral.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = [0, 1, 2, 3, 4];\n     * ArrayExt.rotate(data, 2);        // [2, 3, 4, 0, 1]\n     * ArrayExt.rotate(data, -2);       // [0, 1, 2, 3, 4]\n     * ArrayExt.rotate(data, 10);       // [0, 1, 2, 3, 4]\n     * ArrayExt.rotate(data, 9);        // [4, 0, 1, 2, 3]\n     * ArrayExt.rotate(data, 2, 1, 3);  // [4, 2, 0, 1, 3]\n     * ```\n     */\n    function rotate(array, delta, start = 0, stop = -1) {\n        let n = array.length;\n        if (n <= 1) {\n            return;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        if (start >= stop) {\n            return;\n        }\n        let length = stop - start + 1;\n        if (delta > 0) {\n            delta = delta % length;\n        }\n        else if (delta < 0) {\n            delta = ((delta % length) + length) % length;\n        }\n        if (delta === 0) {\n            return;\n        }\n        let pivot = start + delta;\n        reverse(array, start, pivot - 1);\n        reverse(array, pivot, stop);\n        reverse(array, start, stop);\n    }\n    ArrayExt.rotate = rotate;\n    /**\n     * Fill an array with a static value.\n     *\n     * @param array - The mutable array-like object to fill.\n     *\n     * @param value - The static value to use to fill the array.\n     *\n     * @param start - The index of the first element in the range to be\n     *   filled, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   filled, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * #### Notes\n     * If `stop < start` the fill will wrap at the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * A `start` or `stop` which is non-integral.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = ['one', 'two', 'three', 'four'];\n     * ArrayExt.fill(data, 'r');        // ['r', 'r', 'r', 'r']\n     * ArrayExt.fill(data, 'g', 1);     // ['r', 'g', 'g', 'g']\n     * ArrayExt.fill(data, 'b', 2, 3);  // ['r', 'g', 'b', 'b']\n     * ArrayExt.fill(data, 'z', 3, 1);  // ['z', 'z', 'b', 'z']\n     * ```\n     */\n    function fill(array, value, start = 0, stop = -1) {\n        let n = array.length;\n        if (n === 0) {\n            return;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        let span;\n        if (stop < start) {\n            span = stop + 1 + (n - start);\n        }\n        else {\n            span = stop - start + 1;\n        }\n        for (let i = 0; i < span; ++i) {\n            array[(start + i) % n] = value;\n        }\n    }\n    ArrayExt.fill = fill;\n    /**\n     * Insert a value into an array at a specific index.\n     *\n     * @param array - The array of interest.\n     *\n     * @param index - The index at which to insert the value. Negative\n     *   values are taken as an offset from the end of the array.\n     *\n     * @param value - The value to set at the specified index.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * An `index` which is non-integral.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = [0, 1, 2];\n     * ArrayExt.insert(data, 0, -1);  // [-1, 0, 1, 2]\n     * ArrayExt.insert(data, 2, 12);  // [-1, 0, 12, 1, 2]\n     * ArrayExt.insert(data, -1, 7);  // [-1, 0, 12, 1, 7, 2]\n     * ArrayExt.insert(data, 6, 19);  // [-1, 0, 12, 1, 7, 2, 19]\n     * ```\n     */\n    function insert(array, index, value) {\n        let n = array.length;\n        if (index < 0) {\n            index = Math.max(0, index + n);\n        }\n        else {\n            index = Math.min(index, n);\n        }\n        for (let i = n; i > index; --i) {\n            array[i] = array[i - 1];\n        }\n        array[index] = value;\n    }\n    ArrayExt.insert = insert;\n    /**\n     * Remove and return a value at a specific index in an array.\n     *\n     * @param array - The array of interest.\n     *\n     * @param index - The index of the value to remove. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The value at the specified index, or `undefined` if the\n     *   index is out of range.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Undefined Behavior\n     * An `index` which is non-integral.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = [0, 12, 23, 39, 14, 12, 75];\n     * ArrayExt.removeAt(data, 2);   // 23\n     * ArrayExt.removeAt(data, -2);  // 12\n     * ArrayExt.removeAt(data, 10);  // undefined;\n     * ```\n     */\n    function removeAt(array, index) {\n        let n = array.length;\n        if (index < 0) {\n            index += n;\n        }\n        if (index < 0 || index >= n) {\n            return undefined;\n        }\n        let value = array[index];\n        for (let i = index + 1; i < n; ++i) {\n            array[i - 1] = array[i];\n        }\n        array.length = n - 1;\n        return value;\n    }\n    ArrayExt.removeAt = removeAt;\n    /**\n     * Remove the first occurrence of a value from an array.\n     *\n     * @param array - The array of interest.\n     *\n     * @param value - The value to remove from the array. Values are\n     *   compared using strict `===` equality.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The index of the removed value, or `-1` if the value\n     *   is not contained in the array.\n     *\n     * #### Notes\n     * If `stop < start` the search will wrap at the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = [0, 12, 23, 39, 14, 12, 75];\n     * ArrayExt.removeFirstOf(data, 12);        // 1\n     * ArrayExt.removeFirstOf(data, 17);        // -1\n     * ArrayExt.removeFirstOf(data, 39, 3);     // -1\n     * ArrayExt.removeFirstOf(data, 39, 3, 2);  // 2\n     * ```\n     */\n    function removeFirstOf(array, value, start = 0, stop = -1) {\n        let index = firstIndexOf(array, value, start, stop);\n        if (index !== -1) {\n            removeAt(array, index);\n        }\n        return index;\n    }\n    ArrayExt.removeFirstOf = removeFirstOf;\n    /**\n     * Remove the last occurrence of a value from an array.\n     *\n     * @param array - The array of interest.\n     *\n     * @param value - The value to remove from the array. Values are\n     *   compared using strict `===` equality.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The index of the removed value, or `-1` if the value\n     *   is not contained in the array.\n     *\n     * #### Notes\n     * If `start < stop` the search will wrap at the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = [0, 12, 23, 39, 14, 12, 75];\n     * ArrayExt.removeLastOf(data, 12);        // 5\n     * ArrayExt.removeLastOf(data, 17);        // -1\n     * ArrayExt.removeLastOf(data, 39, 2);     // -1\n     * ArrayExt.removeLastOf(data, 39, 2, 3);  // 3\n     * ```\n     */\n    function removeLastOf(array, value, start = -1, stop = 0) {\n        let index = lastIndexOf(array, value, start, stop);\n        if (index !== -1) {\n            removeAt(array, index);\n        }\n        return index;\n    }\n    ArrayExt.removeLastOf = removeLastOf;\n    /**\n     * Remove all occurrences of a value from an array.\n     *\n     * @param array - The array of interest.\n     *\n     * @param value - The value to remove from the array. Values are\n     *   compared using strict `===` equality.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The number of elements removed from the array.\n     *\n     * #### Notes\n     * If `stop < start` the search will conceptually wrap at the end of\n     * the array, however the array will be traversed front-to-back.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * let data = [14, 12, 23, 39, 14, 12, 19, 14];\n     * ArrayExt.removeAllOf(data, 12);        // 2\n     * ArrayExt.removeAllOf(data, 17);        // 0\n     * ArrayExt.removeAllOf(data, 14, 1, 4);  // 1\n     * ```\n     */\n    function removeAllOf(array, value, start = 0, stop = -1) {\n        let n = array.length;\n        if (n === 0) {\n            return 0;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        let count = 0;\n        for (let i = 0; i < n; ++i) {\n            if (start <= stop && i >= start && i <= stop && array[i] === value) {\n                count++;\n            }\n            else if (stop < start &&\n                (i <= stop || i >= start) &&\n                array[i] === value) {\n                count++;\n            }\n            else if (count > 0) {\n                array[i - count] = array[i];\n            }\n        }\n        if (count > 0) {\n            array.length = n - count;\n        }\n        return count;\n    }\n    ArrayExt.removeAllOf = removeAllOf;\n    /**\n     * Remove the first occurrence of a value which matches a predicate.\n     *\n     * @param array - The array of interest.\n     *\n     * @param fn - The predicate function to apply to the values.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The removed `{ index, value }`, which will be `-1` and\n     *   `undefined` if the value is not contained in the array.\n     *\n     * #### Notes\n     * If `stop < start` the search will wrap at the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * function isEven(value: number): boolean {\n     *   return value % 2 === 0;\n     * }\n     *\n     * let data = [0, 12, 23, 39, 14, 12, 75];\n     * ArrayExt.removeFirstWhere(data, isEven);     // { index: 0, value: 0 }\n     * ArrayExt.removeFirstWhere(data, isEven, 2);  // { index: 3, value: 14 }\n     * ArrayExt.removeFirstWhere(data, isEven, 4);  // { index: -1, value: undefined }\n     * ```\n     */\n    function removeFirstWhere(array, fn, start = 0, stop = -1) {\n        let value;\n        let index = findFirstIndex(array, fn, start, stop);\n        if (index !== -1) {\n            value = removeAt(array, index);\n        }\n        return { index, value };\n    }\n    ArrayExt.removeFirstWhere = removeFirstWhere;\n    /**\n     * Remove the last occurrence of a value which matches a predicate.\n     *\n     * @param array - The array of interest.\n     *\n     * @param fn - The predicate function to apply to the values.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The removed `{ index, value }`, which will be `-1` and\n     *   `undefined` if the value is not contained in the array.\n     *\n     * #### Notes\n     * If `start < stop` the search will wrap at the end of the array.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * function isEven(value: number): boolean {\n     *   return value % 2 === 0;\n     * }\n     *\n     * let data = [0, 12, 23, 39, 14, 12, 75];\n     * ArrayExt.removeLastWhere(data, isEven);        // { index: 5, value: 12 }\n     * ArrayExt.removeLastWhere(data, isEven, 2);     // { index: 1, value: 12 }\n     * ArrayExt.removeLastWhere(data, isEven, 2, 1);  // { index: -1, value: undefined }\n     * ```\n     */\n    function removeLastWhere(array, fn, start = -1, stop = 0) {\n        let value;\n        let index = findLastIndex(array, fn, start, stop);\n        if (index !== -1) {\n            value = removeAt(array, index);\n        }\n        return { index, value };\n    }\n    ArrayExt.removeLastWhere = removeLastWhere;\n    /**\n     * Remove all occurrences of values which match a predicate.\n     *\n     * @param array - The array of interest.\n     *\n     * @param fn - The predicate function to apply to the values.\n     *\n     * @param start - The index of the first element in the range to be\n     *   searched, inclusive. The default value is `0`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @param stop - The index of the last element in the range to be\n     *   searched, inclusive. The default value is `-1`. Negative values\n     *   are taken as an offset from the end of the array.\n     *\n     * @returns The number of elements removed from the array.\n     *\n     * #### Notes\n     * If `stop < start` the search will conceptually wrap at the end of\n     * the array, however the array will be traversed front-to-back.\n     *\n     * #### Complexity\n     * Linear.\n     *\n     * #### Example\n     * ```typescript\n     * import { ArrayExt } from '@lumino/algorithm';\n     *\n     * function isEven(value: number): boolean {\n     *   return value % 2 === 0;\n     * }\n     *\n     * function isNegative(value: number): boolean {\n     *   return value < 0;\n     * }\n     *\n     * let data = [0, 12, -13, -9, 23, 39, 14, -15, 12, 75];\n     * ArrayExt.removeAllWhere(data, isEven);            // 4\n     * ArrayExt.removeAllWhere(data, isNegative, 0, 3);  // 2\n     * ```\n     */\n    function removeAllWhere(array, fn, start = 0, stop = -1) {\n        let n = array.length;\n        if (n === 0) {\n            return 0;\n        }\n        if (start < 0) {\n            start = Math.max(0, start + n);\n        }\n        else {\n            start = Math.min(start, n - 1);\n        }\n        if (stop < 0) {\n            stop = Math.max(0, stop + n);\n        }\n        else {\n            stop = Math.min(stop, n - 1);\n        }\n        let count = 0;\n        for (let i = 0; i < n; ++i) {\n            if (start <= stop && i >= start && i <= stop && fn(array[i], i)) {\n                count++;\n            }\n            else if (stop < start && (i <= stop || i >= start) && fn(array[i], i)) {\n                count++;\n            }\n            else if (count > 0) {\n                array[i - count] = array[i];\n            }\n        }\n        if (count > 0) {\n            array.length = n - count;\n        }\n        return count;\n    }\n    ArrayExt.removeAllWhere = removeAllWhere;\n})(ArrayExt || (ArrayExt = {}));\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Chain together several iterables.\n *\n * @deprecated\n *\n * @param objects - The iterable objects of interest.\n *\n * @returns An iterator which yields the values of the iterables\n *   in the order in which they are supplied.\n *\n * #### Example\n * ```typescript\n * import { chain } from '@lumino/algorithm';\n *\n * let data1 = [1, 2, 3];\n * let data2 = [4, 5, 6];\n *\n * let stream = chain(data1, data2);\n *\n * Array.from(stream);  // [1, 2, 3, 4, 5, 6]\n * ```\n */\nfunction* chain(...objects) {\n    for (const object of objects) {\n        yield* object;\n    }\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Create an empty iterator.\n *\n * @returns A new iterator which yields nothing.\n *\n * #### Example\n * ```typescript\n * import { empty } from '@lumino/algorithm';\n *\n * let stream = empty<number>();\n *\n * Array.from(stream);  // []\n * ```\n */\n// eslint-disable-next-line require-yield\nfunction* empty() {\n    return;\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Enumerate an iterable object.\n *\n * @param object - The iterable object of interest.\n *\n * @param start - The starting enum value. The default is `0`.\n *\n * @returns An iterator which yields the enumerated values.\n *\n * #### Example\n * ```typescript\n * import { enumerate } from '@lumino/algorithm';\n *\n * let data = ['foo', 'bar', 'baz'];\n *\n * let stream = enumerate(data, 1);\n *\n * Array.from(stream);  // [[1, 'foo'], [2, 'bar'], [3, 'baz']]\n * ```\n */\nfunction* enumerate(object, start = 0) {\n    for (const value of object) {\n        yield [start++, value];\n    }\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Filter an iterable for values which pass a test.\n *\n * @param object - The iterable object of interest.\n *\n * @param fn - The predicate function to invoke for each value.\n *\n * @returns An iterator which yields the values which pass the test.\n *\n * #### Example\n * ```typescript\n * import { filter } from '@lumino/algorithm';\n *\n * let data = [1, 2, 3, 4, 5, 6];\n *\n * let stream = filter(data, value => value % 2 === 0);\n *\n * Array.from(stream);  // [2, 4, 6]\n * ```\n */\nfunction* filter(object, fn) {\n    let index = 0;\n    for (const value of object) {\n        if (fn(value, index++)) {\n            yield value;\n        }\n    }\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Find the first value in an iterable which matches a predicate.\n *\n * @param object - The iterable object to search.\n *\n * @param fn - The predicate function to apply to the values.\n *\n * @returns The first matching value, or `undefined` if no matching\n *   value is found.\n *\n * #### Complexity\n * Linear.\n *\n * #### Example\n * ```typescript\n * import { find } from '@lumino/algorithm';\n *\n * interface IAnimal { species: string, name: string };\n *\n * function isCat(value: IAnimal): boolean {\n *   return value.species === 'cat';\n * }\n *\n * let data: IAnimal[] = [\n *   { species: 'dog', name: 'spot' },\n *   { species: 'cat', name: 'fluffy' },\n *   { species: 'alligator', name: 'pocho' }\n * ];\n *\n * find(data, isCat).name;  // 'fluffy'\n * ```\n */\nfunction find(object, fn) {\n    let index = 0;\n    for (const value of object) {\n        if (fn(value, index++)) {\n            return value;\n        }\n    }\n    return undefined;\n}\n/**\n * Find the index of the first value which matches a predicate.\n *\n * @param object - The iterable object to search.\n *\n * @param fn - The predicate function to apply to the values.\n *\n * @returns The index of the first matching value, or `-1` if no\n *   matching value is found.\n *\n * #### Complexity\n * Linear.\n *\n * #### Example\n * ```typescript\n * import { findIndex } from '@lumino/algorithm';\n *\n * interface IAnimal { species: string, name: string };\n *\n * function isCat(value: IAnimal): boolean {\n *   return value.species === 'cat';\n * }\n *\n * let data: IAnimal[] = [\n *   { species: 'dog', name: 'spot' },\n *   { species: 'cat', name: 'fluffy' },\n *   { species: 'alligator', name: 'pocho' }\n * ];\n *\n * findIndex(data, isCat);  // 1\n * ```\n */\nfunction findIndex(object, fn) {\n    let index = 0;\n    for (const value of object) {\n        if (fn(value, index++)) {\n            return index - 1;\n        }\n    }\n    return -1;\n}\n/**\n * Find the minimum value in an iterable.\n *\n * @param object - The iterable object to search.\n *\n * @param fn - The 3-way comparison function to apply to the values.\n *   It should return `< 0` if the first value is less than the second.\n *   `0` if the values are equivalent, or `> 0` if the first value is\n *   greater than the second.\n *\n * @returns The minimum value in the iterable. If multiple values are\n *   equivalent to the minimum, the left-most value is returned. If\n *   the iterable is empty, this returns `undefined`.\n *\n * #### Complexity\n * Linear.\n *\n * #### Example\n * ```typescript\n * import { min } from '@lumino/algorithm';\n *\n * function numberCmp(a: number, b: number): number {\n *   return a - b;\n * }\n *\n * min([7, 4, 0, 3, 9, 4], numberCmp);  // 0\n * ```\n */\nfunction min(object, fn) {\n    let result = undefined;\n    for (const value of object) {\n        if (result === undefined) {\n            result = value;\n            continue;\n        }\n        if (fn(value, result) < 0) {\n            result = value;\n        }\n    }\n    return result;\n}\n/**\n * Find the maximum value in an iterable.\n *\n * @param object - The iterable object to search.\n *\n * @param fn - The 3-way comparison function to apply to the values.\n *   It should return `< 0` if the first value is less than the second.\n *   `0` if the values are equivalent, or `> 0` if the first value is\n *   greater than the second.\n *\n * @returns The maximum value in the iterable. If multiple values are\n *   equivalent to the maximum, the left-most value is returned. If\n *   the iterable is empty, this returns `undefined`.\n *\n * #### Complexity\n * Linear.\n *\n * #### Example\n * ```typescript\n * import { max } from '@lumino/algorithm';\n *\n * function numberCmp(a: number, b: number): number {\n *   return a - b;\n * }\n *\n * max([7, 4, 0, 3, 9, 4], numberCmp);  // 9\n * ```\n */\nfunction max(object, fn) {\n    let result = undefined;\n    for (const value of object) {\n        if (result === undefined) {\n            result = value;\n            continue;\n        }\n        if (fn(value, result) > 0) {\n            result = value;\n        }\n    }\n    return result;\n}\n/**\n * Find the minimum and maximum values in an iterable.\n *\n * @param object - The iterable object to search.\n *\n * @param fn - The 3-way comparison function to apply to the values.\n *   It should return `< 0` if the first value is less than the second.\n *   `0` if the values are equivalent, or `> 0` if the first value is\n *   greater than the second.\n *\n * @returns A 2-tuple of the `[min, max]` values in the iterable. If\n *   multiple values are equivalent, the left-most values are returned.\n *   If the iterable is empty, this returns `undefined`.\n *\n * #### Complexity\n * Linear.\n *\n * #### Example\n * ```typescript\n * import { minmax } from '@lumino/algorithm';\n *\n * function numberCmp(a: number, b: number): number {\n *   return a - b;\n * }\n *\n * minmax([7, 4, 0, 3, 9, 4], numberCmp);  // [0, 9]\n * ```\n */\nfunction minmax(object, fn) {\n    let empty = true;\n    let vmin;\n    let vmax;\n    for (const value of object) {\n        if (empty) {\n            vmin = value;\n            vmax = value;\n            empty = false;\n        }\n        else if (fn(value, vmin) < 0) {\n            vmin = value;\n        }\n        else if (fn(value, vmax) > 0) {\n            vmax = value;\n        }\n    }\n    return empty ? undefined : [vmin, vmax];\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Create an array from an iterable of values.\n *\n * @deprecated\n *\n * @param object - The iterable object of interest.\n *\n * @returns A new array of values from the given object.\n *\n * #### Example\n * ```typescript\n * import { toArray } from '@lumino/algorithm';\n *\n * let stream = [1, 2, 3, 4, 5, 6][Symbol.iterator]();\n *\n * toArray(stream);  // [1, 2, 3, 4, 5, 6];\n * ```\n */\nfunction toArray(object) {\n    return Array.from(object);\n}\n/**\n * Create an object from an iterable of key/value pairs.\n *\n * @param object - The iterable object of interest.\n *\n * @returns A new object mapping keys to values.\n *\n * #### Example\n * ```typescript\n * import { toObject } from '@lumino/algorithm';\n *\n * let data: [string, number][] = [['one', 1], ['two', 2], ['three', 3]];\n *\n * toObject(data);  // { one: 1, two: 2, three: 3 }\n * ```\n */\nfunction toObject(object) {\n    const result = {};\n    for (const [key, value] of object) {\n        result[key] = value;\n    }\n    return result;\n}\n/**\n * Invoke a function for each value in an iterable.\n *\n * @deprecated\n *\n * @param object - The iterable object of interest.\n *\n * @param fn - The callback function to invoke for each value.\n *\n * #### Notes\n * Iteration can be terminated early by returning `false` from the\n * callback function.\n *\n * #### Complexity\n * Linear.\n *\n * #### Example\n * ```typescript\n * import { each } from '@lumino/algorithm';\n *\n * let data = [5, 7, 0, -2, 9];\n *\n * each(data, value => { console.log(value); });\n * ```\n */\nfunction each(object, fn) {\n    let index = 0;\n    for (const value of object) {\n        if (false === fn(value, index++)) {\n            return;\n        }\n    }\n}\n/**\n * Test whether all values in an iterable satisfy a predicate.\n *\n * @param object - The iterable object of interest.\n *\n * @param fn - The predicate function to invoke for each value.\n *\n * @returns `true` if all values pass the test, `false` otherwise.\n *\n * #### Notes\n * Iteration terminates on the first `false` predicate result.\n *\n * #### Complexity\n * Linear.\n *\n * #### Example\n * ```typescript\n * import { every } from '@lumino/algorithm';\n *\n * let data = [5, 7, 1];\n *\n * every(data, value => value % 2 === 0);  // false\n * every(data, value => value % 2 === 1);  // true\n * ```\n */\nfunction every(object, fn) {\n    let index = 0;\n    for (const value of object) {\n        if (false === fn(value, index++)) {\n            return false;\n        }\n    }\n    return true;\n}\n/**\n * Test whether any value in an iterable satisfies a predicate.\n *\n * @param object - The iterable object of interest.\n *\n * @param fn - The predicate function to invoke for each value.\n *\n * @returns `true` if any value passes the test, `false` otherwise.\n *\n * #### Notes\n * Iteration terminates on the first `true` predicate result.\n *\n * #### Complexity\n * Linear.\n *\n * #### Example\n * ```typescript\n * import { some } from '@lumino/algorithm';\n *\n * let data = [5, 7, 1];\n *\n * some(data, value => value === 7);  // true\n * some(data, value => value === 3);  // false\n * ```\n */\nfunction some(object, fn) {\n    let index = 0;\n    for (const value of object) {\n        if (fn(value, index++)) {\n            return true;\n        }\n    }\n    return false;\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Transform the values of an iterable with a mapping function.\n *\n * @param object - The iterable object of interest.\n *\n * @param fn - The mapping function to invoke for each value.\n *\n * @returns An iterator which yields the transformed values.\n *\n * #### Example\n * ```typescript\n * import { map } from '@lumino/algorithm';\n *\n * let data = [1, 2, 3];\n *\n * let stream = map(data, value => value * 2);\n *\n * Array.from(stream);  // [2, 4, 6]\n * ```\n */\nfunction* map(object, fn) {\n    let index = 0;\n    for (const value of object) {\n        yield fn(value, index++);\n    }\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Create an iterator of evenly spaced values.\n *\n * @param start - The starting value for the range, inclusive.\n *\n * @param stop - The stopping value for the range, exclusive.\n *\n * @param step - The distance between each value.\n *\n * @returns An iterator which produces evenly spaced values.\n *\n * #### Notes\n * In the single argument form of `range(stop)`, `start` defaults to\n * `0` and `step` defaults to `1`.\n *\n * In the two argument form of `range(start, stop)`, `step` defaults\n * to `1`.\n *\n * #### Example\n * ```typescript\n * import { range } from '@lumino/algorithm';\n *\n * let stream = range(2, 4);\n *\n * Array.from(stream);  // [2, 3]\n * ```\n */\nfunction* range(start, stop, step) {\n    if (stop === undefined) {\n        stop = start;\n        start = 0;\n        step = 1;\n    }\n    else if (step === undefined) {\n        step = 1;\n    }\n    const length = Private.rangeLength(start, stop, step);\n    for (let index = 0; index < length; index++) {\n        yield start + step * index;\n    }\n}\n/**\n * The namespace for the module implementation details.\n */\nvar Private;\n(function (Private) {\n    /**\n     * Compute the effective length of a range.\n     *\n     * @param start - The starting value for the range, inclusive.\n     *\n     * @param stop - The stopping value for the range, exclusive.\n     *\n     * @param step - The distance between each value.\n     *\n     * @returns The number of steps need to traverse the range.\n     */\n    function rangeLength(start, stop, step) {\n        if (step === 0) {\n            return Infinity;\n        }\n        if (start > stop && step > 0) {\n            return 0;\n        }\n        if (start < stop && step < 0) {\n            return 0;\n        }\n        return Math.ceil((stop - start) / step);\n    }\n    Private.rangeLength = rangeLength;\n})(Private || (Private = {}));\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\nfunction reduce(object, fn, initial) {\n    // Setup the iterator and fetch the first value.\n    const it = object[Symbol.iterator]();\n    let index = 0;\n    let first = it.next();\n    // An empty iterator and no initial value is an error.\n    if (first.done && initial === undefined) {\n        throw new TypeError('Reduce of empty iterable with no initial value.');\n    }\n    // If the iterator is empty, return the initial value.\n    if (first.done) {\n        return initial;\n    }\n    // If the iterator has a single item and no initial value, the\n    // reducer is not invoked and the first item is the return value.\n    let second = it.next();\n    if (second.done && initial === undefined) {\n        return first.value;\n    }\n    // If iterator has a single item and an initial value is provided,\n    // the reducer is invoked and that result is the return value.\n    if (second.done) {\n        return fn(initial, first.value, index++);\n    }\n    // Setup the initial accumlated value.\n    let accumulator;\n    if (initial === undefined) {\n        accumulator = fn(first.value, second.value, index++);\n    }\n    else {\n        accumulator = fn(fn(initial, first.value, index++), second.value, index++);\n    }\n    // Iterate the rest of the values, updating the accumulator.\n    let next;\n    while (!(next = it.next()).done) {\n        accumulator = fn(accumulator, next.value, index++);\n    }\n    // Return the final accumulated value.\n    return accumulator;\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Create an iterator which repeats a value a number of times.\n *\n * @deprecated\n *\n * @param value - The value to repeat.\n *\n * @param count - The number of times to repeat the value.\n *\n * @returns A new iterator which repeats the specified value.\n *\n * #### Example\n * ```typescript\n * import { repeat } from '@lumino/algorithm';\n *\n * let stream = repeat(7, 3);\n *\n * Array.from(stream);  // [7, 7, 7]\n * ```\n */\nfunction* repeat(value, count) {\n    while (0 < count--) {\n        yield value;\n    }\n}\n/**\n * Create an iterator which yields a value a single time.\n *\n * @deprecated\n *\n * @param value - The value to wrap in an iterator.\n *\n * @returns A new iterator which yields the value a single time.\n *\n * #### Example\n * ```typescript\n * import { once } from '@lumino/algorithm';\n *\n * let stream = once(7);\n *\n * Array.from(stream);  // [7]\n * ```\n */\nfunction* once(value) {\n    yield value;\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Create an iterator for a retroable object.\n *\n * @param object - The retroable or array-like object of interest.\n *\n * @returns An iterator which traverses the object's values in reverse.\n *\n * #### Example\n * ```typescript\n * import { retro } from '@lumino/algorithm';\n *\n * let data = [1, 2, 3, 4, 5, 6];\n *\n * let stream = retro(data);\n *\n * Array.from(stream);  // [6, 5, 4, 3, 2, 1]\n * ```\n */\nfunction* retro(object) {\n    if (typeof object.retro === 'function') {\n        yield* object.retro();\n    }\n    else {\n        for (let index = object.length - 1; index > -1; index--) {\n            yield object[index];\n        }\n    }\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Topologically sort an iterable of edges.\n *\n * @param edges - The iterable object of edges to sort.\n *   An edge is represented as a 2-tuple of `[fromNode, toNode]`.\n *\n * @returns The topologically sorted array of nodes.\n *\n * #### Notes\n * If a cycle is present in the graph, the cycle will be ignored and\n * the return value will be only approximately sorted.\n *\n * #### Example\n * ```typescript\n * import { topologicSort } from '@lumino/algorithm';\n *\n * let data = [\n *   ['d', 'e'],\n *   ['c', 'd'],\n *   ['a', 'b'],\n *   ['b', 'c']\n * ];\n *\n * topologicSort(data);  // ['a', 'b', 'c', 'd', 'e']\n * ```\n */\nfunction topologicSort(edges) {\n    // Setup the shared sorting state.\n    let sorted = [];\n    let visited = new Set();\n    let graph = new Map();\n    // Add the edges to the graph.\n    for (const edge of edges) {\n        addEdge(edge);\n    }\n    // Visit each node in the graph.\n    for (const [k] of graph) {\n        visit(k);\n    }\n    // Return the sorted results.\n    return sorted;\n    // Add an edge to the graph.\n    function addEdge(edge) {\n        let [fromNode, toNode] = edge;\n        let children = graph.get(toNode);\n        if (children) {\n            children.push(fromNode);\n        }\n        else {\n            graph.set(toNode, [fromNode]);\n        }\n    }\n    // Recursively visit the node.\n    function visit(node) {\n        if (visited.has(node)) {\n            return;\n        }\n        visited.add(node);\n        let children = graph.get(node);\n        if (children) {\n            for (const child of children) {\n                visit(child);\n            }\n        }\n        sorted.push(node);\n    }\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Iterate over an iterable using a stepped increment.\n *\n * @param object - The iterable object of interest.\n *\n * @param step - The distance to step on each iteration. A value\n *   of less than `1` will behave the same as a value of `1`.\n *\n * @returns An iterator which traverses the iterable step-wise.\n *\n * #### Example\n * ```typescript\n * import { stride } from '@lumino/algorithm';\n *\n * let data = [1, 2, 3, 4, 5, 6];\n *\n * let stream = stride(data, 2);\n *\n * Array.from(stream);  // [1, 3, 5];\n * ```\n */\nfunction* stride(object, step) {\n    let count = 0;\n    for (const value of object) {\n        if (0 === count++ % step) {\n            yield value;\n        }\n    }\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * The namespace for string-specific algorithms.\n */\nvar StringExt;\n(function (StringExt) {\n    /**\n     * Find the indices of characters in a source text.\n     *\n     * @param source - The source text which should be searched.\n     *\n     * @param query - The characters to locate in the source text.\n     *\n     * @param start - The index to start the search.\n     *\n     * @returns The matched indices, or `null` if there is no match.\n     *\n     * #### Complexity\n     * Linear on `sourceText`.\n     *\n     * #### Notes\n     * In order for there to be a match, all of the characters in `query`\n     * **must** appear in `source` in the order given by `query`.\n     *\n     * Characters are matched using strict `===` equality.\n     */\n    function findIndices(source, query, start = 0) {\n        let indices = new Array(query.length);\n        for (let i = 0, j = start, n = query.length; i < n; ++i, ++j) {\n            j = source.indexOf(query[i], j);\n            if (j === -1) {\n                return null;\n            }\n            indices[i] = j;\n        }\n        return indices;\n    }\n    StringExt.findIndices = findIndices;\n    /**\n     * A string matcher which uses a sum-of-squares algorithm.\n     *\n     * @param source - The source text which should be searched.\n     *\n     * @param query - The characters to locate in the source text.\n     *\n     * @param start - The index to start the search.\n     *\n     * @returns The match result, or `null` if there is no match.\n     *   A lower `score` represents a stronger match.\n     *\n     * #### Complexity\n     * Linear on `sourceText`.\n     *\n     * #### Notes\n     * This scoring algorithm uses a sum-of-squares approach to determine\n     * the score. In order for there to be a match, all of the characters\n     * in `query` **must** appear in `source` in order. The index of each\n     * matching character is squared and added to the score. This means\n     * that early and consecutive character matches are preferred, while\n     * late matches are heavily penalized.\n     */\n    function matchSumOfSquares(source, query, start = 0) {\n        let indices = findIndices(source, query, start);\n        if (!indices) {\n            return null;\n        }\n        let score = 0;\n        for (let i = 0, n = indices.length; i < n; ++i) {\n            let j = indices[i] - start;\n            score += j * j;\n        }\n        return { score, indices };\n    }\n    StringExt.matchSumOfSquares = matchSumOfSquares;\n    /**\n     * A string matcher which uses a sum-of-deltas algorithm.\n     *\n     * @param source - The source text which should be searched.\n     *\n     * @param query - The characters to locate in the source text.\n     *\n     * @param start - The index to start the search.\n     *\n     * @returns The match result, or `null` if there is no match.\n     *   A lower `score` represents a stronger match.\n     *\n     * #### Complexity\n     * Linear on `sourceText`.\n     *\n     * #### Notes\n     * This scoring algorithm uses a sum-of-deltas approach to determine\n     * the score. In order for there to be a match, all of the characters\n     * in `query` **must** appear in `source` in order. The delta between\n     * the indices are summed to create the score. This means that groups\n     * of matched characters are preferred, while fragmented matches are\n     * penalized.\n     */\n    function matchSumOfDeltas(source, query, start = 0) {\n        let indices = findIndices(source, query, start);\n        if (!indices) {\n            return null;\n        }\n        let score = 0;\n        let last = start - 1;\n        for (let i = 0, n = indices.length; i < n; ++i) {\n            let j = indices[i];\n            score += j - last - 1;\n            last = j;\n        }\n        return { score, indices };\n    }\n    StringExt.matchSumOfDeltas = matchSumOfDeltas;\n    /**\n     * Highlight the matched characters of a source text.\n     *\n     * @param source - The text which should be highlighted.\n     *\n     * @param indices - The indices of the matched characters. They must\n     *   appear in increasing order and must be in bounds of the source.\n     *\n     * @param fn - The function to apply to the matched chunks.\n     *\n     * @returns An array of unmatched and highlighted chunks.\n     */\n    function highlight(source, indices, fn) {\n        // Set up the result array.\n        let result = [];\n        // Set up the counter variables.\n        let k = 0;\n        let last = 0;\n        let n = indices.length;\n        // Iterator over each index.\n        while (k < n) {\n            // Set up the chunk indices.\n            let i = indices[k];\n            let j = indices[k];\n            // Advance the right chunk index until it's non-contiguous.\n            while (++k < n && indices[k] === j + 1) {\n                j++;\n            }\n            // Extract the unmatched text.\n            if (last < i) {\n                result.push(source.slice(last, i));\n            }\n            // Extract and highlight the matched text.\n            if (i < j + 1) {\n                result.push(fn(source.slice(i, j + 1)));\n            }\n            // Update the last visited index.\n            last = j + 1;\n        }\n        // Extract any remaining unmatched text.\n        if (last < source.length) {\n            result.push(source.slice(last));\n        }\n        // Return the highlighted result.\n        return result;\n    }\n    StringExt.highlight = highlight;\n    /**\n     * A 3-way string comparison function.\n     *\n     * @param a - The first string of interest.\n     *\n     * @param b - The second string of interest.\n     *\n     * @returns `-1` if `a < b`, else `1` if `a > b`, else `0`.\n     */\n    function cmp(a, b) {\n        return a < b ? -1 : a > b ? 1 : 0;\n    }\n    StringExt.cmp = cmp;\n})(StringExt || (StringExt = {}));\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Take a fixed number of items from an iterable.\n *\n * @param object - The iterable object of interest.\n *\n * @param count - The number of items to take from the iterable.\n *\n * @returns An iterator which yields the specified number of items\n *   from the source iterable.\n *\n * #### Notes\n * The returned iterator will exhaust early if the source iterable\n * contains an insufficient number of items.\n *\n * #### Example\n * ```typescript\n * import { take } from '@lumino/algorithm';\n *\n * let stream = take([5, 4, 3, 2, 1, 0, -1], 3);\n *\n * Array.from(stream);  // [5, 4, 3]\n * ```\n */\nfunction* take(object, count) {\n    if (count < 1) {\n        return;\n    }\n    const it = object[Symbol.iterator]();\n    let item;\n    while (0 < count-- && !(item = it.next()).done) {\n        yield item.value;\n    }\n}\n\n// Copyright (c) Jupyter Development Team.\n// Distributed under the terms of the Modified BSD License.\n/*-----------------------------------------------------------------------------\n| Copyright (c) 2014-2017, PhosphorJS Contributors\n|\n| Distributed under the terms of the BSD 3-Clause License.\n|\n| The full license is in the file LICENSE, distributed with this software.\n|----------------------------------------------------------------------------*/\n/**\n * Iterate several iterables in lockstep.\n *\n * @param objects - The iterable objects of interest.\n *\n * @returns An iterator which yields successive tuples of values where\n *   each value is taken in turn from the provided iterables. It will\n *   be as long as the shortest provided iterable.\n *\n * #### Example\n * ```typescript\n * import { zip } from '@lumino/algorithm';\n *\n * let data1 = [1, 2, 3];\n * let data2 = [4, 5, 6];\n *\n * let stream = zip(data1, data2);\n *\n * Array.from(stream);  // [[1, 4], [2, 5], [3, 6]]\n * ```\n */\nfunction* zip(...objects) {\n    const iters = objects.map(obj => obj[Symbol.iterator]());\n    let tuple = iters.map(it => it.next());\n    for (; every(tuple, item => !item.done); tuple = iters.map(it => it.next())) {\n        yield tuple.map(item => item.value);\n    }\n}\n\n\n//# sourceMappingURL=index.es6.js.map\n\n\n//# sourceURL=webpack://_JUPYTERLAB.CORE_OUTPUT/../node_modules/@lumino/algorithm/dist/index.es6.js?");

/***/ })

}]);