// Code generated by go-swagger; DO NOT EDIT.

package global_network_manager_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2022-02-15/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ListClustersWithDialerEligibilityReader is a Reader for the ListClustersWithDialerEligibility structure.
type ListClustersWithDialerEligibilityReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListClustersWithDialerEligibilityReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListClustersWithDialerEligibilityOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListClustersWithDialerEligibilityDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListClustersWithDialerEligibilityOK creates a ListClustersWithDialerEligibilityOK with default headers values
func NewListClustersWithDialerEligibilityOK() *ListClustersWithDialerEligibilityOK {
	return &ListClustersWithDialerEligibilityOK{}
}

/*
ListClustersWithDialerEligibilityOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListClustersWithDialerEligibilityOK struct {
	Payload *models.HashicorpCloudGlobalNetworkManager20220215ListClustersWithDialerEligibilityResponse
}

// IsSuccess returns true when this list clusters with dialer eligibility o k response has a 2xx status code
func (o *ListClustersWithDialerEligibilityOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list clusters with dialer eligibility o k response has a 3xx status code
func (o *ListClustersWithDialerEligibilityOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list clusters with dialer eligibility o k response has a 4xx status code
func (o *ListClustersWithDialerEligibilityOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list clusters with dialer eligibility o k response has a 5xx status code
func (o *ListClustersWithDialerEligibilityOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list clusters with dialer eligibility o k response a status code equal to that given
func (o *ListClustersWithDialerEligibilityOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list clusters with dialer eligibility o k response
func (o *ListClustersWithDialerEligibilityOK) Code() int {
	return 200
}

func (o *ListClustersWithDialerEligibilityOK) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters_with_dialer_eligibility][%d] listClustersWithDialerEligibilityOK  %+v", 200, o.Payload)
}

func (o *ListClustersWithDialerEligibilityOK) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters_with_dialer_eligibility][%d] listClustersWithDialerEligibilityOK  %+v", 200, o.Payload)
}

func (o *ListClustersWithDialerEligibilityOK) GetPayload() *models.HashicorpCloudGlobalNetworkManager20220215ListClustersWithDialerEligibilityResponse {
	return o.Payload
}

func (o *ListClustersWithDialerEligibilityOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudGlobalNetworkManager20220215ListClustersWithDialerEligibilityResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListClustersWithDialerEligibilityDefault creates a ListClustersWithDialerEligibilityDefault with default headers values
func NewListClustersWithDialerEligibilityDefault(code int) *ListClustersWithDialerEligibilityDefault {
	return &ListClustersWithDialerEligibilityDefault{
		_statusCode: code,
	}
}

/*
ListClustersWithDialerEligibilityDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListClustersWithDialerEligibilityDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this list clusters with dialer eligibility default response has a 2xx status code
func (o *ListClustersWithDialerEligibilityDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list clusters with dialer eligibility default response has a 3xx status code
func (o *ListClustersWithDialerEligibilityDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list clusters with dialer eligibility default response has a 4xx status code
func (o *ListClustersWithDialerEligibilityDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list clusters with dialer eligibility default response has a 5xx status code
func (o *ListClustersWithDialerEligibilityDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list clusters with dialer eligibility default response a status code equal to that given
func (o *ListClustersWithDialerEligibilityDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list clusters with dialer eligibility default response
func (o *ListClustersWithDialerEligibilityDefault) Code() int {
	return o._statusCode
}

func (o *ListClustersWithDialerEligibilityDefault) Error() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters_with_dialer_eligibility][%d] ListClustersWithDialerEligibility default  %+v", o._statusCode, o.Payload)
}

func (o *ListClustersWithDialerEligibilityDefault) String() string {
	return fmt.Sprintf("[GET /global-network-manager/2022-02-15/organizations/{location.organization_id}/projects/{location.project_id}/clusters_with_dialer_eligibility][%d] ListClustersWithDialerEligibility default  %+v", o._statusCode, o.Payload)
}

func (o *ListClustersWithDialerEligibilityDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ListClustersWithDialerEligibilityDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
