/**
 * Mandelbulber v2, a 3D fractal generator  _%}}i*<.        ____                _______
 * Copyright (C) 2022 Mandelbulber Team   _>]|=||i=i<,     / __ \___  ___ ___  / ___/ /
 *                                        \><||i|=>>%)    / /_/ / _ \/ -_) _ \/ /__/ /__
 * This file is part of Mandelbulber.     )<=i=]=|=i<>    \____/ .__/\__/_//_/\___/____/
 * The project is licensed under GPLv3,   -<>>=|><|||`        /_/
 * see also COPYING file in this folder.    ~+{i%+++
 *
 * trig pow based on code by Inigo Quilez
 * @reference https://www.iquilezles.org/www/articles/mandelbulb/mandelbulb.htm

 * This file has been autogenerated by tools/populateUiInformation.php
 * from the file "fractal_mandelbulb_iq_v2.cpp" in the folder formula/definition
 * D O    N O T    E D I T    T H I S    F I L E !
 */

REAL4 MandelbulbIqV2Iteration(REAL4 z, __constant sFractalCl *fractal, sExtendedAuxCl *aux)
{
	REAL Pow = fractal->bulb.power;
	// extract polar coordinates
	REAL wr = aux->r;
	REAL wi = atan2(z.x, z.y);
	REAL wo = z.z / aux->r;

	if (!fractal->transformCommon.functionEnabledAFalse)
	{
		if (!fractal->transformCommon.functionEnabledFalse)
			wo = acos(wo);
		else
			wo = asin(wo);
	}
	else
	{
		wo = acos(wo) * (1.0f - fractal->transformCommon.scale0)
				 + asin(wo) * fractal->transformCommon.scale0;
	}

	// scale and rotate the point
	wr = pow(aux->r, Pow);
	wo = wo * Pow * fractal->transformCommon.scaleB1;
	wi = wi * Pow * fractal->transformCommon.scaleA1;

	// convert back to cartesian coordinates
	REAL swo = native_sin(wo);
	z.x = swo * native_sin(wi);
	z.z = native_cos(wo);
	z.y = swo * native_cos(wi);
	z *= wr;

	aux->DE = pow(aux->r, Pow - 1.0f) * aux->DE * Pow + 1.0f;
	z.z *= fractal->transformCommon.scale1;
	z += fractal->transformCommon.offset000;
	return z;
}