/*
 *  Print Dialog for Canon LIPS/PS/LIPSLX/UFR2/CAPT Printer.
 *  Copyright CANON INC. 2010
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef _LOAD
#define _LOAD

#include <gtk/gtk.h>

#define MAX_PATH 256
#define GLADE_FILE  "cngplp.ui"

int LoadPDL(const char* print_file);
void UnLoadPDL();
extern void (*ShowPDLDialog)(const char* name, int print);
extern gboolean (*InitPDLController)(GtkWidget* main_dlg, char *printer_name, const char* print_file, gboolean first_load);
extern void (*UpdatePDLData)(int id, const char* value);
extern void (*UpdatePDLDataInt)(int id, int value);
extern void (*ClosePDLController)();
extern void (*SavePDLPrinterData)();
extern void (*PrintPDLFile)();
extern char* (*GetPDLData)(int id);
extern int (*GetPDLDataInt)(int id, int def);
extern int (*ExecPDLJobMode)();

#endif
