use nix::sys::{
    resource::rlim_t,
    signal::{Signal, SIGKILL},
};

#[derive(Debug, Copy, Clone)]
pub struct Config {
    pub death_sig: Option<Signal>,
    pub restore_sigmask: bool,
    pub make_group_leader: bool,
    pub deny_tsc: bool,
    pub keep: bool,
    pub stop: bool,
    pub ssb: bool,
    pub append_only: bool,
    pub restrict_kptr: bool,
    pub restrict_prlimit: bool,
    pub rlimit_as: Option<rlim_t>,
    pub rlimit_core: Option<rlim_t>,
    pub rlimit_cpu: Option<rlim_t>,
    pub rlimit_data: Option<rlim_t>,
    pub rlimit_fsize: Option<rlim_t>,
    pub rlimit_memlock: Option<rlim_t>,
    pub rlimit_msgqueue: Option<rlim_t>,
    pub rlimit_nice: Option<rlim_t>,
    pub rlimit_nofile: Option<rlim_t>,
    pub rlimit_nproc: Option<rlim_t>,
    pub rlimit_rtprio: Option<rlim_t>,
    pub rlimit_rttime: Option<rlim_t>,
    pub rlimit_sigpending: Option<rlim_t>,
    pub rlimit_stack: Option<rlim_t>,
}

impl Default for Config {
    fn default() -> Config {
        Config {
            death_sig: Some(SIGKILL),
            restore_sigmask: true,
            make_group_leader: false,
            deny_tsc: false,
            keep: false,
            stop: false,
            ssb: false,
            append_only: false,
            restrict_kptr: false,
            restrict_prlimit: false,
            rlimit_as: None,
            rlimit_core: None,
            rlimit_cpu: None,
            rlimit_data: None,
            rlimit_fsize: None,
            rlimit_memlock: None,
            rlimit_msgqueue: None,
            rlimit_nice: None,
            rlimit_nofile: None,
            rlimit_nproc: None,
            rlimit_rtprio: None,
            rlimit_rttime: None,
            rlimit_sigpending: None,
            rlimit_stack: None,
        }
    }
}
