//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;

use crate::*;

// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamPropertyKey = NSString;

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStreamStatus(pub NSUInteger);
impl NSStreamStatus {
    #[doc(alias = "NSStreamStatusNotOpen")]
    pub const NotOpen: Self = Self(0);
    #[doc(alias = "NSStreamStatusOpening")]
    pub const Opening: Self = Self(1);
    #[doc(alias = "NSStreamStatusOpen")]
    pub const Open: Self = Self(2);
    #[doc(alias = "NSStreamStatusReading")]
    pub const Reading: Self = Self(3);
    #[doc(alias = "NSStreamStatusWriting")]
    pub const Writing: Self = Self(4);
    #[doc(alias = "NSStreamStatusAtEnd")]
    pub const AtEnd: Self = Self(5);
    #[doc(alias = "NSStreamStatusClosed")]
    pub const Closed: Self = Self(6);
    #[doc(alias = "NSStreamStatusError")]
    pub const Error: Self = Self(7);
}

unsafe impl Encode for NSStreamStatus {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStreamStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStreamEvent(pub NSUInteger);
bitflags::bitflags! {
    impl NSStreamEvent: NSUInteger {
        #[doc(alias = "NSStreamEventNone")]
        const None = 0;
        #[doc(alias = "NSStreamEventOpenCompleted")]
        const OpenCompleted = 1<<0;
        #[doc(alias = "NSStreamEventHasBytesAvailable")]
        const HasBytesAvailable = 1<<1;
        #[doc(alias = "NSStreamEventHasSpaceAvailable")]
        const HasSpaceAvailable = 1<<2;
        #[doc(alias = "NSStreamEventErrorOccurred")]
        const ErrorOccurred = 1<<3;
        #[doc(alias = "NSStreamEventEndEncountered")]
        const EndEncountered = 1<<4;
    }
}

unsafe impl Encode for NSStreamEvent {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStreamEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSStream;

    unsafe impl ClassType for NSStream {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSObjectProtocol for NSStream {}

extern_methods!(
    unsafe impl NSStream {
        #[method(open)]
        pub unsafe fn open(&self);

        #[method(close)]
        pub unsafe fn close(&self);

        #[method_id(@__retain_semantics Other delegate)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSStreamDelegate>>>;

        #[method(setDelegate:)]
        pub unsafe fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSStreamDelegate>>);

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other propertyForKey:)]
        pub unsafe fn propertyForKey(
            &self,
            key: &NSStreamPropertyKey,
        ) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSString")]
        #[method(setProperty:forKey:)]
        pub unsafe fn setProperty_forKey(
            &self,
            property: Option<&AnyObject>,
            key: &NSStreamPropertyKey,
        ) -> bool;

        #[cfg(all(feature = "NSObjCRuntime", feature = "NSRunLoop", feature = "NSString"))]
        #[method(scheduleInRunLoop:forMode:)]
        pub unsafe fn scheduleInRunLoop_forMode(
            &self,
            a_run_loop: &NSRunLoop,
            mode: &NSRunLoopMode,
        );

        #[cfg(all(feature = "NSObjCRuntime", feature = "NSRunLoop", feature = "NSString"))]
        #[method(removeFromRunLoop:forMode:)]
        pub unsafe fn removeFromRunLoop_forMode(
            &self,
            a_run_loop: &NSRunLoop,
            mode: &NSRunLoopMode,
        );

        #[method(streamStatus)]
        pub unsafe fn streamStatus(&self) -> NSStreamStatus;

        #[cfg(feature = "NSError")]
        #[method_id(@__retain_semantics Other streamError)]
        pub unsafe fn streamError(&self) -> Option<Retained<NSError>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl NSStream {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSInputStream;

    unsafe impl ClassType for NSInputStream {
        #[inherits(NSObject)]
        type Super = NSStream;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSObjectProtocol for NSInputStream {}

extern_methods!(
    unsafe impl NSInputStream {
        #[method(read:maxLength:)]
        pub unsafe fn read_maxLength(&self, buffer: NonNull<u8>, len: NSUInteger) -> NSInteger;

        #[method(getBuffer:length:)]
        pub unsafe fn getBuffer_length(
            &self,
            buffer: NonNull<*mut u8>,
            len: NonNull<NSUInteger>,
        ) -> bool;

        #[method(hasBytesAvailable)]
        pub unsafe fn hasBytesAvailable(&self) -> bool;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Init initWithData:)]
        pub unsafe fn initWithData(this: Allocated<Self>, data: &NSData) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        #[method_id(@__retain_semantics Init initWithURL:)]
        pub unsafe fn initWithURL(this: Allocated<Self>, url: &NSURL) -> Option<Retained<Self>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl NSInputStream {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSOutputStream;

    unsafe impl ClassType for NSOutputStream {
        #[inherits(NSObject)]
        type Super = NSStream;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSObjectProtocol for NSOutputStream {}

extern_methods!(
    unsafe impl NSOutputStream {
        #[method(write:maxLength:)]
        pub unsafe fn write_maxLength(&self, buffer: NonNull<u8>, len: NSUInteger) -> NSInteger;

        #[method(hasSpaceAvailable)]
        pub unsafe fn hasSpaceAvailable(&self) -> bool;

        #[method_id(@__retain_semantics Init initToMemory)]
        pub unsafe fn initToMemory(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics Init initToBuffer:capacity:)]
        pub unsafe fn initToBuffer_capacity(
            this: Allocated<Self>,
            buffer: NonNull<u8>,
            capacity: NSUInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        #[method_id(@__retain_semantics Init initWithURL:append:)]
        pub unsafe fn initWithURL_append(
            this: Allocated<Self>,
            url: &NSURL,
            should_append: bool,
        ) -> Option<Retained<Self>>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl NSOutputStream {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_methods!(
    /// NSSocketStreamCreationExtensions
    unsafe impl NSStream {
        #[cfg(feature = "NSString")]
        #[deprecated = "Use nw_connection_t in Network framework instead"]
        #[method(getStreamsToHostWithName:port:inputStream:outputStream:)]
        pub unsafe fn getStreamsToHostWithName_port_inputStream_outputStream(
            hostname: &NSString,
            port: NSInteger,
            input_stream: Option<&mut Option<Retained<NSInputStream>>>,
            output_stream: Option<&mut Option<Retained<NSOutputStream>>>,
        );

        #[cfg(feature = "NSHost")]
        #[deprecated = "Use nw_connection_t in Network framework instead"]
        #[method(getStreamsToHost:port:inputStream:outputStream:)]
        pub unsafe fn getStreamsToHost_port_inputStream_outputStream(
            host: &NSHost,
            port: NSInteger,
            input_stream: Option<&mut Option<Retained<NSInputStream>>>,
            output_stream: Option<&mut Option<Retained<NSOutputStream>>>,
        );
    }
);

extern_methods!(
    /// NSStreamBoundPairCreationExtensions
    unsafe impl NSStream {
        #[method(getBoundStreamsWithBufferSize:inputStream:outputStream:)]
        pub unsafe fn getBoundStreamsWithBufferSize_inputStream_outputStream(
            buffer_size: NSUInteger,
            input_stream: Option<&mut Option<Retained<NSInputStream>>>,
            output_stream: Option<&mut Option<Retained<NSOutputStream>>>,
        );
    }
);

extern_methods!(
    /// NSInputStreamExtensions
    unsafe impl NSInputStream {
        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Init initWithFileAtPath:)]
        pub unsafe fn initWithFileAtPath(
            this: Allocated<Self>,
            path: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSData")]
        #[method_id(@__retain_semantics Other inputStreamWithData:)]
        pub unsafe fn inputStreamWithData(data: &NSData) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other inputStreamWithFileAtPath:)]
        pub unsafe fn inputStreamWithFileAtPath(path: &NSString) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[method_id(@__retain_semantics Other inputStreamWithURL:)]
        pub unsafe fn inputStreamWithURL(url: &NSURL) -> Option<Retained<Self>>;
    }
);

extern_methods!(
    /// NSOutputStreamExtensions
    unsafe impl NSOutputStream {
        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Init initToFileAtPath:append:)]
        pub unsafe fn initToFileAtPath_append(
            this: Allocated<Self>,
            path: &NSString,
            should_append: bool,
        ) -> Option<Retained<Self>>;

        #[method_id(@__retain_semantics Other outputStreamToMemory)]
        pub unsafe fn outputStreamToMemory() -> Retained<Self>;

        #[method_id(@__retain_semantics Other outputStreamToBuffer:capacity:)]
        pub unsafe fn outputStreamToBuffer_capacity(
            buffer: NonNull<u8>,
            capacity: NSUInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[method_id(@__retain_semantics Other outputStreamToFileAtPath:append:)]
        pub unsafe fn outputStreamToFileAtPath_append(
            path: &NSString,
            should_append: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        #[method_id(@__retain_semantics Other outputStreamWithURL:append:)]
        pub unsafe fn outputStreamWithURL_append(
            url: &NSURL,
            should_append: bool,
        ) -> Option<Retained<Self>>;
    }
);

extern_protocol!(
    pub unsafe trait NSStreamDelegate: NSObjectProtocol {
        #[optional]
        #[method(stream:handleEvent:)]
        unsafe fn stream_handleEvent(&self, a_stream: &NSStream, event_code: NSStreamEvent);
    }

    unsafe impl ProtocolType for dyn NSStreamDelegate {}
);

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelKey: &'static NSStreamPropertyKey;
}

// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamSocketSecurityLevel = NSString;

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelNone: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelSSLv2: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelSSLv3: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelTLSv1: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelNegotiatedSSL: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyConfigurationKey: &'static NSStreamPropertyKey;
}

// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamSOCKSProxyConfiguration = NSString;

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyHostKey: &'static NSStreamSOCKSProxyConfiguration;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyPortKey: &'static NSStreamSOCKSProxyConfiguration;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyVersionKey: &'static NSStreamSOCKSProxyConfiguration;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyUserKey: &'static NSStreamSOCKSProxyConfiguration;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyPasswordKey: &'static NSStreamSOCKSProxyConfiguration;
}

// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamSOCKSProxyVersion = NSString;

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyVersion4: &'static NSStreamSOCKSProxyVersion;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyVersion5: &'static NSStreamSOCKSProxyVersion;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamDataWrittenToMemoryStreamKey: &'static NSStreamPropertyKey;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamFileCurrentOffsetKey: &'static NSStreamPropertyKey;
}

extern "C" {
    #[cfg(all(feature = "NSError", feature = "NSString"))]
    pub static NSStreamSocketSSLErrorDomain: &'static NSErrorDomain;
}

extern "C" {
    #[cfg(all(feature = "NSError", feature = "NSString"))]
    pub static NSStreamSOCKSErrorDomain: &'static NSErrorDomain;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceType: &'static NSStreamPropertyKey;
}

// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamNetworkServiceTypeValue = NSString;

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeVoIP: &'static NSStreamNetworkServiceTypeValue;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeVideo: &'static NSStreamNetworkServiceTypeValue;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeBackground: &'static NSStreamNetworkServiceTypeValue;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeVoice: &'static NSStreamNetworkServiceTypeValue;
}

extern "C" {
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeCallSignaling: &'static NSStreamNetworkServiceTypeValue;
}
