/** @file cdstatus_cddb.h Header with declarations for the cddb routines */

#ifndef _CDSTATUS_CDDB_H
#define _CDSTATUS_CDDB_H

#include "cd_toc_info.h"
#include "track_listing.h"

/** The buffer size to use for socket I/O with the cddb server. */
#define BUFFSIZE 4096
/** The buffer size for the scratch buffer */
#define SCRATCHBUFFER_SIZE 256

/** perform overall cddb query tasks.
  * @param[in] tracks number of tracks on the cd
  * @param[in] cdtocinfo table of contents info for cd
  * @param[in] noMangle whether to do filename mangling to protect filesystem
  * @param[in] cddb_site hostname/IP for cddb server to use
  * @param[in] first_match whether to auto-accept first of multiple cddb matches
  * @return nothing
  */
void cddb_query(unsigned int, const cd_toc_info *, int, const char *, unsigned int);


/* Exported Globals (I hate globals, need to find another way to do this... */
/** Holds album name for cd */
char album_name[256];

/** Holds album year for cd */
int album_year;

/** Holds artist name for cd */
char artist_name[256];

/** Holds album genre for cd */
char album_genre[128];

/** Holds cddb info for each track */
track_listing trackinfo[100];

/** Number of tracks for which we have info */
unsigned int cddb_tracks;

#endif
