
#include "gimme_config_h.h"

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include "args.h"
#include "close_output_file.h"
#include "cdstatus_output.h"

void closeOutputFile(FILE * audio_out, Encoders encoder) {
	switch(encoder)
	{
		case ENC_NULL:
		case ENC_RAW:
		case ENC_WAVE:
		{
			if(fclose(audio_out)!=0)
			{
				conditional_perror(WARNING, "Error closing output file.");
			}
			break;
		}
		case ENC_LAME:
		case ENC_OGGENC:
		case ENC_TOOLAME:
		{
			if(pclose(audio_out)!=0)
			{
				conditional_perror(WARNING, "Error closing output pipe to encoder.");
			}
			break;
		}
		default:
		{
			conditional_perror(CRITICAL, "Unhandled encoder encountered in closeOutputFile.c");
			exit(EXIT_FAILURE);
		}
	}
}
