/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceCreator;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPWorkspaceDesktop;
import org.jkiss.dbeaver.model.fs.nio.EFSNIOResource;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.ui.ActionUtils;

public class ResourcePropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.resource";
    public static final String PROP_CAN_OPEN = "canOpen";
    public static final String PROP_CAN_CREATE_FILE = "canCreateFile";
    public static final String PROP_CAN_CREATE_FOLDER = "canCreateFolder";
    public static final String PROP_CAN_CREATE_LINK = "canCreateLink";
    public static final String PROP_CAN_SET_ACTIVE = "canSetActive";
    public static final String PROP_CAN_DELETE = "canDelete";
    public static final String PROP_IS_LOCAL_FS = "isLocalFS";
    public static final String PROP_IS_FOLDER = "isFolder";
    public static final String PROP_TYPE = "type";

    /*
     * WARNING - void declaration
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        void resource;
        if (!(receiver instanceof IResource)) {
            return false;
        }
        IResource iResource = (IResource)receiver;
        DBPWorkspaceDesktop workspace = DBPPlatformDesktop.getInstance().getWorkspace();
        DBPResourceHandler handler = workspace.getResourceHandler((IResource)resource);
        if (handler == null) {
            return false;
        }
        switch (property) {
            case "canOpen": {
                return (handler.getFeatures((IResource)resource) & 1) != 0;
            }
            case "canDelete": {
                return (handler.getFeatures((IResource)resource) & 2) != 0;
            }
            case "canCreateFile": {
                return handler instanceof DBPResourceCreator && (handler.getFeatures((IResource)resource) & 0x20) != 0;
            }
            case "canCreateFolder": {
                return (handler.getFeatures((IResource)resource) & 4) != 0;
            }
            case "canCreateLink": {
                return (handler.getFeatures((IResource)resource) & 4) != 0 && !resource.isLinked(512);
            }
            case "canSetActive": {
                RCPProject rcpProject;
                DBPProject dBPProject;
                return resource instanceof IProject && (dBPProject = workspace.getActiveProject()) instanceof RCPProject && resource != (rcpProject = (RCPProject)dBPProject).getEclipseProject();
            }
            case "type": {
                DBPResourceHandler resourceHandler = workspace.getResourceHandler((IResource)resource);
                return resourceHandler != null && expectedValue.equals(resourceHandler.getTypeName((IResource)resource));
            }
            case "isLocalFS": {
                return !(resource instanceof EFSNIOResource) && resource.getLocation() != null;
            }
            case "isFolder": {
                return resource instanceof IFolder;
            }
        }
        return false;
    }

    public static void firePropertyChange(String propName) {
        ActionUtils.evaluatePropertyState((String)("org.jkiss.dbeaver.core.resource." + propName));
    }
}

