/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform.services;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.initialization.transform.InstrumentationArtifactMetadata;
import org.gradle.api.internal.initialization.transform.services.InjectedInstrumentationServices;
import org.gradle.api.internal.initialization.transform.utils.CachedInstrumentationAnalysisSerializer;
import org.gradle.api.internal.initialization.transform.utils.DefaultInstrumentationAnalysisSerializer;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationAnalysisSerializer;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationTransformUtils;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.internal.classpath.types.ExternalPluginsInstrumentationTypeRegistry;
import org.gradle.internal.classpath.types.GradleCoreInstrumentationTypeRegistry;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.internal.file.FileType;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.Hashing;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;

public abstract class CacheInstrumentationDataBuildService
implements BuildService<BuildServiceParameters.None> {
    private final Map<Long, ResolutionData> resolutionData = new ConcurrentHashMap<Long, ResolutionData>();
    private final Lazy<InjectedInstrumentationServices> internalServices = Lazy.locking().of(() -> (InjectedInstrumentationServices)this.getObjectFactory().newInstance(InjectedInstrumentationServices.class, new Object[0]));
    private final Lazy<InstrumentationAnalysisSerializer> serializer = Lazy.locking().of(() -> new CachedInstrumentationAnalysisSerializer(new DefaultInstrumentationAnalysisSerializer(((InjectedInstrumentationServices)this.internalServices.get()).getStringInterner())));
    private final Lazy<Cache<Set<File>, ExternalPluginsInstrumentationTypeRegistry>> typeRegistryCache = Lazy.locking().of(() -> CacheBuilder.newBuilder().concurrencyLevel(1).maximumSize(100L).build());

    @Inject
    protected abstract ObjectFactory getObjectFactory();

    public InstrumentationAnalysisSerializer getCachedInstrumentationAnalysisSerializer() {
        return (InstrumentationAnalysisSerializer)this.serializer.get();
    }

    public InstrumentationTypeRegistry getInstrumentationTypeRegistry(long contextId) {
        GradleCoreInstrumentationTypeRegistry gradleCoreInstrumentationTypeRegistry = ((InjectedInstrumentationServices)this.internalServices.get()).getGradleCoreInstrumentationTypeRegistry();
        if (gradleCoreInstrumentationTypeRegistry.isEmpty()) {
            return InstrumentationTypeRegistry.empty();
        }
        return this.getResolutionData(contextId).getInstrumentationTypeRegistry();
    }

    public File getOriginalFile(long contextId, InstrumentationArtifactMetadata metadata) {
        String hash = metadata.getArtifactHash();
        String artifactName = metadata.getArtifactName();
        return (File)Preconditions.checkNotNull((Object)this.getResolutionData(contextId).getOriginalFile(metadata.getArtifactHash()), (String)"Original file for artifact with name '%s' and hash '%s' does not exist! That indicates that artifact changed during resolution from another process. That is not supported!", (Object)artifactName, (Object)hash);
    }

    @Nullable
    public String getArtifactHash(long contextId, File file) {
        return this.getResolutionData(contextId).getArtifactHash(file);
    }

    public FileCollection getTypeHierarchyAnalysis(long contextId) {
        return this.getResolutionData(contextId).getTypeHierarchyAnalysisResult();
    }

    private ResolutionData getResolutionData(long contextId) {
        return (ResolutionData)Preconditions.checkNotNull((Object)this.resolutionData.get(contextId), (String)"Resolution data for id %s does not exist!", (long)contextId);
    }

    public ResolutionScope newResolutionScope(final long contextId) {
        final ResolutionData resolutionData = this.resolutionData.compute(contextId, (__, value) -> {
            Preconditions.checkArgument((value == null ? 1 : 0) != 0, (String)"Resolution data for id %s already exists! Was previous resolution scope closed properly?", (long)contextId);
            return (ResolutionData)this.getObjectFactory().newInstance(ResolutionData.class, new Object[]{this.internalServices.get(), this.serializer.get(), this.typeRegistryCache.get()});
        });
        return new ResolutionScope(){

            @Override
            public void setTypeHierarchyAnalysisResult(FileCollection analysisResult) {
                FileCollection typeHierarchyAnalysisResult = analysisResult.filter(InstrumentationTransformUtils::isTypeHierarchyAnalysisFile);
                resolutionData.getTypeHierarchyAnalysisResult().setFrom((Iterable)typeHierarchyAnalysisResult);
                resolutionData.getTypeHierarchyAnalysisResult().finalizeValueOnRead();
            }

            @Override
            public void setOriginalClasspath(FileCollection originalClasspath) {
                resolutionData.getOriginalClasspath().setFrom((Iterable)originalClasspath);
                resolutionData.getOriginalClasspath().finalizeValueOnRead();
            }

            @Override
            public void close() {
                CacheInstrumentationDataBuildService.this.resolutionData.remove(contextId);
            }
        };
    }

    static abstract class ResolutionData {
        private final Lazy<InstrumentationTypeRegistry> instrumentationTypeRegistry;
        private final Lazy<Map<String, File>> hashToOriginalFile;
        private final Map<File, String> hashCache;
        private final InjectedInstrumentationServices internalServices;
        private final InstrumentationAnalysisSerializer serializer;
        private final Cache<Set<File>, ExternalPluginsInstrumentationTypeRegistry> typeRegistryCache;

        @Inject
        public ResolutionData(InjectedInstrumentationServices internalServices, InstrumentationAnalysisSerializer serializer, Cache<Set<File>, ExternalPluginsInstrumentationTypeRegistry> typeRegistryCache) {
            this.serializer = serializer;
            this.hashCache = new ConcurrentHashMap<File, String>();
            this.typeRegistryCache = typeRegistryCache;
            this.hashToOriginalFile = Lazy.locking().of(() -> {
                Set originalClasspath = this.getOriginalClasspath().getFiles();
                HashMap originalFiles = Maps.newHashMapWithExpectedSize((int)originalClasspath.size());
                originalClasspath.forEach(file -> {
                    String fileHash = this.getArtifactHash((File)file);
                    if (fileHash != null) {
                        originalFiles.put(fileHash, file);
                    }
                });
                return originalFiles;
            });
            this.instrumentationTypeRegistry = Lazy.locking().of(() -> {
                Set typeHierarchyAnalysis = this.getTypeHierarchyAnalysisResult().getFiles();
                return this.getInstrumentationTypeRegistryFromCache(typeHierarchyAnalysis);
            });
            this.internalServices = internalServices;
        }

        private ExternalPluginsInstrumentationTypeRegistry getInstrumentationTypeRegistryFromCache(Set<File> typeHierarchyAnalysis) {
            try {
                return (ExternalPluginsInstrumentationTypeRegistry)this.typeRegistryCache.get(typeHierarchyAnalysis, () -> {
                    GradleCoreInstrumentationTypeRegistry gradleCoreInstrumentationTypeRegistry = this.internalServices.getGradleCoreInstrumentationTypeRegistry();
                    Map<String, Set<String>> directSuperTypes = this.mergeTypeHierarchyAnalysis(typeHierarchyAnalysis);
                    return new ExternalPluginsInstrumentationTypeRegistry(directSuperTypes, gradleCoreInstrumentationTypeRegistry);
                });
            }
            catch (ExecutionException e) {
                throw new RuntimeException(e);
            }
        }

        private Map<String, Set<String>> mergeTypeHierarchyAnalysis(Set<File> typeHierarchyAnalysis) {
            return typeHierarchyAnalysis.stream().flatMap(file -> this.serializer.readTypeHierarchyAnalysis((File)file).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Sets::union));
        }

        abstract ConfigurableFileCollection getTypeHierarchyAnalysisResult();

        abstract ConfigurableFileCollection getOriginalClasspath();

        private InstrumentationTypeRegistry getInstrumentationTypeRegistry() {
            return (InstrumentationTypeRegistry)this.instrumentationTypeRegistry.get();
        }

        @Nullable
        private File getOriginalFile(String hash) {
            return (File)((Map)this.hashToOriginalFile.get()).get(hash);
        }

        @Nullable
        private String getArtifactHash(File file) {
            return this.hashCache.computeIfAbsent(file, __ -> {
                Hasher hasher = Hashing.newHasher();
                FileSystemLocationSnapshot snapshot = this.internalServices.getFileSystemAccess().read(file.getAbsolutePath());
                if (snapshot.getType() == FileType.Missing) {
                    return null;
                }
                hasher.putHash(snapshot.getHash());
                hasher.putString((CharSequence)file.getName());
                return hasher.hash().toString();
            });
        }
    }

    public static interface ResolutionScope
    extends AutoCloseable {
        public void setTypeHierarchyAnalysisResult(FileCollection var1);

        public void setOriginalClasspath(FileCollection var1);

        @Override
        public void close();
    }
}

