/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.ivy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.internal.component.external.model.ExternalModuleDependencyMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.ivy.IvyComponentGraphResolveState;
import org.gradle.internal.component.external.model.ivy.IvyDependencyDescriptor;
import org.gradle.internal.component.local.model.LocalComponentGraphResolveState;
import org.gradle.internal.component.local.model.LocalVariantGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.GraphVariantSelectionResult;
import org.gradle.internal.component.model.GraphVariantSelector;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class IvyDependencyMetadata
extends ExternalModuleDependencyMetadata {
    private final ConfigurationMetadata configuration;
    private final IvyDependencyDescriptor dependencyDescriptor;

    public IvyDependencyMetadata(ConfigurationMetadata configuration, IvyDependencyDescriptor dependencyDescriptor) {
        this(configuration, dependencyDescriptor, null, false);
    }

    public IvyDependencyMetadata(ConfigurationMetadata configuration, IvyDependencyDescriptor dependencyDescriptor, @Nullable String reason, boolean endorsing) {
        this(configuration, dependencyDescriptor, reason, endorsing, (List<IvyArtifactName>)dependencyDescriptor.getConfigurationArtifacts(configuration));
    }

    private IvyDependencyMetadata(ConfigurationMetadata configuration, IvyDependencyDescriptor dependencyDescriptor, @Nullable String reason, boolean endorsing, List<IvyArtifactName> artifacts) {
        super(reason, endorsing, artifacts);
        this.configuration = configuration;
        this.dependencyDescriptor = dependencyDescriptor;
    }

    @Override
    public IvyDependencyDescriptor getDependencyDescriptor() {
        return this.dependencyDescriptor;
    }

    @Override
    protected GraphVariantSelectionResult selectLegacyConfigurations(GraphVariantSelector variantSelector, ImmutableAttributes consumerAttributes, ComponentGraphResolveState targetComponentState, ImmutableAttributesSchema consumerSchema) {
        LocalComponentGraphResolveState localComponent;
        LocalVariantGraphResolveState legacyVariant;
        boolean hasLegacyVariant;
        if (targetComponentState instanceof IvyComponentGraphResolveState) {
            IvyComponentGraphResolveState ivyComponent = (IvyComponentGraphResolveState)targetComponentState;
            return this.getDependencyDescriptor().selectLegacyConfigurations(this.configuration, ivyComponent, variantSelector.getFailureHandler());
        }
        boolean bl = hasLegacyVariant = targetComponentState.getCandidatesForGraphVariantSelection().getLegacyVariant() != null;
        if (hasLegacyVariant) {
            VariantGraphResolveState selected = variantSelector.selectLegacyVariant(consumerAttributes, targetComponentState, consumerSchema, variantSelector.getFailureHandler());
            return new GraphVariantSelectionResult(Collections.singletonList(selected), false);
        }
        if (targetComponentState instanceof LocalComponentGraphResolveState && (legacyVariant = (localComponent = (LocalComponentGraphResolveState)targetComponentState).getConfigurationLegacy("default")) != null) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)"Consuming non-consumable variants from from an ivy component.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "consuming_non_consumable_variants_from_ivy_component")).nagUser();
            return new GraphVariantSelectionResult(Collections.singletonList(legacyVariant), false);
        }
        throw variantSelector.getFailureHandler().configurationDoesNotExistFailure(targetComponentState, this.configuration.getName());
    }

    @Override
    public List<ExcludeMetadata> getExcludes() {
        return this.getDependencyDescriptor().getConfigurationExcludes((Collection<String>)this.configuration.getHierarchy());
    }

    @Override
    public ModuleDependencyMetadata withReason(String reason) {
        return new IvyDependencyMetadata(this.configuration, this.dependencyDescriptor, reason, this.isEndorsingStrictVersions(), this.getArtifacts());
    }

    @Override
    public ModuleDependencyMetadata withEndorseStrictVersions(boolean endorse) {
        return new IvyDependencyMetadata(this.configuration, this.dependencyDescriptor, this.getReason(), endorse, this.getArtifacts());
    }

    @Override
    protected ModuleDependencyMetadata withRequested(ModuleComponentSelector newSelector) {
        IvyDependencyDescriptor newDescriptor = this.dependencyDescriptor.withRequested(newSelector);
        return new IvyDependencyMetadata(this.configuration, newDescriptor, this.getReason(), this.isEndorsingStrictVersions(), this.getArtifacts());
    }

    @Override
    protected ModuleDependencyMetadata withRequestedAndArtifacts(ModuleComponentSelector newSelector, List<IvyArtifactName> artifacts) {
        IvyDependencyDescriptor newDelegate = this.dependencyDescriptor.withRequested(newSelector);
        return new IvyDependencyMetadata(this.configuration, newDelegate, this.getReason(), this.isEndorsingStrictVersions(), artifacts);
    }

    public ModuleDependencyMetadata withDescriptor(IvyDependencyDescriptor descriptor) {
        return new IvyDependencyMetadata(this.configuration, descriptor, this.getReason(), this.isEndorsingStrictVersions(), (List<IvyArtifactName>)this.dependencyDescriptor.getConfigurationArtifacts(this.configuration));
    }
}

