// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The tokens used in a message API inference call.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct TokenUsage {
    /// <p>The number of tokens sent in the request to the model.</p>
    pub input_tokens: i32,
    /// <p>The number of tokens that the model generated for the request.</p>
    pub output_tokens: i32,
    /// <p>The total of input tokens and tokens generated by the model.</p>
    pub total_tokens: i32,
    /// <p>The number of input tokens read from the cache for the request.</p>
    pub cache_read_input_tokens: ::std::option::Option<i32>,
    /// <p>The number of input tokens written to the cache for the request.</p>
    pub cache_write_input_tokens: ::std::option::Option<i32>,
}
impl TokenUsage {
    /// <p>The number of tokens sent in the request to the model.</p>
    pub fn input_tokens(&self) -> i32 {
        self.input_tokens
    }
    /// <p>The number of tokens that the model generated for the request.</p>
    pub fn output_tokens(&self) -> i32 {
        self.output_tokens
    }
    /// <p>The total of input tokens and tokens generated by the model.</p>
    pub fn total_tokens(&self) -> i32 {
        self.total_tokens
    }
    /// <p>The number of input tokens read from the cache for the request.</p>
    pub fn cache_read_input_tokens(&self) -> ::std::option::Option<i32> {
        self.cache_read_input_tokens
    }
    /// <p>The number of input tokens written to the cache for the request.</p>
    pub fn cache_write_input_tokens(&self) -> ::std::option::Option<i32> {
        self.cache_write_input_tokens
    }
}
impl TokenUsage {
    /// Creates a new builder-style object to manufacture [`TokenUsage`](crate::types::TokenUsage).
    pub fn builder() -> crate::types::builders::TokenUsageBuilder {
        crate::types::builders::TokenUsageBuilder::default()
    }
}

/// A builder for [`TokenUsage`](crate::types::TokenUsage).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct TokenUsageBuilder {
    pub(crate) input_tokens: ::std::option::Option<i32>,
    pub(crate) output_tokens: ::std::option::Option<i32>,
    pub(crate) total_tokens: ::std::option::Option<i32>,
    pub(crate) cache_read_input_tokens: ::std::option::Option<i32>,
    pub(crate) cache_write_input_tokens: ::std::option::Option<i32>,
}
impl TokenUsageBuilder {
    /// <p>The number of tokens sent in the request to the model.</p>
    /// This field is required.
    pub fn input_tokens(mut self, input: i32) -> Self {
        self.input_tokens = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of tokens sent in the request to the model.</p>
    pub fn set_input_tokens(mut self, input: ::std::option::Option<i32>) -> Self {
        self.input_tokens = input;
        self
    }
    /// <p>The number of tokens sent in the request to the model.</p>
    pub fn get_input_tokens(&self) -> &::std::option::Option<i32> {
        &self.input_tokens
    }
    /// <p>The number of tokens that the model generated for the request.</p>
    /// This field is required.
    pub fn output_tokens(mut self, input: i32) -> Self {
        self.output_tokens = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of tokens that the model generated for the request.</p>
    pub fn set_output_tokens(mut self, input: ::std::option::Option<i32>) -> Self {
        self.output_tokens = input;
        self
    }
    /// <p>The number of tokens that the model generated for the request.</p>
    pub fn get_output_tokens(&self) -> &::std::option::Option<i32> {
        &self.output_tokens
    }
    /// <p>The total of input tokens and tokens generated by the model.</p>
    /// This field is required.
    pub fn total_tokens(mut self, input: i32) -> Self {
        self.total_tokens = ::std::option::Option::Some(input);
        self
    }
    /// <p>The total of input tokens and tokens generated by the model.</p>
    pub fn set_total_tokens(mut self, input: ::std::option::Option<i32>) -> Self {
        self.total_tokens = input;
        self
    }
    /// <p>The total of input tokens and tokens generated by the model.</p>
    pub fn get_total_tokens(&self) -> &::std::option::Option<i32> {
        &self.total_tokens
    }
    /// <p>The number of input tokens read from the cache for the request.</p>
    pub fn cache_read_input_tokens(mut self, input: i32) -> Self {
        self.cache_read_input_tokens = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of input tokens read from the cache for the request.</p>
    pub fn set_cache_read_input_tokens(mut self, input: ::std::option::Option<i32>) -> Self {
        self.cache_read_input_tokens = input;
        self
    }
    /// <p>The number of input tokens read from the cache for the request.</p>
    pub fn get_cache_read_input_tokens(&self) -> &::std::option::Option<i32> {
        &self.cache_read_input_tokens
    }
    /// <p>The number of input tokens written to the cache for the request.</p>
    pub fn cache_write_input_tokens(mut self, input: i32) -> Self {
        self.cache_write_input_tokens = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of input tokens written to the cache for the request.</p>
    pub fn set_cache_write_input_tokens(mut self, input: ::std::option::Option<i32>) -> Self {
        self.cache_write_input_tokens = input;
        self
    }
    /// <p>The number of input tokens written to the cache for the request.</p>
    pub fn get_cache_write_input_tokens(&self) -> &::std::option::Option<i32> {
        &self.cache_write_input_tokens
    }
    /// Consumes the builder and constructs a [`TokenUsage`](crate::types::TokenUsage).
    /// This method will fail if any of the following fields are not set:
    /// - [`input_tokens`](crate::types::builders::TokenUsageBuilder::input_tokens)
    /// - [`output_tokens`](crate::types::builders::TokenUsageBuilder::output_tokens)
    /// - [`total_tokens`](crate::types::builders::TokenUsageBuilder::total_tokens)
    pub fn build(self) -> ::std::result::Result<crate::types::TokenUsage, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::TokenUsage {
            input_tokens: self.input_tokens.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "input_tokens",
                    "input_tokens was not specified but it is required when building TokenUsage",
                )
            })?,
            output_tokens: self.output_tokens.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "output_tokens",
                    "output_tokens was not specified but it is required when building TokenUsage",
                )
            })?,
            total_tokens: self.total_tokens.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "total_tokens",
                    "total_tokens was not specified but it is required when building TokenUsage",
                )
            })?,
            cache_read_input_tokens: self.cache_read_input_tokens,
            cache_write_input_tokens: self.cache_write_input_tokens,
        })
    }
}
