#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 868
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 98
#define ALIAS_COUNT 0
#define TOKEN_COUNT 43
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 1

enum ts_symbol_identifiers {
  sym__escape_identity = 1,
  anon_sym_BSLASHt = 2,
  anon_sym_BSLASHr = 3,
  anon_sym_BSLASHn = 4,
  anon_sym_SEMI = 5,
  anon_sym_BSLASH_SEMI = 6,
  aux_sym_variable_token1 = 7,
  anon_sym_DOLLAR = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  anon_sym_ENV = 11,
  anon_sym_CACHE = 12,
  anon_sym_LT = 13,
  anon_sym_GT = 14,
  anon_sym_COLON = 15,
  aux_sym__gen_exp_arguments_token1 = 16,
  aux_sym__untrimmed_argument_token1 = 17,
  anon_sym_LPAREN = 18,
  anon_sym_RPAREN = 19,
  anon_sym_DQUOTE = 20,
  aux_sym__quoted_text_token1 = 21,
  aux_sym__unquoted_text_token1 = 22,
  aux_sym_if_command_token1 = 23,
  aux_sym_endwhile_command_token1 = 24,
  sym_if = 25,
  sym_elseif = 26,
  sym_else = 27,
  sym_endif = 28,
  sym_foreach = 29,
  sym_endforeach = 30,
  sym_while = 31,
  sym_endwhile = 32,
  sym_function = 33,
  sym_endfunction = 34,
  sym_macro = 35,
  sym_endmacro = 36,
  sym_block = 37,
  sym_endblock = 38,
  sym_identifier = 39,
  sym_bracket_argument = 40,
  sym_bracket_comment = 41,
  sym_line_comment = 42,
  sym_source_file = 43,
  sym_escape_sequence = 44,
  sym__escape_encoded = 45,
  sym__escape_semicolon = 46,
  sym_variable = 47,
  sym_variable_ref = 48,
  sym_normal_var = 49,
  sym_env_var = 50,
  sym_cache_var = 51,
  sym_gen_exp = 52,
  sym__gen_exp_content = 53,
  sym__gen_exp_arguments = 54,
  sym_argument = 55,
  sym__untrimmed_argument = 56,
  sym__paren_argument = 57,
  sym_quoted_argument = 58,
  sym_quoted_element = 59,
  sym__quoted_text = 60,
  sym_unquoted_argument = 61,
  sym__unquoted_text = 62,
  sym_body = 63,
  sym_argument_list = 64,
  sym_if_command = 65,
  sym_elseif_command = 66,
  sym_else_command = 67,
  sym_endif_command = 68,
  sym_if_condition = 69,
  sym_foreach_command = 70,
  sym_endforeach_command = 71,
  sym_foreach_loop = 72,
  sym_while_command = 73,
  sym_endwhile_command = 74,
  sym_while_loop = 75,
  sym_function_command = 76,
  sym_endfunction_command = 77,
  sym_function_def = 78,
  sym_macro_command = 79,
  sym_endmacro_command = 80,
  sym_macro_def = 81,
  sym_block_command = 82,
  sym_endblock_command = 83,
  sym_block_def = 84,
  sym_normal_command = 85,
  sym__command_invocation = 86,
  sym__untrimmed_command_invocation = 87,
  aux_sym_source_file_repeat1 = 88,
  aux_sym_variable_repeat1 = 89,
  aux_sym__gen_exp_arguments_repeat1 = 90,
  aux_sym__paren_argument_repeat1 = 91,
  aux_sym_quoted_element_repeat1 = 92,
  aux_sym__quoted_text_repeat1 = 93,
  aux_sym_unquoted_argument_repeat1 = 94,
  aux_sym__unquoted_text_repeat1 = 95,
  aux_sym_if_command_repeat1 = 96,
  aux_sym_if_condition_repeat1 = 97,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__escape_identity] = "_escape_identity",
  [anon_sym_BSLASHt] = "\\t",
  [anon_sym_BSLASHr] = "\\r",
  [anon_sym_BSLASHn] = "\\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_BSLASH_SEMI] = "\\;",
  [aux_sym_variable_token1] = "variable_token1",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_ENV] = "ENV",
  [anon_sym_CACHE] = "CACHE",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_COLON] = ":",
  [aux_sym__gen_exp_arguments_token1] = "_gen_exp_arguments_token1",
  [aux_sym__untrimmed_argument_token1] = "_untrimmed_argument_token1",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__quoted_text_token1] = "_quoted_text_token1",
  [aux_sym__unquoted_text_token1] = "_unquoted_text_token1",
  [aux_sym_if_command_token1] = "if_command_token1",
  [aux_sym_endwhile_command_token1] = "endwhile_command_token1",
  [sym_if] = "if",
  [sym_elseif] = "elseif",
  [sym_else] = "else",
  [sym_endif] = "endif",
  [sym_foreach] = "foreach",
  [sym_endforeach] = "endforeach",
  [sym_while] = "while",
  [sym_endwhile] = "endwhile",
  [sym_function] = "function",
  [sym_endfunction] = "endfunction",
  [sym_macro] = "macro",
  [sym_endmacro] = "endmacro",
  [sym_block] = "block",
  [sym_endblock] = "endblock",
  [sym_identifier] = "identifier",
  [sym_bracket_argument] = "bracket_argument",
  [sym_bracket_comment] = "bracket_comment",
  [sym_line_comment] = "line_comment",
  [sym_source_file] = "source_file",
  [sym_escape_sequence] = "escape_sequence",
  [sym__escape_encoded] = "_escape_encoded",
  [sym__escape_semicolon] = "_escape_semicolon",
  [sym_variable] = "variable",
  [sym_variable_ref] = "variable_ref",
  [sym_normal_var] = "normal_var",
  [sym_env_var] = "env_var",
  [sym_cache_var] = "cache_var",
  [sym_gen_exp] = "gen_exp",
  [sym__gen_exp_content] = "_gen_exp_content",
  [sym__gen_exp_arguments] = "_gen_exp_arguments",
  [sym_argument] = "argument",
  [sym__untrimmed_argument] = "_untrimmed_argument",
  [sym__paren_argument] = "_paren_argument",
  [sym_quoted_argument] = "quoted_argument",
  [sym_quoted_element] = "quoted_element",
  [sym__quoted_text] = "_quoted_text",
  [sym_unquoted_argument] = "unquoted_argument",
  [sym__unquoted_text] = "_unquoted_text",
  [sym_body] = "body",
  [sym_argument_list] = "argument_list",
  [sym_if_command] = "if_command",
  [sym_elseif_command] = "elseif_command",
  [sym_else_command] = "else_command",
  [sym_endif_command] = "endif_command",
  [sym_if_condition] = "if_condition",
  [sym_foreach_command] = "foreach_command",
  [sym_endforeach_command] = "endforeach_command",
  [sym_foreach_loop] = "foreach_loop",
  [sym_while_command] = "while_command",
  [sym_endwhile_command] = "endwhile_command",
  [sym_while_loop] = "while_loop",
  [sym_function_command] = "function_command",
  [sym_endfunction_command] = "endfunction_command",
  [sym_function_def] = "function_def",
  [sym_macro_command] = "macro_command",
  [sym_endmacro_command] = "endmacro_command",
  [sym_macro_def] = "macro_def",
  [sym_block_command] = "block_command",
  [sym_endblock_command] = "endblock_command",
  [sym_block_def] = "block_def",
  [sym_normal_command] = "normal_command",
  [sym__command_invocation] = "_command_invocation",
  [sym__untrimmed_command_invocation] = "_untrimmed_command_invocation",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_variable_repeat1] = "variable_repeat1",
  [aux_sym__gen_exp_arguments_repeat1] = "_gen_exp_arguments_repeat1",
  [aux_sym__paren_argument_repeat1] = "_paren_argument_repeat1",
  [aux_sym_quoted_element_repeat1] = "quoted_element_repeat1",
  [aux_sym__quoted_text_repeat1] = "_quoted_text_repeat1",
  [aux_sym_unquoted_argument_repeat1] = "unquoted_argument_repeat1",
  [aux_sym__unquoted_text_repeat1] = "_unquoted_text_repeat1",
  [aux_sym_if_command_repeat1] = "if_command_repeat1",
  [aux_sym_if_condition_repeat1] = "if_condition_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__escape_identity] = sym__escape_identity,
  [anon_sym_BSLASHt] = anon_sym_BSLASHt,
  [anon_sym_BSLASHr] = anon_sym_BSLASHr,
  [anon_sym_BSLASHn] = anon_sym_BSLASHn,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_BSLASH_SEMI] = anon_sym_BSLASH_SEMI,
  [aux_sym_variable_token1] = aux_sym_variable_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_ENV] = anon_sym_ENV,
  [anon_sym_CACHE] = anon_sym_CACHE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_COLON] = anon_sym_COLON,
  [aux_sym__gen_exp_arguments_token1] = aux_sym__gen_exp_arguments_token1,
  [aux_sym__untrimmed_argument_token1] = aux_sym__untrimmed_argument_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__quoted_text_token1] = aux_sym__quoted_text_token1,
  [aux_sym__unquoted_text_token1] = aux_sym__unquoted_text_token1,
  [aux_sym_if_command_token1] = aux_sym_if_command_token1,
  [aux_sym_endwhile_command_token1] = aux_sym_endwhile_command_token1,
  [sym_if] = sym_if,
  [sym_elseif] = sym_elseif,
  [sym_else] = sym_else,
  [sym_endif] = sym_endif,
  [sym_foreach] = sym_foreach,
  [sym_endforeach] = sym_endforeach,
  [sym_while] = sym_while,
  [sym_endwhile] = sym_endwhile,
  [sym_function] = sym_function,
  [sym_endfunction] = sym_endfunction,
  [sym_macro] = sym_macro,
  [sym_endmacro] = sym_endmacro,
  [sym_block] = sym_block,
  [sym_endblock] = sym_endblock,
  [sym_identifier] = sym_identifier,
  [sym_bracket_argument] = sym_bracket_argument,
  [sym_bracket_comment] = sym_bracket_comment,
  [sym_line_comment] = sym_line_comment,
  [sym_source_file] = sym_source_file,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__escape_encoded] = sym__escape_encoded,
  [sym__escape_semicolon] = sym__escape_semicolon,
  [sym_variable] = sym_variable,
  [sym_variable_ref] = sym_variable_ref,
  [sym_normal_var] = sym_normal_var,
  [sym_env_var] = sym_env_var,
  [sym_cache_var] = sym_cache_var,
  [sym_gen_exp] = sym_gen_exp,
  [sym__gen_exp_content] = sym__gen_exp_content,
  [sym__gen_exp_arguments] = sym__gen_exp_arguments,
  [sym_argument] = sym_argument,
  [sym__untrimmed_argument] = sym__untrimmed_argument,
  [sym__paren_argument] = sym__paren_argument,
  [sym_quoted_argument] = sym_quoted_argument,
  [sym_quoted_element] = sym_quoted_element,
  [sym__quoted_text] = sym__quoted_text,
  [sym_unquoted_argument] = sym_unquoted_argument,
  [sym__unquoted_text] = sym__unquoted_text,
  [sym_body] = sym_body,
  [sym_argument_list] = sym_argument_list,
  [sym_if_command] = sym_if_command,
  [sym_elseif_command] = sym_elseif_command,
  [sym_else_command] = sym_else_command,
  [sym_endif_command] = sym_endif_command,
  [sym_if_condition] = sym_if_condition,
  [sym_foreach_command] = sym_foreach_command,
  [sym_endforeach_command] = sym_endforeach_command,
  [sym_foreach_loop] = sym_foreach_loop,
  [sym_while_command] = sym_while_command,
  [sym_endwhile_command] = sym_endwhile_command,
  [sym_while_loop] = sym_while_loop,
  [sym_function_command] = sym_function_command,
  [sym_endfunction_command] = sym_endfunction_command,
  [sym_function_def] = sym_function_def,
  [sym_macro_command] = sym_macro_command,
  [sym_endmacro_command] = sym_endmacro_command,
  [sym_macro_def] = sym_macro_def,
  [sym_block_command] = sym_block_command,
  [sym_endblock_command] = sym_endblock_command,
  [sym_block_def] = sym_block_def,
  [sym_normal_command] = sym_normal_command,
  [sym__command_invocation] = sym__command_invocation,
  [sym__untrimmed_command_invocation] = sym__untrimmed_command_invocation,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_variable_repeat1] = aux_sym_variable_repeat1,
  [aux_sym__gen_exp_arguments_repeat1] = aux_sym__gen_exp_arguments_repeat1,
  [aux_sym__paren_argument_repeat1] = aux_sym__paren_argument_repeat1,
  [aux_sym_quoted_element_repeat1] = aux_sym_quoted_element_repeat1,
  [aux_sym__quoted_text_repeat1] = aux_sym__quoted_text_repeat1,
  [aux_sym_unquoted_argument_repeat1] = aux_sym_unquoted_argument_repeat1,
  [aux_sym__unquoted_text_repeat1] = aux_sym__unquoted_text_repeat1,
  [aux_sym_if_command_repeat1] = aux_sym_if_command_repeat1,
  [aux_sym_if_condition_repeat1] = aux_sym_if_condition_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_identity] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BSLASHt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variable_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENV] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CACHE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__gen_exp_arguments_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__untrimmed_argument_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__quoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_endwhile_command_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_endif] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction] = {
    .visible = true,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_endblock] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_encoded] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_var] = {
    .visible = true,
    .named = true,
  },
  [sym_env_var] = {
    .visible = true,
    .named = true,
  },
  [sym_cache_var] = {
    .visible = true,
    .named = true,
  },
  [sym_gen_exp] = {
    .visible = true,
    .named = true,
  },
  [sym__gen_exp_content] = {
    .visible = false,
    .named = true,
  },
  [sym__gen_exp_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__untrimmed_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__paren_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_element] = {
    .visible = true,
    .named = true,
  },
  [sym__quoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_unquoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__unquoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_if_command] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_else_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_if_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_while_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile_command] = {
    .visible = true,
    .named = true,
  },
  [sym_while_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_function_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction_command] = {
    .visible = true,
    .named = true,
  },
  [sym_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_def] = {
    .visible = true,
    .named = true,
  },
  [sym_block_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endblock_command] = {
    .visible = true,
    .named = true,
  },
  [sym_block_def] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_command] = {
    .visible = true,
    .named = true,
  },
  [sym__command_invocation] = {
    .visible = false,
    .named = true,
  },
  [sym__untrimmed_command_invocation] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__gen_exp_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paren_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_quoted_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__quoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unquoted_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_condition_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 4,
  [5] = 4,
  [6] = 2,
  [7] = 4,
  [8] = 2,
  [9] = 4,
  [10] = 2,
  [11] = 2,
  [12] = 4,
  [13] = 2,
  [14] = 4,
  [15] = 4,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 16,
  [23] = 23,
  [24] = 18,
  [25] = 17,
  [26] = 26,
  [27] = 19,
  [28] = 20,
  [29] = 21,
  [30] = 16,
  [31] = 17,
  [32] = 18,
  [33] = 20,
  [34] = 26,
  [35] = 17,
  [36] = 23,
  [37] = 37,
  [38] = 38,
  [39] = 38,
  [40] = 16,
  [41] = 26,
  [42] = 23,
  [43] = 23,
  [44] = 38,
  [45] = 38,
  [46] = 37,
  [47] = 21,
  [48] = 18,
  [49] = 19,
  [50] = 18,
  [51] = 37,
  [52] = 18,
  [53] = 16,
  [54] = 19,
  [55] = 20,
  [56] = 21,
  [57] = 17,
  [58] = 37,
  [59] = 20,
  [60] = 19,
  [61] = 37,
  [62] = 21,
  [63] = 63,
  [64] = 26,
  [65] = 38,
  [66] = 19,
  [67] = 23,
  [68] = 23,
  [69] = 69,
  [70] = 38,
  [71] = 21,
  [72] = 37,
  [73] = 17,
  [74] = 74,
  [75] = 20,
  [76] = 16,
  [77] = 26,
  [78] = 16,
  [79] = 20,
  [80] = 17,
  [81] = 21,
  [82] = 26,
  [83] = 23,
  [84] = 18,
  [85] = 19,
  [86] = 26,
  [87] = 37,
  [88] = 38,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 109,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 113,
  [115] = 112,
  [116] = 111,
  [117] = 109,
  [118] = 118,
  [119] = 112,
  [120] = 107,
  [121] = 111,
  [122] = 118,
  [123] = 107,
  [124] = 112,
  [125] = 111,
  [126] = 118,
  [127] = 107,
  [128] = 118,
  [129] = 108,
  [130] = 108,
  [131] = 109,
  [132] = 109,
  [133] = 107,
  [134] = 107,
  [135] = 111,
  [136] = 107,
  [137] = 118,
  [138] = 113,
  [139] = 113,
  [140] = 112,
  [141] = 111,
  [142] = 109,
  [143] = 118,
  [144] = 112,
  [145] = 113,
  [146] = 112,
  [147] = 113,
  [148] = 108,
  [149] = 113,
  [150] = 150,
  [151] = 118,
  [152] = 109,
  [153] = 108,
  [154] = 111,
  [155] = 108,
  [156] = 156,
  [157] = 157,
  [158] = 156,
  [159] = 156,
  [160] = 156,
  [161] = 156,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 156,
  [167] = 167,
  [168] = 167,
  [169] = 169,
  [170] = 167,
  [171] = 169,
  [172] = 167,
  [173] = 167,
  [174] = 169,
  [175] = 169,
  [176] = 169,
  [177] = 169,
  [178] = 167,
  [179] = 167,
  [180] = 169,
  [181] = 181,
  [182] = 182,
  [183] = 181,
  [184] = 182,
  [185] = 181,
  [186] = 182,
  [187] = 181,
  [188] = 182,
  [189] = 182,
  [190] = 181,
  [191] = 181,
  [192] = 182,
  [193] = 181,
  [194] = 182,
  [195] = 163,
  [196] = 165,
  [197] = 197,
  [198] = 197,
  [199] = 197,
  [200] = 165,
  [201] = 197,
  [202] = 163,
  [203] = 163,
  [204] = 163,
  [205] = 205,
  [206] = 165,
  [207] = 165,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 210,
  [213] = 210,
  [214] = 211,
  [215] = 215,
  [216] = 215,
  [217] = 210,
  [218] = 218,
  [219] = 219,
  [220] = 215,
  [221] = 211,
  [222] = 211,
  [223] = 211,
  [224] = 210,
  [225] = 215,
  [226] = 210,
  [227] = 215,
  [228] = 215,
  [229] = 211,
  [230] = 215,
  [231] = 210,
  [232] = 211,
  [233] = 233,
  [234] = 209,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 209,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 209,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 233,
  [284] = 284,
  [285] = 209,
  [286] = 286,
  [287] = 287,
  [288] = 242,
  [289] = 235,
  [290] = 239,
  [291] = 241,
  [292] = 246,
  [293] = 245,
  [294] = 236,
  [295] = 244,
  [296] = 237,
  [297] = 240,
  [298] = 298,
  [299] = 272,
  [300] = 261,
  [301] = 261,
  [302] = 260,
  [303] = 259,
  [304] = 255,
  [305] = 233,
  [306] = 258,
  [307] = 273,
  [308] = 250,
  [309] = 251,
  [310] = 252,
  [311] = 253,
  [312] = 267,
  [313] = 253,
  [314] = 314,
  [315] = 255,
  [316] = 276,
  [317] = 279,
  [318] = 280,
  [319] = 282,
  [320] = 287,
  [321] = 286,
  [322] = 252,
  [323] = 278,
  [324] = 274,
  [325] = 250,
  [326] = 272,
  [327] = 271,
  [328] = 270,
  [329] = 269,
  [330] = 268,
  [331] = 248,
  [332] = 266,
  [333] = 273,
  [334] = 267,
  [335] = 264,
  [336] = 263,
  [337] = 262,
  [338] = 261,
  [339] = 260,
  [340] = 259,
  [341] = 276,
  [342] = 279,
  [343] = 258,
  [344] = 273,
  [345] = 250,
  [346] = 251,
  [347] = 252,
  [348] = 253,
  [349] = 267,
  [350] = 258,
  [351] = 259,
  [352] = 255,
  [353] = 276,
  [354] = 279,
  [355] = 280,
  [356] = 282,
  [357] = 287,
  [358] = 286,
  [359] = 278,
  [360] = 274,
  [361] = 267,
  [362] = 272,
  [363] = 271,
  [364] = 270,
  [365] = 269,
  [366] = 268,
  [367] = 248,
  [368] = 266,
  [369] = 260,
  [370] = 261,
  [371] = 264,
  [372] = 263,
  [373] = 262,
  [374] = 261,
  [375] = 260,
  [376] = 259,
  [377] = 262,
  [378] = 280,
  [379] = 258,
  [380] = 273,
  [381] = 250,
  [382] = 251,
  [383] = 252,
  [384] = 253,
  [385] = 267,
  [386] = 282,
  [387] = 287,
  [388] = 255,
  [389] = 276,
  [390] = 279,
  [391] = 280,
  [392] = 282,
  [393] = 287,
  [394] = 286,
  [395] = 278,
  [396] = 274,
  [397] = 279,
  [398] = 272,
  [399] = 271,
  [400] = 270,
  [401] = 269,
  [402] = 268,
  [403] = 248,
  [404] = 266,
  [405] = 263,
  [406] = 263,
  [407] = 264,
  [408] = 263,
  [409] = 262,
  [410] = 251,
  [411] = 260,
  [412] = 259,
  [413] = 262,
  [414] = 264,
  [415] = 258,
  [416] = 273,
  [417] = 250,
  [418] = 251,
  [419] = 252,
  [420] = 253,
  [421] = 267,
  [422] = 264,
  [423] = 269,
  [424] = 266,
  [425] = 255,
  [426] = 276,
  [427] = 279,
  [428] = 280,
  [429] = 282,
  [430] = 287,
  [431] = 286,
  [432] = 278,
  [433] = 274,
  [434] = 266,
  [435] = 271,
  [436] = 270,
  [437] = 269,
  [438] = 268,
  [439] = 248,
  [440] = 266,
  [441] = 248,
  [442] = 264,
  [443] = 263,
  [444] = 262,
  [445] = 261,
  [446] = 260,
  [447] = 259,
  [448] = 268,
  [449] = 269,
  [450] = 258,
  [451] = 273,
  [452] = 250,
  [453] = 251,
  [454] = 252,
  [455] = 253,
  [456] = 270,
  [457] = 271,
  [458] = 272,
  [459] = 276,
  [460] = 248,
  [461] = 255,
  [462] = 272,
  [463] = 286,
  [464] = 274,
  [465] = 271,
  [466] = 280,
  [467] = 274,
  [468] = 278,
  [469] = 268,
  [470] = 270,
  [471] = 282,
  [472] = 287,
  [473] = 278,
  [474] = 286,
  [475] = 475,
  [476] = 233,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 481,
  [482] = 242,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 241,
  [489] = 235,
  [490] = 246,
  [491] = 233,
  [492] = 245,
  [493] = 236,
  [494] = 237,
  [495] = 235,
  [496] = 237,
  [497] = 236,
  [498] = 246,
  [499] = 241,
  [500] = 245,
  [501] = 242,
  [502] = 246,
  [503] = 241,
  [504] = 245,
  [505] = 241,
  [506] = 235,
  [507] = 246,
  [508] = 237,
  [509] = 236,
  [510] = 235,
  [511] = 242,
  [512] = 245,
  [513] = 236,
  [514] = 245,
  [515] = 246,
  [516] = 237,
  [517] = 242,
  [518] = 237,
  [519] = 236,
  [520] = 241,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 239,
  [525] = 525,
  [526] = 244,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 240,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 522,
  [541] = 523,
  [542] = 525,
  [543] = 527,
  [544] = 528,
  [545] = 529,
  [546] = 530,
  [547] = 531,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 539,
  [552] = 529,
  [553] = 538,
  [554] = 533,
  [555] = 528,
  [556] = 537,
  [557] = 536,
  [558] = 535,
  [559] = 536,
  [560] = 535,
  [561] = 537,
  [562] = 538,
  [563] = 539,
  [564] = 527,
  [565] = 522,
  [566] = 533,
  [567] = 523,
  [568] = 525,
  [569] = 527,
  [570] = 528,
  [571] = 530,
  [572] = 529,
  [573] = 573,
  [574] = 530,
  [575] = 531,
  [576] = 531,
  [577] = 525,
  [578] = 530,
  [579] = 523,
  [580] = 529,
  [581] = 533,
  [582] = 522,
  [583] = 583,
  [584] = 528,
  [585] = 527,
  [586] = 535,
  [587] = 536,
  [588] = 537,
  [589] = 538,
  [590] = 539,
  [591] = 525,
  [592] = 522,
  [593] = 523,
  [594] = 525,
  [595] = 527,
  [596] = 528,
  [597] = 529,
  [598] = 530,
  [599] = 523,
  [600] = 531,
  [601] = 522,
  [602] = 602,
  [603] = 533,
  [604] = 539,
  [605] = 535,
  [606] = 536,
  [607] = 537,
  [608] = 538,
  [609] = 538,
  [610] = 539,
  [611] = 529,
  [612] = 528,
  [613] = 613,
  [614] = 527,
  [615] = 525,
  [616] = 537,
  [617] = 533,
  [618] = 523,
  [619] = 536,
  [620] = 536,
  [621] = 621,
  [622] = 537,
  [623] = 535,
  [624] = 531,
  [625] = 522,
  [626] = 538,
  [627] = 627,
  [628] = 628,
  [629] = 539,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 531,
  [634] = 530,
  [635] = 533,
  [636] = 636,
  [637] = 637,
  [638] = 535,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 642,
  [648] = 648,
  [649] = 641,
  [650] = 643,
  [651] = 641,
  [652] = 643,
  [653] = 644,
  [654] = 641,
  [655] = 643,
  [656] = 644,
  [657] = 645,
  [658] = 646,
  [659] = 644,
  [660] = 645,
  [661] = 645,
  [662] = 646,
  [663] = 646,
  [664] = 642,
  [665] = 642,
  [666] = 648,
  [667] = 641,
  [668] = 643,
  [669] = 648,
  [670] = 644,
  [671] = 645,
  [672] = 646,
  [673] = 642,
  [674] = 648,
  [675] = 642,
  [676] = 642,
  [677] = 648,
  [678] = 648,
  [679] = 644,
  [680] = 646,
  [681] = 645,
  [682] = 648,
  [683] = 641,
  [684] = 643,
  [685] = 644,
  [686] = 645,
  [687] = 646,
  [688] = 641,
  [689] = 643,
  [690] = 690,
  [691] = 691,
  [692] = 690,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 701,
  [703] = 698,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 700,
  [711] = 691,
  [712] = 712,
  [713] = 713,
  [714] = 690,
  [715] = 693,
  [716] = 694,
  [717] = 695,
  [718] = 696,
  [719] = 697,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 699,
  [724] = 709,
  [725] = 707,
  [726] = 707,
  [727] = 727,
  [728] = 705,
  [729] = 729,
  [730] = 730,
  [731] = 704,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 698,
  [738] = 709,
  [739] = 691,
  [740] = 712,
  [741] = 701,
  [742] = 700,
  [743] = 713,
  [744] = 744,
  [745] = 745,
  [746] = 690,
  [747] = 729,
  [748] = 730,
  [749] = 729,
  [750] = 697,
  [751] = 696,
  [752] = 695,
  [753] = 694,
  [754] = 693,
  [755] = 713,
  [756] = 712,
  [757] = 691,
  [758] = 709,
  [759] = 693,
  [760] = 707,
  [761] = 691,
  [762] = 705,
  [763] = 704,
  [764] = 733,
  [765] = 698,
  [766] = 694,
  [767] = 695,
  [768] = 712,
  [769] = 696,
  [770] = 729,
  [771] = 730,
  [772] = 701,
  [773] = 700,
  [774] = 735,
  [775] = 730,
  [776] = 699,
  [777] = 699,
  [778] = 733,
  [779] = 713,
  [780] = 709,
  [781] = 707,
  [782] = 705,
  [783] = 697,
  [784] = 697,
  [785] = 696,
  [786] = 695,
  [787] = 694,
  [788] = 693,
  [789] = 690,
  [790] = 713,
  [791] = 712,
  [792] = 792,
  [793] = 793,
  [794] = 729,
  [795] = 730,
  [796] = 691,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 709,
  [801] = 801,
  [802] = 707,
  [803] = 704,
  [804] = 705,
  [805] = 704,
  [806] = 733,
  [807] = 698,
  [808] = 733,
  [809] = 701,
  [810] = 698,
  [811] = 700,
  [812] = 735,
  [813] = 699,
  [814] = 701,
  [815] = 700,
  [816] = 816,
  [817] = 817,
  [818] = 729,
  [819] = 730,
  [820] = 699,
  [821] = 704,
  [822] = 705,
  [823] = 697,
  [824] = 696,
  [825] = 240,
  [826] = 697,
  [827] = 696,
  [828] = 695,
  [829] = 694,
  [830] = 693,
  [831] = 690,
  [832] = 713,
  [833] = 712,
  [834] = 691,
  [835] = 709,
  [836] = 707,
  [837] = 695,
  [838] = 705,
  [839] = 704,
  [840] = 733,
  [841] = 698,
  [842] = 729,
  [843] = 730,
  [844] = 744,
  [845] = 736,
  [846] = 694,
  [847] = 244,
  [848] = 744,
  [849] = 736,
  [850] = 701,
  [851] = 700,
  [852] = 744,
  [853] = 736,
  [854] = 735,
  [855] = 855,
  [856] = 744,
  [857] = 736,
  [858] = 699,
  [859] = 239,
  [860] = 744,
  [861] = 736,
  [862] = 693,
  [863] = 690,
  [864] = 744,
  [865] = 736,
  [866] = 713,
  [867] = 712,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(25);
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == ':') ADVANCE(40);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(42);
      if (('\n' <= lookahead && lookahead <= '\r')) ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '#') ADVANCE(49);
      END_STATE();
    case 1:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '#') ADVANCE(49);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if (lookahead != 0 &&
          lookahead != '#') ADVANCE(49);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '(') ADVANCE(49);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(49);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ',') ADVANCE(41);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(49);
      END_STATE();
    case 6:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(47);
      if (lookahead == 'E') ADVANCE(48);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead != 0) ADVANCE(46);
      END_STATE();
    case 7:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(49);
      END_STATE();
    case 8:
      if (lookahead == '"') ADVANCE(45);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0) ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == '(') ADVANCE(43);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '}') ADVANCE(35);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(53);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(32);
      END_STATE();
    case 10:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ')') ADVANCE(44);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '(') ADVANCE(49);
      END_STATE();
    case 11:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ':') ADVANCE(40);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(49);
      END_STATE();
    case 12:
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ':') ADVANCE(40);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '>') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(49);
      END_STATE();
    case 13:
      if (lookahead == ';') ADVANCE(31);
      if (lookahead == 'n') ADVANCE(29);
      if (lookahead == 'r') ADVANCE(28);
      if (lookahead == 't') ADVANCE(27);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(26);
      END_STATE();
    case 14:
      if (lookahead == 'C') ADVANCE(16);
      END_STATE();
    case 15:
      if (lookahead == 'E') ADVANCE(37);
      END_STATE();
    case 16:
      if (lookahead == 'H') ADVANCE(15);
      END_STATE();
    case 17:
      if (lookahead == 'V') ADVANCE(36);
      END_STATE();
    case 18:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(113);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 19:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(120);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 20:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(122);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 21:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(123);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 22:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(124);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 23:
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(125);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 24:
      if (eof) ADVANCE(25);
      if (lookahead == '}') ADVANCE(35);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(112);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(127);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(96);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(72);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(101);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(42);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(sym__escape_identity);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_BSLASHt);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_BSLASHr);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_BSLASHn);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_BSLASH_SEMI);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_ENV);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(anon_sym_CACHE);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym__gen_exp_arguments_token1);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(aux_sym__untrimmed_argument_token1);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'A') ADVANCE(14);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'N') ADVANCE(17);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'A') ADVANCE(14);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'N') ADVANCE(17);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(57);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(aux_sym_if_command_token1);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '<') ADVANCE(38);
      if (lookahead == 'C') ADVANCE(50);
      if (lookahead == 'E') ADVANCE(51);
      if (lookahead == '\\') ADVANCE(13);
      if (lookahead == '{') ADVANCE(34);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(52);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(49);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(33);
      if (lookahead == ';') ADVANCE(30);
      if (lookahead == '\\') ADVANCE(13);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(52);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#' &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(49);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == ')') ADVANCE(44);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(57);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(57);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_elseif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_else);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_endif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_foreach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_endforeach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_endwhile);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_function);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_endfunction);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_macro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_endmacro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_block);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_endblock);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(116);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(140);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(111);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(103);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(137);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(143);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(63);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(114);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(139);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(87);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(135);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(118);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(92);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(126);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(104);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 24, .external_lex_state = 2},
  [2] = {.lex_state = 18, .external_lex_state = 2},
  [3] = {.lex_state = 18, .external_lex_state = 2},
  [4] = {.lex_state = 18, .external_lex_state = 2},
  [5] = {.lex_state = 18, .external_lex_state = 2},
  [6] = {.lex_state = 18, .external_lex_state = 2},
  [7] = {.lex_state = 18, .external_lex_state = 2},
  [8] = {.lex_state = 18, .external_lex_state = 2},
  [9] = {.lex_state = 18, .external_lex_state = 2},
  [10] = {.lex_state = 18, .external_lex_state = 2},
  [11] = {.lex_state = 18, .external_lex_state = 2},
  [12] = {.lex_state = 18, .external_lex_state = 2},
  [13] = {.lex_state = 18, .external_lex_state = 2},
  [14] = {.lex_state = 18, .external_lex_state = 2},
  [15] = {.lex_state = 18, .external_lex_state = 2},
  [16] = {.lex_state = 2, .external_lex_state = 1},
  [17] = {.lex_state = 2, .external_lex_state = 1},
  [18] = {.lex_state = 2, .external_lex_state = 1},
  [19] = {.lex_state = 2, .external_lex_state = 1},
  [20] = {.lex_state = 2, .external_lex_state = 1},
  [21] = {.lex_state = 2, .external_lex_state = 1},
  [22] = {.lex_state = 2, .external_lex_state = 1},
  [23] = {.lex_state = 2, .external_lex_state = 1},
  [24] = {.lex_state = 2, .external_lex_state = 1},
  [25] = {.lex_state = 2, .external_lex_state = 1},
  [26] = {.lex_state = 2, .external_lex_state = 1},
  [27] = {.lex_state = 2, .external_lex_state = 1},
  [28] = {.lex_state = 2, .external_lex_state = 1},
  [29] = {.lex_state = 2, .external_lex_state = 1},
  [30] = {.lex_state = 2, .external_lex_state = 1},
  [31] = {.lex_state = 2, .external_lex_state = 1},
  [32] = {.lex_state = 2, .external_lex_state = 1},
  [33] = {.lex_state = 2, .external_lex_state = 1},
  [34] = {.lex_state = 2, .external_lex_state = 1},
  [35] = {.lex_state = 2, .external_lex_state = 1},
  [36] = {.lex_state = 2, .external_lex_state = 1},
  [37] = {.lex_state = 2, .external_lex_state = 1},
  [38] = {.lex_state = 2, .external_lex_state = 1},
  [39] = {.lex_state = 2, .external_lex_state = 1},
  [40] = {.lex_state = 2, .external_lex_state = 1},
  [41] = {.lex_state = 2, .external_lex_state = 1},
  [42] = {.lex_state = 2, .external_lex_state = 1},
  [43] = {.lex_state = 2, .external_lex_state = 1},
  [44] = {.lex_state = 2, .external_lex_state = 1},
  [45] = {.lex_state = 2, .external_lex_state = 1},
  [46] = {.lex_state = 2, .external_lex_state = 1},
  [47] = {.lex_state = 2, .external_lex_state = 1},
  [48] = {.lex_state = 2, .external_lex_state = 1},
  [49] = {.lex_state = 2, .external_lex_state = 1},
  [50] = {.lex_state = 2, .external_lex_state = 1},
  [51] = {.lex_state = 2, .external_lex_state = 1},
  [52] = {.lex_state = 2, .external_lex_state = 1},
  [53] = {.lex_state = 2, .external_lex_state = 1},
  [54] = {.lex_state = 2, .external_lex_state = 1},
  [55] = {.lex_state = 2, .external_lex_state = 1},
  [56] = {.lex_state = 2, .external_lex_state = 1},
  [57] = {.lex_state = 2, .external_lex_state = 1},
  [58] = {.lex_state = 2, .external_lex_state = 1},
  [59] = {.lex_state = 2, .external_lex_state = 1},
  [60] = {.lex_state = 2, .external_lex_state = 1},
  [61] = {.lex_state = 2, .external_lex_state = 1},
  [62] = {.lex_state = 2, .external_lex_state = 1},
  [63] = {.lex_state = 2, .external_lex_state = 1},
  [64] = {.lex_state = 2, .external_lex_state = 1},
  [65] = {.lex_state = 2, .external_lex_state = 1},
  [66] = {.lex_state = 2, .external_lex_state = 1},
  [67] = {.lex_state = 2, .external_lex_state = 1},
  [68] = {.lex_state = 2, .external_lex_state = 1},
  [69] = {.lex_state = 2, .external_lex_state = 1},
  [70] = {.lex_state = 2, .external_lex_state = 1},
  [71] = {.lex_state = 2, .external_lex_state = 1},
  [72] = {.lex_state = 2, .external_lex_state = 1},
  [73] = {.lex_state = 2, .external_lex_state = 1},
  [74] = {.lex_state = 18, .external_lex_state = 2},
  [75] = {.lex_state = 2, .external_lex_state = 1},
  [76] = {.lex_state = 2, .external_lex_state = 1},
  [77] = {.lex_state = 2, .external_lex_state = 1},
  [78] = {.lex_state = 2, .external_lex_state = 1},
  [79] = {.lex_state = 2, .external_lex_state = 1},
  [80] = {.lex_state = 2, .external_lex_state = 1},
  [81] = {.lex_state = 2, .external_lex_state = 1},
  [82] = {.lex_state = 2, .external_lex_state = 1},
  [83] = {.lex_state = 2, .external_lex_state = 1},
  [84] = {.lex_state = 2, .external_lex_state = 1},
  [85] = {.lex_state = 2, .external_lex_state = 1},
  [86] = {.lex_state = 2, .external_lex_state = 1},
  [87] = {.lex_state = 2, .external_lex_state = 1},
  [88] = {.lex_state = 2, .external_lex_state = 1},
  [89] = {.lex_state = 2, .external_lex_state = 1},
  [90] = {.lex_state = 2, .external_lex_state = 1},
  [91] = {.lex_state = 2, .external_lex_state = 1},
  [92] = {.lex_state = 2, .external_lex_state = 1},
  [93] = {.lex_state = 2, .external_lex_state = 1},
  [94] = {.lex_state = 2, .external_lex_state = 1},
  [95] = {.lex_state = 2, .external_lex_state = 1},
  [96] = {.lex_state = 2, .external_lex_state = 1},
  [97] = {.lex_state = 2, .external_lex_state = 1},
  [98] = {.lex_state = 2, .external_lex_state = 1},
  [99] = {.lex_state = 2, .external_lex_state = 1},
  [100] = {.lex_state = 2, .external_lex_state = 1},
  [101] = {.lex_state = 2, .external_lex_state = 1},
  [102] = {.lex_state = 2, .external_lex_state = 1},
  [103] = {.lex_state = 2, .external_lex_state = 1},
  [104] = {.lex_state = 2, .external_lex_state = 1},
  [105] = {.lex_state = 2, .external_lex_state = 1},
  [106] = {.lex_state = 2, .external_lex_state = 1},
  [107] = {.lex_state = 18, .external_lex_state = 2},
  [108] = {.lex_state = 18, .external_lex_state = 2},
  [109] = {.lex_state = 24, .external_lex_state = 2},
  [110] = {.lex_state = 24, .external_lex_state = 2},
  [111] = {.lex_state = 24, .external_lex_state = 2},
  [112] = {.lex_state = 24, .external_lex_state = 2},
  [113] = {.lex_state = 24, .external_lex_state = 2},
  [114] = {.lex_state = 24, .external_lex_state = 2},
  [115] = {.lex_state = 24, .external_lex_state = 2},
  [116] = {.lex_state = 24, .external_lex_state = 2},
  [117] = {.lex_state = 24, .external_lex_state = 2},
  [118] = {.lex_state = 24, .external_lex_state = 2},
  [119] = {.lex_state = 24, .external_lex_state = 2},
  [120] = {.lex_state = 19, .external_lex_state = 2},
  [121] = {.lex_state = 24, .external_lex_state = 2},
  [122] = {.lex_state = 24, .external_lex_state = 2},
  [123] = {.lex_state = 20, .external_lex_state = 2},
  [124] = {.lex_state = 24, .external_lex_state = 2},
  [125] = {.lex_state = 24, .external_lex_state = 2},
  [126] = {.lex_state = 24, .external_lex_state = 2},
  [127] = {.lex_state = 21, .external_lex_state = 2},
  [128] = {.lex_state = 24, .external_lex_state = 2},
  [129] = {.lex_state = 19, .external_lex_state = 2},
  [130] = {.lex_state = 21, .external_lex_state = 2},
  [131] = {.lex_state = 24, .external_lex_state = 2},
  [132] = {.lex_state = 24, .external_lex_state = 2},
  [133] = {.lex_state = 22, .external_lex_state = 2},
  [134] = {.lex_state = 23, .external_lex_state = 2},
  [135] = {.lex_state = 24, .external_lex_state = 2},
  [136] = {.lex_state = 24, .external_lex_state = 2},
  [137] = {.lex_state = 24, .external_lex_state = 2},
  [138] = {.lex_state = 24, .external_lex_state = 2},
  [139] = {.lex_state = 24, .external_lex_state = 2},
  [140] = {.lex_state = 24, .external_lex_state = 2},
  [141] = {.lex_state = 24, .external_lex_state = 2},
  [142] = {.lex_state = 24, .external_lex_state = 2},
  [143] = {.lex_state = 24, .external_lex_state = 2},
  [144] = {.lex_state = 24, .external_lex_state = 2},
  [145] = {.lex_state = 24, .external_lex_state = 2},
  [146] = {.lex_state = 24, .external_lex_state = 2},
  [147] = {.lex_state = 24, .external_lex_state = 2},
  [148] = {.lex_state = 23, .external_lex_state = 2},
  [149] = {.lex_state = 24, .external_lex_state = 2},
  [150] = {.lex_state = 24, .external_lex_state = 2},
  [151] = {.lex_state = 24, .external_lex_state = 2},
  [152] = {.lex_state = 24, .external_lex_state = 2},
  [153] = {.lex_state = 20, .external_lex_state = 2},
  [154] = {.lex_state = 24, .external_lex_state = 2},
  [155] = {.lex_state = 22, .external_lex_state = 2},
  [156] = {.lex_state = 7, .external_lex_state = 3},
  [157] = {.lex_state = 7, .external_lex_state = 3},
  [158] = {.lex_state = 7, .external_lex_state = 3},
  [159] = {.lex_state = 7, .external_lex_state = 3},
  [160] = {.lex_state = 7, .external_lex_state = 3},
  [161] = {.lex_state = 7, .external_lex_state = 3},
  [162] = {.lex_state = 7, .external_lex_state = 3},
  [163] = {.lex_state = 2, .external_lex_state = 1},
  [164] = {.lex_state = 7, .external_lex_state = 3},
  [165] = {.lex_state = 2, .external_lex_state = 1},
  [166] = {.lex_state = 7, .external_lex_state = 3},
  [167] = {.lex_state = 3, .external_lex_state = 3},
  [168] = {.lex_state = 3, .external_lex_state = 3},
  [169] = {.lex_state = 3, .external_lex_state = 3},
  [170] = {.lex_state = 3, .external_lex_state = 3},
  [171] = {.lex_state = 3, .external_lex_state = 3},
  [172] = {.lex_state = 3, .external_lex_state = 3},
  [173] = {.lex_state = 3, .external_lex_state = 3},
  [174] = {.lex_state = 3, .external_lex_state = 3},
  [175] = {.lex_state = 3, .external_lex_state = 3},
  [176] = {.lex_state = 3, .external_lex_state = 3},
  [177] = {.lex_state = 3, .external_lex_state = 3},
  [178] = {.lex_state = 3, .external_lex_state = 3},
  [179] = {.lex_state = 3, .external_lex_state = 3},
  [180] = {.lex_state = 3, .external_lex_state = 3},
  [181] = {.lex_state = 3, .external_lex_state = 3},
  [182] = {.lex_state = 3, .external_lex_state = 3},
  [183] = {.lex_state = 3, .external_lex_state = 3},
  [184] = {.lex_state = 3, .external_lex_state = 3},
  [185] = {.lex_state = 3, .external_lex_state = 3},
  [186] = {.lex_state = 3, .external_lex_state = 3},
  [187] = {.lex_state = 3, .external_lex_state = 3},
  [188] = {.lex_state = 3, .external_lex_state = 3},
  [189] = {.lex_state = 3, .external_lex_state = 3},
  [190] = {.lex_state = 3, .external_lex_state = 3},
  [191] = {.lex_state = 3, .external_lex_state = 3},
  [192] = {.lex_state = 3, .external_lex_state = 3},
  [193] = {.lex_state = 3, .external_lex_state = 3},
  [194] = {.lex_state = 3, .external_lex_state = 3},
  [195] = {.lex_state = 5, .external_lex_state = 3},
  [196] = {.lex_state = 5, .external_lex_state = 3},
  [197] = {.lex_state = 8},
  [198] = {.lex_state = 8},
  [199] = {.lex_state = 8},
  [200] = {.lex_state = 12},
  [201] = {.lex_state = 8},
  [202] = {.lex_state = 12},
  [203] = {.lex_state = 3},
  [204] = {.lex_state = 55},
  [205] = {.lex_state = 8},
  [206] = {.lex_state = 3},
  [207] = {.lex_state = 55},
  [208] = {.lex_state = 8},
  [209] = {.lex_state = 1, .external_lex_state = 1},
  [210] = {.lex_state = 9},
  [211] = {.lex_state = 9},
  [212] = {.lex_state = 9},
  [213] = {.lex_state = 9},
  [214] = {.lex_state = 9},
  [215] = {.lex_state = 9},
  [216] = {.lex_state = 9},
  [217] = {.lex_state = 9},
  [218] = {.lex_state = 9},
  [219] = {.lex_state = 9},
  [220] = {.lex_state = 9},
  [221] = {.lex_state = 9},
  [222] = {.lex_state = 9},
  [223] = {.lex_state = 9},
  [224] = {.lex_state = 9},
  [225] = {.lex_state = 9},
  [226] = {.lex_state = 9},
  [227] = {.lex_state = 9},
  [228] = {.lex_state = 9},
  [229] = {.lex_state = 9},
  [230] = {.lex_state = 9},
  [231] = {.lex_state = 9},
  [232] = {.lex_state = 9},
  [233] = {.lex_state = 2, .external_lex_state = 1},
  [234] = {.lex_state = 4, .external_lex_state = 3},
  [235] = {.lex_state = 2, .external_lex_state = 1},
  [236] = {.lex_state = 2, .external_lex_state = 1},
  [237] = {.lex_state = 2, .external_lex_state = 1},
  [238] = {.lex_state = 2, .external_lex_state = 1},
  [239] = {.lex_state = 2, .external_lex_state = 1},
  [240] = {.lex_state = 2, .external_lex_state = 1},
  [241] = {.lex_state = 2, .external_lex_state = 1},
  [242] = {.lex_state = 2, .external_lex_state = 1},
  [243] = {.lex_state = 2, .external_lex_state = 1},
  [244] = {.lex_state = 2, .external_lex_state = 1},
  [245] = {.lex_state = 2, .external_lex_state = 1},
  [246] = {.lex_state = 2, .external_lex_state = 1},
  [247] = {.lex_state = 11},
  [248] = {.lex_state = 18, .external_lex_state = 2},
  [249] = {.lex_state = 18, .external_lex_state = 2},
  [250] = {.lex_state = 18, .external_lex_state = 2},
  [251] = {.lex_state = 18, .external_lex_state = 2},
  [252] = {.lex_state = 18, .external_lex_state = 2},
  [253] = {.lex_state = 18, .external_lex_state = 2},
  [254] = {.lex_state = 6},
  [255] = {.lex_state = 18, .external_lex_state = 2},
  [256] = {.lex_state = 10},
  [257] = {.lex_state = 18, .external_lex_state = 2},
  [258] = {.lex_state = 18, .external_lex_state = 2},
  [259] = {.lex_state = 18, .external_lex_state = 2},
  [260] = {.lex_state = 18, .external_lex_state = 2},
  [261] = {.lex_state = 18, .external_lex_state = 2},
  [262] = {.lex_state = 18, .external_lex_state = 2},
  [263] = {.lex_state = 18, .external_lex_state = 2},
  [264] = {.lex_state = 18, .external_lex_state = 2},
  [265] = {.lex_state = 18, .external_lex_state = 2},
  [266] = {.lex_state = 18, .external_lex_state = 2},
  [267] = {.lex_state = 18, .external_lex_state = 2},
  [268] = {.lex_state = 18, .external_lex_state = 2},
  [269] = {.lex_state = 18, .external_lex_state = 2},
  [270] = {.lex_state = 18, .external_lex_state = 2},
  [271] = {.lex_state = 18, .external_lex_state = 2},
  [272] = {.lex_state = 18, .external_lex_state = 2},
  [273] = {.lex_state = 18, .external_lex_state = 2},
  [274] = {.lex_state = 18, .external_lex_state = 2},
  [275] = {.lex_state = 18, .external_lex_state = 2},
  [276] = {.lex_state = 18, .external_lex_state = 2},
  [277] = {.lex_state = 18, .external_lex_state = 2},
  [278] = {.lex_state = 18, .external_lex_state = 2},
  [279] = {.lex_state = 18, .external_lex_state = 2},
  [280] = {.lex_state = 18, .external_lex_state = 2},
  [281] = {.lex_state = 18, .external_lex_state = 2},
  [282] = {.lex_state = 18, .external_lex_state = 2},
  [283] = {.lex_state = 5, .external_lex_state = 3},
  [284] = {.lex_state = 18, .external_lex_state = 2},
  [285] = {.lex_state = 54},
  [286] = {.lex_state = 18, .external_lex_state = 2},
  [287] = {.lex_state = 18, .external_lex_state = 2},
  [288] = {.lex_state = 5, .external_lex_state = 3},
  [289] = {.lex_state = 5, .external_lex_state = 3},
  [290] = {.lex_state = 5, .external_lex_state = 3},
  [291] = {.lex_state = 5, .external_lex_state = 3},
  [292] = {.lex_state = 5, .external_lex_state = 3},
  [293] = {.lex_state = 5, .external_lex_state = 3},
  [294] = {.lex_state = 5, .external_lex_state = 3},
  [295] = {.lex_state = 5, .external_lex_state = 3},
  [296] = {.lex_state = 5, .external_lex_state = 3},
  [297] = {.lex_state = 5, .external_lex_state = 3},
  [298] = {.lex_state = 5, .external_lex_state = 3},
  [299] = {.lex_state = 20, .external_lex_state = 2},
  [300] = {.lex_state = 21, .external_lex_state = 2},
  [301] = {.lex_state = 23, .external_lex_state = 2},
  [302] = {.lex_state = 23, .external_lex_state = 2},
  [303] = {.lex_state = 23, .external_lex_state = 2},
  [304] = {.lex_state = 24, .external_lex_state = 2},
  [305] = {.lex_state = 12},
  [306] = {.lex_state = 23, .external_lex_state = 2},
  [307] = {.lex_state = 23, .external_lex_state = 2},
  [308] = {.lex_state = 23, .external_lex_state = 2},
  [309] = {.lex_state = 23, .external_lex_state = 2},
  [310] = {.lex_state = 23, .external_lex_state = 2},
  [311] = {.lex_state = 23, .external_lex_state = 2},
  [312] = {.lex_state = 19, .external_lex_state = 2},
  [313] = {.lex_state = 24, .external_lex_state = 2},
  [314] = {.lex_state = 7, .external_lex_state = 3},
  [315] = {.lex_state = 19, .external_lex_state = 2},
  [316] = {.lex_state = 19, .external_lex_state = 2},
  [317] = {.lex_state = 19, .external_lex_state = 2},
  [318] = {.lex_state = 19, .external_lex_state = 2},
  [319] = {.lex_state = 19, .external_lex_state = 2},
  [320] = {.lex_state = 19, .external_lex_state = 2},
  [321] = {.lex_state = 19, .external_lex_state = 2},
  [322] = {.lex_state = 24, .external_lex_state = 2},
  [323] = {.lex_state = 19, .external_lex_state = 2},
  [324] = {.lex_state = 19, .external_lex_state = 2},
  [325] = {.lex_state = 24, .external_lex_state = 2},
  [326] = {.lex_state = 19, .external_lex_state = 2},
  [327] = {.lex_state = 19, .external_lex_state = 2},
  [328] = {.lex_state = 19, .external_lex_state = 2},
  [329] = {.lex_state = 19, .external_lex_state = 2},
  [330] = {.lex_state = 19, .external_lex_state = 2},
  [331] = {.lex_state = 19, .external_lex_state = 2},
  [332] = {.lex_state = 19, .external_lex_state = 2},
  [333] = {.lex_state = 24, .external_lex_state = 2},
  [334] = {.lex_state = 23, .external_lex_state = 2},
  [335] = {.lex_state = 19, .external_lex_state = 2},
  [336] = {.lex_state = 19, .external_lex_state = 2},
  [337] = {.lex_state = 19, .external_lex_state = 2},
  [338] = {.lex_state = 19, .external_lex_state = 2},
  [339] = {.lex_state = 19, .external_lex_state = 2},
  [340] = {.lex_state = 19, .external_lex_state = 2},
  [341] = {.lex_state = 24, .external_lex_state = 2},
  [342] = {.lex_state = 24, .external_lex_state = 2},
  [343] = {.lex_state = 19, .external_lex_state = 2},
  [344] = {.lex_state = 19, .external_lex_state = 2},
  [345] = {.lex_state = 19, .external_lex_state = 2},
  [346] = {.lex_state = 19, .external_lex_state = 2},
  [347] = {.lex_state = 19, .external_lex_state = 2},
  [348] = {.lex_state = 19, .external_lex_state = 2},
  [349] = {.lex_state = 22, .external_lex_state = 2},
  [350] = {.lex_state = 24, .external_lex_state = 2},
  [351] = {.lex_state = 24, .external_lex_state = 2},
  [352] = {.lex_state = 22, .external_lex_state = 2},
  [353] = {.lex_state = 22, .external_lex_state = 2},
  [354] = {.lex_state = 22, .external_lex_state = 2},
  [355] = {.lex_state = 22, .external_lex_state = 2},
  [356] = {.lex_state = 22, .external_lex_state = 2},
  [357] = {.lex_state = 22, .external_lex_state = 2},
  [358] = {.lex_state = 22, .external_lex_state = 2},
  [359] = {.lex_state = 22, .external_lex_state = 2},
  [360] = {.lex_state = 22, .external_lex_state = 2},
  [361] = {.lex_state = 24, .external_lex_state = 2},
  [362] = {.lex_state = 22, .external_lex_state = 2},
  [363] = {.lex_state = 22, .external_lex_state = 2},
  [364] = {.lex_state = 22, .external_lex_state = 2},
  [365] = {.lex_state = 22, .external_lex_state = 2},
  [366] = {.lex_state = 22, .external_lex_state = 2},
  [367] = {.lex_state = 22, .external_lex_state = 2},
  [368] = {.lex_state = 22, .external_lex_state = 2},
  [369] = {.lex_state = 24, .external_lex_state = 2},
  [370] = {.lex_state = 24, .external_lex_state = 2},
  [371] = {.lex_state = 22, .external_lex_state = 2},
  [372] = {.lex_state = 22, .external_lex_state = 2},
  [373] = {.lex_state = 22, .external_lex_state = 2},
  [374] = {.lex_state = 22, .external_lex_state = 2},
  [375] = {.lex_state = 22, .external_lex_state = 2},
  [376] = {.lex_state = 22, .external_lex_state = 2},
  [377] = {.lex_state = 24, .external_lex_state = 2},
  [378] = {.lex_state = 24, .external_lex_state = 2},
  [379] = {.lex_state = 22, .external_lex_state = 2},
  [380] = {.lex_state = 22, .external_lex_state = 2},
  [381] = {.lex_state = 22, .external_lex_state = 2},
  [382] = {.lex_state = 22, .external_lex_state = 2},
  [383] = {.lex_state = 22, .external_lex_state = 2},
  [384] = {.lex_state = 22, .external_lex_state = 2},
  [385] = {.lex_state = 21, .external_lex_state = 2},
  [386] = {.lex_state = 24, .external_lex_state = 2},
  [387] = {.lex_state = 24, .external_lex_state = 2},
  [388] = {.lex_state = 21, .external_lex_state = 2},
  [389] = {.lex_state = 21, .external_lex_state = 2},
  [390] = {.lex_state = 21, .external_lex_state = 2},
  [391] = {.lex_state = 21, .external_lex_state = 2},
  [392] = {.lex_state = 21, .external_lex_state = 2},
  [393] = {.lex_state = 21, .external_lex_state = 2},
  [394] = {.lex_state = 21, .external_lex_state = 2},
  [395] = {.lex_state = 21, .external_lex_state = 2},
  [396] = {.lex_state = 21, .external_lex_state = 2},
  [397] = {.lex_state = 23, .external_lex_state = 2},
  [398] = {.lex_state = 21, .external_lex_state = 2},
  [399] = {.lex_state = 21, .external_lex_state = 2},
  [400] = {.lex_state = 21, .external_lex_state = 2},
  [401] = {.lex_state = 21, .external_lex_state = 2},
  [402] = {.lex_state = 21, .external_lex_state = 2},
  [403] = {.lex_state = 21, .external_lex_state = 2},
  [404] = {.lex_state = 21, .external_lex_state = 2},
  [405] = {.lex_state = 24, .external_lex_state = 2},
  [406] = {.lex_state = 23, .external_lex_state = 2},
  [407] = {.lex_state = 21, .external_lex_state = 2},
  [408] = {.lex_state = 21, .external_lex_state = 2},
  [409] = {.lex_state = 21, .external_lex_state = 2},
  [410] = {.lex_state = 24, .external_lex_state = 2},
  [411] = {.lex_state = 21, .external_lex_state = 2},
  [412] = {.lex_state = 21, .external_lex_state = 2},
  [413] = {.lex_state = 23, .external_lex_state = 2},
  [414] = {.lex_state = 24, .external_lex_state = 2},
  [415] = {.lex_state = 21, .external_lex_state = 2},
  [416] = {.lex_state = 21, .external_lex_state = 2},
  [417] = {.lex_state = 21, .external_lex_state = 2},
  [418] = {.lex_state = 21, .external_lex_state = 2},
  [419] = {.lex_state = 21, .external_lex_state = 2},
  [420] = {.lex_state = 21, .external_lex_state = 2},
  [421] = {.lex_state = 20, .external_lex_state = 2},
  [422] = {.lex_state = 23, .external_lex_state = 2},
  [423] = {.lex_state = 24, .external_lex_state = 2},
  [424] = {.lex_state = 24, .external_lex_state = 2},
  [425] = {.lex_state = 20, .external_lex_state = 2},
  [426] = {.lex_state = 20, .external_lex_state = 2},
  [427] = {.lex_state = 20, .external_lex_state = 2},
  [428] = {.lex_state = 20, .external_lex_state = 2},
  [429] = {.lex_state = 20, .external_lex_state = 2},
  [430] = {.lex_state = 20, .external_lex_state = 2},
  [431] = {.lex_state = 20, .external_lex_state = 2},
  [432] = {.lex_state = 20, .external_lex_state = 2},
  [433] = {.lex_state = 20, .external_lex_state = 2},
  [434] = {.lex_state = 23, .external_lex_state = 2},
  [435] = {.lex_state = 20, .external_lex_state = 2},
  [436] = {.lex_state = 20, .external_lex_state = 2},
  [437] = {.lex_state = 20, .external_lex_state = 2},
  [438] = {.lex_state = 20, .external_lex_state = 2},
  [439] = {.lex_state = 20, .external_lex_state = 2},
  [440] = {.lex_state = 20, .external_lex_state = 2},
  [441] = {.lex_state = 23, .external_lex_state = 2},
  [442] = {.lex_state = 20, .external_lex_state = 2},
  [443] = {.lex_state = 20, .external_lex_state = 2},
  [444] = {.lex_state = 20, .external_lex_state = 2},
  [445] = {.lex_state = 20, .external_lex_state = 2},
  [446] = {.lex_state = 20, .external_lex_state = 2},
  [447] = {.lex_state = 20, .external_lex_state = 2},
  [448] = {.lex_state = 23, .external_lex_state = 2},
  [449] = {.lex_state = 23, .external_lex_state = 2},
  [450] = {.lex_state = 20, .external_lex_state = 2},
  [451] = {.lex_state = 20, .external_lex_state = 2},
  [452] = {.lex_state = 20, .external_lex_state = 2},
  [453] = {.lex_state = 20, .external_lex_state = 2},
  [454] = {.lex_state = 20, .external_lex_state = 2},
  [455] = {.lex_state = 20, .external_lex_state = 2},
  [456] = {.lex_state = 23, .external_lex_state = 2},
  [457] = {.lex_state = 23, .external_lex_state = 2},
  [458] = {.lex_state = 23, .external_lex_state = 2},
  [459] = {.lex_state = 23, .external_lex_state = 2},
  [460] = {.lex_state = 24, .external_lex_state = 2},
  [461] = {.lex_state = 23, .external_lex_state = 2},
  [462] = {.lex_state = 24, .external_lex_state = 2},
  [463] = {.lex_state = 24, .external_lex_state = 2},
  [464] = {.lex_state = 24, .external_lex_state = 2},
  [465] = {.lex_state = 24, .external_lex_state = 2},
  [466] = {.lex_state = 23, .external_lex_state = 2},
  [467] = {.lex_state = 23, .external_lex_state = 2},
  [468] = {.lex_state = 23, .external_lex_state = 2},
  [469] = {.lex_state = 24, .external_lex_state = 2},
  [470] = {.lex_state = 24, .external_lex_state = 2},
  [471] = {.lex_state = 23, .external_lex_state = 2},
  [472] = {.lex_state = 23, .external_lex_state = 2},
  [473] = {.lex_state = 24, .external_lex_state = 2},
  [474] = {.lex_state = 23, .external_lex_state = 2},
  [475] = {.lex_state = 24, .external_lex_state = 2},
  [476] = {.lex_state = 3},
  [477] = {.lex_state = 24, .external_lex_state = 2},
  [478] = {.lex_state = 24, .external_lex_state = 2},
  [479] = {.lex_state = 8},
  [480] = {.lex_state = 24, .external_lex_state = 2},
  [481] = {.lex_state = 24, .external_lex_state = 2},
  [482] = {.lex_state = 12},
  [483] = {.lex_state = 24, .external_lex_state = 2},
  [484] = {.lex_state = 24, .external_lex_state = 2},
  [485] = {.lex_state = 24, .external_lex_state = 2},
  [486] = {.lex_state = 24, .external_lex_state = 2},
  [487] = {.lex_state = 24, .external_lex_state = 2},
  [488] = {.lex_state = 12},
  [489] = {.lex_state = 12},
  [490] = {.lex_state = 12},
  [491] = {.lex_state = 55},
  [492] = {.lex_state = 12},
  [493] = {.lex_state = 12},
  [494] = {.lex_state = 12},
  [495] = {.lex_state = 55},
  [496] = {.lex_state = 8},
  [497] = {.lex_state = 3},
  [498] = {.lex_state = 9},
  [499] = {.lex_state = 9},
  [500] = {.lex_state = 3},
  [501] = {.lex_state = 55},
  [502] = {.lex_state = 3},
  [503] = {.lex_state = 3},
  [504] = {.lex_state = 9},
  [505] = {.lex_state = 55},
  [506] = {.lex_state = 3},
  [507] = {.lex_state = 55},
  [508] = {.lex_state = 3},
  [509] = {.lex_state = 8},
  [510] = {.lex_state = 8},
  [511] = {.lex_state = 3},
  [512] = {.lex_state = 55},
  [513] = {.lex_state = 55},
  [514] = {.lex_state = 8},
  [515] = {.lex_state = 8},
  [516] = {.lex_state = 55},
  [517] = {.lex_state = 8},
  [518] = {.lex_state = 9},
  [519] = {.lex_state = 9},
  [520] = {.lex_state = 8},
  [521] = {.lex_state = 9},
  [522] = {.lex_state = 9},
  [523] = {.lex_state = 9},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 9},
  [526] = {.lex_state = 0},
  [527] = {.lex_state = 9},
  [528] = {.lex_state = 9},
  [529] = {.lex_state = 9},
  [530] = {.lex_state = 9},
  [531] = {.lex_state = 9},
  [532] = {.lex_state = 9},
  [533] = {.lex_state = 9},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 9},
  [536] = {.lex_state = 9},
  [537] = {.lex_state = 9},
  [538] = {.lex_state = 9},
  [539] = {.lex_state = 9},
  [540] = {.lex_state = 9},
  [541] = {.lex_state = 9},
  [542] = {.lex_state = 9},
  [543] = {.lex_state = 9},
  [544] = {.lex_state = 9},
  [545] = {.lex_state = 9},
  [546] = {.lex_state = 9},
  [547] = {.lex_state = 9},
  [548] = {.lex_state = 9},
  [549] = {.lex_state = 9},
  [550] = {.lex_state = 9},
  [551] = {.lex_state = 9},
  [552] = {.lex_state = 9},
  [553] = {.lex_state = 9},
  [554] = {.lex_state = 9},
  [555] = {.lex_state = 9},
  [556] = {.lex_state = 9},
  [557] = {.lex_state = 9},
  [558] = {.lex_state = 9},
  [559] = {.lex_state = 9},
  [560] = {.lex_state = 9},
  [561] = {.lex_state = 9},
  [562] = {.lex_state = 9},
  [563] = {.lex_state = 9},
  [564] = {.lex_state = 9},
  [565] = {.lex_state = 9},
  [566] = {.lex_state = 9},
  [567] = {.lex_state = 9},
  [568] = {.lex_state = 9},
  [569] = {.lex_state = 9},
  [570] = {.lex_state = 9},
  [571] = {.lex_state = 9},
  [572] = {.lex_state = 9},
  [573] = {.lex_state = 9},
  [574] = {.lex_state = 9},
  [575] = {.lex_state = 9},
  [576] = {.lex_state = 9},
  [577] = {.lex_state = 9},
  [578] = {.lex_state = 9},
  [579] = {.lex_state = 9},
  [580] = {.lex_state = 9},
  [581] = {.lex_state = 9},
  [582] = {.lex_state = 9},
  [583] = {.lex_state = 9},
  [584] = {.lex_state = 9},
  [585] = {.lex_state = 9},
  [586] = {.lex_state = 9},
  [587] = {.lex_state = 9},
  [588] = {.lex_state = 9},
  [589] = {.lex_state = 9},
  [590] = {.lex_state = 9},
  [591] = {.lex_state = 9},
  [592] = {.lex_state = 9},
  [593] = {.lex_state = 9},
  [594] = {.lex_state = 9},
  [595] = {.lex_state = 9},
  [596] = {.lex_state = 9},
  [597] = {.lex_state = 9},
  [598] = {.lex_state = 9},
  [599] = {.lex_state = 9},
  [600] = {.lex_state = 9},
  [601] = {.lex_state = 9},
  [602] = {.lex_state = 9},
  [603] = {.lex_state = 9},
  [604] = {.lex_state = 9},
  [605] = {.lex_state = 9},
  [606] = {.lex_state = 9},
  [607] = {.lex_state = 9},
  [608] = {.lex_state = 9},
  [609] = {.lex_state = 9},
  [610] = {.lex_state = 9},
  [611] = {.lex_state = 9},
  [612] = {.lex_state = 9},
  [613] = {.lex_state = 0},
  [614] = {.lex_state = 9},
  [615] = {.lex_state = 9},
  [616] = {.lex_state = 9},
  [617] = {.lex_state = 9},
  [618] = {.lex_state = 9},
  [619] = {.lex_state = 9},
  [620] = {.lex_state = 9},
  [621] = {.lex_state = 0},
  [622] = {.lex_state = 9},
  [623] = {.lex_state = 9},
  [624] = {.lex_state = 9},
  [625] = {.lex_state = 9},
  [626] = {.lex_state = 9},
  [627] = {.lex_state = 9},
  [628] = {.lex_state = 9},
  [629] = {.lex_state = 9},
  [630] = {.lex_state = 9},
  [631] = {.lex_state = 9},
  [632] = {.lex_state = 9},
  [633] = {.lex_state = 9},
  [634] = {.lex_state = 9},
  [635] = {.lex_state = 9},
  [636] = {.lex_state = 9},
  [637] = {.lex_state = 9},
  [638] = {.lex_state = 9},
  [639] = {.lex_state = 9},
  [640] = {.lex_state = 9},
  [641] = {.lex_state = 23},
  [642] = {.lex_state = 56},
  [643] = {.lex_state = 19},
  [644] = {.lex_state = 22},
  [645] = {.lex_state = 21},
  [646] = {.lex_state = 20},
  [647] = {.lex_state = 56},
  [648] = {.lex_state = 56},
  [649] = {.lex_state = 23},
  [650] = {.lex_state = 19},
  [651] = {.lex_state = 23},
  [652] = {.lex_state = 19},
  [653] = {.lex_state = 22},
  [654] = {.lex_state = 23},
  [655] = {.lex_state = 19},
  [656] = {.lex_state = 22},
  [657] = {.lex_state = 21},
  [658] = {.lex_state = 20},
  [659] = {.lex_state = 22},
  [660] = {.lex_state = 21},
  [661] = {.lex_state = 21},
  [662] = {.lex_state = 20},
  [663] = {.lex_state = 20},
  [664] = {.lex_state = 56},
  [665] = {.lex_state = 56},
  [666] = {.lex_state = 56},
  [667] = {.lex_state = 23},
  [668] = {.lex_state = 19},
  [669] = {.lex_state = 56},
  [670] = {.lex_state = 22},
  [671] = {.lex_state = 21},
  [672] = {.lex_state = 20},
  [673] = {.lex_state = 56},
  [674] = {.lex_state = 56},
  [675] = {.lex_state = 56},
  [676] = {.lex_state = 56},
  [677] = {.lex_state = 56},
  [678] = {.lex_state = 56},
  [679] = {.lex_state = 22},
  [680] = {.lex_state = 20},
  [681] = {.lex_state = 21},
  [682] = {.lex_state = 56},
  [683] = {.lex_state = 23},
  [684] = {.lex_state = 19},
  [685] = {.lex_state = 22},
  [686] = {.lex_state = 21},
  [687] = {.lex_state = 20},
  [688] = {.lex_state = 23},
  [689] = {.lex_state = 19},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 24},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 24},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 24},
  [713] = {.lex_state = 24},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 57},
  [730] = {.lex_state = 57},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 24},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 24},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 24},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 57},
  [748] = {.lex_state = 57},
  [749] = {.lex_state = 57},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 24},
  [756] = {.lex_state = 24},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 24},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 24},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 57},
  [771] = {.lex_state = 57},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 57},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 24},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 24},
  [791] = {.lex_state = 24},
  [792] = {.lex_state = 0},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 57},
  [795] = {.lex_state = 57},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 0},
  [798] = {.lex_state = 0},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 0},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 0},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 0},
  [807] = {.lex_state = 24},
  [808] = {.lex_state = 0},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 24},
  [811] = {.lex_state = 0},
  [812] = {.lex_state = 0},
  [813] = {.lex_state = 0},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 0},
  [817] = {.lex_state = 0},
  [818] = {.lex_state = 57},
  [819] = {.lex_state = 57},
  [820] = {.lex_state = 0},
  [821] = {.lex_state = 0},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 0},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 57},
  [826] = {.lex_state = 0},
  [827] = {.lex_state = 0},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 0},
  [830] = {.lex_state = 0},
  [831] = {.lex_state = 0},
  [832] = {.lex_state = 24},
  [833] = {.lex_state = 24},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 0},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 24},
  [842] = {.lex_state = 57},
  [843] = {.lex_state = 57},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 0},
  [846] = {.lex_state = 0},
  [847] = {.lex_state = 57},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 0},
  [852] = {.lex_state = 0},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 0},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 0},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 57},
  [860] = {.lex_state = 0},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 0},
  [863] = {.lex_state = 0},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 24},
  [867] = {.lex_state = 24},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__escape_identity] = ACTIONS(1),
    [anon_sym_BSLASHt] = ACTIONS(1),
    [anon_sym_BSLASHr] = ACTIONS(1),
    [anon_sym_BSLASHn] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_BSLASH_SEMI] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_ENV] = ACTIONS(1),
    [anon_sym_CACHE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [aux_sym__gen_exp_arguments_token1] = ACTIONS(1),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym__unquoted_text_token1] = ACTIONS(1),
    [aux_sym_if_command_token1] = ACTIONS(1),
    [sym_bracket_argument] = ACTIONS(1),
    [sym_bracket_comment] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(855),
    [sym_if_command] = STATE(10),
    [sym_if_condition] = STATE(150),
    [sym_foreach_command] = STATE(149),
    [sym_foreach_loop] = STATE(150),
    [sym_while_command] = STATE(119),
    [sym_while_loop] = STATE(150),
    [sym_function_command] = STATE(154),
    [sym_function_def] = STATE(150),
    [sym_macro_command] = STATE(152),
    [sym_macro_def] = STATE(150),
    [sym_block_command] = STATE(151),
    [sym_block_def] = STATE(150),
    [sym_normal_command] = STATE(150),
    [sym__command_invocation] = STATE(150),
    [sym__untrimmed_command_invocation] = STATE(150),
    [aux_sym_source_file_repeat1] = STATE(150),
    [ts_builtin_sym_end] = ACTIONS(3),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(5),
    [sym_if] = ACTIONS(7),
    [sym_foreach] = ACTIONS(9),
    [sym_while] = ACTIONS(11),
    [sym_function] = ACTIONS(13),
    [sym_macro] = ACTIONS(15),
    [sym_block] = ACTIONS(17),
    [sym_identifier] = ACTIONS(19),
    [sym_bracket_comment] = ACTIONS(5),
    [sym_line_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(27), 1,
      sym_endif,
    ACTIONS(29), 1,
      sym_identifier,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(334), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(14), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [75] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(385), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(4), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [150] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(389), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(74), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [225] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(33), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(353), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(74), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [300] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(35), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(421), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(7), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [375] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(35), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(426), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(74), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [450] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(33), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(349), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(5), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [525] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(37), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(316), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(74), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [600] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(39), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(361), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(15), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [675] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(37), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(312), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(9), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [750] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(41), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(276), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(74), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [825] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(41), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(267), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(12), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [900] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(27), 1,
      sym_endif,
    ACTIONS(29), 1,
      sym_identifier,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(459), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(74), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [975] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(39), 1,
      sym_endif,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    STATE(341), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(74), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [1050] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(51), 1,
      anon_sym_RPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(709), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1112] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(59), 1,
      anon_sym_RPAREN,
    STATE(821), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1174] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(61), 1,
      anon_sym_RPAREN,
    STATE(820), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1236] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(63), 1,
      anon_sym_RPAREN,
    STATE(815), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1298] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(65), 1,
      anon_sym_RPAREN,
    STATE(725), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1360] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(67), 1,
      anon_sym_RPAREN,
    STATE(814), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1422] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(69), 1,
      anon_sym_RPAREN,
    STATE(724), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1484] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
    STATE(759), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1546] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(73), 1,
      anon_sym_RPAREN,
    STATE(858), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1608] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
    STATE(803), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1670] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(77), 1,
      anon_sym_RPAREN,
    STATE(761), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1732] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
    STATE(851), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1794] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(81), 1,
      anon_sym_RPAREN,
    STATE(781), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1856] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    STATE(850), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1918] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(85), 1,
      anon_sym_RPAREN,
    STATE(780), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [1980] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(87), 1,
      anon_sym_RPAREN,
    STATE(839), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2042] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(89), 1,
      anon_sym_RPAREN,
    STATE(777), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2104] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(91), 1,
      anon_sym_RPAREN,
    STATE(836), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2166] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(93), 1,
      anon_sym_RPAREN,
    STATE(691), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2228] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(95), 1,
      anon_sym_RPAREN,
    STATE(731), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2290] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
    STATE(862), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2352] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(99), 1,
      anon_sym_RPAREN,
    STATE(767), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2414] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(101), 1,
      anon_sym_RPAREN,
    STATE(846), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2476] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
    STATE(766), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2538] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(105), 1,
      anon_sym_RPAREN,
    STATE(835), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2600] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(107), 1,
      anon_sym_RPAREN,
    STATE(834), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2662] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
    STATE(830), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2724] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(111), 1,
      anon_sym_RPAREN,
    STATE(693), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2786] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(694), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2848] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(115), 1,
      anon_sym_RPAREN,
    STATE(829), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2910] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(117), 1,
      anon_sym_RPAREN,
    STATE(828), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [2972] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(741), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3034] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(121), 1,
      anon_sym_RPAREN,
    STATE(813), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3096] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(123), 1,
      anon_sym_RPAREN,
    STATE(742), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3158] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
    STATE(723), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3220] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(127), 1,
      anon_sym_RPAREN,
    STATE(695), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3282] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(129), 1,
      anon_sym_RPAREN,
    STATE(699), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3344] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(131), 1,
      anon_sym_RPAREN,
    STATE(738), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3406] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(700), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3468] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(726), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3530] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(701), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3592] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(704), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3654] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(752), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3716] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    STATE(707), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3778] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(145), 1,
      anon_sym_RPAREN,
    STATE(811), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3840] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(147), 1,
      anon_sym_RPAREN,
    STATE(837), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3902] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(149), 1,
      anon_sym_RPAREN,
    STATE(809), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [3964] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(151), 1,
      anon_sym_RPAREN,
    STATE(817), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4026] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(153), 1,
      anon_sym_RPAREN,
    STATE(711), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4088] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(753), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4150] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
    STATE(710), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4212] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(754), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4274] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(161), 1,
      anon_sym_RPAREN,
    STATE(715), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4336] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    STATE(706), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4398] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(165), 1,
      anon_sym_RPAREN,
    STATE(716), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4460] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(167), 1,
      anon_sym_RPAREN,
    STATE(702), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4522] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
    STATE(717), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4584] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
    STATE(805), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4646] = 19,
    ACTIONS(176), 1,
      sym_if,
    ACTIONS(179), 1,
      sym_elseif,
    ACTIONS(182), 1,
      sym_else,
    ACTIONS(185), 1,
      sym_endif,
    ACTIONS(187), 1,
      sym_foreach,
    ACTIONS(190), 1,
      sym_while,
    ACTIONS(193), 1,
      sym_function,
    ACTIONS(196), 1,
      sym_macro,
    ACTIONS(199), 1,
      sym_block,
    ACTIONS(202), 1,
      sym_identifier,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    ACTIONS(173), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(74), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [4718] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(205), 1,
      anon_sym_RPAREN,
    STATE(802), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4780] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(207), 1,
      anon_sym_RPAREN,
    STATE(800), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4842] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(209), 1,
      anon_sym_RPAREN,
    STATE(757), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4904] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(211), 1,
      anon_sym_RPAREN,
    STATE(758), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [4966] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(213), 1,
      anon_sym_RPAREN,
    STATE(760), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5028] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(215), 1,
      anon_sym_RPAREN,
    STATE(763), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5090] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(217), 1,
      anon_sym_RPAREN,
    STATE(772), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5152] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(219), 1,
      anon_sym_RPAREN,
    STATE(796), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5214] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
    STATE(788), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5276] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(223), 1,
      anon_sym_RPAREN,
    STATE(776), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5338] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(225), 1,
      anon_sym_RPAREN,
    STATE(773), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5400] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(227), 1,
      anon_sym_RPAREN,
    STATE(739), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5462] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    STATE(786), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5524] = 14,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
    STATE(787), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5586] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(721), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5645] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(235), 1,
      anon_sym_RPAREN,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(233), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(95), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5704] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(727), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5763] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(801), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5822] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(799), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5881] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(798), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5940] = 13,
    ACTIONS(240), 1,
      anon_sym_DOLLAR,
    ACTIONS(246), 1,
      anon_sym_LPAREN,
    ACTIONS(249), 1,
      anon_sym_RPAREN,
    ACTIONS(251), 1,
      anon_sym_DQUOTE,
    ACTIONS(254), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(257), 1,
      sym_bracket_argument,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(243), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(95), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(237), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [5999] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(797), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6058] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(792), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6117] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(262), 1,
      anon_sym_RPAREN,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(260), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(90), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6176] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    ACTIONS(264), 1,
      anon_sym_RPAREN,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(233), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(95), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6235] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(734), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6294] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(793), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6353] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(732), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6412] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(722), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6471] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(720), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6530] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(708), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6589] = 13,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(49), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_DQUOTE,
    ACTIONS(55), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(57), 1,
      sym_bracket_argument,
    STATE(816), 1,
      sym_argument_list,
    STATE(240), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(47), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(163), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [6648] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(289), 1,
      sym_identifier,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    ACTIONS(266), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(272), 3,
      sym_elseif,
      sym_else,
      sym_endif,
    STATE(107), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6710] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(29), 1,
      sym_identifier,
    STATE(13), 1,
      sym_if_command,
    STATE(109), 1,
      sym_macro_command,
    STATE(111), 1,
      sym_function_command,
    STATE(112), 1,
      sym_while_command,
    STATE(113), 1,
      sym_foreach_command,
    STATE(122), 1,
      sym_block_command,
    ACTIONS(292), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(294), 3,
      sym_elseif,
      sym_else,
      sym_endif,
    STATE(107), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6772] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(110), 1,
      sym_macro_command,
    STATE(124), 1,
      sym_while_command,
    STATE(125), 1,
      sym_function_command,
    STATE(137), 1,
      sym_block_command,
    STATE(145), 1,
      sym_foreach_command,
    STATE(645), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6832] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(110), 1,
      sym_macro_command,
    STATE(124), 1,
      sym_while_command,
    STATE(125), 1,
      sym_function_command,
    STATE(137), 1,
      sym_block_command,
    STATE(145), 1,
      sym_foreach_command,
    STATE(657), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6892] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(8), 1,
      sym_if_command,
    STATE(114), 1,
      sym_foreach_command,
    STATE(115), 1,
      sym_while_command,
    STATE(116), 1,
      sym_function_command,
    STATE(117), 1,
      sym_macro_command,
    STATE(118), 1,
      sym_block_command,
    STATE(644), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(155), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6952] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(306), 1,
      sym_identifier,
    STATE(11), 1,
      sym_if_command,
    STATE(126), 1,
      sym_block_command,
    STATE(131), 1,
      sym_macro_command,
    STATE(135), 1,
      sym_function_command,
    STATE(146), 1,
      sym_while_command,
    STATE(147), 1,
      sym_foreach_command,
    STATE(643), 1,
      sym_body,
    ACTIONS(304), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(129), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7012] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(310), 1,
      sym_identifier,
    STATE(2), 1,
      sym_if_command,
    STATE(121), 1,
      sym_function_command,
    STATE(128), 1,
      sym_block_command,
    STATE(132), 1,
      sym_macro_command,
    STATE(139), 1,
      sym_foreach_command,
    STATE(144), 1,
      sym_while_command,
    STATE(688), 1,
      sym_body,
    ACTIONS(308), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(148), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7072] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(310), 1,
      sym_identifier,
    STATE(2), 1,
      sym_if_command,
    STATE(121), 1,
      sym_function_command,
    STATE(128), 1,
      sym_block_command,
    STATE(132), 1,
      sym_macro_command,
    STATE(139), 1,
      sym_foreach_command,
    STATE(144), 1,
      sym_while_command,
    STATE(641), 1,
      sym_body,
    ACTIONS(308), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(148), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7132] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(306), 1,
      sym_identifier,
    STATE(11), 1,
      sym_if_command,
    STATE(126), 1,
      sym_block_command,
    STATE(131), 1,
      sym_macro_command,
    STATE(135), 1,
      sym_function_command,
    STATE(146), 1,
      sym_while_command,
    STATE(147), 1,
      sym_foreach_command,
    STATE(689), 1,
      sym_body,
    ACTIONS(304), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(129), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7192] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(8), 1,
      sym_if_command,
    STATE(114), 1,
      sym_foreach_command,
    STATE(115), 1,
      sym_while_command,
    STATE(116), 1,
      sym_function_command,
    STATE(117), 1,
      sym_macro_command,
    STATE(118), 1,
      sym_block_command,
    STATE(679), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(155), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7252] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(110), 1,
      sym_macro_command,
    STATE(124), 1,
      sym_while_command,
    STATE(125), 1,
      sym_function_command,
    STATE(137), 1,
      sym_block_command,
    STATE(145), 1,
      sym_foreach_command,
    STATE(681), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7312] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(314), 1,
      sym_identifier,
    STATE(6), 1,
      sym_if_command,
    STATE(138), 1,
      sym_foreach_command,
    STATE(140), 1,
      sym_while_command,
    STATE(141), 1,
      sym_function_command,
    STATE(142), 1,
      sym_macro_command,
    STATE(143), 1,
      sym_block_command,
    STATE(680), 1,
      sym_body,
    ACTIONS(312), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(153), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7372] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(306), 1,
      sym_identifier,
    STATE(11), 1,
      sym_if_command,
    STATE(126), 1,
      sym_block_command,
    STATE(131), 1,
      sym_macro_command,
    STATE(135), 1,
      sym_function_command,
    STATE(146), 1,
      sym_while_command,
    STATE(147), 1,
      sym_foreach_command,
    STATE(652), 1,
      sym_body,
    ACTIONS(304), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(129), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7432] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endwhile,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(319), 1,
      sym_identifier,
    STATE(11), 1,
      sym_if_command,
    STATE(126), 1,
      sym_block_command,
    STATE(131), 1,
      sym_macro_command,
    STATE(135), 1,
      sym_function_command,
    STATE(146), 1,
      sym_while_command,
    STATE(147), 1,
      sym_foreach_command,
    ACTIONS(316), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(120), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7492] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(8), 1,
      sym_if_command,
    STATE(114), 1,
      sym_foreach_command,
    STATE(115), 1,
      sym_while_command,
    STATE(116), 1,
      sym_function_command,
    STATE(117), 1,
      sym_macro_command,
    STATE(118), 1,
      sym_block_command,
    STATE(653), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(155), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7552] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(314), 1,
      sym_identifier,
    STATE(6), 1,
      sym_if_command,
    STATE(138), 1,
      sym_foreach_command,
    STATE(140), 1,
      sym_while_command,
    STATE(141), 1,
      sym_function_command,
    STATE(142), 1,
      sym_macro_command,
    STATE(143), 1,
      sym_block_command,
    STATE(646), 1,
      sym_body,
    ACTIONS(312), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(153), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7612] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endblock,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(325), 1,
      sym_identifier,
    STATE(6), 1,
      sym_if_command,
    STATE(138), 1,
      sym_foreach_command,
    STATE(140), 1,
      sym_while_command,
    STATE(141), 1,
      sym_function_command,
    STATE(142), 1,
      sym_macro_command,
    STATE(143), 1,
      sym_block_command,
    ACTIONS(322), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(123), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7672] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(306), 1,
      sym_identifier,
    STATE(11), 1,
      sym_if_command,
    STATE(126), 1,
      sym_block_command,
    STATE(131), 1,
      sym_macro_command,
    STATE(135), 1,
      sym_function_command,
    STATE(146), 1,
      sym_while_command,
    STATE(147), 1,
      sym_foreach_command,
    STATE(655), 1,
      sym_body,
    ACTIONS(304), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(129), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7732] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(8), 1,
      sym_if_command,
    STATE(114), 1,
      sym_foreach_command,
    STATE(115), 1,
      sym_while_command,
    STATE(116), 1,
      sym_function_command,
    STATE(117), 1,
      sym_macro_command,
    STATE(118), 1,
      sym_block_command,
    STATE(656), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(155), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7792] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(314), 1,
      sym_identifier,
    STATE(6), 1,
      sym_if_command,
    STATE(138), 1,
      sym_foreach_command,
    STATE(140), 1,
      sym_while_command,
    STATE(141), 1,
      sym_function_command,
    STATE(142), 1,
      sym_macro_command,
    STATE(143), 1,
      sym_block_command,
    STATE(672), 1,
      sym_body,
    ACTIONS(312), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(153), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7852] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endmacro,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(331), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(110), 1,
      sym_macro_command,
    STATE(124), 1,
      sym_while_command,
    STATE(125), 1,
      sym_function_command,
    STATE(137), 1,
      sym_block_command,
    STATE(145), 1,
      sym_foreach_command,
    ACTIONS(328), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7912] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(314), 1,
      sym_identifier,
    STATE(6), 1,
      sym_if_command,
    STATE(138), 1,
      sym_foreach_command,
    STATE(140), 1,
      sym_while_command,
    STATE(141), 1,
      sym_function_command,
    STATE(142), 1,
      sym_macro_command,
    STATE(143), 1,
      sym_block_command,
    STATE(662), 1,
      sym_body,
    ACTIONS(312), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(153), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7972] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endwhile,
    ACTIONS(306), 1,
      sym_identifier,
    STATE(11), 1,
      sym_if_command,
    STATE(126), 1,
      sym_block_command,
    STATE(131), 1,
      sym_macro_command,
    STATE(135), 1,
      sym_function_command,
    STATE(146), 1,
      sym_while_command,
    STATE(147), 1,
      sym_foreach_command,
    ACTIONS(334), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(120), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8032] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endmacro,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(110), 1,
      sym_macro_command,
    STATE(124), 1,
      sym_while_command,
    STATE(125), 1,
      sym_function_command,
    STATE(137), 1,
      sym_block_command,
    STATE(145), 1,
      sym_foreach_command,
    ACTIONS(336), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8092] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(110), 1,
      sym_macro_command,
    STATE(124), 1,
      sym_while_command,
    STATE(125), 1,
      sym_function_command,
    STATE(137), 1,
      sym_block_command,
    STATE(145), 1,
      sym_foreach_command,
    STATE(671), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8152] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(110), 1,
      sym_macro_command,
    STATE(124), 1,
      sym_while_command,
    STATE(125), 1,
      sym_function_command,
    STATE(137), 1,
      sym_block_command,
    STATE(145), 1,
      sym_foreach_command,
    STATE(661), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8212] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endfunction,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(341), 1,
      sym_identifier,
    STATE(8), 1,
      sym_if_command,
    STATE(114), 1,
      sym_foreach_command,
    STATE(115), 1,
      sym_while_command,
    STATE(116), 1,
      sym_function_command,
    STATE(117), 1,
      sym_macro_command,
    STATE(118), 1,
      sym_block_command,
    ACTIONS(338), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(133), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8272] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endforeach,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(347), 1,
      sym_identifier,
    STATE(2), 1,
      sym_if_command,
    STATE(121), 1,
      sym_function_command,
    STATE(128), 1,
      sym_block_command,
    STATE(132), 1,
      sym_macro_command,
    STATE(139), 1,
      sym_foreach_command,
    STATE(144), 1,
      sym_while_command,
    ACTIONS(344), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(134), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8332] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(8), 1,
      sym_if_command,
    STATE(114), 1,
      sym_foreach_command,
    STATE(115), 1,
      sym_while_command,
    STATE(116), 1,
      sym_function_command,
    STATE(117), 1,
      sym_macro_command,
    STATE(118), 1,
      sym_block_command,
    STATE(670), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(155), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8392] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(350), 1,
      ts_builtin_sym_end,
    ACTIONS(355), 1,
      sym_identifier,
    STATE(10), 1,
      sym_if_command,
    STATE(119), 1,
      sym_while_command,
    STATE(149), 1,
      sym_foreach_command,
    STATE(151), 1,
      sym_block_command,
    STATE(152), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_function_command,
    ACTIONS(352), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(136), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8452] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(314), 1,
      sym_identifier,
    STATE(6), 1,
      sym_if_command,
    STATE(138), 1,
      sym_foreach_command,
    STATE(140), 1,
      sym_while_command,
    STATE(141), 1,
      sym_function_command,
    STATE(142), 1,
      sym_macro_command,
    STATE(143), 1,
      sym_block_command,
    STATE(658), 1,
      sym_body,
    ACTIONS(312), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(153), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8512] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(310), 1,
      sym_identifier,
    STATE(2), 1,
      sym_if_command,
    STATE(121), 1,
      sym_function_command,
    STATE(128), 1,
      sym_block_command,
    STATE(132), 1,
      sym_macro_command,
    STATE(139), 1,
      sym_foreach_command,
    STATE(144), 1,
      sym_while_command,
    STATE(683), 1,
      sym_body,
    ACTIONS(308), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(148), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8572] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(310), 1,
      sym_identifier,
    STATE(2), 1,
      sym_if_command,
    STATE(121), 1,
      sym_function_command,
    STATE(128), 1,
      sym_block_command,
    STATE(132), 1,
      sym_macro_command,
    STATE(139), 1,
      sym_foreach_command,
    STATE(144), 1,
      sym_while_command,
    STATE(649), 1,
      sym_body,
    ACTIONS(308), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(148), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8632] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(306), 1,
      sym_identifier,
    STATE(11), 1,
      sym_if_command,
    STATE(126), 1,
      sym_block_command,
    STATE(131), 1,
      sym_macro_command,
    STATE(135), 1,
      sym_function_command,
    STATE(146), 1,
      sym_while_command,
    STATE(147), 1,
      sym_foreach_command,
    STATE(684), 1,
      sym_body,
    ACTIONS(304), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(129), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8692] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(8), 1,
      sym_if_command,
    STATE(114), 1,
      sym_foreach_command,
    STATE(115), 1,
      sym_while_command,
    STATE(116), 1,
      sym_function_command,
    STATE(117), 1,
      sym_macro_command,
    STATE(118), 1,
      sym_block_command,
    STATE(685), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(155), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8752] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(110), 1,
      sym_macro_command,
    STATE(124), 1,
      sym_while_command,
    STATE(125), 1,
      sym_function_command,
    STATE(137), 1,
      sym_block_command,
    STATE(145), 1,
      sym_foreach_command,
    STATE(686), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8812] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(314), 1,
      sym_identifier,
    STATE(6), 1,
      sym_if_command,
    STATE(138), 1,
      sym_foreach_command,
    STATE(140), 1,
      sym_while_command,
    STATE(141), 1,
      sym_function_command,
    STATE(142), 1,
      sym_macro_command,
    STATE(143), 1,
      sym_block_command,
    STATE(687), 1,
      sym_body,
    ACTIONS(312), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(153), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8872] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(306), 1,
      sym_identifier,
    STATE(11), 1,
      sym_if_command,
    STATE(126), 1,
      sym_block_command,
    STATE(131), 1,
      sym_macro_command,
    STATE(135), 1,
      sym_function_command,
    STATE(146), 1,
      sym_while_command,
    STATE(147), 1,
      sym_foreach_command,
    STATE(650), 1,
      sym_body,
    ACTIONS(304), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(129), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8932] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(310), 1,
      sym_identifier,
    STATE(2), 1,
      sym_if_command,
    STATE(121), 1,
      sym_function_command,
    STATE(128), 1,
      sym_block_command,
    STATE(132), 1,
      sym_macro_command,
    STATE(139), 1,
      sym_foreach_command,
    STATE(144), 1,
      sym_while_command,
    STATE(654), 1,
      sym_body,
    ACTIONS(308), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(148), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8992] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(306), 1,
      sym_identifier,
    STATE(11), 1,
      sym_if_command,
    STATE(126), 1,
      sym_block_command,
    STATE(131), 1,
      sym_macro_command,
    STATE(135), 1,
      sym_function_command,
    STATE(146), 1,
      sym_while_command,
    STATE(147), 1,
      sym_foreach_command,
    STATE(668), 1,
      sym_body,
    ACTIONS(304), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(129), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9052] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(310), 1,
      sym_identifier,
    STATE(2), 1,
      sym_if_command,
    STATE(121), 1,
      sym_function_command,
    STATE(128), 1,
      sym_block_command,
    STATE(132), 1,
      sym_macro_command,
    STATE(139), 1,
      sym_foreach_command,
    STATE(144), 1,
      sym_while_command,
    STATE(667), 1,
      sym_body,
    ACTIONS(308), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(148), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9112] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endforeach,
    ACTIONS(310), 1,
      sym_identifier,
    STATE(2), 1,
      sym_if_command,
    STATE(121), 1,
      sym_function_command,
    STATE(128), 1,
      sym_block_command,
    STATE(132), 1,
      sym_macro_command,
    STATE(139), 1,
      sym_foreach_command,
    STATE(144), 1,
      sym_while_command,
    ACTIONS(358), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(134), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9172] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(310), 1,
      sym_identifier,
    STATE(2), 1,
      sym_if_command,
    STATE(121), 1,
      sym_function_command,
    STATE(128), 1,
      sym_block_command,
    STATE(132), 1,
      sym_macro_command,
    STATE(139), 1,
      sym_foreach_command,
    STATE(144), 1,
      sym_while_command,
    STATE(651), 1,
      sym_body,
    ACTIONS(308), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(148), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9232] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(19), 1,
      sym_identifier,
    ACTIONS(360), 1,
      ts_builtin_sym_end,
    STATE(10), 1,
      sym_if_command,
    STATE(119), 1,
      sym_while_command,
    STATE(149), 1,
      sym_foreach_command,
    STATE(151), 1,
      sym_block_command,
    STATE(152), 1,
      sym_macro_command,
    STATE(154), 1,
      sym_function_command,
    ACTIONS(362), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(136), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9292] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(314), 1,
      sym_identifier,
    STATE(6), 1,
      sym_if_command,
    STATE(138), 1,
      sym_foreach_command,
    STATE(140), 1,
      sym_while_command,
    STATE(141), 1,
      sym_function_command,
    STATE(142), 1,
      sym_macro_command,
    STATE(143), 1,
      sym_block_command,
    STATE(663), 1,
      sym_body,
    ACTIONS(312), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(153), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9352] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(110), 1,
      sym_macro_command,
    STATE(124), 1,
      sym_while_command,
    STATE(125), 1,
      sym_function_command,
    STATE(137), 1,
      sym_block_command,
    STATE(145), 1,
      sym_foreach_command,
    STATE(660), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9412] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endblock,
    ACTIONS(314), 1,
      sym_identifier,
    STATE(6), 1,
      sym_if_command,
    STATE(138), 1,
      sym_foreach_command,
    STATE(140), 1,
      sym_while_command,
    STATE(141), 1,
      sym_function_command,
    STATE(142), 1,
      sym_macro_command,
    STATE(143), 1,
      sym_block_command,
    ACTIONS(364), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(123), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9472] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(8), 1,
      sym_if_command,
    STATE(114), 1,
      sym_foreach_command,
    STATE(115), 1,
      sym_while_command,
    STATE(116), 1,
      sym_function_command,
    STATE(117), 1,
      sym_macro_command,
    STATE(118), 1,
      sym_block_command,
    STATE(659), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(155), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9532] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endfunction,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(8), 1,
      sym_if_command,
    STATE(114), 1,
      sym_foreach_command,
    STATE(115), 1,
      sym_while_command,
    STATE(116), 1,
      sym_function_command,
    STATE(117), 1,
      sym_macro_command,
    STATE(118), 1,
      sym_block_command,
    ACTIONS(366), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(133), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9592] = 12,
    ACTIONS(370), 1,
      anon_sym_DOLLAR,
    ACTIONS(372), 1,
      anon_sym_GT,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(376), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(378), 1,
      sym_bracket_argument,
    STATE(621), 1,
      sym_argument,
    STATE(808), 1,
      sym__gen_exp_content,
    STATE(488), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(490), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(368), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(202), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9643] = 12,
    ACTIONS(382), 1,
      anon_sym_DOLLAR,
    ACTIONS(384), 1,
      anon_sym_GT,
    ACTIONS(386), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(390), 1,
      sym_bracket_argument,
    STATE(162), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(298), 1,
      sym_argument,
    STATE(291), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(297), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(292), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(380), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(195), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9694] = 12,
    ACTIONS(370), 1,
      anon_sym_DOLLAR,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(376), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(392), 1,
      anon_sym_GT,
    STATE(621), 1,
      sym_argument,
    STATE(840), 1,
      sym__gen_exp_content,
    STATE(488), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(490), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(368), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(202), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9745] = 12,
    ACTIONS(370), 1,
      anon_sym_DOLLAR,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(376), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(394), 1,
      anon_sym_GT,
    STATE(621), 1,
      sym_argument,
    STATE(778), 1,
      sym__gen_exp_content,
    STATE(488), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(490), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(368), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(202), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9796] = 12,
    ACTIONS(370), 1,
      anon_sym_DOLLAR,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(376), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(396), 1,
      anon_sym_GT,
    STATE(621), 1,
      sym_argument,
    STATE(733), 1,
      sym__gen_exp_content,
    STATE(488), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(490), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(368), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(202), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9847] = 12,
    ACTIONS(370), 1,
      anon_sym_DOLLAR,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(376), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(398), 1,
      anon_sym_GT,
    STATE(621), 1,
      sym_argument,
    STATE(806), 1,
      sym__gen_exp_content,
    STATE(488), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(490), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(368), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(202), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9898] = 12,
    ACTIONS(382), 1,
      anon_sym_DOLLAR,
    ACTIONS(386), 1,
      anon_sym_DQUOTE,
    ACTIONS(388), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(390), 1,
      sym_bracket_argument,
    ACTIONS(400), 1,
      anon_sym_GT,
    STATE(164), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(298), 1,
      sym_argument,
    STATE(291), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(297), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(292), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(380), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(195), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [9949] = 7,
    ACTIONS(45), 1,
      anon_sym_DOLLAR,
    ACTIONS(404), 1,
      aux_sym__unquoted_text_token1,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(43), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(165), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(402), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [9990] = 12,
    ACTIONS(409), 1,
      anon_sym_DOLLAR,
    ACTIONS(412), 1,
      anon_sym_GT,
    ACTIONS(414), 1,
      anon_sym_DQUOTE,
    ACTIONS(417), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(420), 1,
      sym_bracket_argument,
    STATE(164), 1,
      aux_sym__gen_exp_arguments_repeat1,
    STATE(298), 1,
      sym_argument,
    STATE(291), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(297), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(292), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(406), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(195), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10041] = 7,
    ACTIONS(426), 1,
      anon_sym_DOLLAR,
    ACTIONS(431), 1,
      aux_sym__unquoted_text_token1,
    STATE(241), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(246), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(423), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(165), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(429), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [10082] = 12,
    ACTIONS(370), 1,
      anon_sym_DOLLAR,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(376), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(434), 1,
      anon_sym_GT,
    STATE(621), 1,
      sym_argument,
    STATE(764), 1,
      sym__gen_exp_content,
    STATE(488), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(490), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(368), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(202), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10133] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(440), 1,
      anon_sym_RPAREN,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    STATE(746), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10181] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(444), 1,
      anon_sym_RPAREN,
    STATE(863), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10229] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(446), 1,
      anon_sym_RPAREN,
    STATE(728), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10277] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(448), 1,
      anon_sym_RPAREN,
    STATE(789), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10325] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(450), 1,
      anon_sym_RPAREN,
    STATE(782), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10373] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(452), 1,
      anon_sym_RPAREN,
    STATE(692), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10421] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(454), 1,
      anon_sym_RPAREN,
    STATE(831), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10469] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(456), 1,
      anon_sym_RPAREN,
    STATE(838), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10517] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(458), 1,
      anon_sym_RPAREN,
    STATE(705), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10565] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(460), 1,
      anon_sym_RPAREN,
    STATE(762), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10613] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(462), 1,
      anon_sym_RPAREN,
    STATE(804), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10661] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(464), 1,
      anon_sym_RPAREN,
    STATE(714), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10709] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(466), 1,
      anon_sym_RPAREN,
    STATE(690), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10757] = 11,
    ACTIONS(374), 1,
      anon_sym_DQUOTE,
    ACTIONS(378), 1,
      sym_bracket_argument,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(442), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(468), 1,
      anon_sym_RPAREN,
    STATE(822), 1,
      sym_argument,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(534), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(203), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10805] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(794), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10850] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(771), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10895] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(842), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10940] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(775), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [10985] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(729), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11030] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(730), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11075] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(747), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11120] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(819), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11165] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(748), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11210] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(770), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11255] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(818), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11300] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(795), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11345] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(749), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11390] = 10,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(478), 1,
      sym_bracket_argument,
    STATE(843), 1,
      sym_argument,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(825), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(204), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11435] = 8,
    ACTIONS(382), 1,
      anon_sym_DOLLAR,
    ACTIONS(480), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(482), 1,
      aux_sym__unquoted_text_token1,
    STATE(291), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(402), 3,
      sym_bracket_argument,
      anon_sym_GT,
      anon_sym_DQUOTE,
    STATE(292), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(380), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(196), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11475] = 8,
    ACTIONS(487), 1,
      anon_sym_DOLLAR,
    ACTIONS(490), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(492), 1,
      aux_sym__unquoted_text_token1,
    STATE(291), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(429), 3,
      sym_bracket_argument,
      anon_sym_GT,
      anon_sym_DQUOTE,
    STATE(292), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(484), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(196), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11515] = 8,
    ACTIONS(497), 1,
      anon_sym_DOLLAR,
    ACTIONS(499), 1,
      anon_sym_DQUOTE,
    ACTIONS(501), 1,
      aux_sym__quoted_text_token1,
    STATE(774), 1,
      sym_quoted_element,
    STATE(520), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(515), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(495), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [11553] = 8,
    ACTIONS(497), 1,
      anon_sym_DOLLAR,
    ACTIONS(501), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(503), 1,
      anon_sym_DQUOTE,
    STATE(735), 1,
      sym_quoted_element,
    STATE(520), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(515), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(495), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [11591] = 8,
    ACTIONS(497), 1,
      anon_sym_DOLLAR,
    ACTIONS(501), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(505), 1,
      anon_sym_DQUOTE,
    STATE(812), 1,
      sym_quoted_element,
    STATE(520), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(515), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(495), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [11629] = 7,
    ACTIONS(510), 1,
      anon_sym_DOLLAR,
    ACTIONS(513), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 2,
      anon_sym_GT,
      anon_sym_COLON,
    STATE(488), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(490), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(507), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(200), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11665] = 8,
    ACTIONS(497), 1,
      anon_sym_DOLLAR,
    ACTIONS(501), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(516), 1,
      anon_sym_DQUOTE,
    STATE(854), 1,
      sym_quoted_element,
    STATE(520), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(515), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(495), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(205), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [11703] = 7,
    ACTIONS(370), 1,
      anon_sym_DOLLAR,
    ACTIONS(518), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(402), 2,
      anon_sym_GT,
      anon_sym_COLON,
    STATE(488), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(490), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(368), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(200), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11739] = 7,
    ACTIONS(402), 1,
      anon_sym_RPAREN,
    ACTIONS(438), 1,
      anon_sym_DOLLAR,
    ACTIONS(520), 1,
      aux_sym__unquoted_text_token1,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(436), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(206), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11774] = 7,
    ACTIONS(472), 1,
      anon_sym_DOLLAR,
    ACTIONS(480), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(522), 1,
      aux_sym__unquoted_text_token1,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(470), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(207), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11809] = 7,
    ACTIONS(497), 1,
      anon_sym_DOLLAR,
    ACTIONS(524), 1,
      anon_sym_DQUOTE,
    ACTIONS(526), 1,
      aux_sym__quoted_text_token1,
    STATE(520), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(515), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(495), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(208), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [11844] = 7,
    ACTIONS(429), 1,
      anon_sym_RPAREN,
    ACTIONS(531), 1,
      anon_sym_DOLLAR,
    ACTIONS(534), 1,
      aux_sym__unquoted_text_token1,
    STATE(503), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(502), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(528), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(206), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11879] = 7,
    ACTIONS(490), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(540), 1,
      anon_sym_DOLLAR,
    ACTIONS(543), 1,
      aux_sym__unquoted_text_token1,
    STATE(505), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(507), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(537), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(207), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
  [11914] = 7,
    ACTIONS(549), 1,
      anon_sym_DOLLAR,
    ACTIONS(552), 1,
      anon_sym_DQUOTE,
    ACTIONS(554), 1,
      aux_sym__quoted_text_token1,
    STATE(520), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(515), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(546), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    STATE(208), 6,
      sym_escape_sequence,
      sym_variable_ref,
      sym_gen_exp,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
  [11949] = 6,
    ACTIONS(559), 1,
      anon_sym_LBRACE,
    ACTIONS(561), 1,
      anon_sym_ENV,
    ACTIONS(563), 1,
      anon_sym_CACHE,
    ACTIONS(565), 1,
      anon_sym_LT,
    ACTIONS(567), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(557), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11981] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(810), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12013] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(790), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12045] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(698), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12077] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(807), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12109] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(866), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12141] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(791), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12173] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(768), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12205] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(737), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12237] = 7,
    ACTIONS(578), 1,
      aux_sym_variable_token1,
    ACTIONS(581), 1,
      anon_sym_DOLLAR,
    ACTIONS(584), 1,
      anon_sym_RBRACE,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(218), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(575), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12269] = 7,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    ACTIONS(586), 1,
      aux_sym_variable_token1,
    ACTIONS(588), 1,
      anon_sym_RBRACE,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(218), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12301] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(867), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12333] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(755), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12365] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(743), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12397] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(832), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12429] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(765), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12461] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(740), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12493] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(841), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12525] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(756), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12557] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(833), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12589] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(713), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12621] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(712), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12653] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(703), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12685] = 7,
    ACTIONS(571), 1,
      aux_sym_variable_token1,
    ACTIONS(573), 1,
      anon_sym_DOLLAR,
    STATE(779), 1,
      sym_variable,
    STATE(499), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(219), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(498), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(569), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [12717] = 4,
    ACTIONS(592), 1,
      anon_sym_DOLLAR,
    ACTIONS(595), 1,
      aux_sym__unquoted_text_token1,
    STATE(233), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(590), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12742] = 6,
    ACTIONS(598), 1,
      anon_sym_LBRACE,
    ACTIONS(600), 1,
      anon_sym_ENV,
    ACTIONS(602), 1,
      anon_sym_CACHE,
    ACTIONS(604), 1,
      anon_sym_LT,
    ACTIONS(567), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(557), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [12771] = 2,
    ACTIONS(608), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(606), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12791] = 2,
    ACTIONS(612), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(610), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12811] = 2,
    ACTIONS(616), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(614), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12831] = 2,
    ACTIONS(620), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(618), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12851] = 2,
    ACTIONS(624), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(622), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12871] = 2,
    ACTIONS(628), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(626), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12891] = 2,
    ACTIONS(632), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(630), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12911] = 2,
    ACTIONS(636), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(634), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12931] = 2,
    ACTIONS(640), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(638), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12951] = 2,
    ACTIONS(644), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(642), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12971] = 2,
    ACTIONS(648), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(646), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [12991] = 2,
    ACTIONS(652), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(650), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [13011] = 6,
    ACTIONS(567), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(654), 1,
      anon_sym_LBRACE,
    ACTIONS(656), 1,
      anon_sym_ENV,
    ACTIONS(658), 1,
      anon_sym_CACHE,
    ACTIONS(660), 1,
      anon_sym_LT,
    ACTIONS(557), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [13038] = 2,
    ACTIONS(662), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(664), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13056] = 2,
    ACTIONS(666), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(668), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13074] = 2,
    ACTIONS(670), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(672), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13092] = 2,
    ACTIONS(674), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(676), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13110] = 2,
    ACTIONS(678), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(680), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13128] = 2,
    ACTIONS(682), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(684), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13146] = 6,
    ACTIONS(688), 1,
      anon_sym_LBRACE,
    ACTIONS(690), 1,
      anon_sym_ENV,
    ACTIONS(692), 1,
      anon_sym_CACHE,
    ACTIONS(694), 1,
      anon_sym_LT,
    ACTIONS(696), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(686), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [13172] = 2,
    ACTIONS(698), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(700), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13190] = 6,
    ACTIONS(567), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(702), 1,
      anon_sym_LBRACE,
    ACTIONS(704), 1,
      anon_sym_ENV,
    ACTIONS(706), 1,
      anon_sym_CACHE,
    ACTIONS(708), 1,
      anon_sym_LT,
    ACTIONS(557), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [13216] = 2,
    ACTIONS(710), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(712), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13234] = 2,
    ACTIONS(714), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(716), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13252] = 2,
    ACTIONS(718), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(720), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13270] = 2,
    ACTIONS(722), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(724), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13288] = 2,
    ACTIONS(726), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(728), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13306] = 2,
    ACTIONS(730), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(732), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13324] = 2,
    ACTIONS(734), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(736), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13342] = 2,
    ACTIONS(738), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(740), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13360] = 2,
    ACTIONS(742), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(744), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13378] = 2,
    ACTIONS(746), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(748), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13396] = 2,
    ACTIONS(750), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(752), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13414] = 2,
    ACTIONS(754), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(756), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13432] = 2,
    ACTIONS(758), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(760), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13450] = 2,
    ACTIONS(762), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(764), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13468] = 2,
    ACTIONS(766), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(768), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13486] = 2,
    ACTIONS(770), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(772), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13504] = 2,
    ACTIONS(774), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(776), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13522] = 2,
    ACTIONS(778), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(780), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13540] = 2,
    ACTIONS(782), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(784), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13558] = 2,
    ACTIONS(786), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(788), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13576] = 2,
    ACTIONS(790), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(792), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13594] = 2,
    ACTIONS(794), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(796), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13612] = 2,
    ACTIONS(798), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(800), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13630] = 2,
    ACTIONS(802), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(804), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13648] = 2,
    ACTIONS(806), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(808), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13666] = 2,
    ACTIONS(810), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(812), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13684] = 5,
    ACTIONS(814), 1,
      anon_sym_DOLLAR,
    ACTIONS(817), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(819), 1,
      aux_sym__unquoted_text_token1,
    STATE(283), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(590), 9,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13708] = 2,
    ACTIONS(822), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(824), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13726] = 6,
    ACTIONS(826), 1,
      anon_sym_LBRACE,
    ACTIONS(828), 1,
      anon_sym_ENV,
    ACTIONS(830), 1,
      anon_sym_CACHE,
    ACTIONS(832), 1,
      anon_sym_LT,
    ACTIONS(567), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(557), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [13752] = 2,
    ACTIONS(834), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(836), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13770] = 2,
    ACTIONS(838), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(840), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13788] = 2,
    ACTIONS(636), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(634), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13805] = 2,
    ACTIONS(608), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(606), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13822] = 2,
    ACTIONS(624), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(622), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13839] = 2,
    ACTIONS(632), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(630), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13856] = 2,
    ACTIONS(652), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(650), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13873] = 2,
    ACTIONS(648), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(646), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13890] = 2,
    ACTIONS(612), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(610), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13907] = 2,
    ACTIONS(644), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(642), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13924] = 2,
    ACTIONS(616), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(614), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13941] = 2,
    ACTIONS(628), 2,
      aux_sym__gen_exp_arguments_token1,
      aux_sym__unquoted_text_token1,
    ACTIONS(626), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13958] = 3,
    ACTIONS(844), 1,
      aux_sym__gen_exp_arguments_token1,
    ACTIONS(846), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(842), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [13977] = 2,
    ACTIONS(770), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(772), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [13993] = 2,
    ACTIONS(726), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(728), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14009] = 2,
    ACTIONS(726), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(728), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14025] = 2,
    ACTIONS(722), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(724), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14041] = 2,
    ACTIONS(718), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(720), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14057] = 2,
    ACTIONS(698), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(700), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14073] = 4,
    ACTIONS(848), 1,
      anon_sym_DOLLAR,
    ACTIONS(851), 1,
      aux_sym__unquoted_text_token1,
    STATE(305), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(590), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_GT,
      anon_sym_COLON,
  [14093] = 2,
    ACTIONS(714), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(716), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14109] = 2,
    ACTIONS(774), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(776), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14125] = 2,
    ACTIONS(670), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(672), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14141] = 2,
    ACTIONS(674), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(676), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14157] = 2,
    ACTIONS(678), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(680), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14173] = 2,
    ACTIONS(682), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(684), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14189] = 2,
    ACTIONS(750), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(752), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14205] = 2,
    ACTIONS(682), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(684), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14221] = 2,
    ACTIONS(854), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(412), 10,
      sym_bracket_argument,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_DQUOTE,
  [14237] = 2,
    ACTIONS(698), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(700), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14253] = 2,
    ACTIONS(786), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(788), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14269] = 2,
    ACTIONS(798), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(800), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14285] = 2,
    ACTIONS(802), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(804), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14301] = 2,
    ACTIONS(810), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(812), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14317] = 2,
    ACTIONS(838), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(840), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14333] = 2,
    ACTIONS(834), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(836), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14349] = 2,
    ACTIONS(678), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(680), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14365] = 2,
    ACTIONS(794), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(796), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14381] = 2,
    ACTIONS(778), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(780), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14397] = 2,
    ACTIONS(670), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(672), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14413] = 2,
    ACTIONS(770), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(772), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14429] = 2,
    ACTIONS(766), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(768), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14445] = 2,
    ACTIONS(762), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(764), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14461] = 2,
    ACTIONS(758), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(760), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14477] = 2,
    ACTIONS(754), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(756), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14493] = 2,
    ACTIONS(662), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(664), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14509] = 2,
    ACTIONS(746), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(748), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14525] = 2,
    ACTIONS(774), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(776), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14541] = 2,
    ACTIONS(750), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(752), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14557] = 2,
    ACTIONS(738), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(740), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14573] = 2,
    ACTIONS(734), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(736), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14589] = 2,
    ACTIONS(730), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(732), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14605] = 2,
    ACTIONS(726), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(728), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14621] = 2,
    ACTIONS(722), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(724), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14637] = 2,
    ACTIONS(718), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(720), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14653] = 2,
    ACTIONS(786), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(788), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14669] = 2,
    ACTIONS(798), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(800), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14685] = 2,
    ACTIONS(714), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(716), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14701] = 2,
    ACTIONS(774), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(776), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14717] = 2,
    ACTIONS(670), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(672), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14733] = 2,
    ACTIONS(674), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(676), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14749] = 2,
    ACTIONS(678), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(680), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14765] = 2,
    ACTIONS(682), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(684), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14781] = 2,
    ACTIONS(750), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(752), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14797] = 2,
    ACTIONS(714), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(716), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14813] = 2,
    ACTIONS(718), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(720), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14829] = 2,
    ACTIONS(698), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(700), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14845] = 2,
    ACTIONS(786), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(788), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14861] = 2,
    ACTIONS(798), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(800), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14877] = 2,
    ACTIONS(802), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(804), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14893] = 2,
    ACTIONS(810), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(812), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14909] = 2,
    ACTIONS(838), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(840), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14925] = 2,
    ACTIONS(834), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(836), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14941] = 2,
    ACTIONS(794), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(796), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14957] = 2,
    ACTIONS(778), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(780), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14973] = 2,
    ACTIONS(750), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(752), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14989] = 2,
    ACTIONS(770), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(772), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15005] = 2,
    ACTIONS(766), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(768), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15021] = 2,
    ACTIONS(762), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(764), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15037] = 2,
    ACTIONS(758), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(760), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15053] = 2,
    ACTIONS(754), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(756), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15069] = 2,
    ACTIONS(662), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(664), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15085] = 2,
    ACTIONS(746), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(748), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15101] = 2,
    ACTIONS(722), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(724), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15117] = 2,
    ACTIONS(726), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(728), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15133] = 2,
    ACTIONS(738), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(740), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15149] = 2,
    ACTIONS(734), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(736), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15165] = 2,
    ACTIONS(730), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(732), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15181] = 2,
    ACTIONS(726), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(728), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15197] = 2,
    ACTIONS(722), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(724), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15213] = 2,
    ACTIONS(718), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(720), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15229] = 2,
    ACTIONS(730), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(732), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15245] = 2,
    ACTIONS(802), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(804), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15261] = 2,
    ACTIONS(714), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(716), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15277] = 2,
    ACTIONS(774), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(776), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15293] = 2,
    ACTIONS(670), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(672), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15309] = 2,
    ACTIONS(674), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(676), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15325] = 2,
    ACTIONS(678), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(680), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15341] = 2,
    ACTIONS(682), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(684), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [15357] = 2,
    ACTIONS(750), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(752), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15373] = 2,
    ACTIONS(810), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(812), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15389] = 2,
    ACTIONS(838), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(840), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15405] = 2,
    ACTIONS(698), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(700), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15421] = 2,
    ACTIONS(786), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(788), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15437] = 2,
    ACTIONS(798), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(800), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15453] = 2,
    ACTIONS(802), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(804), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15469] = 2,
    ACTIONS(810), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(812), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15485] = 2,
    ACTIONS(838), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(840), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15501] = 2,
    ACTIONS(834), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(836), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15517] = 2,
    ACTIONS(794), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(796), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15533] = 2,
    ACTIONS(778), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(780), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15549] = 2,
    ACTIONS(798), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(800), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15565] = 2,
    ACTIONS(770), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(772), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15581] = 2,
    ACTIONS(766), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(768), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15597] = 2,
    ACTIONS(762), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(764), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15613] = 2,
    ACTIONS(758), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(760), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15629] = 2,
    ACTIONS(754), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(756), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15645] = 2,
    ACTIONS(662), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(664), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15661] = 2,
    ACTIONS(746), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(748), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15677] = 2,
    ACTIONS(734), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(736), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15693] = 2,
    ACTIONS(734), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(736), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15709] = 2,
    ACTIONS(738), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(740), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15725] = 2,
    ACTIONS(734), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(736), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15741] = 2,
    ACTIONS(730), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(732), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15757] = 2,
    ACTIONS(674), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(676), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15773] = 2,
    ACTIONS(722), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(724), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15789] = 2,
    ACTIONS(718), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(720), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15805] = 2,
    ACTIONS(730), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(732), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15821] = 2,
    ACTIONS(738), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(740), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15837] = 2,
    ACTIONS(714), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(716), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15853] = 2,
    ACTIONS(774), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(776), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15869] = 2,
    ACTIONS(670), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(672), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15885] = 2,
    ACTIONS(674), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(676), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15901] = 2,
    ACTIONS(678), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(680), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15917] = 2,
    ACTIONS(682), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(684), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [15933] = 2,
    ACTIONS(750), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(752), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [15949] = 2,
    ACTIONS(738), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(740), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15965] = 2,
    ACTIONS(758), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(760), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15981] = 2,
    ACTIONS(746), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(748), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15997] = 2,
    ACTIONS(698), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(700), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16013] = 2,
    ACTIONS(786), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(788), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16029] = 2,
    ACTIONS(798), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(800), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16045] = 2,
    ACTIONS(802), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(804), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16061] = 2,
    ACTIONS(810), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(812), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16077] = 2,
    ACTIONS(838), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(840), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16093] = 2,
    ACTIONS(834), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(836), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16109] = 2,
    ACTIONS(794), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(796), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16125] = 2,
    ACTIONS(778), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(780), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16141] = 2,
    ACTIONS(746), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(748), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16157] = 2,
    ACTIONS(766), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(768), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16173] = 2,
    ACTIONS(762), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(764), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16189] = 2,
    ACTIONS(758), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(760), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16205] = 2,
    ACTIONS(754), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(756), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16221] = 2,
    ACTIONS(662), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(664), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16237] = 2,
    ACTIONS(746), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(748), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16253] = 2,
    ACTIONS(662), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(664), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16269] = 2,
    ACTIONS(738), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(740), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16285] = 2,
    ACTIONS(734), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(736), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16301] = 2,
    ACTIONS(730), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(732), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16317] = 2,
    ACTIONS(726), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(728), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16333] = 2,
    ACTIONS(722), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(724), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16349] = 2,
    ACTIONS(718), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(720), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16365] = 2,
    ACTIONS(754), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(756), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16381] = 2,
    ACTIONS(758), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(760), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16397] = 2,
    ACTIONS(714), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(716), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16413] = 2,
    ACTIONS(774), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(776), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16429] = 2,
    ACTIONS(670), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(672), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16445] = 2,
    ACTIONS(674), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(676), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16461] = 2,
    ACTIONS(678), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(680), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16477] = 2,
    ACTIONS(682), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(684), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [16493] = 2,
    ACTIONS(762), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(764), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16509] = 2,
    ACTIONS(766), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(768), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16525] = 2,
    ACTIONS(770), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(772), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16541] = 2,
    ACTIONS(786), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(788), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16557] = 2,
    ACTIONS(662), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(664), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16573] = 2,
    ACTIONS(698), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(700), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16589] = 2,
    ACTIONS(770), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(772), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16605] = 2,
    ACTIONS(834), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(836), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16621] = 2,
    ACTIONS(778), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(780), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16637] = 2,
    ACTIONS(766), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(768), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16653] = 2,
    ACTIONS(802), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(804), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16669] = 2,
    ACTIONS(778), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(780), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16685] = 2,
    ACTIONS(794), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(796), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16701] = 2,
    ACTIONS(754), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(756), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16717] = 2,
    ACTIONS(762), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(764), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16733] = 2,
    ACTIONS(810), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(812), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16749] = 2,
    ACTIONS(838), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(840), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16765] = 2,
    ACTIONS(794), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(796), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16781] = 2,
    ACTIONS(834), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(836), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16797] = 2,
    ACTIONS(856), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(858), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16812] = 4,
    ACTIONS(860), 1,
      anon_sym_DOLLAR,
    ACTIONS(863), 1,
      aux_sym__unquoted_text_token1,
    STATE(476), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(590), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_RPAREN,
  [16831] = 2,
    ACTIONS(866), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(868), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16846] = 2,
    ACTIONS(870), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(872), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16861] = 4,
    ACTIONS(876), 1,
      anon_sym_DOLLAR,
    ACTIONS(879), 1,
      aux_sym__quoted_text_token1,
    STATE(479), 1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(874), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DQUOTE,
  [16880] = 2,
    ACTIONS(882), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(884), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16895] = 2,
    ACTIONS(886), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(888), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16910] = 2,
    ACTIONS(636), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(634), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [16925] = 2,
    ACTIONS(890), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(892), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16940] = 2,
    ACTIONS(894), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(896), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16955] = 2,
    ACTIONS(898), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(900), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16970] = 2,
    ACTIONS(902), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(904), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [16985] = 2,
    ACTIONS(906), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(908), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [17000] = 2,
    ACTIONS(632), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(630), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17015] = 2,
    ACTIONS(608), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(606), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17030] = 2,
    ACTIONS(652), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(650), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17045] = 5,
    ACTIONS(817), 1,
      aux_sym_endwhile_command_token1,
    ACTIONS(910), 1,
      anon_sym_DOLLAR,
    ACTIONS(913), 1,
      aux_sym__unquoted_text_token1,
    STATE(491), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(590), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [17066] = 2,
    ACTIONS(648), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(646), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17081] = 2,
    ACTIONS(612), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(610), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17096] = 2,
    ACTIONS(616), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(614), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_GT,
      anon_sym_COLON,
  [17111] = 2,
    ACTIONS(608), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(606), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [17125] = 2,
    ACTIONS(616), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(614), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17139] = 2,
    ACTIONS(612), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(610), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17153] = 1,
    ACTIONS(650), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17165] = 1,
    ACTIONS(630), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17177] = 2,
    ACTIONS(648), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(646), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17191] = 2,
    ACTIONS(636), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(634), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [17205] = 2,
    ACTIONS(652), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(650), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17219] = 2,
    ACTIONS(632), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(630), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17233] = 1,
    ACTIONS(646), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17245] = 2,
    ACTIONS(632), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(630), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [17259] = 2,
    ACTIONS(608), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(606), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17273] = 2,
    ACTIONS(652), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(650), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [17287] = 2,
    ACTIONS(616), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(614), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17301] = 2,
    ACTIONS(612), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(610), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17315] = 2,
    ACTIONS(608), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(606), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17329] = 2,
    ACTIONS(636), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(634), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [17343] = 2,
    ACTIONS(648), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(646), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [17357] = 2,
    ACTIONS(612), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(610), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [17371] = 2,
    ACTIONS(648), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(646), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17385] = 2,
    ACTIONS(652), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(650), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17399] = 2,
    ACTIONS(616), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(614), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [17413] = 2,
    ACTIONS(636), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(634), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17427] = 1,
    ACTIONS(614), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17439] = 1,
    ACTIONS(610), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [17451] = 2,
    ACTIONS(632), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(630), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [17465] = 3,
    ACTIONS(916), 1,
      anon_sym_LPAREN,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17475] = 3,
    ACTIONS(920), 1,
      anon_sym_LPAREN,
    ACTIONS(922), 1,
      aux_sym_if_command_token1,
    STATE(560), 1,
      aux_sym_if_command_repeat1,
  [17485] = 3,
    ACTIONS(924), 1,
      anon_sym_LPAREN,
    ACTIONS(926), 1,
      aux_sym_if_command_token1,
    STATE(557), 1,
      aux_sym_if_command_repeat1,
  [17495] = 1,
    ACTIONS(622), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [17501] = 3,
    ACTIONS(928), 1,
      anon_sym_LPAREN,
    ACTIONS(930), 1,
      aux_sym_if_command_token1,
    STATE(556), 1,
      aux_sym_if_command_repeat1,
  [17511] = 1,
    ACTIONS(642), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [17517] = 3,
    ACTIONS(932), 1,
      anon_sym_LPAREN,
    ACTIONS(934), 1,
      aux_sym_if_command_token1,
    STATE(553), 1,
      aux_sym_if_command_repeat1,
  [17527] = 3,
    ACTIONS(936), 1,
      anon_sym_LPAREN,
    ACTIONS(938), 1,
      aux_sym_if_command_token1,
    STATE(551), 1,
      aux_sym_if_command_repeat1,
  [17537] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(940), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17547] = 3,
    ACTIONS(942), 1,
      anon_sym_LPAREN,
    ACTIONS(944), 1,
      aux_sym_if_command_token1,
    STATE(529), 1,
      aux_sym_if_command_repeat1,
  [17557] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(946), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17567] = 3,
    ACTIONS(948), 1,
      anon_sym_LPAREN,
    ACTIONS(950), 1,
      aux_sym_if_command_token1,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17577] = 3,
    ACTIONS(953), 1,
      anon_sym_LPAREN,
    ACTIONS(955), 1,
      aux_sym_if_command_token1,
    STATE(531), 1,
      aux_sym_if_command_repeat1,
  [17587] = 1,
    ACTIONS(626), 3,
      anon_sym_GT,
      anon_sym_COLON,
      anon_sym_RPAREN,
  [17593] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(957), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17603] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(959), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17613] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17623] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(963), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17633] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(965), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17643] = 3,
    ACTIONS(967), 1,
      anon_sym_LPAREN,
    ACTIONS(969), 1,
      aux_sym_if_command_token1,
    STATE(535), 1,
      aux_sym_if_command_repeat1,
  [17653] = 3,
    ACTIONS(971), 1,
      anon_sym_LPAREN,
    ACTIONS(973), 1,
      aux_sym_if_command_token1,
    STATE(536), 1,
      aux_sym_if_command_repeat1,
  [17663] = 3,
    ACTIONS(975), 1,
      anon_sym_LPAREN,
    ACTIONS(977), 1,
      aux_sym_if_command_token1,
    STATE(537), 1,
      aux_sym_if_command_repeat1,
  [17673] = 3,
    ACTIONS(979), 1,
      anon_sym_LPAREN,
    ACTIONS(981), 1,
      aux_sym_if_command_token1,
    STATE(538), 1,
      aux_sym_if_command_repeat1,
  [17683] = 3,
    ACTIONS(983), 1,
      anon_sym_LPAREN,
    ACTIONS(985), 1,
      aux_sym_if_command_token1,
    STATE(539), 1,
      aux_sym_if_command_repeat1,
  [17693] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(987), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17703] = 3,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      aux_sym_if_command_token1,
    STATE(545), 1,
      aux_sym_if_command_repeat1,
  [17713] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(993), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17723] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(995), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17733] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(997), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17743] = 3,
    ACTIONS(999), 1,
      anon_sym_LPAREN,
    ACTIONS(1001), 1,
      aux_sym_if_command_token1,
    STATE(631), 1,
      aux_sym_if_command_repeat1,
  [17753] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1003), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17763] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1005), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17773] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1007), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17783] = 3,
    ACTIONS(1009), 1,
      anon_sym_LPAREN,
    ACTIONS(1011), 1,
      aux_sym_if_command_token1,
    STATE(547), 1,
      aux_sym_if_command_repeat1,
  [17793] = 3,
    ACTIONS(1013), 1,
      anon_sym_LPAREN,
    ACTIONS(1015), 1,
      aux_sym_if_command_token1,
    STATE(629), 1,
      aux_sym_if_command_repeat1,
  [17803] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1017), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17813] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1019), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17823] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1021), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17833] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1023), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17843] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1025), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17853] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1027), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17863] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1029), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17873] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1031), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17883] = 3,
    ACTIONS(1033), 1,
      anon_sym_LPAREN,
    ACTIONS(1035), 1,
      aux_sym_if_command_token1,
    STATE(626), 1,
      aux_sym_if_command_repeat1,
  [17893] = 3,
    ACTIONS(1037), 1,
      anon_sym_LPAREN,
    ACTIONS(1039), 1,
      aux_sym_if_command_token1,
    STATE(558), 1,
      aux_sym_if_command_repeat1,
  [17903] = 3,
    ACTIONS(1041), 1,
      anon_sym_LPAREN,
    ACTIONS(1043), 1,
      aux_sym_if_command_token1,
    STATE(576), 1,
      aux_sym_if_command_repeat1,
  [17913] = 3,
    ACTIONS(1045), 1,
      anon_sym_LPAREN,
    ACTIONS(1047), 1,
      aux_sym_if_command_token1,
    STATE(559), 1,
      aux_sym_if_command_repeat1,
  [17923] = 3,
    ACTIONS(1049), 1,
      anon_sym_LPAREN,
    ACTIONS(1051), 1,
      aux_sym_if_command_token1,
    STATE(561), 1,
      aux_sym_if_command_repeat1,
  [17933] = 3,
    ACTIONS(1053), 1,
      anon_sym_LPAREN,
    ACTIONS(1055), 1,
      aux_sym_if_command_token1,
    STATE(562), 1,
      aux_sym_if_command_repeat1,
  [17943] = 3,
    ACTIONS(1057), 1,
      anon_sym_LPAREN,
    ACTIONS(1059), 1,
      aux_sym_if_command_token1,
    STATE(563), 1,
      aux_sym_if_command_repeat1,
  [17953] = 3,
    ACTIONS(1061), 1,
      anon_sym_LPAREN,
    ACTIONS(1063), 1,
      aux_sym_if_command_token1,
    STATE(552), 1,
      aux_sym_if_command_repeat1,
  [17963] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1065), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [17973] = 3,
    ACTIONS(1067), 1,
      anon_sym_LPAREN,
    ACTIONS(1069), 1,
      aux_sym_if_command_token1,
    STATE(549), 1,
      aux_sym_if_command_repeat1,
  [17983] = 3,
    ACTIONS(1071), 1,
      anon_sym_LPAREN,
    ACTIONS(1073), 1,
      aux_sym_if_command_token1,
    STATE(572), 1,
      aux_sym_if_command_repeat1,
  [17993] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1075), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18003] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1077), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18013] = 3,
    ACTIONS(1079), 1,
      anon_sym_LPAREN,
    ACTIONS(1081), 1,
      aux_sym_if_command_token1,
    STATE(622), 1,
      aux_sym_if_command_repeat1,
  [18023] = 3,
    ACTIONS(1083), 1,
      anon_sym_LPAREN,
    ACTIONS(1085), 1,
      aux_sym_if_command_token1,
    STATE(580), 1,
      aux_sym_if_command_repeat1,
  [18033] = 3,
    ACTIONS(1087), 1,
      anon_sym_LPAREN,
    ACTIONS(1089), 1,
      aux_sym_if_command_token1,
    STATE(620), 1,
      aux_sym_if_command_repeat1,
  [18043] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1091), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18053] = 3,
    ACTIONS(1093), 1,
      anon_sym_LPAREN,
    ACTIONS(1095), 1,
      aux_sym_if_command_token1,
    STATE(575), 1,
      aux_sym_if_command_repeat1,
  [18063] = 3,
    ACTIONS(1097), 1,
      anon_sym_LPAREN,
    ACTIONS(1099), 1,
      aux_sym_if_command_token1,
    STATE(638), 1,
      aux_sym_if_command_repeat1,
  [18073] = 3,
    ACTIONS(1101), 1,
      anon_sym_LPAREN,
    ACTIONS(1103), 1,
      aux_sym_if_command_token1,
    STATE(632), 1,
      aux_sym_if_command_repeat1,
  [18083] = 3,
    ACTIONS(1105), 1,
      anon_sym_LPAREN,
    ACTIONS(1107), 1,
      aux_sym_if_command_token1,
    STATE(604), 1,
      aux_sym_if_command_repeat1,
  [18093] = 3,
    ACTIONS(1109), 1,
      anon_sym_LPAREN,
    ACTIONS(1111), 1,
      aux_sym_if_command_token1,
    STATE(609), 1,
      aux_sym_if_command_repeat1,
  [18103] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1113), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18113] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1115), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18123] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1117), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18133] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1119), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18143] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1121), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18153] = 3,
    ACTIONS(1123), 1,
      anon_sym_LPAREN,
    ACTIONS(1125), 1,
      aux_sym_if_command_token1,
    STATE(616), 1,
      aux_sym_if_command_repeat1,
  [18163] = 3,
    ACTIONS(1127), 1,
      anon_sym_LPAREN,
    ACTIONS(1129), 1,
      aux_sym_if_command_token1,
    STATE(586), 1,
      aux_sym_if_command_repeat1,
  [18173] = 3,
    ACTIONS(1131), 1,
      anon_sym_LPAREN,
    ACTIONS(1133), 1,
      aux_sym_if_command_token1,
    STATE(587), 1,
      aux_sym_if_command_repeat1,
  [18183] = 3,
    ACTIONS(1135), 1,
      anon_sym_LPAREN,
    ACTIONS(1137), 1,
      aux_sym_if_command_token1,
    STATE(588), 1,
      aux_sym_if_command_repeat1,
  [18193] = 3,
    ACTIONS(1139), 1,
      anon_sym_LPAREN,
    ACTIONS(1141), 1,
      aux_sym_if_command_token1,
    STATE(589), 1,
      aux_sym_if_command_repeat1,
  [18203] = 3,
    ACTIONS(1143), 1,
      anon_sym_LPAREN,
    ACTIONS(1145), 1,
      aux_sym_if_command_token1,
    STATE(590), 1,
      aux_sym_if_command_repeat1,
  [18213] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1147), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18223] = 3,
    ACTIONS(1149), 1,
      anon_sym_LPAREN,
    ACTIONS(1151), 1,
      aux_sym_if_command_token1,
    STATE(597), 1,
      aux_sym_if_command_repeat1,
  [18233] = 3,
    ACTIONS(1153), 1,
      anon_sym_LPAREN,
    ACTIONS(1155), 1,
      aux_sym_if_command_token1,
    STATE(619), 1,
      aux_sym_if_command_repeat1,
  [18243] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1157), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18253] = 3,
    ACTIONS(1159), 1,
      anon_sym_LPAREN,
    ACTIONS(1161), 1,
      aux_sym_if_command_token1,
    STATE(623), 1,
      aux_sym_if_command_repeat1,
  [18263] = 3,
    ACTIONS(1163), 1,
      anon_sym_LPAREN,
    ACTIONS(1165), 1,
      aux_sym_if_command_token1,
    STATE(548), 1,
      aux_sym_if_command_repeat1,
  [18273] = 3,
    ACTIONS(1167), 1,
      anon_sym_LPAREN,
    ACTIONS(1169), 1,
      aux_sym_if_command_token1,
    STATE(600), 1,
      aux_sym_if_command_repeat1,
  [18283] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1171), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18293] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1173), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18303] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1175), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18313] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1177), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18323] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1179), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18333] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1181), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18343] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1183), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18353] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1185), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18363] = 3,
    ACTIONS(1187), 1,
      anon_sym_LPAREN,
    ACTIONS(1189), 1,
      aux_sym_if_command_token1,
    STATE(610), 1,
      aux_sym_if_command_repeat1,
  [18373] = 3,
    ACTIONS(1191), 1,
      anon_sym_LBRACE,
    ACTIONS(1193), 1,
      anon_sym_ENV,
    ACTIONS(1195), 1,
      anon_sym_CACHE,
  [18383] = 3,
    ACTIONS(1197), 1,
      anon_sym_LPAREN,
    ACTIONS(1199), 1,
      aux_sym_if_command_token1,
    STATE(608), 1,
      aux_sym_if_command_repeat1,
  [18393] = 3,
    ACTIONS(1201), 1,
      anon_sym_LPAREN,
    ACTIONS(1203), 1,
      aux_sym_if_command_token1,
    STATE(607), 1,
      aux_sym_if_command_repeat1,
  [18403] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1205), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18413] = 3,
    ACTIONS(1207), 1,
      anon_sym_LPAREN,
    ACTIONS(1209), 1,
      aux_sym_if_command_token1,
    STATE(633), 1,
      aux_sym_if_command_repeat1,
  [18423] = 3,
    ACTIONS(1211), 1,
      anon_sym_LPAREN,
    ACTIONS(1213), 1,
      aux_sym_if_command_token1,
    STATE(606), 1,
      aux_sym_if_command_repeat1,
  [18433] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1215), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18443] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1217), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18453] = 3,
    ACTIONS(1219), 1,
      anon_sym_GT,
    ACTIONS(1221), 1,
      anon_sym_COLON,
    STATE(745), 1,
      sym__gen_exp_arguments,
  [18463] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1223), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18473] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1225), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18483] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1227), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18493] = 3,
    ACTIONS(1229), 1,
      anon_sym_LPAREN,
    ACTIONS(1231), 1,
      aux_sym_if_command_token1,
    STATE(605), 1,
      aux_sym_if_command_repeat1,
  [18503] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1233), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18513] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1235), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18523] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1237), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18533] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1239), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18543] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1241), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18553] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1243), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18563] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1245), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18573] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1247), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18583] = 3,
    ACTIONS(1249), 1,
      anon_sym_LPAREN,
    ACTIONS(1251), 1,
      aux_sym_if_command_token1,
    STATE(611), 1,
      aux_sym_if_command_repeat1,
  [18593] = 3,
    ACTIONS(1253), 1,
      anon_sym_LPAREN,
    ACTIONS(1255), 1,
      aux_sym_if_command_token1,
    STATE(624), 1,
      aux_sym_if_command_repeat1,
  [18603] = 3,
    ACTIONS(1257), 1,
      anon_sym_LPAREN,
    ACTIONS(1259), 1,
      aux_sym_if_command_token1,
    STATE(627), 1,
      aux_sym_if_command_repeat1,
  [18613] = 3,
    ACTIONS(1261), 1,
      anon_sym_LPAREN,
    ACTIONS(1263), 1,
      aux_sym_if_command_token1,
    STATE(628), 1,
      aux_sym_if_command_repeat1,
  [18623] = 3,
    ACTIONS(918), 1,
      aux_sym_if_command_token1,
    ACTIONS(1265), 1,
      anon_sym_LPAREN,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [18633] = 3,
    ACTIONS(1267), 1,
      anon_sym_LPAREN,
    ACTIONS(1269), 1,
      aux_sym_if_command_token1,
    STATE(630), 1,
      aux_sym_if_command_repeat1,
  [18643] = 3,
    ACTIONS(1271), 1,
      anon_sym_LPAREN,
    ACTIONS(1273), 1,
      aux_sym_if_command_token1,
    STATE(521), 1,
      aux_sym_if_command_repeat1,
  [18653] = 2,
    ACTIONS(1275), 1,
      sym_endforeach,
    STATE(354), 1,
      sym_endforeach_command,
  [18660] = 2,
    ACTIONS(1277), 1,
      anon_sym_RPAREN,
    ACTIONS(1279), 1,
      aux_sym_endwhile_command_token1,
  [18667] = 2,
    ACTIONS(1281), 1,
      sym_endwhile,
    STATE(280), 1,
      sym_endwhile_command,
  [18674] = 2,
    ACTIONS(1283), 1,
      sym_endfunction,
    STATE(282), 1,
      sym_endfunction_command,
  [18681] = 2,
    ACTIONS(1285), 1,
      sym_endmacro,
    STATE(287), 1,
      sym_endmacro_command,
  [18688] = 2,
    ACTIONS(1287), 1,
      sym_endblock,
    STATE(286), 1,
      sym_endblock_command,
  [18695] = 2,
    ACTIONS(1289), 1,
      anon_sym_RPAREN,
    ACTIONS(1291), 1,
      aux_sym_endwhile_command_token1,
  [18702] = 2,
    ACTIONS(1293), 1,
      anon_sym_RPAREN,
    ACTIONS(1295), 1,
      aux_sym_endwhile_command_token1,
  [18709] = 2,
    ACTIONS(1297), 1,
      sym_endforeach,
    STATE(397), 1,
      sym_endforeach_command,
  [18716] = 2,
    ACTIONS(1299), 1,
      sym_endwhile,
    STATE(466), 1,
      sym_endwhile_command,
  [18723] = 2,
    ACTIONS(1301), 1,
      sym_endforeach,
    STATE(342), 1,
      sym_endforeach_command,
  [18730] = 2,
    ACTIONS(1303), 1,
      sym_endwhile,
    STATE(378), 1,
      sym_endwhile_command,
  [18737] = 2,
    ACTIONS(1305), 1,
      sym_endfunction,
    STATE(471), 1,
      sym_endfunction_command,
  [18744] = 2,
    ACTIONS(1307), 1,
      sym_endforeach,
    STATE(390), 1,
      sym_endforeach_command,
  [18751] = 2,
    ACTIONS(1309), 1,
      sym_endwhile,
    STATE(391), 1,
      sym_endwhile_command,
  [18758] = 2,
    ACTIONS(1311), 1,
      sym_endfunction,
    STATE(392), 1,
      sym_endfunction_command,
  [18765] = 2,
    ACTIONS(1313), 1,
      sym_endmacro,
    STATE(393), 1,
      sym_endmacro_command,
  [18772] = 2,
    ACTIONS(1315), 1,
      sym_endblock,
    STATE(394), 1,
      sym_endblock_command,
  [18779] = 2,
    ACTIONS(1317), 1,
      sym_endfunction,
    STATE(386), 1,
      sym_endfunction_command,
  [18786] = 2,
    ACTIONS(1319), 1,
      sym_endmacro,
    STATE(387), 1,
      sym_endmacro_command,
  [18793] = 2,
    ACTIONS(1321), 1,
      sym_endmacro,
    STATE(472), 1,
      sym_endmacro_command,
  [18800] = 2,
    ACTIONS(1323), 1,
      sym_endblock,
    STATE(474), 1,
      sym_endblock_command,
  [18807] = 2,
    ACTIONS(1325), 1,
      sym_endblock,
    STATE(463), 1,
      sym_endblock_command,
  [18814] = 2,
    ACTIONS(1327), 1,
      anon_sym_RPAREN,
    ACTIONS(1329), 1,
      aux_sym_endwhile_command_token1,
  [18821] = 2,
    ACTIONS(1331), 1,
      anon_sym_RPAREN,
    ACTIONS(1333), 1,
      aux_sym_endwhile_command_token1,
  [18828] = 2,
    ACTIONS(1335), 1,
      anon_sym_RPAREN,
    ACTIONS(1337), 1,
      aux_sym_endwhile_command_token1,
  [18835] = 2,
    ACTIONS(1339), 1,
      sym_endforeach,
    STATE(317), 1,
      sym_endforeach_command,
  [18842] = 2,
    ACTIONS(1341), 1,
      sym_endwhile,
    STATE(318), 1,
      sym_endwhile_command,
  [18849] = 2,
    ACTIONS(1343), 1,
      anon_sym_RPAREN,
    ACTIONS(1345), 1,
      aux_sym_endwhile_command_token1,
  [18856] = 2,
    ACTIONS(1347), 1,
      sym_endfunction,
    STATE(319), 1,
      sym_endfunction_command,
  [18863] = 2,
    ACTIONS(1349), 1,
      sym_endmacro,
    STATE(320), 1,
      sym_endmacro_command,
  [18870] = 2,
    ACTIONS(1351), 1,
      sym_endblock,
    STATE(321), 1,
      sym_endblock_command,
  [18877] = 2,
    ACTIONS(1353), 1,
      anon_sym_RPAREN,
    ACTIONS(1355), 1,
      aux_sym_endwhile_command_token1,
  [18884] = 2,
    ACTIONS(1357), 1,
      anon_sym_RPAREN,
    ACTIONS(1359), 1,
      aux_sym_endwhile_command_token1,
  [18891] = 2,
    ACTIONS(1361), 1,
      anon_sym_RPAREN,
    ACTIONS(1363), 1,
      aux_sym_endwhile_command_token1,
  [18898] = 2,
    ACTIONS(1365), 1,
      anon_sym_RPAREN,
    ACTIONS(1367), 1,
      aux_sym_endwhile_command_token1,
  [18905] = 2,
    ACTIONS(1369), 1,
      anon_sym_RPAREN,
    ACTIONS(1371), 1,
      aux_sym_endwhile_command_token1,
  [18912] = 2,
    ACTIONS(1373), 1,
      anon_sym_RPAREN,
    ACTIONS(1375), 1,
      aux_sym_endwhile_command_token1,
  [18919] = 2,
    ACTIONS(1377), 1,
      sym_endfunction,
    STATE(356), 1,
      sym_endfunction_command,
  [18926] = 2,
    ACTIONS(1379), 1,
      sym_endblock,
    STATE(358), 1,
      sym_endblock_command,
  [18933] = 2,
    ACTIONS(1381), 1,
      sym_endmacro,
    STATE(357), 1,
      sym_endmacro_command,
  [18940] = 2,
    ACTIONS(1383), 1,
      anon_sym_RPAREN,
    ACTIONS(1385), 1,
      aux_sym_endwhile_command_token1,
  [18947] = 2,
    ACTIONS(1387), 1,
      sym_endforeach,
    STATE(427), 1,
      sym_endforeach_command,
  [18954] = 2,
    ACTIONS(1389), 1,
      sym_endwhile,
    STATE(428), 1,
      sym_endwhile_command,
  [18961] = 2,
    ACTIONS(1391), 1,
      sym_endfunction,
    STATE(429), 1,
      sym_endfunction_command,
  [18968] = 2,
    ACTIONS(1393), 1,
      sym_endmacro,
    STATE(430), 1,
      sym_endmacro_command,
  [18975] = 2,
    ACTIONS(1395), 1,
      sym_endblock,
    STATE(431), 1,
      sym_endblock_command,
  [18982] = 2,
    ACTIONS(1397), 1,
      sym_endforeach,
    STATE(279), 1,
      sym_endforeach_command,
  [18989] = 2,
    ACTIONS(1399), 1,
      sym_endwhile,
    STATE(355), 1,
      sym_endwhile_command,
  [18996] = 1,
    ACTIONS(1401), 1,
      anon_sym_RPAREN,
  [19000] = 1,
    ACTIONS(127), 1,
      anon_sym_RPAREN,
  [19004] = 1,
    ACTIONS(1403), 1,
      anon_sym_RPAREN,
  [19008] = 1,
    ACTIONS(1405), 1,
      anon_sym_RPAREN,
  [19012] = 1,
    ACTIONS(1407), 1,
      anon_sym_RPAREN,
  [19016] = 1,
    ACTIONS(1409), 1,
      anon_sym_RPAREN,
  [19020] = 1,
    ACTIONS(1411), 1,
      anon_sym_RPAREN,
  [19024] = 1,
    ACTIONS(1413), 1,
      anon_sym_RPAREN,
  [19028] = 1,
    ACTIONS(1415), 1,
      anon_sym_RBRACE,
  [19032] = 1,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
  [19036] = 1,
    ACTIONS(1417), 1,
      anon_sym_RPAREN,
  [19040] = 1,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
  [19044] = 1,
    ACTIONS(59), 1,
      anon_sym_RPAREN,
  [19048] = 1,
    ACTIONS(1419), 1,
      anon_sym_RBRACE,
  [19052] = 1,
    ACTIONS(1421), 1,
      anon_sym_RPAREN,
  [19056] = 1,
    ACTIONS(464), 1,
      anon_sym_RPAREN,
  [19060] = 1,
    ACTIONS(151), 1,
      anon_sym_RPAREN,
  [19064] = 1,
    ACTIONS(161), 1,
      anon_sym_RPAREN,
  [19068] = 1,
    ACTIONS(1423), 1,
      anon_sym_RPAREN,
  [19072] = 1,
    ACTIONS(165), 1,
      anon_sym_RPAREN,
  [19076] = 1,
    ACTIONS(1425), 1,
      anon_sym_RPAREN,
  [19080] = 1,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
  [19084] = 1,
    ACTIONS(1427), 1,
      anon_sym_RBRACE,
  [19088] = 1,
    ACTIONS(1429), 1,
      anon_sym_RBRACE,
  [19092] = 1,
    ACTIONS(1431), 1,
      anon_sym_RPAREN,
  [19096] = 1,
    ACTIONS(1433), 1,
      anon_sym_RPAREN,
  [19100] = 1,
    ACTIONS(1435), 1,
      anon_sym_RPAREN,
  [19104] = 1,
    ACTIONS(1437), 1,
      anon_sym_RPAREN,
  [19108] = 1,
    ACTIONS(1439), 1,
      anon_sym_RPAREN,
  [19112] = 1,
    ACTIONS(1441), 1,
      anon_sym_RPAREN,
  [19116] = 1,
    ACTIONS(1443), 1,
      anon_sym_RPAREN,
  [19120] = 1,
    ACTIONS(1445), 1,
      anon_sym_RPAREN,
  [19124] = 1,
    ACTIONS(1447), 1,
      anon_sym_RPAREN,
  [19128] = 1,
    ACTIONS(123), 1,
      anon_sym_RPAREN,
  [19132] = 1,
    ACTIONS(101), 1,
      anon_sym_RPAREN,
  [19136] = 1,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
  [19140] = 1,
    ACTIONS(71), 1,
      anon_sym_RPAREN,
  [19144] = 1,
    ACTIONS(1449), 1,
      anon_sym_RPAREN,
  [19148] = 1,
    ACTIONS(444), 1,
      anon_sym_RPAREN,
  [19152] = 1,
    ACTIONS(1451), 1,
      aux_sym_endwhile_command_token1,
  [19156] = 1,
    ACTIONS(1453), 1,
      aux_sym_endwhile_command_token1,
  [19160] = 1,
    ACTIONS(1455), 1,
      anon_sym_RPAREN,
  [19164] = 1,
    ACTIONS(1457), 1,
      anon_sym_RPAREN,
  [19168] = 1,
    ACTIONS(1459), 1,
      anon_sym_GT,
  [19172] = 1,
    ACTIONS(1461), 1,
      anon_sym_RPAREN,
  [19176] = 1,
    ACTIONS(1463), 1,
      anon_sym_DQUOTE,
  [19180] = 1,
    ACTIONS(1465), 1,
      anon_sym_LBRACE,
  [19184] = 1,
    ACTIONS(1467), 1,
      anon_sym_RBRACE,
  [19188] = 1,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
  [19192] = 1,
    ACTIONS(99), 1,
      anon_sym_RPAREN,
  [19196] = 1,
    ACTIONS(1469), 1,
      anon_sym_RBRACE,
  [19200] = 1,
    ACTIONS(95), 1,
      anon_sym_RPAREN,
  [19204] = 1,
    ACTIONS(1471), 1,
      anon_sym_RPAREN,
  [19208] = 1,
    ACTIONS(1473), 1,
      anon_sym_RBRACE,
  [19212] = 1,
    ACTIONS(1475), 1,
      anon_sym_LBRACE,
  [19216] = 1,
    ACTIONS(1477), 1,
      anon_sym_GT,
  [19220] = 1,
    ACTIONS(1479), 1,
      anon_sym_RPAREN,
  [19224] = 1,
    ACTIONS(1481), 1,
      aux_sym_endwhile_command_token1,
  [19228] = 1,
    ACTIONS(1483), 1,
      aux_sym_endwhile_command_token1,
  [19232] = 1,
    ACTIONS(1485), 1,
      aux_sym_endwhile_command_token1,
  [19236] = 1,
    ACTIONS(1487), 1,
      anon_sym_RPAREN,
  [19240] = 1,
    ACTIONS(1489), 1,
      anon_sym_RPAREN,
  [19244] = 1,
    ACTIONS(1491), 1,
      anon_sym_RPAREN,
  [19248] = 1,
    ACTIONS(1493), 1,
      anon_sym_RPAREN,
  [19252] = 1,
    ACTIONS(1495), 1,
      anon_sym_RPAREN,
  [19256] = 1,
    ACTIONS(1497), 1,
      anon_sym_RBRACE,
  [19260] = 1,
    ACTIONS(1499), 1,
      anon_sym_RBRACE,
  [19264] = 1,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
  [19268] = 1,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
  [19272] = 1,
    ACTIONS(1501), 1,
      anon_sym_RPAREN,
  [19276] = 1,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
  [19280] = 1,
    ACTIONS(147), 1,
      anon_sym_RPAREN,
  [19284] = 1,
    ACTIONS(466), 1,
      anon_sym_RPAREN,
  [19288] = 1,
    ACTIONS(1503), 1,
      anon_sym_RPAREN,
  [19292] = 1,
    ACTIONS(1505), 1,
      anon_sym_GT,
  [19296] = 1,
    ACTIONS(1507), 1,
      anon_sym_RBRACE,
  [19300] = 1,
    ACTIONS(1509), 1,
      anon_sym_RPAREN,
  [19304] = 1,
    ACTIONS(1511), 1,
      anon_sym_RPAREN,
  [19308] = 1,
    ACTIONS(1513), 1,
      anon_sym_RBRACE,
  [19312] = 1,
    ACTIONS(1515), 1,
      anon_sym_RPAREN,
  [19316] = 1,
    ACTIONS(1517), 1,
      aux_sym_endwhile_command_token1,
  [19320] = 1,
    ACTIONS(1519), 1,
      aux_sym_endwhile_command_token1,
  [19324] = 1,
    ACTIONS(215), 1,
      anon_sym_RPAREN,
  [19328] = 1,
    ACTIONS(1521), 1,
      anon_sym_RPAREN,
  [19332] = 1,
    ACTIONS(1523), 1,
      anon_sym_DQUOTE,
  [19336] = 1,
    ACTIONS(1525), 1,
      aux_sym_endwhile_command_token1,
  [19340] = 1,
    ACTIONS(225), 1,
      anon_sym_RPAREN,
  [19344] = 1,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
  [19348] = 1,
    ACTIONS(1527), 1,
      anon_sym_GT,
  [19352] = 1,
    ACTIONS(1529), 1,
      anon_sym_RBRACE,
  [19356] = 1,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
  [19360] = 1,
    ACTIONS(111), 1,
      anon_sym_RPAREN,
  [19364] = 1,
    ACTIONS(452), 1,
      anon_sym_RPAREN,
  [19368] = 1,
    ACTIONS(1531), 1,
      anon_sym_RPAREN,
  [19372] = 1,
    ACTIONS(1533), 1,
      anon_sym_RPAREN,
  [19376] = 1,
    ACTIONS(1535), 1,
      anon_sym_RPAREN,
  [19380] = 1,
    ACTIONS(1537), 1,
      anon_sym_RPAREN,
  [19384] = 1,
    ACTIONS(1539), 1,
      anon_sym_RPAREN,
  [19388] = 1,
    ACTIONS(1541), 1,
      anon_sym_RPAREN,
  [19392] = 1,
    ACTIONS(1543), 1,
      anon_sym_RPAREN,
  [19396] = 1,
    ACTIONS(1545), 1,
      anon_sym_RBRACE,
  [19400] = 1,
    ACTIONS(1547), 1,
      anon_sym_RBRACE,
  [19404] = 1,
    ACTIONS(1549), 1,
      anon_sym_RPAREN,
  [19408] = 1,
    ACTIONS(1551), 1,
      anon_sym_RPAREN,
  [19412] = 1,
    ACTIONS(1553), 1,
      aux_sym_endwhile_command_token1,
  [19416] = 1,
    ACTIONS(1555), 1,
      aux_sym_endwhile_command_token1,
  [19420] = 1,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
  [19424] = 1,
    ACTIONS(1557), 1,
      anon_sym_RPAREN,
  [19428] = 1,
    ACTIONS(1559), 1,
      anon_sym_RPAREN,
  [19432] = 1,
    ACTIONS(1561), 1,
      anon_sym_RPAREN,
  [19436] = 1,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
  [19440] = 1,
    ACTIONS(1563), 1,
      anon_sym_RPAREN,
  [19444] = 1,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
  [19448] = 1,
    ACTIONS(1565), 1,
      anon_sym_RPAREN,
  [19452] = 1,
    ACTIONS(448), 1,
      anon_sym_RPAREN,
  [19456] = 1,
    ACTIONS(1567), 1,
      anon_sym_RPAREN,
  [19460] = 1,
    ACTIONS(1569), 1,
      anon_sym_GT,
  [19464] = 1,
    ACTIONS(1571), 1,
      anon_sym_RBRACE,
  [19468] = 1,
    ACTIONS(1573), 1,
      anon_sym_GT,
  [19472] = 1,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
  [19476] = 1,
    ACTIONS(1575), 1,
      anon_sym_RBRACE,
  [19480] = 1,
    ACTIONS(1577), 1,
      anon_sym_RPAREN,
  [19484] = 1,
    ACTIONS(1579), 1,
      anon_sym_DQUOTE,
  [19488] = 1,
    ACTIONS(145), 1,
      anon_sym_RPAREN,
  [19492] = 1,
    ACTIONS(75), 1,
      anon_sym_RPAREN,
  [19496] = 1,
    ACTIONS(1581), 1,
      anon_sym_RPAREN,
  [19500] = 1,
    ACTIONS(1583), 1,
      anon_sym_RPAREN,
  [19504] = 1,
    ACTIONS(1585), 1,
      anon_sym_RPAREN,
  [19508] = 1,
    ACTIONS(1587), 1,
      aux_sym_endwhile_command_token1,
  [19512] = 1,
    ACTIONS(1589), 1,
      aux_sym_endwhile_command_token1,
  [19516] = 1,
    ACTIONS(63), 1,
      anon_sym_RPAREN,
  [19520] = 1,
    ACTIONS(1591), 1,
      anon_sym_RPAREN,
  [19524] = 1,
    ACTIONS(440), 1,
      anon_sym_RPAREN,
  [19528] = 1,
    ACTIONS(1593), 1,
      anon_sym_RPAREN,
  [19532] = 1,
    ACTIONS(1595), 1,
      anon_sym_RPAREN,
  [19536] = 1,
    ACTIONS(626), 1,
      aux_sym_endwhile_command_token1,
  [19540] = 1,
    ACTIONS(1597), 1,
      anon_sym_RPAREN,
  [19544] = 1,
    ACTIONS(1599), 1,
      anon_sym_RPAREN,
  [19548] = 1,
    ACTIONS(1601), 1,
      anon_sym_RPAREN,
  [19552] = 1,
    ACTIONS(1603), 1,
      anon_sym_RPAREN,
  [19556] = 1,
    ACTIONS(1605), 1,
      anon_sym_RPAREN,
  [19560] = 1,
    ACTIONS(1607), 1,
      anon_sym_RPAREN,
  [19564] = 1,
    ACTIONS(1609), 1,
      anon_sym_RBRACE,
  [19568] = 1,
    ACTIONS(1611), 1,
      anon_sym_RBRACE,
  [19572] = 1,
    ACTIONS(117), 1,
      anon_sym_RPAREN,
  [19576] = 1,
    ACTIONS(115), 1,
      anon_sym_RPAREN,
  [19580] = 1,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
  [19584] = 1,
    ACTIONS(1613), 1,
      anon_sym_RPAREN,
  [19588] = 1,
    ACTIONS(454), 1,
      anon_sym_RPAREN,
  [19592] = 1,
    ACTIONS(1615), 1,
      anon_sym_RPAREN,
  [19596] = 1,
    ACTIONS(1617), 1,
      anon_sym_GT,
  [19600] = 1,
    ACTIONS(1619), 1,
      anon_sym_RBRACE,
  [19604] = 1,
    ACTIONS(1621), 1,
      aux_sym_endwhile_command_token1,
  [19608] = 1,
    ACTIONS(1623), 1,
      aux_sym_endwhile_command_token1,
  [19612] = 1,
    ACTIONS(1625), 1,
      anon_sym_LBRACE,
  [19616] = 1,
    ACTIONS(1627), 1,
      anon_sym_LBRACE,
  [19620] = 1,
    ACTIONS(1629), 1,
      anon_sym_RPAREN,
  [19624] = 1,
    ACTIONS(642), 1,
      aux_sym_endwhile_command_token1,
  [19628] = 1,
    ACTIONS(1631), 1,
      anon_sym_LBRACE,
  [19632] = 1,
    ACTIONS(1633), 1,
      anon_sym_LBRACE,
  [19636] = 1,
    ACTIONS(87), 1,
      anon_sym_RPAREN,
  [19640] = 1,
    ACTIONS(1635), 1,
      anon_sym_RPAREN,
  [19644] = 1,
    ACTIONS(1637), 1,
      anon_sym_LBRACE,
  [19648] = 1,
    ACTIONS(1639), 1,
      anon_sym_LBRACE,
  [19652] = 1,
    ACTIONS(1641), 1,
      anon_sym_DQUOTE,
  [19656] = 1,
    ACTIONS(1643), 1,
      ts_builtin_sym_end,
  [19660] = 1,
    ACTIONS(1645), 1,
      anon_sym_LBRACE,
  [19664] = 1,
    ACTIONS(1647), 1,
      anon_sym_LBRACE,
  [19668] = 1,
    ACTIONS(79), 1,
      anon_sym_RPAREN,
  [19672] = 1,
    ACTIONS(622), 1,
      aux_sym_endwhile_command_token1,
  [19676] = 1,
    ACTIONS(1649), 1,
      anon_sym_LBRACE,
  [19680] = 1,
    ACTIONS(1651), 1,
      anon_sym_LBRACE,
  [19684] = 1,
    ACTIONS(1653), 1,
      anon_sym_RPAREN,
  [19688] = 1,
    ACTIONS(1655), 1,
      anon_sym_RPAREN,
  [19692] = 1,
    ACTIONS(1657), 1,
      anon_sym_LBRACE,
  [19696] = 1,
    ACTIONS(1659), 1,
      anon_sym_LBRACE,
  [19700] = 1,
    ACTIONS(1661), 1,
      anon_sym_RBRACE,
  [19704] = 1,
    ACTIONS(1663), 1,
      anon_sym_RBRACE,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 75,
  [SMALL_STATE(4)] = 150,
  [SMALL_STATE(5)] = 225,
  [SMALL_STATE(6)] = 300,
  [SMALL_STATE(7)] = 375,
  [SMALL_STATE(8)] = 450,
  [SMALL_STATE(9)] = 525,
  [SMALL_STATE(10)] = 600,
  [SMALL_STATE(11)] = 675,
  [SMALL_STATE(12)] = 750,
  [SMALL_STATE(13)] = 825,
  [SMALL_STATE(14)] = 900,
  [SMALL_STATE(15)] = 975,
  [SMALL_STATE(16)] = 1050,
  [SMALL_STATE(17)] = 1112,
  [SMALL_STATE(18)] = 1174,
  [SMALL_STATE(19)] = 1236,
  [SMALL_STATE(20)] = 1298,
  [SMALL_STATE(21)] = 1360,
  [SMALL_STATE(22)] = 1422,
  [SMALL_STATE(23)] = 1484,
  [SMALL_STATE(24)] = 1546,
  [SMALL_STATE(25)] = 1608,
  [SMALL_STATE(26)] = 1670,
  [SMALL_STATE(27)] = 1732,
  [SMALL_STATE(28)] = 1794,
  [SMALL_STATE(29)] = 1856,
  [SMALL_STATE(30)] = 1918,
  [SMALL_STATE(31)] = 1980,
  [SMALL_STATE(32)] = 2042,
  [SMALL_STATE(33)] = 2104,
  [SMALL_STATE(34)] = 2166,
  [SMALL_STATE(35)] = 2228,
  [SMALL_STATE(36)] = 2290,
  [SMALL_STATE(37)] = 2352,
  [SMALL_STATE(38)] = 2414,
  [SMALL_STATE(39)] = 2476,
  [SMALL_STATE(40)] = 2538,
  [SMALL_STATE(41)] = 2600,
  [SMALL_STATE(42)] = 2662,
  [SMALL_STATE(43)] = 2724,
  [SMALL_STATE(44)] = 2786,
  [SMALL_STATE(45)] = 2848,
  [SMALL_STATE(46)] = 2910,
  [SMALL_STATE(47)] = 2972,
  [SMALL_STATE(48)] = 3034,
  [SMALL_STATE(49)] = 3096,
  [SMALL_STATE(50)] = 3158,
  [SMALL_STATE(51)] = 3220,
  [SMALL_STATE(52)] = 3282,
  [SMALL_STATE(53)] = 3344,
  [SMALL_STATE(54)] = 3406,
  [SMALL_STATE(55)] = 3468,
  [SMALL_STATE(56)] = 3530,
  [SMALL_STATE(57)] = 3592,
  [SMALL_STATE(58)] = 3654,
  [SMALL_STATE(59)] = 3716,
  [SMALL_STATE(60)] = 3778,
  [SMALL_STATE(61)] = 3840,
  [SMALL_STATE(62)] = 3902,
  [SMALL_STATE(63)] = 3964,
  [SMALL_STATE(64)] = 4026,
  [SMALL_STATE(65)] = 4088,
  [SMALL_STATE(66)] = 4150,
  [SMALL_STATE(67)] = 4212,
  [SMALL_STATE(68)] = 4274,
  [SMALL_STATE(69)] = 4336,
  [SMALL_STATE(70)] = 4398,
  [SMALL_STATE(71)] = 4460,
  [SMALL_STATE(72)] = 4522,
  [SMALL_STATE(73)] = 4584,
  [SMALL_STATE(74)] = 4646,
  [SMALL_STATE(75)] = 4718,
  [SMALL_STATE(76)] = 4780,
  [SMALL_STATE(77)] = 4842,
  [SMALL_STATE(78)] = 4904,
  [SMALL_STATE(79)] = 4966,
  [SMALL_STATE(80)] = 5028,
  [SMALL_STATE(81)] = 5090,
  [SMALL_STATE(82)] = 5152,
  [SMALL_STATE(83)] = 5214,
  [SMALL_STATE(84)] = 5276,
  [SMALL_STATE(85)] = 5338,
  [SMALL_STATE(86)] = 5400,
  [SMALL_STATE(87)] = 5462,
  [SMALL_STATE(88)] = 5524,
  [SMALL_STATE(89)] = 5586,
  [SMALL_STATE(90)] = 5645,
  [SMALL_STATE(91)] = 5704,
  [SMALL_STATE(92)] = 5763,
  [SMALL_STATE(93)] = 5822,
  [SMALL_STATE(94)] = 5881,
  [SMALL_STATE(95)] = 5940,
  [SMALL_STATE(96)] = 5999,
  [SMALL_STATE(97)] = 6058,
  [SMALL_STATE(98)] = 6117,
  [SMALL_STATE(99)] = 6176,
  [SMALL_STATE(100)] = 6235,
  [SMALL_STATE(101)] = 6294,
  [SMALL_STATE(102)] = 6353,
  [SMALL_STATE(103)] = 6412,
  [SMALL_STATE(104)] = 6471,
  [SMALL_STATE(105)] = 6530,
  [SMALL_STATE(106)] = 6589,
  [SMALL_STATE(107)] = 6648,
  [SMALL_STATE(108)] = 6710,
  [SMALL_STATE(109)] = 6772,
  [SMALL_STATE(110)] = 6832,
  [SMALL_STATE(111)] = 6892,
  [SMALL_STATE(112)] = 6952,
  [SMALL_STATE(113)] = 7012,
  [SMALL_STATE(114)] = 7072,
  [SMALL_STATE(115)] = 7132,
  [SMALL_STATE(116)] = 7192,
  [SMALL_STATE(117)] = 7252,
  [SMALL_STATE(118)] = 7312,
  [SMALL_STATE(119)] = 7372,
  [SMALL_STATE(120)] = 7432,
  [SMALL_STATE(121)] = 7492,
  [SMALL_STATE(122)] = 7552,
  [SMALL_STATE(123)] = 7612,
  [SMALL_STATE(124)] = 7672,
  [SMALL_STATE(125)] = 7732,
  [SMALL_STATE(126)] = 7792,
  [SMALL_STATE(127)] = 7852,
  [SMALL_STATE(128)] = 7912,
  [SMALL_STATE(129)] = 7972,
  [SMALL_STATE(130)] = 8032,
  [SMALL_STATE(131)] = 8092,
  [SMALL_STATE(132)] = 8152,
  [SMALL_STATE(133)] = 8212,
  [SMALL_STATE(134)] = 8272,
  [SMALL_STATE(135)] = 8332,
  [SMALL_STATE(136)] = 8392,
  [SMALL_STATE(137)] = 8452,
  [SMALL_STATE(138)] = 8512,
  [SMALL_STATE(139)] = 8572,
  [SMALL_STATE(140)] = 8632,
  [SMALL_STATE(141)] = 8692,
  [SMALL_STATE(142)] = 8752,
  [SMALL_STATE(143)] = 8812,
  [SMALL_STATE(144)] = 8872,
  [SMALL_STATE(145)] = 8932,
  [SMALL_STATE(146)] = 8992,
  [SMALL_STATE(147)] = 9052,
  [SMALL_STATE(148)] = 9112,
  [SMALL_STATE(149)] = 9172,
  [SMALL_STATE(150)] = 9232,
  [SMALL_STATE(151)] = 9292,
  [SMALL_STATE(152)] = 9352,
  [SMALL_STATE(153)] = 9412,
  [SMALL_STATE(154)] = 9472,
  [SMALL_STATE(155)] = 9532,
  [SMALL_STATE(156)] = 9592,
  [SMALL_STATE(157)] = 9643,
  [SMALL_STATE(158)] = 9694,
  [SMALL_STATE(159)] = 9745,
  [SMALL_STATE(160)] = 9796,
  [SMALL_STATE(161)] = 9847,
  [SMALL_STATE(162)] = 9898,
  [SMALL_STATE(163)] = 9949,
  [SMALL_STATE(164)] = 9990,
  [SMALL_STATE(165)] = 10041,
  [SMALL_STATE(166)] = 10082,
  [SMALL_STATE(167)] = 10133,
  [SMALL_STATE(168)] = 10181,
  [SMALL_STATE(169)] = 10229,
  [SMALL_STATE(170)] = 10277,
  [SMALL_STATE(171)] = 10325,
  [SMALL_STATE(172)] = 10373,
  [SMALL_STATE(173)] = 10421,
  [SMALL_STATE(174)] = 10469,
  [SMALL_STATE(175)] = 10517,
  [SMALL_STATE(176)] = 10565,
  [SMALL_STATE(177)] = 10613,
  [SMALL_STATE(178)] = 10661,
  [SMALL_STATE(179)] = 10709,
  [SMALL_STATE(180)] = 10757,
  [SMALL_STATE(181)] = 10805,
  [SMALL_STATE(182)] = 10850,
  [SMALL_STATE(183)] = 10895,
  [SMALL_STATE(184)] = 10940,
  [SMALL_STATE(185)] = 10985,
  [SMALL_STATE(186)] = 11030,
  [SMALL_STATE(187)] = 11075,
  [SMALL_STATE(188)] = 11120,
  [SMALL_STATE(189)] = 11165,
  [SMALL_STATE(190)] = 11210,
  [SMALL_STATE(191)] = 11255,
  [SMALL_STATE(192)] = 11300,
  [SMALL_STATE(193)] = 11345,
  [SMALL_STATE(194)] = 11390,
  [SMALL_STATE(195)] = 11435,
  [SMALL_STATE(196)] = 11475,
  [SMALL_STATE(197)] = 11515,
  [SMALL_STATE(198)] = 11553,
  [SMALL_STATE(199)] = 11591,
  [SMALL_STATE(200)] = 11629,
  [SMALL_STATE(201)] = 11665,
  [SMALL_STATE(202)] = 11703,
  [SMALL_STATE(203)] = 11739,
  [SMALL_STATE(204)] = 11774,
  [SMALL_STATE(205)] = 11809,
  [SMALL_STATE(206)] = 11844,
  [SMALL_STATE(207)] = 11879,
  [SMALL_STATE(208)] = 11914,
  [SMALL_STATE(209)] = 11949,
  [SMALL_STATE(210)] = 11981,
  [SMALL_STATE(211)] = 12013,
  [SMALL_STATE(212)] = 12045,
  [SMALL_STATE(213)] = 12077,
  [SMALL_STATE(214)] = 12109,
  [SMALL_STATE(215)] = 12141,
  [SMALL_STATE(216)] = 12173,
  [SMALL_STATE(217)] = 12205,
  [SMALL_STATE(218)] = 12237,
  [SMALL_STATE(219)] = 12269,
  [SMALL_STATE(220)] = 12301,
  [SMALL_STATE(221)] = 12333,
  [SMALL_STATE(222)] = 12365,
  [SMALL_STATE(223)] = 12397,
  [SMALL_STATE(224)] = 12429,
  [SMALL_STATE(225)] = 12461,
  [SMALL_STATE(226)] = 12493,
  [SMALL_STATE(227)] = 12525,
  [SMALL_STATE(228)] = 12557,
  [SMALL_STATE(229)] = 12589,
  [SMALL_STATE(230)] = 12621,
  [SMALL_STATE(231)] = 12653,
  [SMALL_STATE(232)] = 12685,
  [SMALL_STATE(233)] = 12717,
  [SMALL_STATE(234)] = 12742,
  [SMALL_STATE(235)] = 12771,
  [SMALL_STATE(236)] = 12791,
  [SMALL_STATE(237)] = 12811,
  [SMALL_STATE(238)] = 12831,
  [SMALL_STATE(239)] = 12851,
  [SMALL_STATE(240)] = 12871,
  [SMALL_STATE(241)] = 12891,
  [SMALL_STATE(242)] = 12911,
  [SMALL_STATE(243)] = 12931,
  [SMALL_STATE(244)] = 12951,
  [SMALL_STATE(245)] = 12971,
  [SMALL_STATE(246)] = 12991,
  [SMALL_STATE(247)] = 13011,
  [SMALL_STATE(248)] = 13038,
  [SMALL_STATE(249)] = 13056,
  [SMALL_STATE(250)] = 13074,
  [SMALL_STATE(251)] = 13092,
  [SMALL_STATE(252)] = 13110,
  [SMALL_STATE(253)] = 13128,
  [SMALL_STATE(254)] = 13146,
  [SMALL_STATE(255)] = 13172,
  [SMALL_STATE(256)] = 13190,
  [SMALL_STATE(257)] = 13216,
  [SMALL_STATE(258)] = 13234,
  [SMALL_STATE(259)] = 13252,
  [SMALL_STATE(260)] = 13270,
  [SMALL_STATE(261)] = 13288,
  [SMALL_STATE(262)] = 13306,
  [SMALL_STATE(263)] = 13324,
  [SMALL_STATE(264)] = 13342,
  [SMALL_STATE(265)] = 13360,
  [SMALL_STATE(266)] = 13378,
  [SMALL_STATE(267)] = 13396,
  [SMALL_STATE(268)] = 13414,
  [SMALL_STATE(269)] = 13432,
  [SMALL_STATE(270)] = 13450,
  [SMALL_STATE(271)] = 13468,
  [SMALL_STATE(272)] = 13486,
  [SMALL_STATE(273)] = 13504,
  [SMALL_STATE(274)] = 13522,
  [SMALL_STATE(275)] = 13540,
  [SMALL_STATE(276)] = 13558,
  [SMALL_STATE(277)] = 13576,
  [SMALL_STATE(278)] = 13594,
  [SMALL_STATE(279)] = 13612,
  [SMALL_STATE(280)] = 13630,
  [SMALL_STATE(281)] = 13648,
  [SMALL_STATE(282)] = 13666,
  [SMALL_STATE(283)] = 13684,
  [SMALL_STATE(284)] = 13708,
  [SMALL_STATE(285)] = 13726,
  [SMALL_STATE(286)] = 13752,
  [SMALL_STATE(287)] = 13770,
  [SMALL_STATE(288)] = 13788,
  [SMALL_STATE(289)] = 13805,
  [SMALL_STATE(290)] = 13822,
  [SMALL_STATE(291)] = 13839,
  [SMALL_STATE(292)] = 13856,
  [SMALL_STATE(293)] = 13873,
  [SMALL_STATE(294)] = 13890,
  [SMALL_STATE(295)] = 13907,
  [SMALL_STATE(296)] = 13924,
  [SMALL_STATE(297)] = 13941,
  [SMALL_STATE(298)] = 13958,
  [SMALL_STATE(299)] = 13977,
  [SMALL_STATE(300)] = 13993,
  [SMALL_STATE(301)] = 14009,
  [SMALL_STATE(302)] = 14025,
  [SMALL_STATE(303)] = 14041,
  [SMALL_STATE(304)] = 14057,
  [SMALL_STATE(305)] = 14073,
  [SMALL_STATE(306)] = 14093,
  [SMALL_STATE(307)] = 14109,
  [SMALL_STATE(308)] = 14125,
  [SMALL_STATE(309)] = 14141,
  [SMALL_STATE(310)] = 14157,
  [SMALL_STATE(311)] = 14173,
  [SMALL_STATE(312)] = 14189,
  [SMALL_STATE(313)] = 14205,
  [SMALL_STATE(314)] = 14221,
  [SMALL_STATE(315)] = 14237,
  [SMALL_STATE(316)] = 14253,
  [SMALL_STATE(317)] = 14269,
  [SMALL_STATE(318)] = 14285,
  [SMALL_STATE(319)] = 14301,
  [SMALL_STATE(320)] = 14317,
  [SMALL_STATE(321)] = 14333,
  [SMALL_STATE(322)] = 14349,
  [SMALL_STATE(323)] = 14365,
  [SMALL_STATE(324)] = 14381,
  [SMALL_STATE(325)] = 14397,
  [SMALL_STATE(326)] = 14413,
  [SMALL_STATE(327)] = 14429,
  [SMALL_STATE(328)] = 14445,
  [SMALL_STATE(329)] = 14461,
  [SMALL_STATE(330)] = 14477,
  [SMALL_STATE(331)] = 14493,
  [SMALL_STATE(332)] = 14509,
  [SMALL_STATE(333)] = 14525,
  [SMALL_STATE(334)] = 14541,
  [SMALL_STATE(335)] = 14557,
  [SMALL_STATE(336)] = 14573,
  [SMALL_STATE(337)] = 14589,
  [SMALL_STATE(338)] = 14605,
  [SMALL_STATE(339)] = 14621,
  [SMALL_STATE(340)] = 14637,
  [SMALL_STATE(341)] = 14653,
  [SMALL_STATE(342)] = 14669,
  [SMALL_STATE(343)] = 14685,
  [SMALL_STATE(344)] = 14701,
  [SMALL_STATE(345)] = 14717,
  [SMALL_STATE(346)] = 14733,
  [SMALL_STATE(347)] = 14749,
  [SMALL_STATE(348)] = 14765,
  [SMALL_STATE(349)] = 14781,
  [SMALL_STATE(350)] = 14797,
  [SMALL_STATE(351)] = 14813,
  [SMALL_STATE(352)] = 14829,
  [SMALL_STATE(353)] = 14845,
  [SMALL_STATE(354)] = 14861,
  [SMALL_STATE(355)] = 14877,
  [SMALL_STATE(356)] = 14893,
  [SMALL_STATE(357)] = 14909,
  [SMALL_STATE(358)] = 14925,
  [SMALL_STATE(359)] = 14941,
  [SMALL_STATE(360)] = 14957,
  [SMALL_STATE(361)] = 14973,
  [SMALL_STATE(362)] = 14989,
  [SMALL_STATE(363)] = 15005,
  [SMALL_STATE(364)] = 15021,
  [SMALL_STATE(365)] = 15037,
  [SMALL_STATE(366)] = 15053,
  [SMALL_STATE(367)] = 15069,
  [SMALL_STATE(368)] = 15085,
  [SMALL_STATE(369)] = 15101,
  [SMALL_STATE(370)] = 15117,
  [SMALL_STATE(371)] = 15133,
  [SMALL_STATE(372)] = 15149,
  [SMALL_STATE(373)] = 15165,
  [SMALL_STATE(374)] = 15181,
  [SMALL_STATE(375)] = 15197,
  [SMALL_STATE(376)] = 15213,
  [SMALL_STATE(377)] = 15229,
  [SMALL_STATE(378)] = 15245,
  [SMALL_STATE(379)] = 15261,
  [SMALL_STATE(380)] = 15277,
  [SMALL_STATE(381)] = 15293,
  [SMALL_STATE(382)] = 15309,
  [SMALL_STATE(383)] = 15325,
  [SMALL_STATE(384)] = 15341,
  [SMALL_STATE(385)] = 15357,
  [SMALL_STATE(386)] = 15373,
  [SMALL_STATE(387)] = 15389,
  [SMALL_STATE(388)] = 15405,
  [SMALL_STATE(389)] = 15421,
  [SMALL_STATE(390)] = 15437,
  [SMALL_STATE(391)] = 15453,
  [SMALL_STATE(392)] = 15469,
  [SMALL_STATE(393)] = 15485,
  [SMALL_STATE(394)] = 15501,
  [SMALL_STATE(395)] = 15517,
  [SMALL_STATE(396)] = 15533,
  [SMALL_STATE(397)] = 15549,
  [SMALL_STATE(398)] = 15565,
  [SMALL_STATE(399)] = 15581,
  [SMALL_STATE(400)] = 15597,
  [SMALL_STATE(401)] = 15613,
  [SMALL_STATE(402)] = 15629,
  [SMALL_STATE(403)] = 15645,
  [SMALL_STATE(404)] = 15661,
  [SMALL_STATE(405)] = 15677,
  [SMALL_STATE(406)] = 15693,
  [SMALL_STATE(407)] = 15709,
  [SMALL_STATE(408)] = 15725,
  [SMALL_STATE(409)] = 15741,
  [SMALL_STATE(410)] = 15757,
  [SMALL_STATE(411)] = 15773,
  [SMALL_STATE(412)] = 15789,
  [SMALL_STATE(413)] = 15805,
  [SMALL_STATE(414)] = 15821,
  [SMALL_STATE(415)] = 15837,
  [SMALL_STATE(416)] = 15853,
  [SMALL_STATE(417)] = 15869,
  [SMALL_STATE(418)] = 15885,
  [SMALL_STATE(419)] = 15901,
  [SMALL_STATE(420)] = 15917,
  [SMALL_STATE(421)] = 15933,
  [SMALL_STATE(422)] = 15949,
  [SMALL_STATE(423)] = 15965,
  [SMALL_STATE(424)] = 15981,
  [SMALL_STATE(425)] = 15997,
  [SMALL_STATE(426)] = 16013,
  [SMALL_STATE(427)] = 16029,
  [SMALL_STATE(428)] = 16045,
  [SMALL_STATE(429)] = 16061,
  [SMALL_STATE(430)] = 16077,
  [SMALL_STATE(431)] = 16093,
  [SMALL_STATE(432)] = 16109,
  [SMALL_STATE(433)] = 16125,
  [SMALL_STATE(434)] = 16141,
  [SMALL_STATE(435)] = 16157,
  [SMALL_STATE(436)] = 16173,
  [SMALL_STATE(437)] = 16189,
  [SMALL_STATE(438)] = 16205,
  [SMALL_STATE(439)] = 16221,
  [SMALL_STATE(440)] = 16237,
  [SMALL_STATE(441)] = 16253,
  [SMALL_STATE(442)] = 16269,
  [SMALL_STATE(443)] = 16285,
  [SMALL_STATE(444)] = 16301,
  [SMALL_STATE(445)] = 16317,
  [SMALL_STATE(446)] = 16333,
  [SMALL_STATE(447)] = 16349,
  [SMALL_STATE(448)] = 16365,
  [SMALL_STATE(449)] = 16381,
  [SMALL_STATE(450)] = 16397,
  [SMALL_STATE(451)] = 16413,
  [SMALL_STATE(452)] = 16429,
  [SMALL_STATE(453)] = 16445,
  [SMALL_STATE(454)] = 16461,
  [SMALL_STATE(455)] = 16477,
  [SMALL_STATE(456)] = 16493,
  [SMALL_STATE(457)] = 16509,
  [SMALL_STATE(458)] = 16525,
  [SMALL_STATE(459)] = 16541,
  [SMALL_STATE(460)] = 16557,
  [SMALL_STATE(461)] = 16573,
  [SMALL_STATE(462)] = 16589,
  [SMALL_STATE(463)] = 16605,
  [SMALL_STATE(464)] = 16621,
  [SMALL_STATE(465)] = 16637,
  [SMALL_STATE(466)] = 16653,
  [SMALL_STATE(467)] = 16669,
  [SMALL_STATE(468)] = 16685,
  [SMALL_STATE(469)] = 16701,
  [SMALL_STATE(470)] = 16717,
  [SMALL_STATE(471)] = 16733,
  [SMALL_STATE(472)] = 16749,
  [SMALL_STATE(473)] = 16765,
  [SMALL_STATE(474)] = 16781,
  [SMALL_STATE(475)] = 16797,
  [SMALL_STATE(476)] = 16812,
  [SMALL_STATE(477)] = 16831,
  [SMALL_STATE(478)] = 16846,
  [SMALL_STATE(479)] = 16861,
  [SMALL_STATE(480)] = 16880,
  [SMALL_STATE(481)] = 16895,
  [SMALL_STATE(482)] = 16910,
  [SMALL_STATE(483)] = 16925,
  [SMALL_STATE(484)] = 16940,
  [SMALL_STATE(485)] = 16955,
  [SMALL_STATE(486)] = 16970,
  [SMALL_STATE(487)] = 16985,
  [SMALL_STATE(488)] = 17000,
  [SMALL_STATE(489)] = 17015,
  [SMALL_STATE(490)] = 17030,
  [SMALL_STATE(491)] = 17045,
  [SMALL_STATE(492)] = 17066,
  [SMALL_STATE(493)] = 17081,
  [SMALL_STATE(494)] = 17096,
  [SMALL_STATE(495)] = 17111,
  [SMALL_STATE(496)] = 17125,
  [SMALL_STATE(497)] = 17139,
  [SMALL_STATE(498)] = 17153,
  [SMALL_STATE(499)] = 17165,
  [SMALL_STATE(500)] = 17177,
  [SMALL_STATE(501)] = 17191,
  [SMALL_STATE(502)] = 17205,
  [SMALL_STATE(503)] = 17219,
  [SMALL_STATE(504)] = 17233,
  [SMALL_STATE(505)] = 17245,
  [SMALL_STATE(506)] = 17259,
  [SMALL_STATE(507)] = 17273,
  [SMALL_STATE(508)] = 17287,
  [SMALL_STATE(509)] = 17301,
  [SMALL_STATE(510)] = 17315,
  [SMALL_STATE(511)] = 17329,
  [SMALL_STATE(512)] = 17343,
  [SMALL_STATE(513)] = 17357,
  [SMALL_STATE(514)] = 17371,
  [SMALL_STATE(515)] = 17385,
  [SMALL_STATE(516)] = 17399,
  [SMALL_STATE(517)] = 17413,
  [SMALL_STATE(518)] = 17427,
  [SMALL_STATE(519)] = 17439,
  [SMALL_STATE(520)] = 17451,
  [SMALL_STATE(521)] = 17465,
  [SMALL_STATE(522)] = 17475,
  [SMALL_STATE(523)] = 17485,
  [SMALL_STATE(524)] = 17495,
  [SMALL_STATE(525)] = 17501,
  [SMALL_STATE(526)] = 17511,
  [SMALL_STATE(527)] = 17517,
  [SMALL_STATE(528)] = 17527,
  [SMALL_STATE(529)] = 17537,
  [SMALL_STATE(530)] = 17547,
  [SMALL_STATE(531)] = 17557,
  [SMALL_STATE(532)] = 17567,
  [SMALL_STATE(533)] = 17577,
  [SMALL_STATE(534)] = 17587,
  [SMALL_STATE(535)] = 17593,
  [SMALL_STATE(536)] = 17603,
  [SMALL_STATE(537)] = 17613,
  [SMALL_STATE(538)] = 17623,
  [SMALL_STATE(539)] = 17633,
  [SMALL_STATE(540)] = 17643,
  [SMALL_STATE(541)] = 17653,
  [SMALL_STATE(542)] = 17663,
  [SMALL_STATE(543)] = 17673,
  [SMALL_STATE(544)] = 17683,
  [SMALL_STATE(545)] = 17693,
  [SMALL_STATE(546)] = 17703,
  [SMALL_STATE(547)] = 17713,
  [SMALL_STATE(548)] = 17723,
  [SMALL_STATE(549)] = 17733,
  [SMALL_STATE(550)] = 17743,
  [SMALL_STATE(551)] = 17753,
  [SMALL_STATE(552)] = 17763,
  [SMALL_STATE(553)] = 17773,
  [SMALL_STATE(554)] = 17783,
  [SMALL_STATE(555)] = 17793,
  [SMALL_STATE(556)] = 17803,
  [SMALL_STATE(557)] = 17813,
  [SMALL_STATE(558)] = 17823,
  [SMALL_STATE(559)] = 17833,
  [SMALL_STATE(560)] = 17843,
  [SMALL_STATE(561)] = 17853,
  [SMALL_STATE(562)] = 17863,
  [SMALL_STATE(563)] = 17873,
  [SMALL_STATE(564)] = 17883,
  [SMALL_STATE(565)] = 17893,
  [SMALL_STATE(566)] = 17903,
  [SMALL_STATE(567)] = 17913,
  [SMALL_STATE(568)] = 17923,
  [SMALL_STATE(569)] = 17933,
  [SMALL_STATE(570)] = 17943,
  [SMALL_STATE(571)] = 17953,
  [SMALL_STATE(572)] = 17963,
  [SMALL_STATE(573)] = 17973,
  [SMALL_STATE(574)] = 17983,
  [SMALL_STATE(575)] = 17993,
  [SMALL_STATE(576)] = 18003,
  [SMALL_STATE(577)] = 18013,
  [SMALL_STATE(578)] = 18023,
  [SMALL_STATE(579)] = 18033,
  [SMALL_STATE(580)] = 18043,
  [SMALL_STATE(581)] = 18053,
  [SMALL_STATE(582)] = 18063,
  [SMALL_STATE(583)] = 18073,
  [SMALL_STATE(584)] = 18083,
  [SMALL_STATE(585)] = 18093,
  [SMALL_STATE(586)] = 18103,
  [SMALL_STATE(587)] = 18113,
  [SMALL_STATE(588)] = 18123,
  [SMALL_STATE(589)] = 18133,
  [SMALL_STATE(590)] = 18143,
  [SMALL_STATE(591)] = 18153,
  [SMALL_STATE(592)] = 18163,
  [SMALL_STATE(593)] = 18173,
  [SMALL_STATE(594)] = 18183,
  [SMALL_STATE(595)] = 18193,
  [SMALL_STATE(596)] = 18203,
  [SMALL_STATE(597)] = 18213,
  [SMALL_STATE(598)] = 18223,
  [SMALL_STATE(599)] = 18233,
  [SMALL_STATE(600)] = 18243,
  [SMALL_STATE(601)] = 18253,
  [SMALL_STATE(602)] = 18263,
  [SMALL_STATE(603)] = 18273,
  [SMALL_STATE(604)] = 18283,
  [SMALL_STATE(605)] = 18293,
  [SMALL_STATE(606)] = 18303,
  [SMALL_STATE(607)] = 18313,
  [SMALL_STATE(608)] = 18323,
  [SMALL_STATE(609)] = 18333,
  [SMALL_STATE(610)] = 18343,
  [SMALL_STATE(611)] = 18353,
  [SMALL_STATE(612)] = 18363,
  [SMALL_STATE(613)] = 18373,
  [SMALL_STATE(614)] = 18383,
  [SMALL_STATE(615)] = 18393,
  [SMALL_STATE(616)] = 18403,
  [SMALL_STATE(617)] = 18413,
  [SMALL_STATE(618)] = 18423,
  [SMALL_STATE(619)] = 18433,
  [SMALL_STATE(620)] = 18443,
  [SMALL_STATE(621)] = 18453,
  [SMALL_STATE(622)] = 18463,
  [SMALL_STATE(623)] = 18473,
  [SMALL_STATE(624)] = 18483,
  [SMALL_STATE(625)] = 18493,
  [SMALL_STATE(626)] = 18503,
  [SMALL_STATE(627)] = 18513,
  [SMALL_STATE(628)] = 18523,
  [SMALL_STATE(629)] = 18533,
  [SMALL_STATE(630)] = 18543,
  [SMALL_STATE(631)] = 18553,
  [SMALL_STATE(632)] = 18563,
  [SMALL_STATE(633)] = 18573,
  [SMALL_STATE(634)] = 18583,
  [SMALL_STATE(635)] = 18593,
  [SMALL_STATE(636)] = 18603,
  [SMALL_STATE(637)] = 18613,
  [SMALL_STATE(638)] = 18623,
  [SMALL_STATE(639)] = 18633,
  [SMALL_STATE(640)] = 18643,
  [SMALL_STATE(641)] = 18653,
  [SMALL_STATE(642)] = 18660,
  [SMALL_STATE(643)] = 18667,
  [SMALL_STATE(644)] = 18674,
  [SMALL_STATE(645)] = 18681,
  [SMALL_STATE(646)] = 18688,
  [SMALL_STATE(647)] = 18695,
  [SMALL_STATE(648)] = 18702,
  [SMALL_STATE(649)] = 18709,
  [SMALL_STATE(650)] = 18716,
  [SMALL_STATE(651)] = 18723,
  [SMALL_STATE(652)] = 18730,
  [SMALL_STATE(653)] = 18737,
  [SMALL_STATE(654)] = 18744,
  [SMALL_STATE(655)] = 18751,
  [SMALL_STATE(656)] = 18758,
  [SMALL_STATE(657)] = 18765,
  [SMALL_STATE(658)] = 18772,
  [SMALL_STATE(659)] = 18779,
  [SMALL_STATE(660)] = 18786,
  [SMALL_STATE(661)] = 18793,
  [SMALL_STATE(662)] = 18800,
  [SMALL_STATE(663)] = 18807,
  [SMALL_STATE(664)] = 18814,
  [SMALL_STATE(665)] = 18821,
  [SMALL_STATE(666)] = 18828,
  [SMALL_STATE(667)] = 18835,
  [SMALL_STATE(668)] = 18842,
  [SMALL_STATE(669)] = 18849,
  [SMALL_STATE(670)] = 18856,
  [SMALL_STATE(671)] = 18863,
  [SMALL_STATE(672)] = 18870,
  [SMALL_STATE(673)] = 18877,
  [SMALL_STATE(674)] = 18884,
  [SMALL_STATE(675)] = 18891,
  [SMALL_STATE(676)] = 18898,
  [SMALL_STATE(677)] = 18905,
  [SMALL_STATE(678)] = 18912,
  [SMALL_STATE(679)] = 18919,
  [SMALL_STATE(680)] = 18926,
  [SMALL_STATE(681)] = 18933,
  [SMALL_STATE(682)] = 18940,
  [SMALL_STATE(683)] = 18947,
  [SMALL_STATE(684)] = 18954,
  [SMALL_STATE(685)] = 18961,
  [SMALL_STATE(686)] = 18968,
  [SMALL_STATE(687)] = 18975,
  [SMALL_STATE(688)] = 18982,
  [SMALL_STATE(689)] = 18989,
  [SMALL_STATE(690)] = 18996,
  [SMALL_STATE(691)] = 19000,
  [SMALL_STATE(692)] = 19004,
  [SMALL_STATE(693)] = 19008,
  [SMALL_STATE(694)] = 19012,
  [SMALL_STATE(695)] = 19016,
  [SMALL_STATE(696)] = 19020,
  [SMALL_STATE(697)] = 19024,
  [SMALL_STATE(698)] = 19028,
  [SMALL_STATE(699)] = 19032,
  [SMALL_STATE(700)] = 19036,
  [SMALL_STATE(701)] = 19040,
  [SMALL_STATE(702)] = 19044,
  [SMALL_STATE(703)] = 19048,
  [SMALL_STATE(704)] = 19052,
  [SMALL_STATE(705)] = 19056,
  [SMALL_STATE(706)] = 19060,
  [SMALL_STATE(707)] = 19064,
  [SMALL_STATE(708)] = 19068,
  [SMALL_STATE(709)] = 19072,
  [SMALL_STATE(710)] = 19076,
  [SMALL_STATE(711)] = 19080,
  [SMALL_STATE(712)] = 19084,
  [SMALL_STATE(713)] = 19088,
  [SMALL_STATE(714)] = 19092,
  [SMALL_STATE(715)] = 19096,
  [SMALL_STATE(716)] = 19100,
  [SMALL_STATE(717)] = 19104,
  [SMALL_STATE(718)] = 19108,
  [SMALL_STATE(719)] = 19112,
  [SMALL_STATE(720)] = 19116,
  [SMALL_STATE(721)] = 19120,
  [SMALL_STATE(722)] = 19124,
  [SMALL_STATE(723)] = 19128,
  [SMALL_STATE(724)] = 19132,
  [SMALL_STATE(725)] = 19136,
  [SMALL_STATE(726)] = 19140,
  [SMALL_STATE(727)] = 19144,
  [SMALL_STATE(728)] = 19148,
  [SMALL_STATE(729)] = 19152,
  [SMALL_STATE(730)] = 19156,
  [SMALL_STATE(731)] = 19160,
  [SMALL_STATE(732)] = 19164,
  [SMALL_STATE(733)] = 19168,
  [SMALL_STATE(734)] = 19172,
  [SMALL_STATE(735)] = 19176,
  [SMALL_STATE(736)] = 19180,
  [SMALL_STATE(737)] = 19184,
  [SMALL_STATE(738)] = 19188,
  [SMALL_STATE(739)] = 19192,
  [SMALL_STATE(740)] = 19196,
  [SMALL_STATE(741)] = 19200,
  [SMALL_STATE(742)] = 19204,
  [SMALL_STATE(743)] = 19208,
  [SMALL_STATE(744)] = 19212,
  [SMALL_STATE(745)] = 19216,
  [SMALL_STATE(746)] = 19220,
  [SMALL_STATE(747)] = 19224,
  [SMALL_STATE(748)] = 19228,
  [SMALL_STATE(749)] = 19232,
  [SMALL_STATE(750)] = 19236,
  [SMALL_STATE(751)] = 19240,
  [SMALL_STATE(752)] = 19244,
  [SMALL_STATE(753)] = 19248,
  [SMALL_STATE(754)] = 19252,
  [SMALL_STATE(755)] = 19256,
  [SMALL_STATE(756)] = 19260,
  [SMALL_STATE(757)] = 19264,
  [SMALL_STATE(758)] = 19268,
  [SMALL_STATE(759)] = 19272,
  [SMALL_STATE(760)] = 19276,
  [SMALL_STATE(761)] = 19280,
  [SMALL_STATE(762)] = 19284,
  [SMALL_STATE(763)] = 19288,
  [SMALL_STATE(764)] = 19292,
  [SMALL_STATE(765)] = 19296,
  [SMALL_STATE(766)] = 19300,
  [SMALL_STATE(767)] = 19304,
  [SMALL_STATE(768)] = 19308,
  [SMALL_STATE(769)] = 19312,
  [SMALL_STATE(770)] = 19316,
  [SMALL_STATE(771)] = 19320,
  [SMALL_STATE(772)] = 19324,
  [SMALL_STATE(773)] = 19328,
  [SMALL_STATE(774)] = 19332,
  [SMALL_STATE(775)] = 19336,
  [SMALL_STATE(776)] = 19340,
  [SMALL_STATE(777)] = 19344,
  [SMALL_STATE(778)] = 19348,
  [SMALL_STATE(779)] = 19352,
  [SMALL_STATE(780)] = 19356,
  [SMALL_STATE(781)] = 19360,
  [SMALL_STATE(782)] = 19364,
  [SMALL_STATE(783)] = 19368,
  [SMALL_STATE(784)] = 19372,
  [SMALL_STATE(785)] = 19376,
  [SMALL_STATE(786)] = 19380,
  [SMALL_STATE(787)] = 19384,
  [SMALL_STATE(788)] = 19388,
  [SMALL_STATE(789)] = 19392,
  [SMALL_STATE(790)] = 19396,
  [SMALL_STATE(791)] = 19400,
  [SMALL_STATE(792)] = 19404,
  [SMALL_STATE(793)] = 19408,
  [SMALL_STATE(794)] = 19412,
  [SMALL_STATE(795)] = 19416,
  [SMALL_STATE(796)] = 19420,
  [SMALL_STATE(797)] = 19424,
  [SMALL_STATE(798)] = 19428,
  [SMALL_STATE(799)] = 19432,
  [SMALL_STATE(800)] = 19436,
  [SMALL_STATE(801)] = 19440,
  [SMALL_STATE(802)] = 19444,
  [SMALL_STATE(803)] = 19448,
  [SMALL_STATE(804)] = 19452,
  [SMALL_STATE(805)] = 19456,
  [SMALL_STATE(806)] = 19460,
  [SMALL_STATE(807)] = 19464,
  [SMALL_STATE(808)] = 19468,
  [SMALL_STATE(809)] = 19472,
  [SMALL_STATE(810)] = 19476,
  [SMALL_STATE(811)] = 19480,
  [SMALL_STATE(812)] = 19484,
  [SMALL_STATE(813)] = 19488,
  [SMALL_STATE(814)] = 19492,
  [SMALL_STATE(815)] = 19496,
  [SMALL_STATE(816)] = 19500,
  [SMALL_STATE(817)] = 19504,
  [SMALL_STATE(818)] = 19508,
  [SMALL_STATE(819)] = 19512,
  [SMALL_STATE(820)] = 19516,
  [SMALL_STATE(821)] = 19520,
  [SMALL_STATE(822)] = 19524,
  [SMALL_STATE(823)] = 19528,
  [SMALL_STATE(824)] = 19532,
  [SMALL_STATE(825)] = 19536,
  [SMALL_STATE(826)] = 19540,
  [SMALL_STATE(827)] = 19544,
  [SMALL_STATE(828)] = 19548,
  [SMALL_STATE(829)] = 19552,
  [SMALL_STATE(830)] = 19556,
  [SMALL_STATE(831)] = 19560,
  [SMALL_STATE(832)] = 19564,
  [SMALL_STATE(833)] = 19568,
  [SMALL_STATE(834)] = 19572,
  [SMALL_STATE(835)] = 19576,
  [SMALL_STATE(836)] = 19580,
  [SMALL_STATE(837)] = 19584,
  [SMALL_STATE(838)] = 19588,
  [SMALL_STATE(839)] = 19592,
  [SMALL_STATE(840)] = 19596,
  [SMALL_STATE(841)] = 19600,
  [SMALL_STATE(842)] = 19604,
  [SMALL_STATE(843)] = 19608,
  [SMALL_STATE(844)] = 19612,
  [SMALL_STATE(845)] = 19616,
  [SMALL_STATE(846)] = 19620,
  [SMALL_STATE(847)] = 19624,
  [SMALL_STATE(848)] = 19628,
  [SMALL_STATE(849)] = 19632,
  [SMALL_STATE(850)] = 19636,
  [SMALL_STATE(851)] = 19640,
  [SMALL_STATE(852)] = 19644,
  [SMALL_STATE(853)] = 19648,
  [SMALL_STATE(854)] = 19652,
  [SMALL_STATE(855)] = 19656,
  [SMALL_STATE(856)] = 19660,
  [SMALL_STATE(857)] = 19664,
  [SMALL_STATE(858)] = 19668,
  [SMALL_STATE(859)] = 19672,
  [SMALL_STATE(860)] = 19676,
  [SMALL_STATE(861)] = 19680,
  [SMALL_STATE(862)] = 19684,
  [SMALL_STATE(863)] = 19688,
  [SMALL_STATE(864)] = 19692,
  [SMALL_STATE(865)] = 19696,
  [SMALL_STATE(866)] = 19700,
  [SMALL_STATE(867)] = 19704,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(583),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(550),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(640),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(639),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(637),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(636),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(635),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(602),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(573),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(598),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(617),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(530),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(546),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(578),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(574),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(571),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(634),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [45] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [47] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [55] = {.entry = {.count = 1, .reusable = false}}, SHIFT(163),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [59] = {.entry = {.count = 1, .reusable = true}}, SHIFT(465),
  [61] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [63] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [65] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [67] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(360),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(438),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(473),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [173] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(108),
  [176] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(583),
  [179] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(602),
  [182] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(573),
  [185] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2),
  [187] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(550),
  [190] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(640),
  [193] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(639),
  [196] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(637),
  [199] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(636),
  [202] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2), SHIFT_REPEAT(617),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(324),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [237] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(241),
  [240] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(209),
  [243] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(95),
  [246] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(98),
  [249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2),
  [251] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(198),
  [254] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(163),
  [257] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2), SHIFT_REPEAT(240),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [264] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1),
  [266] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(107),
  [269] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(583),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [274] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(550),
  [277] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(640),
  [280] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(639),
  [283] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(637),
  [286] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(636),
  [289] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(617),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [294] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_body, 1),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [298] = {.entry = {.count = 1, .reusable = false}}, SHIFT(533),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [302] = {.entry = {.count = 1, .reusable = false}}, SHIFT(554),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [306] = {.entry = {.count = 1, .reusable = false}}, SHIFT(581),
  [308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [310] = {.entry = {.count = 1, .reusable = false}}, SHIFT(603),
  [312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [314] = {.entry = {.count = 1, .reusable = false}}, SHIFT(566),
  [316] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(120),
  [319] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(581),
  [322] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(123),
  [325] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(566),
  [328] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(127),
  [331] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(533),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [338] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(133),
  [341] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(554),
  [344] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(134),
  [347] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(603),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [352] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(136),
  [355] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(635),
  [358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [360] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(136),
  [364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [376] = {.entry = {.count = 1, .reusable = false}}, SHIFT(202),
  [378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [384] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_arguments, 1),
  [386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(195),
  [390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [400] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_arguments, 2),
  [402] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoted_argument, 1),
  [404] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [406] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(291),
  [409] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(234),
  [412] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2),
  [414] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(197),
  [417] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(195),
  [420] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2), SHIFT_REPEAT(297),
  [423] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(241),
  [426] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(209),
  [429] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2),
  [431] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(165),
  [434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [442] = {.entry = {.count = 1, .reusable = false}}, SHIFT(203),
  [444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(456),
  [464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(825),
  [480] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoted_argument, 1),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(196),
  [484] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(291),
  [487] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(234),
  [490] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2),
  [492] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(196),
  [495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [501] = {.entry = {.count = 1, .reusable = false}}, SHIFT(205),
  [503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(847),
  [507] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(488),
  [510] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(247),
  [513] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(200),
  [516] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [518] = {.entry = {.count = 1, .reusable = false}}, SHIFT(200),
  [520] = {.entry = {.count = 1, .reusable = false}}, SHIFT(206),
  [522] = {.entry = {.count = 1, .reusable = false}}, SHIFT(207),
  [524] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_element, 1),
  [526] = {.entry = {.count = 1, .reusable = false}}, SHIFT(208),
  [528] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(503),
  [531] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(256),
  [534] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(206),
  [537] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(505),
  [540] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(285),
  [543] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2), SHIFT_REPEAT(207),
  [546] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(520),
  [549] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(254),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2),
  [554] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_quoted_element_repeat1, 2), SHIFT_REPEAT(208),
  [557] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 1),
  [559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(744),
  [563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(736),
  [565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [567] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 1),
  [569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(613),
  [575] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(499),
  [578] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(218),
  [581] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2), SHIFT_REPEAT(613),
  [584] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2),
  [586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [588] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2),
  [592] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(233),
  [595] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(233),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(864),
  [602] = {.entry = {.count = 1, .reusable = true}}, SHIFT(865),
  [604] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [606] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gen_exp, 4),
  [608] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gen_exp, 4),
  [610] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_env_var, 5),
  [612] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_env_var, 5),
  [614] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cache_var, 5),
  [616] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cache_var, 5),
  [618] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 3),
  [620] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 3),
  [622] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 3),
  [624] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 3),
  [626] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1),
  [628] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 1),
  [630] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_escape_sequence, 1),
  [632] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_escape_sequence, 1),
  [634] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_gen_exp, 3),
  [636] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_gen_exp, 3),
  [638] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 2),
  [640] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 2),
  [642] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 2),
  [644] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 2),
  [646] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_var, 4),
  [648] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_var, 4),
  [650] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_ref, 1),
  [652] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_ref, 1),
  [654] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [656] = {.entry = {.count = 1, .reusable = true}}, SHIFT(852),
  [658] = {.entry = {.count = 1, .reusable = true}}, SHIFT(853),
  [660] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [662] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 3),
  [664] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 3),
  [666] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 3),
  [668] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 3),
  [670] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 5),
  [672] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 5),
  [674] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endblock_command, 5),
  [676] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endblock_command, 5),
  [678] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 6),
  [680] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 6),
  [682] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 7),
  [684] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 7),
  [686] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 1),
  [688] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [690] = {.entry = {.count = 1, .reusable = true}}, SHIFT(844),
  [692] = {.entry = {.count = 1, .reusable = true}}, SHIFT(845),
  [694] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [696] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 1),
  [698] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 3),
  [700] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 3),
  [702] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [704] = {.entry = {.count = 1, .reusable = true}}, SHIFT(856),
  [706] = {.entry = {.count = 1, .reusable = true}}, SHIFT(857),
  [708] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [710] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 4),
  [712] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 4),
  [714] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 5),
  [716] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 5),
  [718] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endblock_command, 4),
  [720] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endblock_command, 4),
  [722] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 4),
  [724] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 4),
  [726] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 4),
  [728] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 4),
  [730] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 4),
  [732] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 4),
  [734] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 4),
  [736] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 4),
  [738] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 5),
  [740] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 5),
  [742] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 5),
  [744] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 5),
  [746] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endblock_command, 3),
  [748] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endblock_command, 3),
  [750] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 2),
  [752] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 2),
  [754] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 3),
  [756] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 3),
  [758] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 3),
  [760] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 3),
  [762] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 3),
  [764] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 3),
  [766] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 4),
  [768] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 4),
  [770] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 5),
  [772] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 5),
  [774] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 5),
  [776] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 5),
  [778] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 3),
  [780] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 3),
  [782] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 4),
  [784] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 4),
  [786] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 3),
  [788] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 3),
  [790] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 4),
  [792] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 4),
  [794] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 4),
  [796] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 4),
  [798] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_loop, 3),
  [800] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_loop, 3),
  [802] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_loop, 3),
  [804] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_loop, 3),
  [806] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 5),
  [808] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 5),
  [810] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 3),
  [812] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_def, 3),
  [814] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(283),
  [817] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2),
  [819] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(283),
  [822] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 5),
  [824] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 5),
  [826] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [828] = {.entry = {.count = 1, .reusable = true}}, SHIFT(860),
  [830] = {.entry = {.count = 1, .reusable = true}}, SHIFT(861),
  [832] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [834] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_def, 3),
  [836] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_def, 3),
  [838] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_def, 3),
  [840] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_def, 3),
  [842] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 1),
  [844] = {.entry = {.count = 1, .reusable = false}}, SHIFT(314),
  [846] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 1),
  [848] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(305),
  [851] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(305),
  [854] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__gen_exp_arguments_repeat1, 2),
  [856] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_command, 4),
  [858] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_command, 4),
  [860] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(476),
  [863] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(476),
  [866] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 4),
  [868] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 4),
  [870] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 5),
  [872] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 5),
  [874] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2),
  [876] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2), SHIFT_REPEAT(479),
  [879] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 2), SHIFT_REPEAT(479),
  [882] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 5),
  [884] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 5),
  [886] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 4),
  [888] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 4),
  [890] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 4),
  [892] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 4),
  [894] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 4),
  [896] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 4),
  [898] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_command, 5),
  [900] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_command, 5),
  [902] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 5),
  [904] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 5),
  [906] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 5),
  [908] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 5),
  [910] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(491),
  [913] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2), SHIFT_REPEAT(491),
  [916] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [918] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [920] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [922] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [924] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [926] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [928] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [930] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [932] = {.entry = {.count = 1, .reusable = true}}, SHIFT(664),
  [934] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [936] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [938] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [948] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2),
  [950] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2), SHIFT_REPEAT(532),
  [953] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [955] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [957] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [959] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [961] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [963] = {.entry = {.count = 1, .reusable = true}}, SHIFT(677),
  [965] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [967] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [969] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [971] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [973] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [975] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [977] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [979] = {.entry = {.count = 1, .reusable = true}}, SHIFT(642),
  [981] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [983] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [985] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [987] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [989] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(631),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(669),
  [1009] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(629),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1019] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(674),
  [1031] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [1033] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [1035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1039] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [1041] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1043] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1045] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1053] = {.entry = {.count = 1, .reusable = true}}, SHIFT(673),
  [1055] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [1057] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [1059] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1061] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [1063] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [1065] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1067] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [1069] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1071] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1073] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1075] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1077] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1079] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1081] = {.entry = {.count = 1, .reusable = true}}, SHIFT(622),
  [1083] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [1085] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [1087] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [1089] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [1091] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [1093] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [1101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [1107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(676),
  [1111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [1113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(666),
  [1121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(616),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [1135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(665),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(590),
  [1147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(16),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(619),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(623),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(682),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(213),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(848),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(849),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(647),
  [1199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(608),
  [1201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [1205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [1215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1219] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_content, 1),
  [1221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [1225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(678),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(611),
  [1253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(624),
  [1257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(628),
  [1265] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1267] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1269] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [1271] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [1275] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [1277] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1279] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [1281] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [1283] = {.entry = {.count = 1, .reusable = true}}, SHIFT(615),
  [1285] = {.entry = {.count = 1, .reusable = true}}, SHIFT(618),
  [1287] = {.entry = {.count = 1, .reusable = true}}, SHIFT(625),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1295] = {.entry = {.count = 1, .reusable = false}}, SHIFT(186),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [1301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(594),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [1321] = {.entry = {.count = 1, .reusable = true}}, SHIFT(593),
  [1323] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [1325] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1327] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1329] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [1331] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1333] = {.entry = {.count = 1, .reusable = false}}, SHIFT(187),
  [1335] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1337] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [1339] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1343] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1345] = {.entry = {.count = 1, .reusable = false}}, SHIFT(188),
  [1347] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [1355] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [1359] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [1361] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [1363] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [1365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(437),
  [1367] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [1369] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [1371] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [1375] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(444),
  [1385] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(591),
  [1393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(599),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(601),
  [1397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(612),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [1407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [1419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [1421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1427] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [1431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1443] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(827),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(826),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [1457] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [1459] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1467] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__gen_exp_content, 2),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(785),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(784),
  [1485] = {.entry = {.count = 1, .reusable = true}}, SHIFT(769),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [1495] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [1517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(751),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(750),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(783),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [1537] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1539] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [1545] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(519),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1551] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(824),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(823),
  [1557] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(422),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(859),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1585] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1587] = {.entry = {.count = 1, .reusable = true}}, SHIFT(696),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(697),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(510),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(718),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(719),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(215),
  [1633] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1643] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [1661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_bracket_argument = 0,
  ts_external_token_bracket_comment = 1,
  ts_external_token_line_comment = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_bracket_argument] = sym_bracket_argument,
  [ts_external_token_bracket_comment] = sym_bracket_comment,
  [ts_external_token_line_comment] = sym_line_comment,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_bracket_argument] = true,
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [2] = {
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [3] = {
    [ts_external_token_bracket_argument] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_cmake_external_scanner_create(void);
void tree_sitter_cmake_external_scanner_destroy(void *);
bool tree_sitter_cmake_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_cmake_external_scanner_serialize(void *, char *);
void tree_sitter_cmake_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_cmake() {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_cmake_external_scanner_create,
      tree_sitter_cmake_external_scanner_destroy,
      tree_sitter_cmake_external_scanner_scan,
      tree_sitter_cmake_external_scanner_serialize,
      tree_sitter_cmake_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
