# This file is part of Cantera. See License.txt in the top-level directory or
# at https://cantera.org/license.txt for license and copyright information.

from typing import TypeAlias
from collections.abc import Callable, Iterable
from typing import Any, Literal

from typing_extensions import Never, override

_Func1Like: TypeAlias = str | Callable[[float], float] | float

class Func1:
    def __init__(
        self,
        c: _Func1Like,
        *args: Any,
        init: bool = True,
    ) -> None: ...
    @property
    def type(self) -> str: ...
    def __add__(self, other: _Func1Like) -> Func1: ...
    def __radd__(self, other: _Func1Like) -> Func1: ...
    def __sub__(self, other: _Func1Like) -> Func1: ...
    def __rsub__(self, other: _Func1Like) -> Func1: ...
    def __mul__(self, other: _Func1Like) -> Func1: ...
    def __rmul__(self, other: _Func1Like) -> Func1: ...
    def __truediv__(self, other: _Func1Like) -> Func1: ...
    def __rtruediv__(self, other: _Func1Like) -> Func1: ...
    @property
    def cxx_type(self) -> str: ...
    def write(self, name: str = "x") -> str: ...
    def __call__(self, t: float) -> float: ...
    @override
    def __reduce__(self) -> Never: ...
    def __copy__(self) -> Never: ...

class Tabulated1(Func1):
    def __init__(
        self,
        time: Iterable[float],
        fval: Iterable[float],
        method: Literal["linear", "previous"] = "linear",
    ) -> None: ...
